/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.type.Type;
import io.trino.testing.AbstractTestQueries;
import io.trino.testing.CustomFunctionBundle;
import io.trino.testing.MaterializedResult;
import io.trino.testing.PlanDeterminismChecker;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestQueryPlanDeterminism
extends AbstractTestQueries {
    private PlanDeterminismChecker determinismChecker;

    @BeforeAll
    public void setUp() {
        this.determinismChecker = new PlanDeterminismChecker(this.getQueryRunner());
    }

    @AfterAll
    public void tearDown() {
        this.determinismChecker = null;
    }

    protected QueryRunner createQueryRunner() {
        Session defaultSession = TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").build();
        StandaloneQueryRunner queryRunner = new StandaloneQueryRunner(defaultSession);
        queryRunner.installPlugin((Plugin)new TpchPlugin());
        queryRunner.createCatalog((String)defaultSession.getCatalog().get(), "tpch", (Map)ImmutableMap.of((Object)"tpch.splits-per-node", (Object)"1"));
        queryRunner.addFunctions(CustomFunctionBundle.CUSTOM_FUNCTIONS);
        return queryRunner;
    }

    protected MaterializedResult computeActual(@Language(value="SQL") String sql) {
        this.determinismChecker.checkPlanIsDeterministic(sql);
        return super.computeActual(sql);
    }

    protected MaterializedResult computeActual(Session session, @Language(value="SQL") String sql) {
        this.determinismChecker.checkPlanIsDeterministic(session, sql);
        return super.computeActual(session, sql);
    }

    protected void assertQuery(@Language(value="SQL") String sql) {
        this.determinismChecker.checkPlanIsDeterministic(sql);
    }

    protected void assertQuery(Session session, @Language(value="SQL") String sql) {
        this.determinismChecker.checkPlanIsDeterministic(session, sql);
    }

    protected void assertQueryOrdered(@Language(value="SQL") String sql) {
        this.determinismChecker.checkPlanIsDeterministic(sql);
    }

    protected void assertQuery(@Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        this.determinismChecker.checkPlanIsDeterministic(actual);
    }

    protected void assertQuery(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        this.determinismChecker.checkPlanIsDeterministic(session, actual);
    }

    protected void assertQueryOrdered(@Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        this.determinismChecker.checkPlanIsDeterministic(actual);
    }

    protected void assertQueryOrdered(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        this.determinismChecker.checkPlanIsDeterministic(session, actual);
    }

    protected void assertUpdate(@Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        this.determinismChecker.checkPlanIsDeterministic(actual);
    }

    protected void assertUpdate(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        this.determinismChecker.checkPlanIsDeterministic(session, actual);
    }

    protected void assertUpdate(@Language(value="SQL") String sql) {
        this.determinismChecker.checkPlanIsDeterministic(sql);
    }

    protected void assertUpdate(Session session, @Language(value="SQL") String sql) {
        this.determinismChecker.checkPlanIsDeterministic(session, sql);
    }

    protected void assertUpdate(@Language(value="SQL") String sql, long count) {
        this.determinismChecker.checkPlanIsDeterministic(sql);
    }

    protected void assertUpdate(Session session, @Language(value="SQL") String sql, long count) {
        this.determinismChecker.checkPlanIsDeterministic(session, sql);
    }

    protected void assertQueryFails(@Language(value="SQL") String sql, @Language(value="RegExp") String expectedMessageRegExp) {
        super.assertQueryFails(sql, expectedMessageRegExp);
    }

    protected void assertQueryFails(Session session, @Language(value="SQL") String sql, @Language(value="RegExp") String expectedMessageRegExp) {
        super.assertQueryFails(session, sql, expectedMessageRegExp);
    }

    protected void assertAccessAllowed(@Language(value="SQL") String sql, TestingAccessControlManager.TestingPrivilege ... deniedPrivileges) {
    }

    protected void assertAccessAllowed(Session session, @Language(value="SQL") String sql, TestingAccessControlManager.TestingPrivilege ... deniedPrivileges) {
    }

    protected void assertAccessDenied(@Language(value="SQL") String sql, @Language(value="RegExp") String exceptionsMessageRegExp, TestingAccessControlManager.TestingPrivilege ... deniedPrivileges) {
    }

    protected void assertAccessDenied(Session session, @Language(value="SQL") String sql, @Language(value="RegExp") String exceptionsMessageRegExp, TestingAccessControlManager.TestingPrivilege ... deniedPrivileges) {
    }

    protected void assertTableColumnNames(String tableName, String ... columnNames) {
    }

    protected MaterializedResult computeExpected(@Language(value="SQL") String sql, List<? extends Type> resultTypes) {
        this.determinismChecker.checkPlanIsDeterministic(sql);
        return super.computeExpected(sql, resultTypes);
    }

    @Test
    public void testTpchQ9deterministic() {
        this.determinismChecker.checkPlanIsDeterministic("SELECT\n  nation,\n  o_year,\n  sum(amount) AS sum_profit\nFROM (\n       SELECT\n         n.name                                                          AS nation,\n         extract(YEAR FROM o.orderdate)                                  AS o_year,\n         l.extendedprice * (1 - l.discount) - ps.supplycost * l.quantity AS amount\n       FROM\n         part p,\n         supplier s,\n         lineitem l,\n         partsupp ps,\n         orders o,\n         nation n\n       WHERE\n         s.suppkey = l.suppkey\n         AND ps.suppkey = l.suppkey\n         AND ps.partkey = l.partkey\n         AND p.partkey = l.partkey\n         AND o.orderkey = l.orderkey\n         AND s.nationkey = n.nationkey\n         AND p.name LIKE '%green%'\n     ) AS profit\nGROUP BY\n  nation,\n  o_year\nORDER BY\n  nation,\n  o_year DESC\n");
    }

    @Test
    public void testTpcdsQ6deterministic() {
        this.determinismChecker.checkPlanIsDeterministic("SELECT orderdate FROM orders o,\n     lineitem i\nWHERE o.orderdate =\n    (SELECT DISTINCT (orderdate)\n     FROM orders\n     WHERE totalprice > 2)\n  AND i.quantity > 1.2 *\n    (SELECT avg(j.quantity)\n     FROM lineitem j\n    )\n");
    }

    @Test
    public void testLargeIn() {
        Assumptions.abort((String)"Skipping testLargeIn");
    }
}

