/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.tests.tpch.TpchQueryRunner;
import org.junit.jupiter.api.Test;

public class TestRepartitionQueries
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return TpchQueryRunner.builder().build();
    }

    @Test
    public void testBoolean() {
        this.testRepartitioning("CASE WHEN mod(custkey + nationkey, 11) = 0 THEN FALSE ELSE TRUE END");
    }

    @Test
    public void testSmallInt() {
        this.testRepartitioning("CAST(custkey AS SMALLINT)");
    }

    @Test
    public void testInteger() {
        this.testRepartitioning("CAST(custkey AS INTEGER)");
    }

    @Test
    public void testBigInt() {
        this.testRepartitioning("CAST(custkey AS BIGINT)");
    }

    @Test
    public void testIpAddress() {
        this.testRepartitioning("CAST (FORMAT('%s.%s.%s.%s', custkey % 255, nationkey % 255, nationkey, nationkey) as ipaddress)", "CAST (column_under_test as VARCHAR)", "custkey % 255 || '.' || nationkey % 255 || '.' || nationkey || '.' || nationkey");
    }

    @Test
    public void testBigintWithNulls() {
        this.testRepartitioning("CASE WHEN mod(custkey + nationkey, 11) = 0 THEN NULL ELSE custkey END");
    }

    @Test
    public void testVarchar() {
        this.testRepartitioning("comment");
    }

    @Test
    public void testArrayOfBigInt() {
        this.testRepartitioning("ARRAY[custkey, nationkey, nationkey * 2]");
    }

    @Test
    public void testArrayOfArray() {
        this.testRepartitioning("ARRAY[ARRAY[custkey, nationkey], ARRAY[nationkey * 2]]", "array_join(column_under_test[1], ',') || ',' ||  array_join(column_under_test[2], ',')", "custkey || ',' || nationkey || ',' || nationkey * 2");
    }

    @Test
    public void testStruct() {
        this.testRepartitioning("CAST(    ROW (        custkey,        name,        acctbal    ) AS ROW(        l_custkey BIGINT,        l_name VARCHAR(25),        l_acctbal DOUBLE    ))", "FORMAT('%s%s%s', column_under_test.l_custkey, column_under_test.l_name, column_under_test.l_acctbal)", "custkey || name || acctbal");
    }

    @Test
    public void testStructWithNulls() {
        this.testRepartitioning("CAST (CASE WHEN mod(custkey + nationkey, 11) = 0 THEN NULL ELSE ROW (custkey, name) END AS ROW(l_custkey BIGINT, l_name VARCHAR(25)))", "CASE WHEN column_under_test IS NULL THEN '' ELSE FORMAT('%s%s', column_under_test.l_custkey, column_under_test.l_name) END", "CASE WHEN mod(custkey + nationkey, 11) = 0 THEN '' ELSE custkey || name END");
    }

    @Test
    public void testMaps() {
        this.testRepartitioning("MAP(ARRAY[1, 2], ARRAY[custkey, nationkey])", "array_join(map_values(column_under_test), ',')", "custkey || ',' || nationkey");
    }

    private void testRepartitioning(String columnExpression) {
        this.testRepartitioning(columnExpression, "column_under_test", columnExpression);
    }

    private void testRepartitioning(String columnExpression, String columnProjection, String actualColumnExpression) {
        this.assertQuery(String.format("WITH custkey_ex AS (  SELECT    custkey,    nationkey,    %s AS column_under_test  FROM customer)SELECT %s FROM (  SELECT c.column_under_test   FROM custkey_ex c, nation n   WHERE c.nationkey = n.nationkey)", columnExpression, columnProjection), String.format("SELECT %s AS column_under_test FROM customer", actualColumnExpression));
    }
}

