/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import io.trino.Session;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSequenceFunction
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return DistributedQueryRunner.builder((Session)TestingSession.testSessionBuilder().build()).build();
    }

    @Test
    public void testSequence() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(sequence(0, 8000, 3))\n"))).matches("SELECT * FROM UNNEST(sequence(0, 8000, 3))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM TABLE(sequence(1, 10, 3))"))).matches("VALUES BIGINT '1', 4, 7, 10");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM TABLE(sequence(1, 10, 6))"))).matches("VALUES BIGINT '1', 7");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM TABLE(sequence(-1, -10, -3))"))).matches("VALUES BIGINT '-1', -4, -7, -10");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM TABLE(sequence(-1, -10, -6))"))).matches("VALUES BIGINT '-1', -7");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM TABLE(sequence(-5, 5, 3))"))).matches("VALUES BIGINT '-5', -2, 1, 4");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM TABLE(sequence(5, -5, -3))"))).matches("VALUES BIGINT '5', 2, -1, -4");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM TABLE(sequence(0, 10, 3))"))).matches("VALUES BIGINT '0', 3, 6, 9");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM TABLE(sequence(0, -10, -3))"))).matches("VALUES BIGINT '0', -3, -6, -9");
    }

    @Test
    public void testDefaultArguments() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(sequence(stop => 10))\n"))).matches("SELECT * FROM UNNEST(sequence(0, 10, 1))");
    }

    @Test
    public void testInvalidArgument() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(sequence(\n                    start => -5,\n                    stop => 10,\n                    step => -2))\n"))).failure().hasMessage("Step must be positive for sequence [-5, 10]");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(sequence(\n                    start => 10,\n                    stop => -5,\n                    step => 2))\n"))).failure().hasMessage("Step must be negative for sequence [10, -5]");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(sequence(\n                    start => null,\n                    stop => -5,\n                    step => 2))\n"))).failure().hasMessage("Start is null");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(sequence(\n                    start => 10,\n                    stop => null,\n                    step => 2))\n"))).failure().hasMessage("Stop is null");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(sequence(\n                    start => 10,\n                    stop => -5,\n                    step => null))\n"))).failure().hasMessage("Step is null");
    }

    @Test
    public void testSingletonSequence() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(sequence(\n                    start => 10,\n                    stop => 10,\n                    step => 2))\n"))).matches("VALUES BIGINT '10'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(sequence(\n                    start => 10,\n                    stop => 10,\n                    step => -2))\n"))).matches("VALUES BIGINT '10'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(sequence(\n                    start => 10,\n                    stop => 10,\n                    step => 0))\n"))).matches("VALUES BIGINT '10'");
    }

    @Test
    public void testBigStep() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(sequence(\n                    start => 10,\n                    stop => -5,\n                    step => %s))\n".formatted(-9223381260236L)))).matches("VALUES BIGINT '10'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(sequence(\n                    start => 10,\n                    stop => -5,\n                    step => %s))\n".formatted(-9223381260237L)))).matches("VALUES BIGINT '10'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT DISTINCT x - lag(x, 1) OVER(ORDER BY x DESC)\nFROM TABLE(sequence(\n                    start => %s,\n                    stop => %s,\n                    step => %s)) t(x)\n".formatted(Long.MAX_VALUE, Long.MIN_VALUE, -9223381260237L)))).matches(String.format("VALUES (null), (%s)", -9223381260237L));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(sequence(\n                    start => 10,\n                    stop => -5,\n                    step => %s))\n".formatted(Long.MIN_VALUE)))).matches("VALUES BIGINT '10'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(sequence(\n                    start => -5,\n                    stop => 10,\n                    step => %s))\n".formatted(9223381260236L)))).matches("VALUES BIGINT '-5'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(sequence(\n                    start => -5,\n                    stop => 10,\n                    step => %s))\n".formatted(9223381260237L)))).matches("VALUES BIGINT '-5'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT DISTINCT x - lag(x, 1) OVER(ORDER BY x)\nFROM TABLE(sequence(\n                    start => %s,\n                    stop => %s,\n                    step => %s)) t(x)\n".formatted(Long.MIN_VALUE, Long.MAX_VALUE, 9223381260237L)))).matches(String.format("VALUES (null), (%s)", 9223381260237L));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(sequence(\n                    start => -5,\n                    stop => 10,\n                    step => %s))\n".formatted(Long.MAX_VALUE)))).matches("VALUES BIGINT '-5'");
    }

    @Test
    public void testMultipleSplits() {
        long sequenceLength = 10500000L;
        long start = 10L;
        long step = 5L;
        long stop = start + (sequenceLength - 1L) * step;
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(x), count(DISTINCT x), min(x), max(x)\nFROM TABLE(sequence(\n                    start => %s,\n                    stop => %s,\n                    step => %s)) t(x)\n".formatted(start, stop, step)))).matches(String.format("SELECT BIGINT '%s', BIGINT '%s', BIGINT '%s', BIGINT '%s'", sequenceLength, sequenceLength, start, stop));
        sequenceLength = 4500000L;
        stop = start + (sequenceLength - 1L) * step;
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT min(x), max(x)\nFROM TABLE(sequence(\n                    start => %s,\n                    stop => %s,\n                    step => %s)) t(x)\n".formatted(start, stop, step)))).matches(String.format("SELECT BIGINT '%s', BIGINT '%s'", start, stop));
        step = -5L;
        stop = start + (sequenceLength - 1L) * step;
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT max(x), min(x)\nFROM TABLE(sequence(\n                    start => %s,\n                    stop => %s,\n                    step => %s)) t(x)\n".formatted(start, stop, step)))).matches(String.format("SELECT BIGINT '%s', BIGINT '%s'", start, stop));
    }

    @Test
    public void testEdgeValues() {
        long start = -9223372036854775793L;
        long stop = -9223372036854775805L;
        long step = -10L;
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(sequence(\n                    start => %s,\n                    stop => %s,\n                    step => %s))\n".formatted(start, stop, step)))).matches(String.format("VALUES (%s), (%s)", start, start + step));
        start = -9223372036854775807L - 999999L * step;
        stop = -9223372036854775807L;
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT max(x), min(x)\nFROM TABLE(sequence(\n                    start => %s,\n                    stop => %s,\n                    step => %s)) t(x)\n".formatted(start, stop, step)))).matches(String.format("SELECT %s, %s", start, -9223372036854775807L));
        start = 0x7FFFFFFFFFFFFFF0L;
        stop = 0x7FFFFFFFFFFFFFFCL;
        step = 10L;
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(sequence(\n                    start => %s,\n                    stop => %s,\n                    step => %s))\n".formatted(start, stop, step)))).matches(String.format("VALUES (%s), (%s)", start, start + step));
        start = 0x7FFFFFFFFFFFFFFEL - 999999L * step;
        stop = 0x7FFFFFFFFFFFFFFEL;
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT min(x), max(x)\nFROM TABLE(sequence(\n                    start => %s,\n                    stop => %s,\n                    step => %s)) t(x)\n".formatted(start, stop, step)))).matches(String.format("SELECT %s, %s", start, 0x7FFFFFFFFFFFFFFEL));
    }
}

