/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractSequentialIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.inject.Provider;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.FullJsonResponseHandler;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.StatusResponseHandler;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.testing.Closeables;
import io.airlift.units.Duration;
import io.trino.client.ClientCapabilities;
import io.trino.client.ClientSession;
import io.trino.client.Column;
import io.trino.client.ProtocolHeaders;
import io.trino.client.QueryDataJacksonModule;
import io.trino.client.QueryError;
import io.trino.client.QueryResults;
import io.trino.client.ResultRowsDecoder;
import io.trino.client.StatementClient;
import io.trino.client.StatementClientFactory;
import io.trino.client.uri.HttpClientFactory;
import io.trino.client.uri.TrinoUri;
import io.trino.plugin.memory.MemoryPlugin;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.server.BasicQueryInfo;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.Plugin;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.TimeZoneNotSupportedException;
import io.trino.testing.TestingSession;
import io.trino.testing.TestingTrinoClient;
import jakarta.ws.rs.core.Response;
import java.io.Closeable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestServer {
    private static final JsonCodec<QueryResults> QUERY_RESULTS_CODEC = new JsonCodecFactory((Provider)new ObjectMapperProvider().withModules(Set.of(new QueryDataJacksonModule()))).jsonCodec(QueryResults.class);
    private TestingTrinoServer server;
    private HttpClient client;

    @BeforeAll
    public void setup() {
        this.server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.of((Object)"http-server.process-forwarded", (Object)"true", (Object)"query.client.timeout", (Object)"1s")).build();
        this.server.installPlugin((Plugin)new MemoryPlugin());
        this.server.installPlugin((Plugin)new TpchPlugin());
        this.server.createCatalog("memory", "memory");
        this.server.createCatalog("tpch", "tpch");
        this.client = new JettyHttpClient();
    }

    @AfterAll
    public void tearDown() throws Exception {
        Closeables.closeAll((Closeable[])new Closeable[]{this.server, this.client});
        this.server = null;
        this.client = null;
    }

    @Test
    public void testInvalidSessionError() {
        String invalidTimeZone = "this_is_an_invalid_time_zone";
        QueryResults queryResults = (QueryResults)this.postQuery(request -> request.setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"show catalogs", (Charset)StandardCharsets.UTF_8)).setHeader(ProtocolHeaders.TRINO_HEADERS.requestCatalog(), "catalog").setHeader(ProtocolHeaders.TRINO_HEADERS.requestSchema(), "schema").setHeader(ProtocolHeaders.TRINO_HEADERS.requestPath(), "path").setHeader(ProtocolHeaders.TRINO_HEADERS.requestTimeZone(), invalidTimeZone)).map(FullJsonResponseHandler.JsonResponse::getValue).peek(result -> Preconditions.checkState((result.getError() == null != (result.getNextUri() == null) ? 1 : 0) != 0)).collect(TestServer.last());
        QueryError queryError = queryResults.getError();
        Assertions.assertThat((Object)queryError).isNotNull();
        TimeZoneNotSupportedException expected = new TimeZoneNotSupportedException(invalidTimeZone);
        Assertions.assertThat((int)queryError.getErrorCode()).isEqualTo(expected.getErrorCode().getCode());
        Assertions.assertThat((String)queryError.getErrorName()).isEqualTo(expected.getErrorCode().getName());
        Assertions.assertThat((String)queryError.getErrorType()).isEqualTo(expected.getErrorCode().getType().name());
        Assertions.assertThat((String)queryError.getMessage()).isEqualTo(expected.getMessage());
    }

    @Test
    public void testFirstResponseColumns() throws Exception {
        List queryResults = (List)this.postQuery(request -> request.setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"show catalogs", (Charset)StandardCharsets.UTF_8)).setHeader(ProtocolHeaders.TRINO_HEADERS.requestCatalog(), "catalog").setHeader(ProtocolHeaders.TRINO_HEADERS.requestSchema(), "schema").setHeader(ProtocolHeaders.TRINO_HEADERS.requestPath(), "path")).map(FullJsonResponseHandler.JsonResponse::getValue).collect(ImmutableList.toImmutableList());
        QueryResults first = (QueryResults)queryResults.getFirst();
        QueryResults last = (QueryResults)queryResults.getLast();
        Optional<QueryResults> data = queryResults.stream().filter(results -> results.getData() != null).findFirst();
        Assertions.assertThat((List)first.getColumns()).isNull();
        Assertions.assertThat((String)first.getStats().getState()).isEqualTo("QUEUED");
        Assertions.assertThat((Object)first.getData()).isNull();
        Assertions.assertThat((List)last.getColumns()).hasSize(1);
        Assertions.assertThat((String)((Column)Iterables.getOnlyElement((Iterable)last.getColumns())).getName()).isEqualTo("Catalog");
        Assertions.assertThat((String)((Column)Iterables.getOnlyElement((Iterable)last.getColumns())).getType()).isEqualTo("varchar(6)");
        Assertions.assertThat((String)last.getStats().getState()).isEqualTo("FINISHED");
        Assertions.assertThat(data).isPresent();
        QueryResults results2 = data.orElseThrow();
        try (ResultRowsDecoder decoder = new ResultRowsDecoder();){
            Assertions.assertThat((Iterable)decoder.toRows(results2)).containsOnly((Object[])new List[]{ImmutableList.of((Object)"memory"), ImmutableList.of((Object)"system"), ImmutableList.of((Object)"tpch")});
        }
    }

    @Test
    public void testServerStarts() {
        StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/info")).build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Assertions.assertThat((int)response.getStatusCode()).isEqualTo(Response.Status.OK.getStatusCode());
    }

    @Test
    public void testQuery() {
        ImmutableList.Builder data = ImmutableList.builder();
        QueryResults queryResults = (QueryResults)this.postQuery(request -> request.setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"show catalogs", (Charset)StandardCharsets.UTF_8)).setHeader(ProtocolHeaders.TRINO_HEADERS.requestCatalog(), "catalog").setHeader(ProtocolHeaders.TRINO_HEADERS.requestSchema(), "schema").setHeader(ProtocolHeaders.TRINO_HEADERS.requestPath(), "path").setHeader(ProtocolHeaders.TRINO_HEADERS.requestClientInfo(), "{\"clientVersion\":\"testVersion\"}").addHeader(ProtocolHeaders.TRINO_HEADERS.requestSession(), "query_max_memory=1GB").addHeader(ProtocolHeaders.TRINO_HEADERS.requestSession(), "join_distribution_type=partitioned,max_hash_partition_count = 43").addHeader(ProtocolHeaders.TRINO_HEADERS.requestPreparedStatement(), "foo=select * from bar")).map(FullJsonResponseHandler.JsonResponse::getValue).peek(result -> Assertions.assertThat((Object)result.getError()).isNull()).peek(results -> {
            if (results.getData() != null) {
                try (ResultRowsDecoder decoder = new ResultRowsDecoder();){
                    data.addAll((Iterable)decoder.toRows(results));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }).collect(TestServer.last());
        BasicQueryInfo queryInfo = this.server.getQueryManager().getQueryInfo(new QueryId(queryResults.getId()));
        Assertions.assertThat((Map)queryInfo.getSession().getSystemProperties()).isEqualTo((Object)ImmutableMap.builder().put((Object)"query_max_memory", (Object)"1GB").put((Object)"join_distribution_type", (Object)"partitioned").put((Object)"max_hash_partition_count", (Object)"43").buildOrThrow());
        Assertions.assertThat((String)((String)queryInfo.getSession().getClientInfo().get())).isEqualTo("{\"clientVersion\":\"testVersion\"}");
        Assertions.assertThat((Map)queryInfo.getSession().getPreparedStatements()).isEqualTo((Object)ImmutableMap.of((Object)"foo", (Object)"select * from bar"));
        ImmutableList rows = data.build();
        Assertions.assertThat((List)rows).isEqualTo((Object)ImmutableList.of((Object)ImmutableList.of((Object)"memory"), (Object)ImmutableList.of((Object)"system"), (Object)ImmutableList.of((Object)"tpch")));
    }

    @Test
    public void testTransactionSupport() {
        FullJsonResponseHandler.JsonResponse queryResults = (FullJsonResponseHandler.JsonResponse)this.postQuery(request -> request.setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"start transaction", (Charset)StandardCharsets.UTF_8)).setHeader(ProtocolHeaders.TRINO_HEADERS.requestTransactionId(), "none")).peek(result -> Assertions.assertThat((Object)((QueryResults)result.getValue()).getError()).isNull()).collect(TestServer.last());
        Assertions.assertThat((String)queryResults.getHeader(ProtocolHeaders.TRINO_HEADERS.responseStartedTransactionId())).isNotNull();
    }

    @Test
    public void testNoTransactionSupport() {
        QueryResults queryResults = this.postQuery(request -> request.setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"start transaction", (Charset)StandardCharsets.UTF_8))).map(FullJsonResponseHandler.JsonResponse::getValue).filter(result -> result.getError() != null).findFirst().orElseThrow(() -> new RuntimeException("Error expected"));
        Assertions.assertThat((URI)queryResults.getNextUri()).isNull();
        Assertions.assertThat((int)queryResults.getError().getErrorCode()).isEqualTo(StandardErrorCode.INCOMPATIBLE_CLIENT.toErrorCode().getCode());
    }

    @Test
    public void testVersionOnError() {
        this.checkVersionOnError("SELECT query that fails parsing", "ParsingException: line 1:19: mismatched input 'fails'. Expecting");
        this.checkVersionOnError("SELECT foo FROM some_catalog.some_schema.no_such_table", "TrinoException: line 1:17: Catalog 'some_catalog' not found");
        this.checkVersionOnError("SELECT 1 / 0", "TrinoException: Division by zero(?s:.*)at io.trino.sql.planner.LocalExecutionPlanner.plan");
        this.checkVersionOnError("select 1 / a from (values 0) t(a)", "TrinoException: Division by zero(?s:.*)at io.trino.sql.planner.LocalExecutionPlanner.plan");
        this.checkVersionOnError("select 1 / a + x + x from (values (rand(), 0)) t(x, a)", "TrinoException: Division by zero(?s:.*)at io.trino.operator.Driver.processInternal");
    }

    @Test
    public void testVersionOnCompilerFailedError() {
        String tableName = "memory.default.test_version_on_compiler_failed";
        try (TestingTrinoClient testingClient = new TestingTrinoClient(this.server, TestingSession.testSessionBuilder().build());){
            testingClient.execute("DROP TABLE IF EXISTS " + tableName);
            testingClient.execute("CREATE TABLE " + tableName + " AS SELECT '' as foo");
            String array = IntStream.range(0, 254).mapToObj(columnNumber -> "foo").collect(Collectors.joining(", ", "ARRAY[", "]"));
            String query = "SELECT " + String.join((CharSequence)" || ", Collections.nCopies(10, array)) + "FROM " + tableName;
            this.checkVersionOnError(query, "TrinoException: Failed to execute query; (?s:.*)at io.trino.sql.gen.PageFunctionCompiler.compileProjectionInternal");
        }
    }

    @Test
    public void testSetPathSupportByClient() {
        try (TestingTrinoClient testingClient = new TestingTrinoClient(this.server, TestingSession.testSessionBuilder().setClientCapabilities(Set.of()).build());){
            Assertions.assertThatThrownBy(() -> testingClient.execute("SET PATH foo")).hasMessage("SET PATH not supported by client");
        }
        testingClient = new TestingTrinoClient(this.server, TestingSession.testSessionBuilder().setClientCapabilities(Set.of(ClientCapabilities.PATH.name())).build());
        try {
            testingClient.execute("SET PATH foo");
        }
        finally {
            testingClient.close();
        }
    }

    @Test
    public void testSetSessionSupportByClient() {
        try (TestingTrinoClient testingClient = new TestingTrinoClient(this.server, TestingSession.testSessionBuilder().setClientCapabilities(Set.of()).build());){
            Assertions.assertThatThrownBy(() -> testingClient.execute("SET SESSION AUTHORIZATION userA")).hasMessage("SET SESSION AUTHORIZATION not supported by client");
        }
        testingClient = new TestingTrinoClient(this.server, TestingSession.testSessionBuilder().setClientCapabilities(Set.of(ClientCapabilities.SESSION_AUTHORIZATION.name())).build());
        try {
            testingClient.execute("SET SESSION AUTHORIZATION userA");
        }
        finally {
            testingClient.close();
        }
    }

    @Test
    public void testAbandonedQueries() throws InterruptedException {
        TrinoUri trinoUri = TrinoUri.builder().setUri(this.server.getBaseUrl()).build();
        OkHttpClient httpClient = HttpClientFactory.toHttpClientBuilder((TrinoUri)trinoUri, (String)"Trino Test").build();
        ClientSession session = ClientSession.builder().server(this.server.getBaseUrl()).source("test").timeZone(ZoneId.of("UTC")).user(Optional.of("user")).heartbeatInterval(new Duration(1.0, TimeUnit.SECONDS)).build();
        try (StatementClient client = StatementClientFactory.newStatementClient((Call.Factory)httpClient, (ClientSession)session, (String)"SELECT * FROM tpch.sf1.nation");){
            client.advance();
            Thread.sleep(2000L);
            client.advance();
            Assertions.assertThat((String)client.currentStatusInfo().getError().getMessage()).contains(new CharSequence[]{"was abandoned by the client, as it may have exited or stopped checking for query results"});
        }
        client = StatementClientFactory.newStatementClient((Call.Factory)httpClient, (ClientSession)session, (String)"SELECT * FROM tpch.sf1.nation");
        try {
            while (client.advance()) {
                client.currentRows().forEach(list -> {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                });
                Assertions.assertThat((Object)client.currentStatusInfo().getError()).isNull();
            }
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void testResetSessionSupportByClient() {
        try (TestingTrinoClient testingClient = new TestingTrinoClient(this.server, TestingSession.testSessionBuilder().setClientCapabilities(Set.of()).build());){
            Assertions.assertThatThrownBy(() -> testingClient.execute("RESET SESSION AUTHORIZATION")).hasMessage("RESET SESSION AUTHORIZATION not supported by client");
        }
        testingClient = new TestingTrinoClient(this.server, TestingSession.testSessionBuilder().setClientCapabilities(Set.of(ClientCapabilities.SESSION_AUTHORIZATION.name())).build());
        try {
            testingClient.execute("RESET SESSION AUTHORIZATION");
        }
        finally {
            testingClient.close();
        }
    }

    private void checkVersionOnError(String query, @Language(value="RegExp") String proofOfOrigin) {
        QueryResults queryResults = this.postQuery(request -> request.setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)query, (Charset)StandardCharsets.UTF_8))).map(FullJsonResponseHandler.JsonResponse::getValue).filter(result -> result.getError() != null).findFirst().orElseThrow(() -> new RuntimeException("Error expected"));
        Assertions.assertThat((URI)queryResults.getNextUri()).isNull();
        QueryError queryError = queryResults.getError();
        String stackTrace = Throwables.getStackTraceAsString((Throwable)queryError.getFailureInfo().toException());
        Assertions.assertThat((String)stackTrace).containsPattern((CharSequence)proofOfOrigin);
        long versionLines = Splitter.on((String)"\n").splitToStream((CharSequence)stackTrace).filter(line -> line.contains("at io.trino.$gen.Trino_testversion____")).count();
        if (versionLines != 1L) {
            Fail.fail((String)String.format("Expected version embedded in the stacktrace exactly once, but was %s: %s", versionLines, stackTrace));
        }
    }

    @Test
    public void testStatusPing() {
        Request request = Request.Builder.prepareHead().setUri(this.uriFor("/v1/status")).setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "unknown").setFollowRedirects(false).build();
        StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)this.client.execute(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        ((AbstractIntegerAssert)Assertions.assertThat((int)response.getStatusCode()).describedAs("Status code", new Object[0])).isEqualTo(Response.Status.OK.getStatusCode());
        ((AbstractStringAssert)Assertions.assertThat((String)response.getHeader("Content-Type")).describedAs("Content Type", new Object[0])).isEqualTo("application/json");
    }

    @Test
    public void testRedirectToUi() {
        Request request = Request.Builder.prepareGet().setUri(this.uriFor("/")).setFollowRedirects(false).build();
        StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)this.client.execute(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        ((AbstractIntegerAssert)Assertions.assertThat((int)response.getStatusCode()).describedAs("Status code", new Object[0])).isEqualTo(Response.Status.SEE_OTHER.getStatusCode());
        ((AbstractStringAssert)Assertions.assertThat((String)response.getHeader("Location")).describedAs("Location", new Object[0])).isEqualTo(String.valueOf(this.server.getBaseUrl()) + "/ui/");
        request = Request.Builder.prepareGet().setUri(this.uriFor("/")).setHeader("X-Forwarded-Proto", "https").setHeader("X-Forwarded-Host", "my-load-balancer.local").setHeader("X-Forwarded-Port", "443").setFollowRedirects(false).build();
        response = (StatusResponseHandler.StatusResponse)this.client.execute(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        ((AbstractIntegerAssert)Assertions.assertThat((int)response.getStatusCode()).describedAs("Status code", new Object[0])).isEqualTo(Response.Status.SEE_OTHER.getStatusCode());
        ((AbstractStringAssert)Assertions.assertThat((String)response.getHeader("Location")).describedAs("Location", new Object[0])).isEqualTo("https://my-load-balancer.local/ui/");
    }

    private Stream<FullJsonResponseHandler.JsonResponse<QueryResults>> postQuery(Function<Request.Builder, Request.Builder> requestConfigurer) {
        Request.Builder request = Request.Builder.preparePost().setUri(this.uriFor("/v1/statement")).setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "user").setHeader(ProtocolHeaders.TRINO_HEADERS.requestSource(), "source");
        request = requestConfigurer.apply(request);
        FullJsonResponseHandler.JsonResponse queryResults = (FullJsonResponseHandler.JsonResponse)this.client.execute(request.build(), (ResponseHandler)FullJsonResponseHandler.createFullJsonResponseHandler(QUERY_RESULTS_CODEC));
        return Streams.stream((Iterator)((Object)new QueryResultsIterator(this.client, (FullJsonResponseHandler.JsonResponse<QueryResults>)queryResults)));
    }

    private URI uriFor(String path) {
        return HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath(path).build();
    }

    private static <T> Collector<T, ?, T> last() {
        return Collectors.collectingAndThen(Collectors.reducing((a, b) -> b), Optional::get);
    }

    private static class QueryResultsIterator
    extends AbstractSequentialIterator<FullJsonResponseHandler.JsonResponse<QueryResults>> {
        private final HttpClient client;

        QueryResultsIterator(HttpClient client, FullJsonResponseHandler.JsonResponse<QueryResults> firstResults) {
            super(Objects.requireNonNull(firstResults, "firstResults is null"));
            this.client = Objects.requireNonNull(client, "client is null");
        }

        protected FullJsonResponseHandler.JsonResponse<QueryResults> computeNext(FullJsonResponseHandler.JsonResponse<QueryResults> previous) {
            if (((QueryResults)previous.getValue()).getNextUri() == null) {
                return null;
            }
            return (FullJsonResponseHandler.JsonResponse)this.client.execute(Request.Builder.prepareGet().setUri(((QueryResults)previous.getValue()).getNextUri()).build(), (ResponseHandler)FullJsonResponseHandler.createFullJsonResponseHandler(QUERY_RESULTS_CODEC));
        }
    }
}

