/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.connector.MockConnector;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.connector.TestingTableFunctions;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.connector.TableFunctionApplicationResult;
import io.trino.spi.function.FunctionProvider;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.function.table.TableFunctionProcessorProvider;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTableFunctionInvocation
extends AbstractTestQueryFramework {
    private static final String TESTING_CATALOG = "testing_catalog";
    private static final String TABLE_FUNCTION_SCHEMA = "table_function_schema";

    protected QueryRunner createQueryRunner() throws Exception {
        return DistributedQueryRunner.builder((Session)TestingSession.testSessionBuilder().setCatalog(TESTING_CATALOG).setSchema(TABLE_FUNCTION_SCHEMA).build()).setAdditionalSetup(queryRunner -> {
            queryRunner.installPlugin((Plugin)new MockConnectorPlugin((ConnectorFactory)MockConnectorFactory.builder().withTableFunctions((Iterable)ImmutableSet.of((Object)new TestingTableFunctions.SimpleTableFunctionWithAccessControl(), (Object)new TestingTableFunctions.IdentityFunction(), (Object)new TestingTableFunctions.IdentityPassThroughFunction(), (Object)new TestingTableFunctions.RepeatFunction(), (Object)new TestingTableFunctions.EmptyOutputFunction(), (Object)new TestingTableFunctions.EmptyOutputWithPassThroughFunction(), (Object[])new ConnectorTableFunction[]{new TestingTableFunctions.TestInputsFunction(), new TestingTableFunctions.PassThroughInputFunction(), new TestingTableFunctions.TestInputFunction(), new TestingTableFunctions.TestSingleInputRowSemanticsFunction(), new TestingTableFunctions.ConstantFunction(), new TestingTableFunctions.EmptySourceFunction()})).withApplyTableFunction((session, handle) -> {
                if (handle instanceof TestingTableFunctions.SimpleTableFunction.SimpleTableFunctionHandle) {
                    TestingTableFunctions.SimpleTableFunction.SimpleTableFunctionHandle functionHandle = (TestingTableFunctions.SimpleTableFunction.SimpleTableFunctionHandle)handle;
                    return Optional.of(new TableFunctionApplicationResult((Object)functionHandle.getTableHandle(), (List)functionHandle.getTableHandle().getColumns().orElseThrow()));
                }
                return Optional.empty();
            }).withFunctionProvider(Optional.of(new FunctionProvider(this){

                public TableFunctionProcessorProvider getTableFunctionProcessorProvider(ConnectorTableFunctionHandle functionHandle) {
                    if (functionHandle instanceof TestingTableFunctions.TestingTableFunctionHandle) {
                        TestingTableFunctions.TestingTableFunctionHandle handle = (TestingTableFunctions.TestingTableFunctionHandle)functionHandle;
                        return switch (handle.name().getFunctionName()) {
                            case "identity_function" -> new TestingTableFunctions.IdentityFunction.IdentityFunctionProcessorProvider();
                            case "identity_pass_through_function" -> new TestingTableFunctions.IdentityPassThroughFunction.IdentityPassThroughFunctionProcessorProvider();
                            case "empty_output" -> new TestingTableFunctions.EmptyOutputFunction.EmptyOutputProcessorProvider();
                            case "empty_output_with_pass_through" -> new TestingTableFunctions.EmptyOutputWithPassThroughFunction.EmptyOutputWithPassThroughProcessorProvider();
                            case "test_inputs_function" -> new TestingTableFunctions.TestInputsFunction.TestInputsFunctionProcessorProvider();
                            case "pass_through" -> new TestingTableFunctions.PassThroughInputFunction.PassThroughInputProcessorProvider();
                            case "test_input" -> new TestingTableFunctions.TestInputFunction.TestInputProcessorProvider();
                            case "test_single_input_function" -> new TestingTableFunctions.TestSingleInputRowSemanticsFunction.TestSingleInputFunctionProcessorProvider();
                            case "empty_source" -> new TestingTableFunctions.EmptySourceFunction.EmptySourceFunctionProcessorProvider();
                            default -> throw new IllegalArgumentException("unexpected table function: " + String.valueOf(handle.name()));
                        };
                    }
                    if (functionHandle instanceof TestingTableFunctions.RepeatFunction.RepeatFunctionHandle) {
                        return new TestingTableFunctions.RepeatFunction.RepeatFunctionProcessorProvider();
                    }
                    if (functionHandle instanceof TestingTableFunctions.ConstantFunction.ConstantFunctionHandle) {
                        return new TestingTableFunctions.ConstantFunction.ConstantFunctionProcessorProvider();
                    }
                    return null;
                }
            })).withTableFunctionSplitSources(functionHandle -> {
                TestingTableFunctions.TestingTableFunctionHandle handle;
                if (functionHandle instanceof TestingTableFunctions.ConstantFunction.ConstantFunctionHandle) {
                    TestingTableFunctions.ConstantFunction.ConstantFunctionHandle handle2 = (TestingTableFunctions.ConstantFunction.ConstantFunctionHandle)functionHandle;
                    return TestingTableFunctions.ConstantFunction.getConstantFunctionSplitSource((TestingTableFunctions.ConstantFunction.ConstantFunctionHandle)handle2);
                }
                if (functionHandle instanceof TestingTableFunctions.TestingTableFunctionHandle && (handle = (TestingTableFunctions.TestingTableFunctionHandle)functionHandle).name().equals((Object)new SchemaFunctionName("system", "empty_source"))) {
                    return new FixedSplitSource((Iterable)ImmutableList.of((Object)MockConnector.MockConnectorSplit.MOCK_CONNECTOR_SPLIT));
                }
                return null;
            }).build()));
            queryRunner.createCatalog(TESTING_CATALOG, "mock", (Map)ImmutableMap.of());
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog("tpch", "tpch", (Map)ImmutableMap.of());
        }).build();
    }

    @Test
    public void testPrimitiveDefaultArgument() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT boolean_column FROM TABLE(system.simple_table_function(column => 'boolean_column', ignored => 1))"))).matches("SELECT true WHERE false");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT boolean_column FROM TABLE(system.simple_table_function(column => 'boolean_column'))"))).matches("SELECT true WHERE false");
    }

    @Test
    public void testAccessControl() {
        this.assertAccessDenied("SELECT boolean_column FROM TABLE(system.simple_table_function(column => 'boolean_column', ignored => 1))", "Cannot select from columns .*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"simple_table.boolean_column", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessDenied("SELECT boolean_column FROM TABLE(system.simple_table_function(column => 'boolean_column', ignored => 1))", "Cannot select from columns .*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"simple_table", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
    }

    @Test
    public void testNoArgumentsPassed() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT col FROM TABLE(system.simple_table_function())"))).matches("SELECT true WHERE false");
    }

    @Test
    public void testIdentityFunction() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT b, a FROM TABLE(system.identity_function(input => TABLE(VALUES (1, 2), (3, 4), (5, 6)) T(a, b)))"))).matches("VALUES (2, 1), (4, 3), (6, 5)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT b, a FROM TABLE(system.identity_pass_through_function(input => TABLE(VALUES (1, 2), (3, 4), (5, 6)) T(a, b)))"))).matches("VALUES (2, 1), (4, 3), (6, 5)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT i.b, a FROM TABLE(system.identity_function(input => TABLE(VALUES ('x', 1), ('y', 2), ('z', null)) T(a, b) PARTITION BY b)) i"))).matches("VALUES (1, 'x'), (2, 'y'), (null, 'z')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT b, a FROM TABLE(system.identity_pass_through_function(input => TABLE(VALUES ('x', 1), ('y', 2), ('z', null)) T(a, b) PARTITION BY b))"))).matches("VALUES (1, 'x'), (2, 'y'), (null, 'z')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM TABLE(system.identity_function(input => TABLE(tpch.tiny.orders)))"))).matches("SELECT * FROM tpch.tiny.orders");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT row_number, * FROM TABLE(system.identity_pass_through_function(input => TABLE(tpch.tiny.orders)))"))).matches("SELECT row_number, * FROM tpch.tiny.orders");
    }

    @Test
    public void testRepeatFunction() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.repeat(TABLE(VALUES (1, 2), (3, 4), (5, 6))))\n"))).matches("VALUES (1, 2), (1, 2), (3, 4), (3, 4), (5, 6), (5, 6)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.repeat(\n                        TABLE(VALUES ('a', true), ('b', false)),\n                        4))\n"))).matches("VALUES ('a', true), ('b', false), ('a', true), ('b', false), ('a', true), ('b', false), ('a', true), ('b', false)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.repeat(\n                        TABLE(VALUES ('a', true), ('b', false)) t(x, y) PARTITION BY x,\n                        4))\n"))).matches("VALUES ('a', true), ('b', false), ('a', true), ('b', false), ('a', true), ('b', false), ('a', true), ('b', false)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.repeat(\n                        TABLE(VALUES ('a', true), ('b', false)) t(x, y) ORDER BY y,\n                        4))\n"))).matches("VALUES ('a', true), ('b', false), ('a', true), ('b', false), ('a', true), ('b', false), ('a', true), ('b', false)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.repeat(\n                        TABLE(VALUES ('a', true), ('b', false)) t(x, y) PARTITION BY x ORDER BY y,\n                        4))\n"))).matches("VALUES ('a', true), ('b', false), ('a', true), ('b', false), ('a', true), ('b', false), ('a', true), ('b', false)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.repeat(TABLE(tpch.tiny.part), 3))\n"))).matches("SELECT * FROM tpch.tiny.part UNION ALL TABLE tpch.tiny.part UNION ALL TABLE tpch.tiny.part");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.repeat(TABLE(tpch.tiny.part) PARTITION BY type, 3))\n"))).matches("SELECT * FROM tpch.tiny.part UNION ALL TABLE tpch.tiny.part UNION ALL TABLE tpch.tiny.part");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.repeat(TABLE(tpch.tiny.part) ORDER BY size, 3))\n"))).matches("SELECT * FROM tpch.tiny.part UNION ALL TABLE tpch.tiny.part UNION ALL TABLE tpch.tiny.part");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.repeat(TABLE(tpch.tiny.part) PARTITION BY type ORDER BY size, 3))\n"))).matches("SELECT * FROM tpch.tiny.part UNION ALL TABLE tpch.tiny.part UNION ALL TABLE tpch.tiny.part");
    }

    @Test
    public void testFunctionsReturningEmptyPages() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.empty_output(TABLE(tpch.tiny.orders)))\n"))).matches("SELECT true WHERE false");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.empty_output(TABLE(tpch.tiny.orders) PARTITION BY orderstatus))\n"))).matches("SELECT true, 'X' WHERE false");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.empty_output_with_pass_through(TABLE(tpch.tiny.orders)))\n"))).matches("SELECT true, * FROM tpch.tiny.orders WHERE false");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.empty_output_with_pass_through(TABLE(tpch.tiny.orders) PARTITION BY orderstatus))\n"))).matches("SELECT true, * FROM tpch.tiny.orders WHERE false");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.empty_output(TABLE(SELECT * FROM tpch.tiny.orders WHERE false)))\n"))).matches("SELECT true WHERE false");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.empty_output(TABLE(SELECT * FROM tpch.tiny.orders WHERE false) PARTITION BY orderstatus))\n"))).matches("SELECT true, 'X' WHERE false");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.empty_output_with_pass_through(TABLE(SELECT * FROM tpch.tiny.orders WHERE false)))\n"))).matches("SELECT true, * FROM tpch.tiny.orders WHERE false");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.empty_output_with_pass_through(TABLE(SELECT * FROM tpch.tiny.orders WHERE false) PARTITION BY orderstatus))\n"))).matches("SELECT true, * FROM tpch.tiny.orders WHERE false");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.empty_source())\n"))).matches("SELECT true WHERE false");
    }

    @Test
    public void testInputPartitioning() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.test_inputs_function(\n               input_1 => TABLE(VALUES 1, 2, 3),\n               input_2 => TABLE(VALUES 4, 5, 4, 5, 4) t2(x2) PARTITION BY x2,\n               input_3 => TABLE(VALUES 6, 7, 6) t3(x3) PARTITION BY x3,\n               input_4 => TABLE(VALUES 8, 9)))\n"))).matches("VALUES (true, 4, 6), (true, 4, 7), (true, 5, 6), (true, 5, 7)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.test_inputs_function(\n               input_1 => TABLE(VALUES 1, 2, 3),\n               input_2 => TABLE(VALUES 4, 5, 4, 5, 4) t2(x2) PARTITION BY x2,\n               input_3 => TABLE(VALUES 6, 7, 6) t3(x3) PARTITION BY x3,\n               input_4 => TABLE(VALUES 8, 9) t4(x4) PARTITION BY x4))\n"))).matches("VALUES (true, 4, 6, 8), (true, 4, 6, 9), (true, 4, 7, 8), (true, 4, 7, 9), (true, 5, 6, 8), (true, 5, 6, 9), (true, 5, 7, 8), (true, 5, 7, 9)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.test_inputs_function(\n               input_1 => TABLE(VALUES 1, 2, 3),\n               input_2 => TABLE(VALUES 4, 5, 4, 5, 4) t2(x2) PARTITION BY x2,\n               input_3 => TABLE(VALUES 6, 7, 6) t3(x3) PARTITION BY x3,\n               input_4 => TABLE(VALUES 8, 8) t4(x4) PARTITION BY x4))\n"))).matches("VALUES (true, 4, 6, 8), (true, 4, 7, 8), (true, 5, 6, 8), (true, 5, 7, 8)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.test_inputs_function(\n               input_1 => TABLE(VALUES 1, null),\n               input_2 => TABLE(VALUES 2, null, 2, null) t2(x2) PARTITION BY x2,\n               input_3 => TABLE(VALUES 3, null, 3, null) t3(x3) PARTITION BY x3,\n               input_4 => TABLE(VALUES null, null) t4(x4) PARTITION BY x4))\n"))).matches("VALUES (true, 2, 3, null), (true, 2, null, null), (true, null, 3, null), (true, null, null, null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.test_inputs_function(\n               input_1 => TABLE(VALUES 1, 2, 3),\n               input_2 => TABLE(VALUES 4, 5, 4, 5, 4),\n               input_3 => TABLE(VALUES 6, 7, 6),\n               input_4 => TABLE(VALUES 8, 9)))\n"))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT DISTINCT regionkey, nationkey\nFROM TABLE(system.test_inputs_function(\n               input_1 => TABLE(tpch.tiny.nation),\n               input_2 => TABLE(tpch.tiny.nation) PARTITION BY regionkey ORDER BY name,\n               input_3 => TABLE(tpch.tiny.customer) PARTITION BY nationkey,\n               input_4 => TABLE(tpch.tiny.customer)))\n"))).matches("SELECT DISTINCT n.regionkey, c.nationkey FROM tpch.tiny.nation n, tpch.tiny.customer c");
    }

    @Test
    public void testEmptyPartitions() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.test_inputs_function(\n               input_1 => TABLE(VALUES 1, 2, 3),\n               input_2 => TABLE(SELECT 2 WHERE false),\n               input_3 => TABLE(SELECT 3 WHERE false),\n               input_4 => TABLE(SELECT 4 WHERE false)))\n"))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.test_inputs_function(\n               input_1 => TABLE(SELECT 1 WHERE false),\n               input_2 => TABLE(VALUES 2),\n               input_3 => TABLE(VALUES 3),\n               input_4 => TABLE(VALUES 4)))\n"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.test_inputs_function(\n               input_1 => TABLE(VALUES 1, 2, 3),\n               input_2 => TABLE(SELECT 2 WHERE false) t2(x2) PARTITION BY x2,\n               input_3 => TABLE(SELECT 3 WHERE false) t3(x3) PARTITION BY x3,\n               input_4 => TABLE(SELECT 4 WHERE false) t4(x4) PARTITION BY x4))\n"))).matches("VALUES (true, CAST(null AS integer), CAST(null AS integer), CAST(null AS integer))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.test_inputs_function(\n               input_1 => TABLE(VALUES 1, 2, 3),\n               input_2 => TABLE(SELECT 2 WHERE false) t2(x2) PARTITION BY x2,\n               input_3 => TABLE(VALUES 3, 4, 4) t3(x3) PARTITION BY x3,\n               input_4 => TABLE(VALUES 4, 4, 4, 5, 5, 5, 5) t4(x4) PARTITION BY x4))\n"))).matches("VALUES (true, CAST(null AS integer), 3, 4), (true, null, 4, 4), (true, null, 4, 5), (true, null, 3, 5)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.test_inputs_function(\n               input_1 => TABLE(VALUES 1, 2, 3),\n               input_2 => TABLE(SELECT 2 WHERE false) t2(x2) PARTITION BY x2,\n               input_3 => TABLE(SELECT 3 WHERE false) t3(x3) PARTITION BY x3,\n               input_4 => TABLE(VALUES 4, 5) t4(x4) PARTITION BY x4))\n"))).matches("VALUES (true, CAST(null AS integer), CAST(null AS integer), 4), (true, null, null, 5)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.test_inputs_function(\n               input_1 => TABLE(VALUES 1, 2, 3),\n               input_2 => TABLE(SELECT 2 WHERE false) t2(x2) PARTITION BY x2 PRUNE WHEN EMPTY,\n               input_3 => TABLE(SELECT 3 WHERE false) t3(x3) PARTITION BY x3,\n               input_4 => TABLE(VALUES 4, 5) t4(x4) PARTITION BY x4))\n"))).returnsEmptyResult();
    }

    @Test
    public void testCopartitioning() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.test_inputs_function(\n               input_1 => TABLE(VALUES 1, 2, 3),\n               input_2 => TABLE(VALUES 1, 1, 2, 2) t2(x2) PARTITION BY x2,\n               input_3 => TABLE(VALUES 4, 5) t3(x3),\n               input_4 => TABLE(VALUES 2, 2, 2, 3) t4(x4) PARTITION BY x4\n               COPARTITION (t2, t4)))\n"))).matches("VALUES (true, 1, null), (true, 2, 2), (true, null, 3)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.test_inputs_function(\n               input_1 => TABLE(VALUES 1, 2, 3),\n               input_2 => TABLE(VALUES 1, 1, 2, 2) t2(x2) PARTITION BY x2 PRUNE WHEN EMPTY,\n               input_3 => TABLE(VALUES 4, 5) t3(x3),\n               input_4 => TABLE(VALUES 2, 2, 2, 3) t4(x4) PARTITION BY x4\n               COPARTITION (t2, t4)))\n"))).matches("VALUES (true, 1, null), (true, 2, 2)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.test_inputs_function(\n               input_1 => TABLE(VALUES 1, 2, 3),\n               input_2 => TABLE(VALUES 1, 1, 2, 2) t2(x2) PARTITION BY x2,\n               input_3 => TABLE(VALUES 4, 5) t3(x3),\n               input_4 => TABLE(VALUES 2, 2, 2, 3) t4(x4) PARTITION BY x4 PRUNE WHEN EMPTY\n               COPARTITION (t2, t4)))\n"))).matches("VALUES (true, 2, 2), (true, null, 3)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.test_inputs_function(\n               input_1 => TABLE(VALUES 1, 2, 3),\n               input_2 => TABLE(VALUES 1, 1, 2, 2) t2(x2) PARTITION BY x2 PRUNE WHEN EMPTY,\n               input_3 => TABLE(VALUES 4, 5) t3(x3),\n               input_4 => TABLE(VALUES 2, 2, 2, 3) t4(x4) PARTITION BY x4 PRUNE WHEN EMPTY\n               COPARTITION (t2, t4)))\n"))).matches("VALUES (true, 2, 2)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.test_inputs_function(\n               input_1 => TABLE(VALUES 1, 2, 3),\n               input_2 => TABLE(VALUES 1, 1, null, null, 2, 2) t2(x2) PARTITION BY x2,\n               input_3 => TABLE(VALUES 4, 5) t3(x3),\n               input_4 => TABLE(VALUES null, 2, 2, 2, 3) t4(x4) PARTITION BY x4\n               COPARTITION (t2, t4)))\n"))).matches("VALUES (true, 1, null), (true, 2, 2), (true, null, null), (true, null, 3)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.test_inputs_function(\n               input_1 => TABLE(VALUES 1, 2, 3),\n               input_2 => TABLE(VALUES 1, 1, null, null, 2, 2) t2(x2) PARTITION BY x2 PRUNE WHEN EMPTY,\n               input_3 => TABLE(VALUES 4, 5) t3(x3),\n               input_4 => TABLE(VALUES null, 2, 2, 2, 3) t4(x4) PARTITION BY x4 PRUNE WHEN EMPTY\n               COPARTITION (t2, t4)))\n"))).matches("VALUES (true, 2, 2), (true, null, null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.test_inputs_function(\n               input_1 => TABLE(VALUES 1, 2, 3),\n               input_2 => TABLE(VALUES 1, 1, null, null) t2(x2) PARTITION BY x2,\n               input_3 => TABLE(VALUES 2, 2, null) t3(x3) PARTITION BY x3,\n               input_4 => TABLE(VALUES 2, 3, 3) t4(x4) PARTITION BY x4\n               COPARTITION (t2, t4, t3)))\n"))).matches("VALUES (true, 1, null, null), (true, null, null, null), (true, null, 2, 2), (true, null, null, 3)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.test_inputs_function(\n               input_1 => TABLE(VALUES 1, 2, 3),\n               input_2 => TABLE(VALUES 1, 1, null, null) t2(x2) PARTITION BY x2,\n               input_3 => TABLE(VALUES 2, 2, null) t3(x3) PARTITION BY x3 PRUNE WHEN EMPTY,\n               input_4 => TABLE(VALUES 2, 3, 3) t4(x4) PARTITION BY x4\n               COPARTITION (t2, t4, t3)))\n"))).matches("VALUES (true, CAST(null AS integer), null, null), (true, null, 2, 2)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.test_inputs_function(\n               input_1 => TABLE(VALUES 1, 2, 3),\n               input_2 => TABLE(VALUES 1, 1, null, null) t2(x2) PARTITION BY x2 PRUNE WHEN EMPTY,\n               input_3 => TABLE(VALUES 2, 2, null) t3(x3) PARTITION BY x3,\n               input_4 => TABLE(VALUES 2, 3, 3) t4(x4) PARTITION BY x4\n               COPARTITION (t2, t4, t3)))\n"))).matches("VALUES (true, 1, CAST(null AS integer), CAST(null AS integer)), (true, null, null, null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.test_inputs_function(\n               input_1 => TABLE(VALUES 1, 2, 3),\n               input_2 => TABLE(VALUES 1, 1, null, null) t2(x2) PARTITION BY x2 PRUNE WHEN EMPTY,\n               input_3 => TABLE(VALUES 2, 2, null) t3(x3) PARTITION BY x3,\n               input_4 => TABLE(VALUES 2, 3, 3) t4(x4) PARTITION BY x4 PRUNE WHEN EMPTY\n               COPARTITION (t2, t4, t3)))\n"))).returnsEmptyResult();
    }

    @Test
    public void testPassThroughWithEmptyPartitions() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.pass_through(\n                            TABLE(VALUES (1, 'a'), (2, 'b')) t1(a1, b1) PARTITION BY a1,\n                            TABLE(VALUES (2, 'x'), (3, 'y')) t2(a2, b2) PARTITION BY a2\n                            COPARTITION (t1, t2)))\n"))).matches("VALUES (true, false, 1, 'a', null, null), (true, true, 2, 'b', 2, 'x'), (false, true, null, null, 3, 'y')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.pass_through(\n                            TABLE(VALUES (1, 'a'), (2, 'b')) t1(a1, b1) PARTITION BY a1,\n                            TABLE(SELECT 2, 'x' WHERE false) t2(a2, b2) PARTITION BY a2\n                            COPARTITION (t1, t2)))\n"))).matches("VALUES (true, false, 1, 'a', CAST(null AS integer), CAST(null AS VARCHAR(1))), (true, false, 2, 'b', null, null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.pass_through(\n                            TABLE(VALUES (1, 'a'), (2, 'b')) t1(a1, b1) PARTITION BY a1,\n                            TABLE(SELECT 2, 'x' WHERE false) t2(a2, b2) PARTITION BY a2))\n"))).matches("VALUES (true, false, 1, 'a', CAST(null AS integer), CAST(null AS VARCHAR(1))), (true, false, 2, 'b', null, null)");
    }

    @Test
    public void testPassThroughWithEmptyInput() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.pass_through(\n                            TABLE(SELECT 1, 'x' WHERE false) t1(a1, b1) PARTITION BY a1,\n                            TABLE(SELECT 2, 'y' WHERE false) t2(a2, b2) PARTITION BY a2\n                            COPARTITION (t1, t2)))\n"))).matches("VALUES (false, false, CAST(null AS integer), CAST(null AS VARCHAR(1)), CAST(null AS integer), CAST(null AS VARCHAR(1)))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.pass_through(\n                            TABLE(SELECT 1, 'x' WHERE false) t1(a1, b1) PARTITION BY a1,\n                            TABLE(SELECT 2, 'y' WHERE false) t2(a2, b2) PARTITION BY a2))\n"))).matches("VALUES (false, false, CAST(null AS integer), CAST(null AS VARCHAR(1)), CAST(null AS integer), CAST(null AS VARCHAR(1)))");
    }

    @Test
    public void testInput() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT got_input\nFROM TABLE(system.test_input(TABLE(VALUES 1)))\n"))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT got_input\nFROM TABLE(system.test_input(TABLE(VALUES 1, 2, 3) t(a) PARTITION BY a))\n"))).matches("VALUES true, true, true");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT got_input\nFROM TABLE(system.test_input(TABLE(SELECT 1 WHERE false)))\n"))).matches("VALUES false");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT got_input\nFROM TABLE(system.test_input(TABLE(SELECT 1 WHERE false) t(a) PARTITION BY a))\n"))).matches("VALUES false");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT got_input\nFROM TABLE(system.test_input(TABLE(SELECT * FROM tpch.tiny.orders WHERE false)))\n"))).matches("VALUES false");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT got_input\nFROM TABLE(system.test_input(TABLE(SELECT * FROM tpch.tiny.orders WHERE false) PARTITION BY orderstatus ORDER BY orderkey))\n"))).matches("VALUES false");
    }

    @Test
    public void testSingleSourceWithRowSemantics() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.test_single_input_function(TABLE(VALUES (true), (false), (true))))\n"))).matches("VALUES true");
    }

    @Test
    public void testConstantFunction() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.constant(5))\n"))).matches("VALUES 5");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.constant(2, 10))\n"))).matches("VALUES (2), (2), (2), (2), (2), (2), (2), (2), (2), (2)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.constant(null, 3))\n"))).matches("VALUES (CAST(null AS integer)), (null), (null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.constant(5 * 4, 3))\n"))).matches("VALUES (20), (20), (20)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.constant(2147483648, 3))\n"))).failure().hasMessage("line 2:28: Cannot cast type bigint to integer");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(*), count(DISTINCT constant_column), min(constant_column)\nFROM TABLE(system.constant(2, 1000000))\n"))).matches("VALUES (BIGINT '1000000', BIGINT '1', 2)");
        this.assertQueryReturnsEmptyResult("SELECT *\nFROM TABLE(system.constant(5, 0))\n");
    }

    @Test
    public void testPruneAllColumns() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT 'a' FROM TABLE(system.identity_pass_through_function(input => TABLE(VALUES 1, 2, 3)))"))).matches("VALUES 'a', 'a', 'a'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT 'a' FROM TABLE(system.identity_pass_through_function(input => TABLE(SELECT 1 WHERE false)))"))).matches("SELECT 'a' WHERE false");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT 'a' FROM TABLE(system.identity_pass_through_function(input => TABLE(SELECT 1 WHERE false) PRUNE WHEN EMPTY))"))).matches("SELECT 'a' WHERE false");
    }

    @Test
    public void testPrunePassThroughColumns() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT p1, p2, x1, x2, y1, y2\nFROM TABLE(system.pass_through(\n                            TABLE(VALUES (1, 'a'), (2, 'b'), (3, 'c')) t1(x1, x2),\n                            TABLE(VALUES (4, 'd'), (5, 'e')) t2(y1, y2))) t(p1, p2)\n"))).matches("VALUES (true, true, 3, 'c', 5, 'e')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT x1, x2, y1, y2\nFROM TABLE(system.pass_through(\n                            TABLE(VALUES (1, 'a'), (2, 'b'), (3, 'c')) t1(x1, x2),\n                            TABLE(VALUES (4, 'd'), (5, 'e')) t2(y1, y2))) t(p1, p2)\n"))).matches("VALUES (3, 'c', 5, 'e')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT x2, y2\nFROM TABLE(system.pass_through(\n                            TABLE(VALUES (1, 'a'), (2, 'b'), (3, 'c')) t1(x1, x2),\n                            TABLE(VALUES (4, 'd'), (5, 'e')) t2(y1, y2))) t(p1, p2)\n"))).matches("VALUES ('c', 'e')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT y1, y2\nFROM TABLE(system.pass_through(\n                            TABLE(VALUES (1, 'a'), (2, 'b'), (3, 'c')) t1(x1, x2),\n                            TABLE(VALUES (4, 'd'), (5, 'e')) t2(y1, y2))) t(p1, p2)\n"))).matches("VALUES (5, 'e')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT 'x'\nFROM TABLE(system.pass_through(\n                            TABLE(VALUES (1, 'a'), (2, 'b'), (3, 'c')) t1(x1, x2),\n                            TABLE(VALUES (4, 'd'), (5, 'e')) t2(y1, y2))) t(p1, p2)\n"))).matches("VALUES ('x')");
    }

    @Test
    public void testPrunePassThroughColumnsWithEmptyInput() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT p1, p2, x1, x2, y1, y2\nFROM TABLE(system.pass_through(\n                            TABLE(SELECT 1, 'a' WHERE FALSE) t1(x1, x2),\n                            TABLE(SELECT 4, 'd' WHERE FALSE) t2(y1, y2))) t(p1, p2)\n"))).matches("VALUES (false, false, CAST(null AS integer), CAST(null AS varchar(1)), CAST(null AS integer), CAST(null AS varchar(1)))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT x1, x2, y1, y2\nFROM TABLE(system.pass_through(\n                            TABLE(SELECT 1, 'a' WHERE FALSE) t1(x1, x2),\n                            TABLE(SELECT 4, 'd' WHERE FALSE) t2(y1, y2))) t(p1, p2)\n"))).matches("VALUES (CAST(null AS integer), CAST(null AS varchar(1)), CAST(null AS integer), CAST(null AS varchar(1)))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT x2, y2\nFROM TABLE(system.pass_through(\n                            TABLE(SELECT 1, 'a' WHERE FALSE) t1(x1, x2),\n                            TABLE(SELECT 4, 'd' WHERE FALSE) t2(y1, y2))) t(p1, p2)\n"))).matches("VALUES (CAST(null AS varchar(1)), CAST(null AS varchar(1)))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT y1, y2\nFROM TABLE(system.pass_through(\n                            TABLE(SELECT 1, 'a' WHERE FALSE) t1(x1, x2),\n                            TABLE(SELECT 4, 'd' WHERE FALSE) t2(y1, y2))) t(p1, p2)\n"))).matches("VALUES (CAST(null AS integer), CAST(null AS varchar(1)))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT 'x'\nFROM TABLE(system.pass_through(\n                            TABLE(SELECT 1, 'a' WHERE FALSE) t1(x1, x2),\n                            TABLE(SELECT 4, 'd' WHERE FALSE) t2(y1, y2))) t(p1, p2)\n"))).matches("VALUES ('x')");
    }
}

