/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import io.trino.SessionTestUtils;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Plugin;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import java.io.Closeable;
import java.util.Map;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestTablesample {
    private QueryRunner queryRunner;
    private QueryAssertions assertions;

    @BeforeAll
    public void setUp() throws Exception {
        this.queryRunner = new StandaloneQueryRunner(SessionTestUtils.TEST_SESSION);
        this.queryRunner.installPlugin((Plugin)new TpchPlugin());
        this.queryRunner.createCatalog("tpch", "tpch", (Map)ImmutableMap.of((Object)"tpch.splits-per-node", (Object)"1"));
        this.assertions = new QueryAssertions(this.queryRunner);
    }

    @AfterAll
    public void tearDown() throws Exception {
        Closeables.closeAll((Closeable[])new Closeable[]{this.queryRunner, this.assertions});
        this.queryRunner = null;
        this.assertions = null;
    }

    @Test
    public void testTablesample() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("SELECT count(*) FROM tpch.tiny.orders TABLESAMPLE BERNOULLI (0)"))).matches("VALUES BIGINT '0'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("SELECT count(*) FROM tpch.tiny.orders TABLESAMPLE BERNOULLI (100)"))).matches("VALUES BIGINT '15000'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("SELECT count(*) FROM tpch.tiny.orders TABLESAMPLE BERNOULLI (1)"))).result().satisfies(new ThrowingConsumer[]{result -> Assertions.assertThat((Long)((Long)result.getOnlyValue())).isBetween(Long.valueOf(50L), Long.valueOf(450L))});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("SELECT count(*) FROM tpch.tiny.orders TABLESAMPLE BERNOULLI (1e-1)"))).result().satisfies(new ThrowingConsumer[]{result -> Assertions.assertThat((Long)((Long)result.getOnlyValue())).isBetween(Long.valueOf(3L), Long.valueOf(45L))});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("SELECT count(*) FROM tpch.tiny.orders TABLESAMPLE BERNOULLI (0.1)"))).result().satisfies(new ThrowingConsumer[]{result -> Assertions.assertThat((Long)((Long)result.getOnlyValue())).isBetween(Long.valueOf(3L), Long.valueOf(45L))});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("SELECT count(*) FROM tpch.tiny.orders TABLESAMPLE BERNOULLI (0.000000000000000000001)"))).result().satisfies(new ThrowingConsumer[]{result -> Assertions.assertThat((Long)((Long)result.getOnlyValue())).isBetween(Long.valueOf(0L), Long.valueOf(5L))});
    }

    @Test
    public void testNullRatio() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("SELECT count(*) FROM tpch.tiny.orders TABLESAMPLE BERNOULLI (NULL)"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:62: Sample percentage cannot be NULL");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("SELECT count(*) FROM tpch.tiny.orders TABLESAMPLE BERNOULLI (CAST(NULL AS integer))"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:62: Sample percentage cannot be NULL");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("SELECT count(*) FROM tpch.tiny.orders TABLESAMPLE BERNOULLI (CAST(NULL AS double))"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:62: Sample percentage cannot be NULL");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("SELECT count(*) FROM tpch.tiny.orders TABLESAMPLE BERNOULLI (CAST(NULL AS varchar))"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:62: Sample percentage should be a numeric expression");
    }

    @Test
    public void testInvalidRatioType() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("SELECT count(*) FROM tpch.sf1.orders TABLESAMPLE BERNOULLI (DATE '1970-01-02')"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:61: Sample percentage should be a numeric expression");
    }

    @Test
    public void testInSubquery() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("SELECT count(*) FROM tpch.tiny.orders WHERE orderkey IN (SELECT orderkey FROM tpch.tiny.orders TABLESAMPLE BERNOULLI (0))"))).matches("VALUES BIGINT '0'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("SELECT count(*) FROM tpch.tiny.orders WHERE orderkey IN (SELECT orderkey FROM tpch.tiny.orders TABLESAMPLE BERNOULLI (100))"))).matches("VALUES BIGINT '15000'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("SELECT count(*) FROM tpch.tiny.orders WHERE orderkey IN (SELECT orderkey FROM tpch.tiny.orders TABLESAMPLE BERNOULLI (1))"))).result().satisfies(new ThrowingConsumer[]{result -> Assertions.assertThat((Long)((Long)result.getOnlyValue())).isBetween(Long.valueOf(50L), Long.valueOf(450L))});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("SELECT count(*) FROM tpch.tiny.orders WHERE orderkey IN (SELECT orderkey FROM tpch.tiny.orders TABLESAMPLE BERNOULLI (1e-1))"))).result().satisfies(new ThrowingConsumer[]{result -> Assertions.assertThat((Long)((Long)result.getOnlyValue())).isBetween(Long.valueOf(3L), Long.valueOf(45L))});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("SELECT count(*) FROM tpch.tiny.orders WHERE orderkey IN (SELECT orderkey FROM tpch.tiny.orders TABLESAMPLE BERNOULLI (0.1))"))).result().satisfies(new ThrowingConsumer[]{result -> Assertions.assertThat((Long)((Long)result.getOnlyValue())).isBetween(Long.valueOf(3L), Long.valueOf(45L))});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("SELECT count(*) FROM tpch.tiny.orders WHERE orderkey IN (SELECT orderkey FROM tpch.tiny.orders TABLESAMPLE BERNOULLI (0.000000000000000000001))"))).result().satisfies(new ThrowingConsumer[]{result -> Assertions.assertThat((Long)((Long)result.getOnlyValue())).isBetween(Long.valueOf(0L), Long.valueOf(5L))});
    }
}

