/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import io.airlift.log.Logger;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTestSetup {
    private static final Logger log = Logger.get(TestTestSetup.class);
    private static final Path ROOT_POM_REPO_PATH = Paths.get("pom.xml", new String[0]);

    @Test
    public void testSetupOfTests() throws Exception {
        Path rootPom = TestTestSetup.findRepositoryRoot().resolve(ROOT_POM_REPO_PATH);
        List<String> errors = this.verifyModule(rootPom);
        if (!errors.isEmpty()) {
            String string = "\n\t\t%s";
            Assertions.fail((String)("Errors: " + errors.stream().map(arg_0 -> TestTestSetup.lambda$testSetupOfTests$0("\n\t\t%s", arg_0)).collect(Collectors.joining())));
        }
    }

    private List<String> verifyModule(Path pom) throws Exception {
        System.out.println("verifying " + String.valueOf(pom));
        ArrayList<String> errors = new ArrayList<String>();
        try (InputStream inputStream = Files.newInputStream(pom, new OpenOption[0]);){
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read(inputStream);
            boolean hasJunitApi = false;
            boolean hasAirliftJunitExtensions = false;
            for (Dependency dependency : model.getDependencies()) {
                if (dependency.getGroupId().equals("org.junit.jupiter") && dependency.getArtifactId().equals("junit-jupiter-api")) {
                    hasJunitApi = true;
                }
                if (!dependency.getGroupId().equals("io.airlift") || !dependency.getArtifactId().equals("junit-extensions")) continue;
                hasAirliftJunitExtensions = true;
            }
            if (hasJunitApi && !hasAirliftJunitExtensions) {
                errors.add("Missing dependency on io.airlift:junit-extensions in " + String.valueOf(pom));
            }
            for (String module : model.getModules()) {
                errors.addAll(this.verifyModule(pom.resolveSibling(module).resolve("pom.xml")));
            }
        }
        return errors;
    }

    private static Path findRepositoryRoot() {
        Path workingDirectory = Paths.get("", new String[0]).toAbsolutePath();
        log.info("Current working directory: %s", new Object[]{workingDirectory});
        for (Path path = workingDirectory; path != null; path = path.getParent()) {
            if (!Files.isDirectory(path.resolve(".git"), new LinkOption[0])) continue;
            return path;
        }
        throw new RuntimeException("Failed to find repository root from " + String.valueOf(workingDirectory));
    }

    private static /* synthetic */ String lambda$testSetupOfTests$0(String rec$, Object xva$0) {
        return "\n\t\t%s".formatted(xva$0);
    }
}

