/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.plugin.tpcds.TpcdsPlugin;
import io.trino.spi.Plugin;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.tests.tpch.TpchQueryRunner;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestUnionQueries
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = TpchQueryRunner.builder().build();
        queryRunner.installPlugin((Plugin)new TpcdsPlugin());
        queryRunner.createCatalog("tpcds", "tpcds", (Map)ImmutableMap.of());
        return queryRunner;
    }

    @Test
    public void testUnionFromDifferentCatalogs() {
        String query = "SELECT count(*) FROM (SELECT nationkey FROM tpch.tiny.nation UNION ALL SELECT ss_sold_date_sk FROM tpcds.tiny.store_sales) n JOIN tpch.tiny.region r ON n.nationkey = r.regionkey";
        this.assertQuery(query, "VALUES(5)");
    }

    @Test
    public void testUnionAllOnConnectorPartitionedTables() {
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_reordering_strategy", OptimizerConfig.JoinReorderingStrategy.NONE.name()).setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.BROADCAST.name()).build();
        String query = "SELECT count(*) FROM ((SELECT orderkey FROM orders) union all (SELECT nationkey FROM nation)) o JOIN nation n ON o.orderkey = n.nationkey";
        this.assertQuery(session, query, "VALUES(32)");
    }
}

