/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import com.google.common.collect.MoreCollectors;
import io.airlift.concurrent.Threads;
import io.trino.execution.QueryManager;
import io.trino.execution.QueryState;
import io.trino.server.BasicQueryInfo;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.assertions.Assert;
import io.trino.tests.tpch.TpchQueryRunner;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestWorkerRestart {
    private static final int TEST_ITERATIONS = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=1)
    @Timeout(value=90L)
    public void testRestartBeforeQuery() throws Exception {
        try (DistributedQueryRunner queryRunner = TpchQueryRunner.builder().build();
             ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%d")));){
            try {
                Assertions.assertThat((long)((Long)queryRunner.execute("SELECT count(*) FROM tpch.tiny.lineitem").getOnlyValue())).isEqualTo(60175L);
                TestWorkerRestart.restartWorker(queryRunner);
                Future<MaterializedResult> future = executor.submit(() -> queryRunner.execute("SELECT count(*) FROM tpch.sf1.lineitem -- " + String.valueOf(UUID.randomUUID())));
                future.get();
                Assertions.assertThat((long)((Long)queryRunner.execute("SELECT count(*) FROM tpch.tiny.lineitem").getOnlyValue())).isEqualTo(60175L);
            }
            finally {
                TestWorkerRestart.cancelQueries(queryRunner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=1)
    @Timeout(value=90L)
    public void testRestartDuringQuery() throws Exception {
        try (DistributedQueryRunner queryRunner = TpchQueryRunner.builder().build();
             ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%d")));){
            try {
                Assertions.assertThat((long)((Long)queryRunner.execute("SELECT count(*) FROM tpch.tiny.lineitem").getOnlyValue())).isEqualTo(60175L);
                String sql = "SELECT count(*) FROM tpch.sf1000000000.lineitem -- " + String.valueOf(UUID.randomUUID());
                Future<MaterializedResult> future = executor.submit(() -> queryRunner.execute(sql));
                TestWorkerRestart.waitForQueryStart(queryRunner, sql);
                TestWorkerRestart.restartWorker(queryRunner);
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(future::get).isInstanceOf(ExecutionException.class)).cause().hasMessageFindingMatch("^Expected response code from \\S+ to be 200, but was 500|Error fetching \\S+: Expected response code to be 200, but was 500|Could not communicate with the remote task. The node may have crashed or be under too much load");
                Assertions.assertThat((long)((Long)queryRunner.execute("SELECT count(*) FROM tpch.tiny.lineitem").getOnlyValue())).isEqualTo(60175L);
            }
            finally {
                TestWorkerRestart.cancelQueries(queryRunner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=1)
    @Timeout(value=90L)
    public void testStartDuringQuery() throws Exception {
        try (DistributedQueryRunner queryRunner = TpchQueryRunner.builder().build();
             ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%d")));){
            try {
                Assertions.assertThat((long)((Long)queryRunner.execute("SELECT count(*) FROM tpch.tiny.lineitem").getOnlyValue())).isEqualTo(60175L);
                TestingTrinoServer worker = queryRunner.getServers().stream().filter(server -> !server.isCoordinator()).findFirst().orElseThrow();
                worker.close();
                Future<MaterializedResult> future = executor.submit(() -> queryRunner.execute("SELECT count(*) FROM tpch.tiny.lineitem -- " + String.valueOf(UUID.randomUUID())));
                queryRunner.restartWorker(worker);
                future.get();
                Assertions.assertThat((long)((Long)queryRunner.execute("SELECT count(*) FROM tpch.tiny.lineitem").getOnlyValue())).isEqualTo(60175L);
            }
            finally {
                TestWorkerRestart.cancelQueries(queryRunner);
            }
        }
    }

    private static void waitForQueryStart(DistributedQueryRunner queryRunner, String sql) {
        Assert.assertEventually(() -> {
            BasicQueryInfo queryInfo = (BasicQueryInfo)queryRunner.getCoordinator().getQueryManager().getQueries().stream().filter(query -> query.getQuery().equals(sql)).collect(MoreCollectors.onlyElement());
            Assertions.assertThat((Comparable)queryInfo.getState()).isEqualTo((Object)QueryState.RUNNING);
        });
    }

    private static void restartWorker(DistributedQueryRunner queryRunner) throws Exception {
        TestingTrinoServer worker = queryRunner.getServers().stream().filter(server -> !server.isCoordinator()).findFirst().orElseThrow();
        queryRunner.restartWorker(worker);
    }

    private static void cancelQueries(DistributedQueryRunner queryRunner) {
        QueryManager queryManager = queryRunner.getCoordinator().getQueryManager();
        queryManager.getQueries().stream().map(BasicQueryInfo::getQueryId).forEach(arg_0 -> ((QueryManager)queryManager).cancelQuery(arg_0));
    }
}

