/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.ci;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import io.airlift.log.Logger;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.yaml.snakeyaml.Yaml;

public class TestCiWorkflow {
    private static final Logger log = Logger.get(TestCiWorkflow.class);
    private static final Path CI_YML_REPO_PATH = Paths.get(".github/workflows/ci.yml", new String[0]);

    @Test
    public void testUploadTestResultsCondition() throws Exception {
        String uploadTestResultsStepName = "Upload test results";
        ImmutableSet nonTestSteps = ImmutableSet.of((Object)uploadTestResultsStepName, (Object)"Maven Install");
        Yaml yaml = new Yaml();
        Map workflow = (Map)yaml.load((Reader)new StringReader(Files.readString(TestCiWorkflow.findRepositoryRoot().resolve(CI_YML_REPO_PATH))));
        Map<String, ?> jobs = TestCiWorkflow.getMap(workflow, "jobs");
        Map<String, ?> test = TestCiWorkflow.getMap(jobs, "test");
        List<?> steps = TestCiWorkflow.getList(test, "steps");
        List<Map> allTestSteps = TestCiWorkflow.findAll(steps, arg_0 -> TestCiWorkflow.lambda$testUploadTestResultsCondition$0((Set)nonTestSteps, arg_0));
        List testStepIds = (List)allTestSteps.stream().peek(testStep -> Assertions.assertThat((Map)testStep).containsKey((Object)"id")).map(testStep -> TestCiWorkflow.getString(testStep, "id")).collect(ImmutableList.toImmutableList());
        Assertions.assertThat((List)testStepIds).doesNotHaveDuplicates();
        Map uploadTestResults = TestCiWorkflow.findOnly(steps, step -> Objects.equals(step.get("name"), uploadTestResultsStepName));
        System.out.println(TestCiWorkflow.getString(TestCiWorkflow.getMap(uploadTestResults, "with"), "has-failed-tests"));
        Set conditions = (Set)Stream.of(TestCiWorkflow.getString(TestCiWorkflow.getMap(uploadTestResults, "with"), "has-failed-tests").strip().replaceFirst("^\\$\\{\\{", "").replaceFirst("}}$", "").strip().split("\\|\\|")).map(option -> option.strip().replaceFirst("steps\\.([-a-zA-Z0-9]+)\\.outcome == 'failure'", "$1")).collect(ImmutableSet.toImmutableSet());
        Assertions.assertThat((Collection)conditions).containsExactlyInAnyOrderElementsOf((Iterable)testStepIds);
    }

    private static Path findRepositoryRoot() {
        Path workingDirectory = Paths.get("", new String[0]).toAbsolutePath();
        log.info("Current working directory: %s", new Object[]{workingDirectory});
        for (Path path = workingDirectory; path != null; path = path.getParent()) {
            if (!Files.isDirectory(path.resolve(".git"), new LinkOption[0])) continue;
            return path;
        }
        throw new RuntimeException("Failed to find repository root from " + String.valueOf(workingDirectory));
    }

    private static String getString(Map<?, ?> map, String key) {
        Object value = map.get(key);
        Verify.verifyNotNull(value, (String)"No or null entry for key [%s] in %s", (Object[])new Object[]{key, map});
        return (String)value;
    }

    private static List<?> getList(Map<?, ?> map, String key) {
        Object value = map.get(key);
        Verify.verifyNotNull(value, (String)"No or null entry for key [%s] in %s", (Object[])new Object[]{key, map});
        return (List)value;
    }

    private static Map<String, ?> getMap(Map<?, ?> map, String key) {
        Object value = map.get(key);
        Verify.verifyNotNull(value, (String)"No or null entry for key [%s] in %s", (Object[])new Object[]{key, map});
        return (Map)((Map)value).entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> (String)e.getKey(), Map.Entry::getValue));
    }

    private static <T> T findOnly(List<?> list, Predicate<T> predicate) {
        return (T)list.stream().filter(e -> predicate.test(e)).collect(MoreCollectors.onlyElement());
    }

    private static <T> List<T> findAll(List<?> list, Predicate<T> predicate) {
        return (List)list.stream().filter(e -> predicate.test(e)).collect(ImmutableList.toImmutableList());
    }

    private static /* synthetic */ boolean lambda$testUploadTestResultsCondition$0(Set nonTestSteps, Map step) {
        if (step.containsKey("name") && nonTestSteps.contains(TestCiWorkflow.getString(step, "name"))) {
            return false;
        }
        boolean runsTests = false;
        if (step.containsKey("run")) {
            String run = TestCiWorkflow.getString(step, "run").toLowerCase(Locale.ENGLISH);
            runsTests = run.contains("maven") || run.contains("test");
        }
        boolean looksLikeTests = step.containsKey("name") && TestCiWorkflow.getString(step, "name").toLowerCase(Locale.ENGLISH).contains("test");
        return runsTests || looksLikeTests;
    }
}

