/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.ci;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.yaml.snakeyaml.Yaml;

public class TestWorkflows {
    private static final Logger log = Logger.get(TestWorkflows.class);

    @Test
    public void testWorkflows() throws Exception {
        ArrayList errors = new ArrayList();
        TestWorkflows.listWorkflows().forEach(path -> errors.addAll(TestWorkflows.checkWorkflow(path)));
        if (!errors.isEmpty()) {
            String string = "\n\t\t%s";
            Assertions.fail((String)("Errors: " + errors.stream().map(arg_0 -> TestWorkflows.lambda$testWorkflows$1("\n\t\t%s", arg_0)).collect(Collectors.joining())));
        }
    }

    private static List<Path> listWorkflows() throws Exception {
        try (Stream<Path> walk = Files.walk(TestWorkflows.findRepositoryRoot().resolve(".github/workflows"), 1, new FileVisitOption[0]);){
            List list = (List)walk.filter(path -> path.toString().endsWith(".yml")).collect(ImmutableList.toImmutableList());
            return list;
        }
    }

    private static List<String> checkWorkflow(Path path) {
        ArrayList<String> errors = new ArrayList<String>();
        try {
            Yaml yaml = new Yaml();
            Map workflow = (Map)yaml.load((Reader)new StringReader(Files.readString(path)));
            Map<String, ?> jobs = TestWorkflows.getMap(workflow, "jobs");
            jobs.forEach((jobName, jobDefinition) -> {
                Map job = (Map)jobDefinition;
                List<?> steps = TestWorkflows.getList(job, "steps");
                for (int stepPosition = 0; stepPosition < steps.size(); ++stepPosition) {
                    String uses;
                    Map step = (Map)steps.get(stepPosition);
                    String stepName = (String)MoreObjects.firstNonNull((Object)((String)step.get("name")), (Object)("Step #" + stepPosition));
                    if (!step.containsKey("uses") || TestWorkflows.isSafeActionReference(uses = TestWorkflows.getString(step, "uses"))) continue;
                    errors.add("Unsafe action reference in %s \u00bb %s \u00bb %s: %s. A reference to a 3rd party action is safe when it pins to a specific commit.".formatted(path, jobName, stepName, uses));
                }
            });
        }
        catch (AssertionError | Exception e) {
            throw new AssertionError("Failed when checking %s: %s".formatted(path, e), (Throwable)e);
        }
        return errors;
    }

    @Test
    public void testActions() throws Exception {
        ArrayList errors = new ArrayList();
        TestWorkflows.listActions().forEach(path -> errors.addAll(TestWorkflows.checkAction(path)));
        if (!errors.isEmpty()) {
            String string = "\n\t\t%s";
            Assertions.fail((String)("Errors: " + errors.stream().map(arg_0 -> TestWorkflows.lambda$testActions$1("\n\t\t%s", arg_0)).collect(Collectors.joining())));
        }
    }

    private static List<Path> listActions() throws Exception {
        Path actionsDir = TestWorkflows.findRepositoryRoot().resolve(".github/actions");
        try (Stream<Path> walk = Files.walk(actionsDir, 1, new FileVisitOption[0]);){
            List list = (List)walk.filter(Predicate.not(actionsDir::equals)).map(path -> path.resolve("action.yml")).collect(ImmutableList.toImmutableList());
            return list;
        }
    }

    private static List<String> checkAction(Path path) {
        ArrayList<String> errors = new ArrayList<String>();
        try {
            Yaml yaml = new Yaml();
            Map workflow = (Map)yaml.load((Reader)new StringReader(Files.readString(path)));
            Map<String, ?> runs = TestWorkflows.getMap(workflow, "runs");
            Assertions.assertThat((String)TestWorkflows.getString(runs, "using")).isEqualTo("composite");
            List<?> steps = TestWorkflows.getList(runs, "steps");
            for (int stepPosition = 0; stepPosition < steps.size(); ++stepPosition) {
                String uses;
                Map step = (Map)steps.get(stepPosition);
                String stepName = (String)MoreObjects.firstNonNull((Object)((String)step.get("name")), (Object)("Step #" + stepPosition));
                if (!step.containsKey("uses") || TestWorkflows.isSafeActionReference(uses = TestWorkflows.getString(step, "uses"))) continue;
                errors.add("Unsafe action reference in %s \u00bb %s: %s. A reference to a 3rd party action is safe when it pins to a specific commit.".formatted(path, stepName, uses));
            }
        }
        catch (AssertionError | Exception e) {
            throw new AssertionError("Failed when checking %s: %s".formatted(path, e), (Throwable)e);
        }
        return errors;
    }

    private static boolean isSafeActionReference(String actionName) {
        if (actionName.startsWith("actions/")) {
            return true;
        }
        if (actionName.startsWith("./")) {
            return true;
        }
        if (actionName.startsWith("trinodb/")) {
            return true;
        }
        return actionName.matches(".*@[0-9a-f]{40}$");
    }

    private static Path findRepositoryRoot() {
        Path workingDirectory = Paths.get("", new String[0]).toAbsolutePath();
        log.info("Current working directory: %s", new Object[]{workingDirectory});
        for (Path path = workingDirectory; path != null; path = path.getParent()) {
            if (!Files.isDirectory(path.resolve(".git"), new LinkOption[0])) continue;
            return path;
        }
        throw new RuntimeException("Failed to find repository root from " + String.valueOf(workingDirectory));
    }

    private static String getString(Map<?, ?> map, String key) {
        Object value = map.get(key);
        Verify.verifyNotNull(value, (String)"No or null entry for key [%s] in %s", (Object[])new Object[]{key, map});
        return (String)value;
    }

    private static List<?> getList(Map<?, ?> map, String key) {
        Object value = map.get(key);
        Verify.verifyNotNull(value, (String)"No or null entry for key [%s] in %s", (Object[])new Object[]{key, map});
        return (List)value;
    }

    private static Map<String, ?> getMap(Map<?, ?> map, String key) {
        Object value = map.get(key);
        Verify.verifyNotNull(value, (String)"No or null entry for key [%s] in %s", (Object[])new Object[]{key, map});
        return (Map)((Map)value).entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> (String)e.getKey(), Map.Entry::getValue));
    }

    private static /* synthetic */ String lambda$testActions$1(String rec$, Object xva$0) {
        return "\n\t\t%s".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$testWorkflows$1(String rec$, Object xva$0) {
        return "\n\t\t%s".formatted(xva$0);
    }
}

