/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.tpch;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Provider;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.Session;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.planprinter.IoPlanPrinter;
import io.trino.testing.BaseConnectorTest;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.TestingSession;
import io.trino.tests.tpch.TpchQueryRunner;
import io.trino.type.TypeDeserializer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTpchConnectorTest
extends BaseConnectorTest {
    protected QueryRunner createQueryRunner() throws Exception {
        return TpchQueryRunner.builder().build();
    }

    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return switch (connectorBehavior) {
            case TestingConnectorBehavior.SUPPORTS_ADD_COLUMN, TestingConnectorBehavior.SUPPORTS_ARRAY, TestingConnectorBehavior.SUPPORTS_COMMENT_ON_COLUMN, TestingConnectorBehavior.SUPPORTS_COMMENT_ON_TABLE, TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW, TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA, TestingConnectorBehavior.SUPPORTS_CREATE_TABLE, TestingConnectorBehavior.SUPPORTS_CREATE_VIEW, TestingConnectorBehavior.SUPPORTS_DELETE, TestingConnectorBehavior.SUPPORTS_INSERT, TestingConnectorBehavior.SUPPORTS_MAP_TYPE, TestingConnectorBehavior.SUPPORTS_MERGE, TestingConnectorBehavior.SUPPORTS_RENAME_COLUMN, TestingConnectorBehavior.SUPPORTS_RENAME_TABLE, TestingConnectorBehavior.SUPPORTS_ROW_TYPE, TestingConnectorBehavior.SUPPORTS_SET_COLUMN_TYPE, TestingConnectorBehavior.SUPPORTS_TOPN_PUSHDOWN, TestingConnectorBehavior.SUPPORTS_UPDATE -> false;
            default -> super.hasBehavior(connectorBehavior);
        };
    }

    @Test
    public void testIoExplain() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE IO, FORMAT JSON) " + query);
        IoPlanPrinter.EstimatedStatsAndCost scanEstimate = new IoPlanPrinter.EstimatedStatsAndCost(15000.0, 1597294.0, 1597294.0, 0.0, 0.0);
        IoPlanPrinter.EstimatedStatsAndCost totalEstimate = new IoPlanPrinter.EstimatedStatsAndCost(15000.0, 1597294.0, 1597294.0, 0.0, 1597294.0);
        IoPlanPrinter.IoPlan.TableColumnInfo input = new IoPlanPrinter.IoPlan.TableColumnInfo(new CatalogSchemaTableName("tpch", "tiny", "orders"), new IoPlanPrinter.Constraint(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.ColumnConstraint("orderstatus", (Type)VarcharType.createVarcharType((int)1), new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("F"), IoPlanPrinter.FormattedMarker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("F"), IoPlanPrinter.FormattedMarker.Bound.EXACTLY)), (Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("O"), IoPlanPrinter.FormattedMarker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("O"), IoPlanPrinter.FormattedMarker.Bound.EXACTLY)), (Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("P"), IoPlanPrinter.FormattedMarker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("P"), IoPlanPrinter.FormattedMarker.Bound.EXACTLY))))))), scanEstimate);
        ObjectMapperProvider objectMapperProvider = new ObjectMapperProvider();
        objectMapperProvider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)new TypeDeserializer(this.getQueryRunner().getPlannerContext().getTypeManager())));
        JsonCodec codec = new JsonCodecFactory((Provider)objectMapperProvider).jsonCodec(IoPlanPrinter.IoPlan.class);
        Assertions.assertThat((Object)((IoPlanPrinter.IoPlan)codec.fromJson((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())))).isEqualTo((Object)new IoPlanPrinter.IoPlan((Set)ImmutableSet.of((Object)input), Optional.empty(), totalEstimate));
    }

    @Test
    public void testAnalyzePropertiesSystemTable() {
        this.assertQuery("SELECT COUNT(*) FROM system.metadata.analyze_properties WHERE catalog_name = 'tpch'", "SELECT 0");
    }

    @Test
    public void testAnalyze() {
        this.assertUpdate("ANALYZE orders", 15000L);
        this.assertQueryFails("ANALYZE orders WITH (foo = 'bar')", "line 1:22: Catalog 'tpch' analyze property 'foo' does not exist");
    }

    @Test
    public void testPreSortedInput() {
        this.assertExplain("EXPLAIN SELECT * FROM orders ORDER BY orderkey ASC NULLS FIRST LIMIT 10", new String[]{"\\QLimitPartial[count = 10, inputPreSortedBy = [orderkey]]"});
        this.assertExplain("EXPLAIN SELECT * FROM lineitem ORDER BY orderkey ASC NULLS FIRST LIMIT 10", new String[]{"\\QLimitPartial[count = 10, inputPreSortedBy = [orderkey]]"});
        this.assertExplain("EXPLAIN SELECT * FROM lineitem ORDER BY orderkey ASC NULLS FIRST, linenumber ASC NULLS FIRST LIMIT 10", new String[]{"\\QLimitPartial[count = 10, inputPreSortedBy = [orderkey, linenumber]]"});
        this.assertExplain("EXPLAIN SELECT * FROM lineitem ORDER BY orderkey ASC NULLS FIRST, linenumber LIMIT 10", new String[]{"\\QTopNPartial[count = 10, orderBy = [orderkey ASC NULLS FIRST, linenumber ASC NULLS LAST]]"});
        this.assertExplain("EXPLAIN SELECT * FROM lineitem ORDER BY orderkey ASC LIMIT 10", new String[]{"\\QTopNPartial[count = 10, orderBy = [orderkey ASC NULLS LAST]]"});
        this.assertQuery("SELECT * FROM lineitem WHERE orderkey IS NOT NULL ORDER BY orderkey ASC NULLS FIRST LIMIT 10", "SELECT * FROM lineitem ORDER BY orderkey ASC LIMIT 10");
    }

    @Test
    public void testShowTables() {
        this.assertQuerySucceeds(this.createSession("sf1"), "SHOW TABLES");
        this.assertQuerySucceeds(this.createSession("sf1.0"), "SHOW TABLES");
        this.assertQuerySucceeds("SHOW TABLES FROM sf1");
        this.assertQuerySucceeds("SHOW TABLES FROM \"sf1.0\"");
        this.assertQueryFails("SHOW TABLES FROM sf0", "line 1:1: Schema 'sf0' does not exist");
    }

    @Test
    public void testShowCreateTable() {
        Assertions.assertThat((Object)this.computeActual("SHOW CREATE TABLE orders").getOnlyValue()).isEqualTo((Object)"CREATE TABLE tpch.tiny.orders (\n   orderkey bigint NOT NULL,\n   custkey bigint NOT NULL,\n   orderstatus varchar(1) NOT NULL,\n   totalprice double NOT NULL,\n   orderdate date NOT NULL,\n   orderpriority varchar(15) NOT NULL,\n   clerk varchar(15) NOT NULL,\n   shippriority integer NOT NULL,\n   comment varchar(79) NOT NULL\n)");
    }

    @Test
    public void testPredicateReflectedInExplain() {
        super.testPredicateReflectedInExplain();
        this.assertExplain("EXPLAIN SELECT orderkey FROM orders WHERE orderstatus = 'F'", new String[]{"\\Q:: [[F]]"});
    }

    private Session createSession(String schemaName) {
        return TestingSession.testSessionBuilder().setSource("test").setCatalog("tpch").setSchema(schemaName).build();
    }
}

