/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.tpch;

import io.trino.plugin.tpch.ColumnNaming;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.assertions.Assert;
import io.trino.testing.statistics.MetricComparisonStrategies;
import io.trino.testing.statistics.Metrics;
import io.trino.testing.statistics.StatisticsAssertion;
import io.trino.tests.tpch.TpchQueryRunner;
import io.trino.tpch.TpchTable;
import java.util.Map;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestTpchDistributedStats {
    private StatisticsAssertion statisticsAssertion;

    @BeforeAll
    public void setup() throws Exception {
        DistributedQueryRunner runner = ((TpchQueryRunner.Builder)TpchQueryRunner.builder().withConnectorProperties(Map.of("tpch.column-naming", ColumnNaming.STANDARD.name())).amendSession(builder -> builder.setSystemProperty("collect_plan_statistics_for_all_queries", "true"))).build();
        this.statisticsAssertion = new StatisticsAssertion((QueryRunner)runner);
    }

    @AfterAll
    public void tearDown() {
        this.statisticsAssertion.close();
        this.statisticsAssertion = null;
    }

    @Test
    public void testTableScanStats() {
        TpchTable.getTables().forEach(table -> this.statisticsAssertion.check("SELECT * FROM " + table.getTableName(), checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.noError())));
    }

    @Test
    public void testFilter() {
        this.statisticsAssertion.check("SELECT * FROM lineitem WHERE l_shipdate <= DATE '1998-12-01' - INTERVAL '90' DAY", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()));
        this.statisticsAssertion.check("SELECT l_orderkey FROM lineitem GROUP BY l_orderkey HAVING sum(l_quantity) > 30", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()));
        this.statisticsAssertion.check("SELECT * FROM lineitem WHERE l_receiptdate > l_commitdate", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)-0.2, (double)-0.18)));
        this.statisticsAssertion.check("SELECT * FROM lineitem WHERE l_receiptdate >= l_commitdate", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)-0.23, (double)-0.2)));
        this.statisticsAssertion.check("SELECT * FROM lineitem WHERE l_receiptdate < l_commitdate", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)0.35, (double)0.38)));
        this.statisticsAssertion.check("SELECT * FROM lineitem WHERE l_receiptdate <= l_commitdate", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)0.3, (double)0.35)));
    }

    @Test
    public void testJoin() {
        this.statisticsAssertion.check("SELECT * FROM  part, partsupp WHERE p_partkey = ps_partkey", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()));
    }

    @Test
    public void testUnion() {
        this.statisticsAssertion.check("SELECT * FROM nation UNION SELECT * FROM nation", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)1.0, (double)1.0)));
        this.statisticsAssertion.check("SELECT * FROM nation UNION ALL SELECT * FROM nation", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.noError()));
        this.statisticsAssertion.check("SELECT * FROM orders WHERE o_custkey < 755 OR o_orderstatus = '0' UNION SELECT * FROM orders WHERE o_custkey > 755 OR o_orderstatus = 'F'", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)0.3, (double)0.35)));
        this.statisticsAssertion.check("SELECT * FROM orders WHERE o_custkey < 755 OR o_orderstatus = '0' UNION ALL SELECT * FROM orders WHERE o_custkey > 755 OR o_orderstatus = 'F'", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()));
        this.statisticsAssertion.check("SELECT * FROM orders WHERE o_custkey < 900 UNION SELECT * FROM orders WHERE o_custkey > 600", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)0.15, (double)0.25)));
        this.statisticsAssertion.check("SELECT * FROM orders WHERE o_custkey < 900 UNION ALL SELECT * FROM orders WHERE o_custkey > 600", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()));
    }

    @Test
    public void testIntersect() {
        this.statisticsAssertion.check("SELECT * FROM nation INTERSECT SELECT * FROM nation", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.absoluteError((double)45.0)));
        this.statisticsAssertion.check("SELECT * FROM orders WHERE o_custkey < 900 INTERSECT SELECT * FROM orders WHERE o_custkey > 600", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)4.3, (double)4.4)));
    }

    @Test
    public void testExcept() {
        this.statisticsAssertion.check("SELECT * FROM nation EXCEPT SELECT * FROM nation", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.absoluteError((double)45.0)));
        this.statisticsAssertion.check("SELECT * FROM orders WHERE o_custkey < 900 EXCEPT SELECT * FROM orders WHERE o_custkey > 600", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)1.7, (double)1.8)));
    }

    @Test
    public void testEnforceSingleRow() {
        this.statisticsAssertion.check("SELECT (SELECT n_regionkey FROM nation WHERE n_name = 'nosuchvalue') AS sub", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.noError()));
        this.statisticsAssertion.check("SELECT (SELECT n_regionkey FROM nation WHERE n_name = 'GERMANY') AS sub", checks -> checks.estimate(Metrics.distinctValuesCount((String)"sub"), MetricComparisonStrategies.noError()).estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.noError()));
    }

    @Test
    public void testValues() {
        this.statisticsAssertion.check("VALUES 1", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.noError()));
    }

    @Test
    public void testSemiJoin() {
        this.statisticsAssertion.check("SELECT * FROM nation WHERE n_regionkey IN (SELECT r_regionkey FROM region)", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.noError()));
        this.statisticsAssertion.check("SELECT * FROM nation WHERE n_regionkey IN (SELECT r_regionkey FROM region WHERE r_regionkey % 3 = 0)", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.absoluteError((double)15.0)));
    }

    @Test
    public void testLimit() {
        this.statisticsAssertion.check("SELECT * FROM nation LIMIT 10", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.noError()));
    }

    @Test
    public void testGroupBy() {
        this.statisticsAssertion.check("SELECT l_returnflag, l_linestatus FROM lineitem GROUP BY l_returnflag, l_linestatus", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.absoluteError((double)2.0)));
    }

    @Test
    public void testSort() {
        this.statisticsAssertion.check("SELECT * FROM nation ORDER BY n_nationkey", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.noError()));
    }

    @Test
    public void testTablesample() {
        this.statisticsAssertion.check("SELECT * FROM orders TABLESAMPLE BERNOULLI (42)", checks -> checks.noEstimate(Metrics.OUTPUT_ROW_COUNT));
        Assert.assertEventually(() -> this.statisticsAssertion.check("SELECT * FROM orders TABLESAMPLE SYSTEM (42)", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)0.3))));
    }
}

