/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.tpch;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.plugin.tpch.ColumnNaming;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingSession;
import io.trino.testing.statistics.MetricComparisonStrategies;
import io.trino.testing.statistics.Metrics;
import io.trino.testing.statistics.StatisticsAssertion;
import java.util.Map;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestTpchLocalStats {
    private StatisticsAssertion statisticsAssertion;

    @BeforeAll
    public void setUp() {
        Session defaultSession = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").setSystemProperty("collect_plan_statistics_for_all_queries", "true").build();
        StandaloneQueryRunner queryRunner = new StandaloneQueryRunner(defaultSession);
        queryRunner.installPlugin((Plugin)new TpchPlugin());
        queryRunner.createCatalog("tpch", "tpch", (Map)ImmutableMap.builder().put((Object)"tpch.splits-per-node", (Object)"1").put((Object)"tpch.column-naming", (Object)ColumnNaming.STANDARD.name()).buildOrThrow());
        this.statisticsAssertion = new StatisticsAssertion((QueryRunner)queryRunner);
    }

    @AfterAll
    public void tearDown() {
        this.statisticsAssertion.close();
        this.statisticsAssertion = null;
    }

    @Test
    public void testTableScanStats() {
        this.statisticsAssertion.check("SELECT * FROM nation", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()).verifyExactColumnStatistics("n_nationkey").verifyExactColumnStatistics("n_regionkey").verifyExactColumnStatistics("n_name"));
    }

    @Test
    public void testDateComparisons() {
        this.statisticsAssertion.check("SELECT * FROM orders WHERE o_orderdate >= DATE '1993-10-01'", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()));
        this.statisticsAssertion.check("SELECT * FROM orders WHERE o_orderdate < DATE '1993-10-01' + INTERVAL '3' MONTH", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()));
        this.statisticsAssertion.check("SELECT * FROM orders WHERE o_orderdate >= DATE '1993-10-01' AND o_orderdate < DATE '1993-10-01' + INTERVAL '3' MONTH", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()));
        this.statisticsAssertion.check("SELECT * FROM orders WHERE o_orderdate >= DATE '1993-10-01' OR o_orderdate < DATE '1993-10-01' + INTERVAL '3' MONTH", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()));
        this.statisticsAssertion.check("SELECT * FROM orders WHERE NOT (o_orderdate >= DATE '1993-10-01' AND o_orderdate < DATE '1993-10-01' + INTERVAL '3' MONTH)", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()));
    }

    @Test
    public void testLimit() {
        this.statisticsAssertion.check("SELECT * FROM nation LIMIT 10", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.noError()));
    }

    @Test
    public void testEnforceSingleRow() {
        this.statisticsAssertion.check("SELECT (SELECT n_regionkey FROM nation WHERE n_name = 'GERMANY') AS sub", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.noError()));
    }

    @Test
    public void testVarcharComparisons() {
        this.statisticsAssertion.check("SELECT * FROM orders WHERE o_comment = 'requests above the furiously even instructions use alw'", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()));
        this.statisticsAssertion.check("SELECT * FROM orders WHERE 'this is always ...' = '... false'", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.noError()));
    }

    @Test
    public void testInnerJoinStats() {
        this.statisticsAssertion.check("SELECT * FROM supplier, nation", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()).verifyExactColumnStatistics("s_nationkey").verifyExactColumnStatistics("n_nationkey").verifyExactColumnStatistics("s_suppkey"));
        this.statisticsAssertion.check("SELECT * FROM supplier, nation WHERE n_nationkey <= 12", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()).verifyExactColumnStatistics("s_nationkey").verifyColumnStatistics("n_nationkey", MetricComparisonStrategies.relativeError((double)0.1)).verifyExactColumnStatistics("s_suppkey"));
        this.statisticsAssertion.check("SELECT * FROM supplier, nation WHERE s_nationkey = n_nationkey", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()).verifyExactColumnStatistics("s_nationkey").verifyExactColumnStatistics("n_nationkey").verifyExactColumnStatistics("s_suppkey"));
        this.statisticsAssertion.check("SELECT * FROM supplier, nation WHERE s_nationkey = n_nationkey AND n_nationkey <= 12", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)0.15)).verifyColumnStatistics("s_nationkey", MetricComparisonStrategies.relativeError((double)0.15)).verifyColumnStatistics("n_nationkey", MetricComparisonStrategies.relativeError((double)0.15)));
        this.statisticsAssertion.check("SELECT n1.n_nationkey FROM nation n1, nation n2 WHERE n1.n_nationkey + 1 = n2.n_nationkey - 1 AND n1.n_nationkey > 5 AND n2.n_nationkey < 20", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.absoluteError((double)8.0)));
        this.statisticsAssertion.check("SELECT * FROM nation, supplier, partsupp WHERE n_nationkey = s_nationkey AND s_suppkey = ps_suppkey", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()).verifyExactColumnStatistics("ps_partkey").verifyExactColumnStatistics("n_nationkey").verifyExactColumnStatistics("s_nationkey").verifyExactColumnStatistics("n_name"));
        this.statisticsAssertion.check("SELECT * FROM nation, supplier, partsupp WHERE n_nationkey = s_nationkey AND s_suppkey = ps_suppkey AND n_nationkey <= 12", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)0.15)).verifyColumnStatistics("ps_partkey", MetricComparisonStrategies.relativeError((double)0.15)).verifyColumnStatistics("n_nationkey", MetricComparisonStrategies.relativeError((double)0.15)).verifyColumnStatistics("s_nationkey", MetricComparisonStrategies.relativeError((double)0.15)));
        this.statisticsAssertion.check("SELECT * FROM partsupp, lineitem WHERE ps_partkey = l_partkey AND ps_suppkey = l_suppkey", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)4.0)).verifyExactColumnStatistics("ps_partkey").verifyExactColumnStatistics("l_partkey").verifyExactColumnStatistics("ps_suppkey").verifyExactColumnStatistics("l_suppkey").verifyExactColumnStatistics("l_orderkey"));
    }

    @Test
    public void testLeftJoinStats() {
        this.statisticsAssertion.check("SELECT * FROM supplier LEFT JOIN nation ON true", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()).verifyExactColumnStatistics("s_nationkey").verifyExactColumnStatistics("n_nationkey").verifyExactColumnStatistics("s_suppkey"));
        this.statisticsAssertion.check("SELECT * FROM supplier LEFT JOIN nation ON false", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()).verifyExactColumnStatistics("s_nationkey").verifyExactColumnStatistics("s_suppkey"));
        this.statisticsAssertion.check("SELECT * FROM supplier LEFT JOIN nation ON s_nationkey = n_nationkey", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)0.7)).verifyColumnStatistics("s_nationkey", MetricComparisonStrategies.absoluteError((double)0.4)).verifyColumnStatistics("n_nationkey", MetricComparisonStrategies.absoluteError((double)0.4)).verifyColumnStatistics("s_suppkey", MetricComparisonStrategies.absoluteError((double)0.4)));
        this.statisticsAssertion.check("SELECT * FROM supplier LEFT JOIN nation ON s_nationkey = n_nationkey AND n_nationkey <= 12", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)0.7)).verifyColumnStatistics("s_nationkey", MetricComparisonStrategies.absoluteError((double)0.4)).verifyColumnStatistics("n_nationkey", MetricComparisonStrategies.relativeError((double)0.4)).verifyColumnStatistics("s_suppkey", MetricComparisonStrategies.absoluteError((double)0.4)));
        this.statisticsAssertion.check("SELECT * FROM (SELECT * FROM supplier WHERE s_nationkey <= 12) LEFT JOIN nation ON s_nationkey = n_nationkey", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)0.7)).verifyColumnStatistics("s_nationkey", MetricComparisonStrategies.absoluteError((double)2.0)).verifyColumnStatistics("n_nationkey", MetricComparisonStrategies.absoluteError((double)2.0)));
        this.statisticsAssertion.check("SELECT * FROM partsupp LEFT JOIN lineitem ON ps_partkey = l_partkey AND ps_suppkey = l_suppkey", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)4.0)).verifyExactColumnStatistics("ps_partkey").verifyColumnStatistics("l_partkey", MetricComparisonStrategies.absoluteError((double)6.0)).verifyExactColumnStatistics("ps_suppkey").verifyColumnStatistics("l_suppkey", MetricComparisonStrategies.absoluteError((double)6.0)).verifyColumnStatistics("l_orderkey", MetricComparisonStrategies.absoluteError((double)6.0)));
        this.statisticsAssertion.check("SELECT * FROM partsupp LEFT JOIN lineitem ON ps_partkey = l_partkey AND ps_suppkey < l_suppkey", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)0.3, (double)0.4)).verifyExactColumnStatistics("ps_partkey").verifyColumnStatistics("l_partkey", MetricComparisonStrategies.relativeError((double)0.7)).verifyExactColumnStatistics("ps_suppkey").verifyColumnStatistics("l_suppkey", MetricComparisonStrategies.relativeError((double)0.7)).verifyColumnStatistics("l_orderkey", MetricComparisonStrategies.relativeError((double)0.7)));
    }

    @Test
    public void testRightJoinStats() {
        this.statisticsAssertion.check("SELECT * FROM nation RIGHT JOIN supplier ON true", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()).verifyExactColumnStatistics("s_nationkey").verifyExactColumnStatistics("n_nationkey").verifyExactColumnStatistics("s_suppkey"));
        this.statisticsAssertion.check("SELECT * FROM nation RIGHT JOIN supplier ON false", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()).verifyExactColumnStatistics("s_nationkey").verifyExactColumnStatistics("s_suppkey"));
        this.statisticsAssertion.check("SELECT * FROM nation RIGHT JOIN supplier ON s_nationkey = n_nationkey", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)0.7)).verifyColumnStatistics("s_nationkey", MetricComparisonStrategies.absoluteError((double)0.4)).verifyColumnStatistics("n_nationkey", MetricComparisonStrategies.absoluteError((double)0.4)).verifyColumnStatistics("s_suppkey", MetricComparisonStrategies.absoluteError((double)0.4)));
        this.statisticsAssertion.check("SELECT * FROM nation RIGHT JOIN supplier ON s_nationkey = n_nationkey AND n_nationkey <= 12", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)0.7)).verifyColumnStatistics("s_nationkey", MetricComparisonStrategies.absoluteError((double)0.4)).verifyColumnStatistics("n_nationkey", MetricComparisonStrategies.relativeError((double)0.4)).verifyColumnStatistics("s_suppkey", MetricComparisonStrategies.absoluteError((double)0.4)));
        this.statisticsAssertion.check("SELECT * FROM nation RIGHT JOIN (SELECT * FROM supplier WHERE s_nationkey <= 12) ON s_nationkey = n_nationkey", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)0.7)).verifyColumnStatistics("s_nationkey", MetricComparisonStrategies.absoluteError((double)2.0)).verifyColumnStatistics("n_nationkey", MetricComparisonStrategies.absoluteError((double)2.0)));
        this.statisticsAssertion.check("SELECT * FROM lineitem RIGHT JOIN partsupp ON ps_partkey = l_partkey AND ps_suppkey = l_suppkey", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)4.0)).verifyExactColumnStatistics("ps_partkey").verifyColumnStatistics("l_partkey", MetricComparisonStrategies.absoluteError((double)6.0)).verifyExactColumnStatistics("ps_suppkey").verifyColumnStatistics("l_suppkey", MetricComparisonStrategies.absoluteError((double)6.0)).verifyColumnStatistics("l_orderkey", MetricComparisonStrategies.absoluteError((double)6.0)));
        this.statisticsAssertion.check("SELECT * FROM lineitem RIGHT JOIN partsupp ON ps_partkey = l_partkey AND ps_suppkey < l_suppkey", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)0.3, (double)0.4)).verifyExactColumnStatistics("ps_partkey").verifyColumnStatistics("l_partkey", MetricComparisonStrategies.relativeError((double)0.7)).verifyExactColumnStatistics("ps_suppkey").verifyColumnStatistics("l_suppkey", MetricComparisonStrategies.relativeError((double)0.7)).verifyColumnStatistics("l_orderkey", MetricComparisonStrategies.relativeError((double)0.7)));
    }

    @Test
    public void testFullJoinStats() {
        this.statisticsAssertion.check("SELECT * FROM supplier FULL JOIN nation ON true", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()).verifyExactColumnStatistics("s_nationkey").verifyExactColumnStatistics("n_nationkey").verifyExactColumnStatistics("s_suppkey"));
        this.statisticsAssertion.check("SELECT * FROM nation FULL JOIN supplier ON s_nationkey = n_nationkey", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)0.7)).verifyColumnStatistics("s_nationkey", MetricComparisonStrategies.absoluteError((double)0.4)).verifyColumnStatistics("n_nationkey", MetricComparisonStrategies.absoluteError((double)0.4)).verifyColumnStatistics("s_suppkey", MetricComparisonStrategies.absoluteError((double)0.4)));
        this.statisticsAssertion.check("SELECT * FROM (SELECT * FROM nation WHERE n_nationkey <= 12) FULL JOIN supplier ON s_nationkey = n_nationkey", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)0.7)).verifyColumnStatistics("s_nationkey", MetricComparisonStrategies.absoluteError((double)0.4)).verifyColumnStatistics("n_nationkey", MetricComparisonStrategies.relativeError((double)0.4)).verifyColumnStatistics("s_suppkey", MetricComparisonStrategies.absoluteError((double)0.4)));
        this.statisticsAssertion.check("SELECT * FROM nation FULL JOIN (SELECT * FROM supplier WHERE s_nationkey <= 12) ON s_nationkey = n_nationkey", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)0.7)).verifyColumnStatistics("s_nationkey", MetricComparisonStrategies.relativeError((double)0.4)).verifyColumnStatistics("n_nationkey", MetricComparisonStrategies.relativeError((double)0.4)));
        this.statisticsAssertion.check("SELECT * FROM lineitem FULL JOIN partsupp ON ps_partkey = l_partkey AND ps_suppkey = l_suppkey", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)4.0)).verifyColumnStatistics("ps_partkey", MetricComparisonStrategies.absoluteError((double)6.0)).verifyColumnStatistics("l_partkey", MetricComparisonStrategies.absoluteError((double)6.0)).verifyColumnStatistics("ps_suppkey", MetricComparisonStrategies.absoluteError((double)6.0)).verifyColumnStatistics("l_suppkey", MetricComparisonStrategies.absoluteError((double)6.0)).verifyColumnStatistics("l_orderkey", MetricComparisonStrategies.absoluteError((double)6.0)));
        this.statisticsAssertion.check("SELECT * FROM lineitem FULL JOIN partsupp ON ps_partkey = l_partkey AND ps_suppkey < l_suppkey", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)0.4, (double)0.5)).verifyColumnStatistics("ps_partkey", MetricComparisonStrategies.relativeError((double)0.6)).verifyColumnStatistics("l_partkey", MetricComparisonStrategies.relativeError((double)0.6)).verifyColumnStatistics("ps_suppkey", MetricComparisonStrategies.relativeError((double)0.6)).verifyColumnStatistics("l_suppkey", MetricComparisonStrategies.relativeError((double)0.6)).verifyColumnStatistics("l_orderkey", MetricComparisonStrategies.relativeError((double)0.6)));
    }

    @Test
    public void testAggregation() {
        this.statisticsAssertion.check("SELECT count() AS count FROM nation", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()).verifyNoColumnStatistics("count"));
        this.statisticsAssertion.check("SELECT n_name, count() AS count FROM nation GROUP BY n_name", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()).verifyNoColumnStatistics("count").verifyExactColumnStatistics("n_name"));
        this.statisticsAssertion.check("SELECT n_name, count() AS count FROM nation, region GROUP BY n_name", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()).verifyNoColumnStatistics("count").verifyExactColumnStatistics("n_name"));
    }

    @Test
    public void testUnion() {
        this.statisticsAssertion.check("SELECT * FROM nation UNION SELECT * FROM nation", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)1.0, (double)1.0)).verifyExactColumnStatistics("n_nationkey").verifyExactColumnStatistics("n_regionkey"));
        this.statisticsAssertion.check("SELECT * FROM nation UNION ALL SELECT * FROM nation", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.noError()).verifyExactColumnStatistics("n_nationkey").verifyExactColumnStatistics("n_regionkey"));
        this.statisticsAssertion.check("SELECT * FROM orders WHERE o_custkey < 755 OR o_orderstatus = '0' UNION SELECT * FROM orders WHERE o_custkey > 755 OR o_orderstatus = 'F'", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)0.3, (double)0.35)).estimate(Metrics.distinctValuesCount((String)"o_orderkey"), MetricComparisonStrategies.relativeError((double)-0.4, (double)-0.3)).estimate(Metrics.nullsFraction((String)"o_orderkey"), MetricComparisonStrategies.relativeError((double)0.3, (double)0.35)).estimate(Metrics.lowValue((String)"o_orderkey"), MetricComparisonStrategies.noError()).estimate(Metrics.highValue((String)"o_orderkey"), MetricComparisonStrategies.noError()).estimate(Metrics.distinctValuesCount((String)"o_custkey"), MetricComparisonStrategies.relativeError((double)0.5)).estimate(Metrics.nullsFraction((String)"o_custkey"), MetricComparisonStrategies.relativeError((double)0.45, (double)0.55)).estimate(Metrics.lowValue((String)"o_custkey"), MetricComparisonStrategies.noError()).estimate(Metrics.highValue((String)"o_custkey"), MetricComparisonStrategies.noError()).estimate(Metrics.distinctValuesCount((String)"o_orderstatus"), MetricComparisonStrategies.relativeError((double)0.5)).estimate(Metrics.nullsFraction((String)"o_orderstatus"), MetricComparisonStrategies.noError()).estimate(Metrics.lowValue((String)"o_orderstatus"), MetricComparisonStrategies.noError()).estimate(Metrics.highValue((String)"o_orderstatus"), MetricComparisonStrategies.noError()));
        this.statisticsAssertion.check("SELECT * FROM orders WHERE o_custkey < 755 OR o_orderstatus = '0' UNION ALL SELECT * FROM orders WHERE o_custkey > 755 OR o_orderstatus = 'F'", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()).estimate(Metrics.distinctValuesCount((String)"o_orderkey"), MetricComparisonStrategies.relativeError((double)-0.4, (double)-0.3)).estimate(Metrics.nullsFraction((String)"o_orderkey"), MetricComparisonStrategies.relativeError((double)0.3, (double)0.35)).estimate(Metrics.lowValue((String)"o_orderkey"), MetricComparisonStrategies.noError()).estimate(Metrics.highValue((String)"o_orderkey"), MetricComparisonStrategies.noError()).estimate(Metrics.distinctValuesCount((String)"o_custkey"), MetricComparisonStrategies.relativeError((double)0.5)).estimate(Metrics.nullsFraction((String)"o_custkey"), MetricComparisonStrategies.relativeError((double)0.45, (double)0.55)).estimate(Metrics.lowValue((String)"o_custkey"), MetricComparisonStrategies.noError()).estimate(Metrics.highValue((String)"o_custkey"), MetricComparisonStrategies.noError()).estimate(Metrics.distinctValuesCount((String)"o_orderstatus"), MetricComparisonStrategies.relativeError((double)0.5)).estimate(Metrics.nullsFraction((String)"o_orderstatus"), MetricComparisonStrategies.noError()).estimate(Metrics.lowValue((String)"o_orderstatus"), MetricComparisonStrategies.noError()).estimate(Metrics.highValue((String)"o_orderstatus"), MetricComparisonStrategies.noError()));
        this.statisticsAssertion.check("SELECT * FROM orders WHERE o_custkey < 900 UNION SELECT * FROM orders WHERE o_custkey > 600", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)0.15, (double)0.25)).estimate(Metrics.distinctValuesCount((String)"o_orderkey"), MetricComparisonStrategies.relativeError((double)-0.4, (double)-0.3)).estimate(Metrics.nullsFraction((String)"o_orderkey"), MetricComparisonStrategies.relativeError((double)0.15, (double)0.25)).estimate(Metrics.lowValue((String)"o_orderkey"), MetricComparisonStrategies.noError()).estimate(Metrics.highValue((String)"o_orderkey"), MetricComparisonStrategies.noError()).estimate(Metrics.distinctValuesCount((String)"o_custkey"), MetricComparisonStrategies.relativeError((double)-0.4, (double)-0.3)).estimate(Metrics.nullsFraction((String)"o_custkey"), MetricComparisonStrategies.relativeError((double)0.15, (double)0.25)).estimate(Metrics.lowValue((String)"o_custkey"), MetricComparisonStrategies.noError()).estimate(Metrics.highValue((String)"o_custkey"), MetricComparisonStrategies.noError()));
        this.statisticsAssertion.check("SELECT * FROM orders WHERE o_custkey < 900 UNION ALL SELECT * FROM orders WHERE o_custkey > 600", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()).estimate(Metrics.distinctValuesCount((String)"o_orderkey"), MetricComparisonStrategies.relativeError((double)-0.4, (double)-0.3)).estimate(Metrics.nullsFraction((String)"o_orderkey"), MetricComparisonStrategies.relativeError((double)-0.4, (double)-0.3)).estimate(Metrics.lowValue((String)"o_orderkey"), MetricComparisonStrategies.noError()).estimate(Metrics.highValue((String)"o_orderkey"), MetricComparisonStrategies.noError()).estimate(Metrics.distinctValuesCount((String)"o_custkey"), MetricComparisonStrategies.relativeError((double)-0.4, (double)-0.3)).estimate(Metrics.nullsFraction((String)"o_custkey"), MetricComparisonStrategies.relativeError((double)0.15, (double)0.25)).estimate(Metrics.lowValue((String)"o_custkey"), MetricComparisonStrategies.noError()).estimate(Metrics.highValue((String)"o_custkey"), MetricComparisonStrategies.noError()));
    }

    @Test
    public void testIntersect() {
        this.statisticsAssertion.check("SELECT * FROM nation INTERSECT SELECT * FROM nation", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.absoluteError((double)45.0)));
        this.statisticsAssertion.check("SELECT * FROM orders WHERE o_custkey < 900 INTERSECT SELECT * FROM orders WHERE o_custkey > 600", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)4.3, (double)4.4)));
    }

    @Test
    public void testExcept() {
        this.statisticsAssertion.check("SELECT * FROM nation EXCEPT SELECT * FROM nation", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.absoluteError((double)45.0)));
        this.statisticsAssertion.check("SELECT * FROM orders WHERE o_custkey < 900 EXCEPT SELECT * FROM orders WHERE o_custkey > 600", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)1.7, (double)1.8)));
    }

    @Test
    public void testInSubquery() {
        this.statisticsAssertion.check("select * from lineitem where l_orderkey in (select o_orderkey from orders where o_orderdate >= DATE '1993-10-01')", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.defaultTolerance()));
    }

    @Test
    public void testNotInSubquery() {
        this.statisticsAssertion.check("select * from lineitem where l_orderkey not in (select o_orderkey from orders where o_orderdate >= DATE '1993-10-01')", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)0.0, (double)1.0)));
    }

    @Test
    public void testCorrelatedSubquery() {
        this.statisticsAssertion.check("SELECT (SELECT count(*) FROM nation n1 WHERE n1.n_nationkey = n2.n_nationkey AND n1.n_regionkey > n2.n_regionkey) FROM nation n2", checks -> checks.estimate(Metrics.OUTPUT_ROW_COUNT, MetricComparisonStrategies.relativeError((double)0.5)));
    }
}

