/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.tpch;

import io.trino.plugin.memory.MemoryPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.tests.tpch.TpchQueryRunner;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestTpchTableScanRedirection
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = TpchQueryRunner.builder().withConnectorProperties(Map.of("tpch.table-scan-redirection-catalog", "memory", "tpch.table-scan-redirection-schema", "test")).build();
        queryRunner.installPlugin((Plugin)new MemoryPlugin());
        queryRunner.createCatalog("memory", "memory");
        queryRunner.createCatalog("tpch_data_load", "tpch");
        queryRunner.execute("CREATE SCHEMA memory.test");
        return queryRunner;
    }

    @Test
    @Timeout(value=20L)
    public void testTableScanRedirection() {
        this.assertUpdate("CREATE TABLE memory.test.orders AS SELECT * FROM tpch_data_load.tiny.orders WHERE orderstatus IN ('O', 'P')", 7696L);
        Assertions.assertThat((int)this.computeActual("SELECT * FROM tpch.tiny.orders WHERE orderstatus IN ('O', 'F')").getRowCount()).isEqualTo(7333L);
    }

    @Test
    @Timeout(value=20L)
    public void testTableScanRedirectionWithCoercion() {
        this.assertUpdate("CREATE TABLE memory.test.nation AS SELECT * FROM (VALUES '42') t(nationkey)", 1L);
        this.assertQuery("SELECT nationkey FROM tpch.tiny.nation", "VALUES 42");
    }
}

