/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.tpch;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.TestingSession;
import java.util.Map;

public final class TpchQueryRunner {
    private TpchQueryRunner() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void main(String[] args) throws Exception {
        Logging.initialize();
        DistributedQueryRunner queryRunner = ((Builder)((Builder)((Builder)TpchQueryRunner.builder().addCoordinatorProperty("http-server.http.port", "8080")).setExtraProperties((Map)ImmutableMap.builder().put((Object)"sql.default-catalog", (Object)"tpch").put((Object)"sql.default-schema", (Object)"tiny").buildOrThrow())).withProtocolSpooling("json+zstd")).build();
        Logger log = Logger.get(TpchQueryRunner.class);
        log.info("======== SERVER STARTED ========");
        log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
    }

    public static final class Builder
    extends DistributedQueryRunner.Builder<Builder> {
        private Map<String, String> connectorProperties = ImmutableMap.of();

        private Builder() {
            super(TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").build());
        }

        @CanIgnoreReturnValue
        public Builder withConnectorProperties(Map<String, String> connectorProperties) {
            this.connectorProperties = ImmutableMap.copyOf(connectorProperties);
            return this;
        }

        public DistributedQueryRunner build() throws Exception {
            DistributedQueryRunner queryRunner = super.build();
            try {
                queryRunner.installPlugin((Plugin)new TpchPlugin());
                queryRunner.createCatalog("tpch", "tpch", this.connectorProperties);
                return queryRunner;
            }
            catch (Exception e) {
                queryRunner.close();
                throw e;
            }
        }
    }
}

