/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift.api;

import com.google.common.base.MoreObjects;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftStruct;
import io.trino.plugin.thrift.api.TrinoThriftId;
import io.trino.plugin.thrift.api.TrinoThriftSplit;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ThriftStruct
public final class TrinoThriftSplitBatch {
    private final List<TrinoThriftSplit> splits;
    private final TrinoThriftId nextToken;

    @ThriftConstructor
    public TrinoThriftSplitBatch(List<TrinoThriftSplit> splits, @Nullable TrinoThriftId nextToken) {
        this.splits = Objects.requireNonNull(splits, "splits is null");
        this.nextToken = nextToken;
    }

    @ThriftField(value=1)
    public List<TrinoThriftSplit> getSplits() {
        return this.splits;
    }

    @Nullable
    @ThriftField(value=2, requiredness=ThriftField.Requiredness.OPTIONAL)
    public TrinoThriftId getNextToken() {
        return this.nextToken;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrinoThriftSplitBatch other = (TrinoThriftSplitBatch)obj;
        return Objects.equals(this.splits, other.splits) && Objects.equals(this.nextToken, other.nextToken);
    }

    public int hashCode() {
        return Objects.hash(this.splits, this.nextToken);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfSplits", this.splits.size()).add("nextToken", (Object)this.nextToken).toString();
    }
}

