package io.trino.plugin.thrift.api.datatypes;

import io.airlift.drift.annotations.ThriftDocumentation;
import io.airlift.drift.annotations.ThriftOrder;

@ThriftDocumentation({
    "Elements of {@code nulls} array determine if a value for a corresponding row is null.",
    "Elements of {@code dates} array are date values for each row represented as the number",
    "of days passed since 1970-01-01.",
    "If row is null then value is ignored."
})
class TrinoThriftDate$DriftMeta {
  @ThriftDocumentation
  @ThriftOrder(10000)
  void getNulls() {
  }

  @ThriftDocumentation
  @ThriftOrder(10001)
  void getDates() {
  }
}
