package io.trino.plugin.thrift.api.datatypes;

import io.airlift.drift.annotations.ThriftDocumentation;
import io.airlift.drift.annotations.ThriftOrder;

@ThriftDocumentation({
    "Elements of {@code nulls} array determine if a value for a corresponding row is null.",
    "Elements of {@code doubles} array are values for each row. If row is null then value is ignored."
})
class TrinoThriftDouble$DriftMeta {
  @ThriftDocumentation
  @ThriftOrder(10000)
  void getNulls() {
  }

  @ThriftDocumentation
  @ThriftOrder(10001)
  void getDoubles() {
  }
}
