/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift.api.datatypes;

import com.google.common.base.Preconditions;
import io.trino.plugin.thrift.api.TrinoThriftBlock;
import io.trino.spi.block.Block;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.Type;
import java.util.function.BiFunction;

final class TrinoThriftTypeUtils {
    private TrinoThriftTypeUtils() {
    }

    public static TrinoThriftBlock fromLongBasedBlock(Block block, Type type, BiFunction<boolean[], long[], TrinoThriftBlock> result) {
        int positions = block.getPositionCount();
        if (positions == 0) {
            return result.apply(null, null);
        }
        boolean[] nulls = null;
        long[] longs = null;
        for (int position = 0; position < positions; ++position) {
            if (block.isNull(position)) {
                if (nulls == null) {
                    nulls = new boolean[positions];
                }
                nulls[position] = true;
                continue;
            }
            if (longs == null) {
                longs = new long[positions];
            }
            longs[position] = type.getLong(block, position);
        }
        return result.apply(nulls, longs);
    }

    public static TrinoThriftBlock fromLongBasedColumn(RecordSet recordSet, int columnIndex, int positions, BiFunction<boolean[], long[], TrinoThriftBlock> result) {
        if (positions == 0) {
            return result.apply(null, null);
        }
        boolean[] nulls = null;
        long[] longs = null;
        RecordCursor cursor = recordSet.cursor();
        for (int position = 0; position < positions; ++position) {
            Preconditions.checkState((boolean)cursor.advanceNextPosition(), (Object)"cursor has less values than expected");
            if (cursor.isNull(columnIndex)) {
                if (nulls == null) {
                    nulls = new boolean[positions];
                }
                nulls[position] = true;
                continue;
            }
            if (longs == null) {
                longs = new long[positions];
            }
            longs[position] = cursor.getLong(columnIndex);
        }
        Preconditions.checkState((!cursor.advanceNextPosition() ? 1 : 0) != 0, (Object)"cursor has more values than expected");
        return result.apply(nulls, longs);
    }

    public static TrinoThriftBlock fromIntBasedBlock(Block block, Type type, BiFunction<boolean[], int[], TrinoThriftBlock> result) {
        int positions = block.getPositionCount();
        if (positions == 0) {
            return result.apply(null, null);
        }
        boolean[] nulls = null;
        int[] ints = null;
        for (int position = 0; position < positions; ++position) {
            if (block.isNull(position)) {
                if (nulls == null) {
                    nulls = new boolean[positions];
                }
                nulls[position] = true;
                continue;
            }
            if (ints == null) {
                ints = new int[positions];
            }
            ints[position] = (int)type.getLong(block, position);
        }
        return result.apply(nulls, ints);
    }

    public static TrinoThriftBlock fromIntBasedColumn(RecordSet recordSet, int columnIndex, int positions, BiFunction<boolean[], int[], TrinoThriftBlock> result) {
        if (positions == 0) {
            return result.apply(null, null);
        }
        boolean[] nulls = null;
        int[] ints = null;
        RecordCursor cursor = recordSet.cursor();
        for (int position = 0; position < positions; ++position) {
            Preconditions.checkState((boolean)cursor.advanceNextPosition(), (Object)"cursor has less values than expected");
            if (cursor.isNull(columnIndex)) {
                if (nulls == null) {
                    nulls = new boolean[positions];
                }
                nulls[position] = true;
                continue;
            }
            if (ints == null) {
                ints = new int[positions];
            }
            ints[position] = (int)cursor.getLong(columnIndex);
        }
        Preconditions.checkState((!cursor.advanceNextPosition() ? 1 : 0) != 0, (Object)"cursor has more values than expected");
        return result.apply(nulls, ints);
    }

    public static int totalSize(boolean[] nulls, int[] sizes) {
        int numberOfRecords = nulls != null ? nulls.length : (sizes != null ? sizes.length : 0);
        int total = 0;
        for (int i = 0; i < numberOfRecords; ++i) {
            if (nulls != null && nulls[i]) continue;
            total += sizes[i];
        }
        return total;
    }

    public static int[] calculateOffsets(int[] sizes, boolean[] nulls, int totalRecords) {
        if (sizes == null) {
            return new int[totalRecords + 1];
        }
        int[] offsets = new int[totalRecords + 1];
        offsets[0] = 0;
        for (int i = 0; i < totalRecords; ++i) {
            int size = nulls != null && nulls[i] ? 0 : sizes[i];
            offsets[i + 1] = offsets[i] + size;
        }
        return offsets;
    }

    public static boolean sameSizeIfPresent(boolean[] nulls, int[] sizes) {
        return nulls == null || sizes == null || nulls.length == sizes.length;
    }
}

