/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift.api.datatypes;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftStruct;
import io.trino.plugin.thrift.api.TrinoThriftBlock;
import io.trino.plugin.thrift.api.datatypes.SliceData;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftColumnData;
import io.trino.spi.block.Block;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.HyperLogLogType;
import io.trino.spi.type.Type;
import jakarta.annotation.Nullable;
import java.util.Objects;

@ThriftStruct
public final class TrinoThriftHyperLogLog
implements TrinoThriftColumnData {
    private final SliceData sliceType;

    @ThriftConstructor
    public TrinoThriftHyperLogLog(@ThriftField(name="nulls") @Nullable boolean[] nulls, @ThriftField(name="sizes") @Nullable int[] sizes, @ThriftField(name="bytes") @Nullable byte[] bytes) {
        this.sliceType = new SliceData(nulls, sizes, bytes);
    }

    @Nullable
    @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
    public boolean[] getNulls() {
        return this.sliceType.getNulls();
    }

    @Nullable
    @ThriftField(value=2, requiredness=ThriftField.Requiredness.OPTIONAL)
    public int[] getSizes() {
        return this.sliceType.getSizes();
    }

    @Nullable
    @ThriftField(value=3, requiredness=ThriftField.Requiredness.OPTIONAL)
    public byte[] getBytes() {
        return this.sliceType.getBytes();
    }

    @Override
    public ValueBlock toBlock(Type desiredType) {
        Preconditions.checkArgument((boolean)HyperLogLogType.HYPER_LOG_LOG.equals((Object)desiredType), (String)"type doesn't match: %s", (Object)desiredType);
        return this.sliceType.toBlock(desiredType);
    }

    @Override
    public int numberOfRecords() {
        return this.sliceType.numberOfRecords();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrinoThriftHyperLogLog other = (TrinoThriftHyperLogLog)obj;
        return Objects.equals(this.sliceType, other.sliceType);
    }

    public int hashCode() {
        return this.sliceType.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfRecords", this.numberOfRecords()).toString();
    }

    public static TrinoThriftBlock fromBlock(Block block) {
        return SliceData.fromSliceBasedBlock(block, (Type)HyperLogLogType.HYPER_LOG_LOG, (nulls, sizes, bytes) -> TrinoThriftBlock.hyperLogLogData(new TrinoThriftHyperLogLog(nulls, sizes, bytes)));
    }
}

