/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift.api.datatypes;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftStruct;
import io.trino.plugin.thrift.api.TrinoThriftBlock;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftColumnData;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftTypeUtils;
import io.trino.spi.block.Block;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

@ThriftStruct
public final class TrinoThriftTimestamp
implements TrinoThriftColumnData {
    private final boolean[] nulls;
    private final long[] timestamps;

    @ThriftConstructor
    public TrinoThriftTimestamp(@ThriftField(name="nulls") @Nullable boolean[] nulls, @ThriftField(name="timestamps") @Nullable long[] timestamps) {
        Preconditions.checkArgument((boolean)TrinoThriftTimestamp.sameSizeIfPresent(nulls, timestamps), (Object)"nulls and values must be of the same size");
        this.nulls = nulls;
        this.timestamps = timestamps;
    }

    @Nullable
    @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
    public boolean[] getNulls() {
        return this.nulls;
    }

    @Nullable
    @ThriftField(value=2, requiredness=ThriftField.Requiredness.OPTIONAL)
    public long[] getTimestamps() {
        return this.timestamps;
    }

    @Override
    public ValueBlock toBlock(Type desiredType) {
        Preconditions.checkArgument((boolean)TimestampType.TIMESTAMP_MILLIS.equals((Object)desiredType), (String)"type doesn't match: %s", (Object)desiredType);
        int numberOfRecords = this.numberOfRecords();
        long[] timestampsInMicros = new long[numberOfRecords];
        if (this.timestamps != null) {
            for (int i = 0; i < this.timestamps.length; ++i) {
                timestampsInMicros[i] = Math.multiplyExact(this.timestamps[i], 1000);
            }
        }
        return new LongArrayBlock(numberOfRecords, Optional.ofNullable(this.nulls), timestampsInMicros);
    }

    @Override
    public int numberOfRecords() {
        if (this.nulls != null) {
            return this.nulls.length;
        }
        if (this.timestamps != null) {
            return this.timestamps.length;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrinoThriftTimestamp other = (TrinoThriftTimestamp)obj;
        return Arrays.equals(this.nulls, other.nulls) && Arrays.equals(this.timestamps, other.timestamps);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.nulls), Arrays.hashCode(this.timestamps));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfRecords", this.numberOfRecords()).toString();
    }

    public static TrinoThriftBlock fromBlock(Block block) {
        return TrinoThriftTypeUtils.fromLongBasedBlock(block, (Type)TimestampType.TIMESTAMP_MILLIS, (nulls, timestampsInMicros) -> {
            long[] timestampsInMillis = TrinoThriftTimestamp.epochMicrosToEpochMillis(timestampsInMicros);
            return TrinoThriftBlock.timestampData(new TrinoThriftTimestamp((boolean[])nulls, timestampsInMillis));
        });
    }

    public static TrinoThriftBlock fromRecordSetColumn(RecordSet recordSet, int columnIndex, int totalRecords) {
        return TrinoThriftTypeUtils.fromLongBasedColumn(recordSet, columnIndex, totalRecords, (nulls, timestampsInMicros) -> {
            long[] timestampsInMillis = TrinoThriftTimestamp.epochMicrosToEpochMillis(timestampsInMicros);
            return TrinoThriftBlock.timestampData(new TrinoThriftTimestamp((boolean[])nulls, timestampsInMillis));
        });
    }

    private static long[] epochMicrosToEpochMillis(@Nullable long[] timestampsInMicros) {
        if (timestampsInMicros == null) {
            return null;
        }
        long[] timestampsInMillis = new long[timestampsInMicros.length];
        for (int i = 0; i < timestampsInMicros.length; ++i) {
            long epochMicros = timestampsInMicros[i];
            Preconditions.checkArgument((Math.floorMod(epochMicros, 1000) == 0 ? 1 : 0) != 0, (String)"Not whole milliseconds at position %s: %s", (int)i, (long)epochMicros);
            timestampsInMillis[i] = Math.floorDiv(epochMicros, 1000);
        }
        return timestampsInMillis;
    }

    private static boolean sameSizeIfPresent(boolean[] nulls, long[] timestamps) {
        return nulls == null || timestamps == null || nulls.length == timestamps.length;
    }
}

