/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import io.trino.client.FailureInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FailureException
extends RuntimeException {
    private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("(.*)\\.(.*)\\(([^:]*)(?::(.*))?\\)");
    private final FailureInfo failureInfo;

    FailureException(FailureInfo failureInfo) {
        super(failureInfo.getMessage(), failureInfo.getCause() == null ? null : new FailureException(failureInfo.getCause()));
        this.failureInfo = failureInfo;
        for (FailureInfo suppressed : failureInfo.getSuppressed()) {
            this.addSuppressed(new FailureException(suppressed));
        }
        this.setStackTrace((StackTraceElement[])failureInfo.getStack().stream().map(FailureException::toStackTraceElement).toArray(StackTraceElement[]::new));
    }

    public FailureInfo getFailureInfo() {
        return this.failureInfo;
    }

    @Override
    public synchronized FailureException getCause() {
        return (FailureException)super.getCause();
    }

    @Override
    public String toString() {
        String type = this.failureInfo.getType();
        String message = this.failureInfo.getMessage();
        if (message != null) {
            return type + ": " + message;
        }
        return type;
    }

    private static StackTraceElement toStackTraceElement(String stack) {
        Matcher matcher = STACK_TRACE_PATTERN.matcher(stack);
        if (matcher.matches()) {
            String declaringClass = matcher.group(1);
            String methodName = matcher.group(2);
            String fileName = matcher.group(3);
            int number = -1;
            if (fileName.equals("Native Method")) {
                fileName = null;
                number = -2;
            } else if (matcher.group(4) != null) {
                number = Integer.parseInt(matcher.group(4));
            }
            return new StackTraceElement(declaringClass, methodName, fileName, number);
        }
        return new StackTraceElement("Unknown", stack, null, -1);
    }
}

