/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.trino.client.ErrorInfo;
import io.trino.client.ErrorLocation;
import io.trino.client.FailureException;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;

@Immutable
public class FailureInfo {
    private final String type;
    private final String message;
    private final FailureInfo cause;
    private final List<FailureInfo> suppressed;
    private final List<String> stack;
    private final ErrorInfo errorInfo;
    private final ErrorLocation errorLocation;

    @JsonCreator
    public FailureInfo(@JsonProperty(value="type") String type, @JsonProperty(value="message") String message, @JsonProperty(value="cause") FailureInfo cause, @JsonProperty(value="suppressed") List<FailureInfo> suppressed, @JsonProperty(value="stack") List<String> stack, @JsonProperty(value="errorInfo") @Nullable ErrorInfo errorInfo, @JsonProperty(value="errorLocation") @Nullable ErrorLocation errorLocation) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(suppressed, "suppressed is null");
        Objects.requireNonNull(stack, "stack is null");
        this.type = type;
        this.message = message;
        this.cause = cause;
        this.suppressed = ImmutableList.copyOf(suppressed);
        this.stack = ImmutableList.copyOf(stack);
        this.errorInfo = errorInfo;
        this.errorLocation = errorLocation;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Nullable
    @JsonProperty
    public String getMessage() {
        return this.message;
    }

    @Nullable
    @JsonProperty
    public FailureInfo getCause() {
        return this.cause;
    }

    @JsonProperty
    public List<FailureInfo> getSuppressed() {
        return this.suppressed;
    }

    @JsonProperty
    public List<String> getStack() {
        return this.stack;
    }

    @Nullable
    @JsonProperty
    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    @Nullable
    @JsonProperty
    public ErrorLocation getErrorLocation() {
        return this.errorLocation;
    }

    public RuntimeException toException() {
        return new FailureException(this);
    }
}

