/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.uri;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import io.trino.client.uri.ConnectionProperty;
import io.trino.client.uri.PropertyName;
import java.io.File;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Stream;

abstract class AbstractConnectionProperty<V, T>
implements ConnectionProperty<V, T> {
    private final PropertyName propertyName;
    private final String key;
    private final Optional<T> defaultValue;
    private final Predicate<Properties> isRequired;
    private final Validator<Properties> validator;
    private final Converter<V, T> converter;
    private final String[] choices;
    protected static final Predicate<Properties> NOT_REQUIRED = properties -> false;
    protected static final Validator<Properties> ALLOWED = properties -> Optional.empty();
    protected static final Converter<String, String> STRING_CONVERTER = String.class::cast;
    protected static final Converter<String, String> NON_EMPTY_STRING_CONVERTER = value -> {
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)"value is empty");
        return value;
    };
    protected static final Converter<String, File> FILE_CONVERTER = File::new;
    protected static final Converter<String, Boolean> BOOLEAN_CONVERTER = value -> {
        switch (value.toLowerCase(Locale.ENGLISH)) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        throw new IllegalArgumentException("value must be 'true' or 'false'");
    };

    protected AbstractConnectionProperty(PropertyName propertyName, Optional<T> defaultValue, Predicate<Properties> isRequired, Validator<Properties> validator, Converter<V, T> converter) {
        this.propertyName = Objects.requireNonNull(propertyName, "key is null");
        this.key = propertyName.toString();
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue is null");
        this.isRequired = Objects.requireNonNull(isRequired, "isRequired is null");
        this.validator = Objects.requireNonNull(validator, "validator is null");
        this.converter = Objects.requireNonNull(converter, "converter is null");
        Class type = new TypeToken<T>(this.getClass()){}.getRawType();
        this.choices = type == Boolean.class ? new String[]{"true", "false"} : (Enum.class.isAssignableFrom(type) ? (String[])Stream.of(type.getEnumConstants()).map(Object::toString).toArray(String[]::new) : null);
    }

    protected AbstractConnectionProperty(PropertyName key, Predicate<Properties> required, Validator<Properties> allowed, Converter<V, T> converter) {
        this(key, Optional.empty(), required, allowed, converter);
    }

    @Override
    public PropertyName getPropertyName() {
        return this.propertyName;
    }

    @Override
    public DriverPropertyInfo getDriverPropertyInfo(Properties mergedProperties) {
        String currentValue = mergedProperties.getProperty(this.key);
        DriverPropertyInfo result = new DriverPropertyInfo(this.key, currentValue);
        result.required = this.isRequired.test(mergedProperties);
        result.choices = this.choices != null ? (String[])this.choices.clone() : null;
        return result;
    }

    @Override
    public boolean isRequired(Properties properties) {
        return this.isRequired.test(properties);
    }

    @Override
    public boolean isValid(Properties properties) {
        return !this.validator.validate(properties).isPresent();
    }

    @Override
    public Optional<T> getValue(Properties properties) throws SQLException {
        return this.getValueOrDefault(properties, this.defaultValue);
    }

    @Override
    public Optional<T> getValueOrDefault(Properties properties, Optional<T> defaultValue) throws SQLException {
        Object value = properties.get(this.key);
        if (value == null) {
            if (this.isRequired(properties) && !defaultValue.isPresent()) {
                throw new SQLException(String.format("Connection property %s is required", this.key));
            }
            return defaultValue;
        }
        try {
            return Optional.of(this.converter.convert(value));
        }
        catch (RuntimeException e) {
            if (this.isEmpty(value)) {
                throw new SQLException(String.format("Connection property %s value is empty", this.key), e);
            }
            throw new SQLException(String.format("Connection property %s value is invalid: %s", this.key, value), e);
        }
    }

    private boolean isEmpty(V value) {
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        return false;
    }

    @Override
    public void validate(Properties properties) throws SQLException {
        Optional<String> message;
        if (properties.containsKey(this.key) && (message = this.validator.validate(properties)).isPresent()) {
            throw new SQLException(message.get());
        }
        this.getValue(properties);
    }

    protected static <T> Validator<T> validator(Predicate<T> predicate, String errorMessage) {
        Objects.requireNonNull(predicate, "predicate is null");
        Objects.requireNonNull(errorMessage, "errorMessage is null");
        return value -> {
            if (predicate.test(value)) {
                return Optional.empty();
            }
            return Optional.of(errorMessage);
        };
    }

    protected static <T> Predicate<T> checkedPredicate(CheckedPredicate<T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return value -> {
            try {
                return predicate.test(value);
            }
            catch (SQLException e) {
                return false;
            }
        };
    }

    protected static interface Validator<T> {
        public Optional<String> validate(T var1);

        default public Validator<T> and(Validator<? super T> other) {
            Objects.requireNonNull(other, "other is null");
            return t -> {
                Optional<String> result = this.validate(t);
                if (result.isPresent()) {
                    return result;
                }
                return other.validate(t);
            };
        }
    }

    static interface Converter<V, T> {
        public T convert(V var1);
    }

    protected static interface CheckedPredicate<T> {
        public boolean test(T var1) throws SQLException;
    }
}

