/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.internal.builtin;

import com.google.errorprone.annotations.Immutable;
import io.airlift.drift.codec.ThriftCodec;
import io.airlift.drift.codec.internal.ProtocolReader;
import io.airlift.drift.codec.internal.ProtocolWriter;
import io.airlift.drift.codec.metadata.ThriftType;
import io.airlift.drift.protocol.TProtocolReader;
import io.airlift.drift.protocol.TProtocolWriter;
import java.util.Objects;

@Immutable
public class ShortArrayThriftCodec
implements ThriftCodec<short[]> {
    @Override
    public ThriftType getType() {
        return ThriftType.array(ThriftType.I16);
    }

    @Override
    public short[] read(TProtocolReader protocol) throws Exception {
        Objects.requireNonNull(protocol, "protocol is null");
        return new ProtocolReader(protocol).readI16Array();
    }

    @Override
    public void write(short[] value, TProtocolWriter protocol) throws Exception {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(protocol, "protocol is null");
        new ProtocolWriter(protocol).writeI16Array(value);
    }
}

