/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.reflect.TypeToken;
import com.google.inject.internal.MoreTypes;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.codec.metadata.ConstructorInjection;
import io.airlift.drift.codec.metadata.Extractor;
import io.airlift.drift.codec.metadata.FieldExtractor;
import io.airlift.drift.codec.metadata.FieldInjection;
import io.airlift.drift.codec.metadata.FieldKind;
import io.airlift.drift.codec.metadata.FieldMetadata;
import io.airlift.drift.codec.metadata.MetadataErrors;
import io.airlift.drift.codec.metadata.MethodExtractor;
import io.airlift.drift.codec.metadata.MethodInjection;
import io.airlift.drift.codec.metadata.ParameterInjection;
import io.airlift.drift.codec.metadata.ReflectionHelper;
import io.airlift.drift.codec.metadata.ThriftCatalog;
import io.airlift.drift.codec.metadata.ThriftFieldMetadata;
import io.airlift.drift.codec.metadata.ThriftMethodInjection;
import io.airlift.drift.codec.metadata.ThriftParameterInjection;
import io.airlift.drift.codec.metadata.ThriftStructMetadata;
import io.airlift.drift.codec.metadata.ThriftTypeReference;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public abstract class AbstractThriftMetadataBuilder {
    protected final String structName;
    protected final Type structType;
    protected final Type builderType;
    protected final List<String> documentation;
    protected final List<FieldMetadata> fields = new ArrayList<FieldMetadata>();
    protected final List<Extractor> extractors = new ArrayList<Extractor>();
    protected final List<MethodInjection> builderMethodInjections = new ArrayList<MethodInjection>();
    protected final List<ConstructorInjection> constructorInjections = new ArrayList<ConstructorInjection>();
    protected final List<FieldInjection> fieldInjections = new ArrayList<FieldInjection>();
    protected final List<MethodInjection> methodInjections = new ArrayList<MethodInjection>();
    protected final ThriftCatalog catalog;
    protected final MetadataErrors metadataErrors;

    protected AbstractThriftMetadataBuilder(ThriftCatalog catalog, Type structType) {
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.structType = Objects.requireNonNull(structType, "structType is null");
        this.metadataErrors = new MetadataErrors(catalog.getMonitor());
        this.structName = this.extractName();
        this.builderType = this.extractBuilderType();
        this.documentation = ThriftCatalog.getThriftDocumentation(this.getStructClass());
        this.extractFromConstructors();
        this.extractFromFields();
        this.extractFromMethods();
    }

    protected abstract String extractName();

    protected abstract Map<String, String> extractStructIdlAnnotations();

    protected abstract Class<?> extractBuilderClass();

    protected abstract void validateConstructors();

    protected abstract boolean isValidateSetter(Method var1);

    protected abstract ThriftFieldMetadata buildField(Collection<FieldMetadata> var1);

    public abstract ThriftStructMetadata build();

    public MetadataErrors getMetadataErrors() {
        return this.metadataErrors;
    }

    public Class<?> getStructClass() {
        return TypeToken.of((Type)this.structType).getRawType();
    }

    public Class<?> getBuilderClass() {
        return TypeToken.of((Type)this.builderType).getRawType();
    }

    private Type extractBuilderType() {
        Class<?> builderClass = this.extractBuilderClass();
        if (builderClass == null) {
            return null;
        }
        if (builderClass.getTypeParameters().length == 0) {
            return builderClass;
        }
        if (!(this.structType instanceof ParameterizedType)) {
            this.metadataErrors.addError("Builder class '%s' may only be generic if the type it builds ('%s') is also generic", builderClass.getName(), this.getStructClass().getName());
            return builderClass;
        }
        if (builderClass.getTypeParameters().length != this.getStructClass().getTypeParameters().length) {
            this.metadataErrors.addError("Generic builder class '%s' must have the same number of type parameters as the type it builds ('%s')", builderClass.getName(), this.getStructClass().getName());
            return builderClass;
        }
        ParameterizedType parameterizedStructType = (ParameterizedType)this.structType;
        return new MoreTypes.ParameterizedTypeImpl(builderClass.getEnclosingClass(), builderClass, parameterizedStructType.getActualTypeArguments());
    }

    protected final void verifyClass(Class<? extends Annotation> annotation) {
        String annotationName = annotation.getSimpleName();
        String structClassName = this.getStructClass().getName();
        if (!Modifier.isPublic(this.getStructClass().getModifiers())) {
            this.metadataErrors.addError("%s class '%s' is not public", annotationName, structClassName);
        }
        if (!this.getStructClass().isAnnotationPresent(annotation)) {
            this.metadataErrors.addError("%s class '%s' does not have a @%s annotation", annotationName, structClassName, annotationName);
        }
    }

    protected final void extractFromConstructors() {
        if (this.builderType == null) {
            this.addConstructors(this.structType);
        } else {
            this.addConstructors(this.builderType);
            this.addBuilderMethods();
            for (Constructor<?> constructor : this.getStructClass().getConstructors()) {
                if (!constructor.isAnnotationPresent(ThriftConstructor.class)) continue;
                this.metadataErrors.addWarning("Thrift class '%s' has a builder class, but constructor '%s' annotated with @ThriftConstructor", this.getStructClass().getName(), constructor);
            }
        }
    }

    protected final void addConstructors(Type type) {
        Class clazz = TypeToken.of((Type)type).getRawType();
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.isSynthetic() || !constructor.isAnnotationPresent(ThriftConstructor.class)) continue;
            if (!Modifier.isPublic(constructor.getModifiers())) {
                this.metadataErrors.addError("@ThriftConstructor '%s' is not public", constructor.toGenericString());
                continue;
            }
            List<ParameterInjection> parameters = this.getParameterInjections(type, constructor.getParameterAnnotations(), ReflectionHelper.resolveFieldTypes(this.structType, constructor.getGenericParameterTypes()), ReflectionHelper.extractParameterNames(constructor));
            if (parameters == null) continue;
            this.fields.addAll(parameters);
            this.constructorInjections.add(new ConstructorInjection(constructor, parameters));
        }
        if (this.constructorInjections.isEmpty()) {
            try {
                Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                if (!Modifier.isPublic(constructor.getModifiers())) {
                    this.metadataErrors.addError("Default constructor '%s' is not public", constructor.toGenericString());
                }
                this.constructorInjections.add(new ConstructorInjection(constructor, new ParameterInjection[0]));
            }
            catch (NoSuchMethodException e) {
                this.metadataErrors.addError("Struct class '%s' does not have a public no-arg constructor", clazz.getName());
            }
        }
        this.validateConstructors();
    }

    protected final void addBuilderMethods() {
        for (Method method : ReflectionHelper.findAnnotatedMethods(this.getBuilderClass(), ThriftConstructor.class)) {
            List<ParameterInjection> parameters = this.getParameterInjections(this.builderType, method.getParameterAnnotations(), ReflectionHelper.resolveFieldTypes(this.builderType, method.getGenericParameterTypes()), ReflectionHelper.extractParameterNames(method));
            if (parameters != null) {
                this.fields.addAll(parameters);
                this.builderMethodInjections.add(new MethodInjection(method, parameters));
            }
            if (this.getStructClass().isAssignableFrom(method.getReturnType())) continue;
            this.metadataErrors.addError("'%s' says that '%s' is its builder class, but @ThriftConstructor method '%s' in the builder does not build an instance assignable to that type", this.structType, this.builderType, method.getName());
        }
        for (Method method : ReflectionHelper.getAllDeclaredMethods(this.getBuilderClass())) {
            if (!method.isAnnotationPresent(ThriftConstructor.class) && !this.hasThriftFieldAnnotation(method)) continue;
            if (!Modifier.isPublic(method.getModifiers())) {
                this.metadataErrors.addError("@ThriftConstructor method '%s' is not public", method.toGenericString());
            }
            if (!Modifier.isStatic(method.getModifiers())) continue;
            this.metadataErrors.addError("@ThriftConstructor method '%s' is static", method.toGenericString());
        }
        if (this.builderMethodInjections.isEmpty()) {
            this.metadataErrors.addError("Struct builder class '%s' does not have a public builder method annotated with @ThriftConstructor", this.getBuilderClass().getName());
        }
        if (this.builderMethodInjections.size() > 1) {
            this.metadataErrors.addError("Multiple builder methods are annotated with @ThriftConstructor ", this.builderMethodInjections);
        }
    }

    protected final void extractFromFields() {
        if (this.builderType == null) {
            this.addFields(this.getStructClass(), true, true);
        } else {
            this.addFields(this.getBuilderClass(), false, true);
            this.addFields(this.getStructClass(), true, false);
        }
    }

    protected final void addFields(Class<?> clazz, boolean allowReaders, boolean allowWriters) {
        for (Field fieldField : ReflectionHelper.findAnnotatedFields(clazz, ThriftField.class)) {
            this.addField(fieldField, allowReaders, allowWriters);
        }
        for (Field field : ReflectionHelper.getAllDeclaredFields(clazz)) {
            if (!field.isAnnotationPresent(ThriftField.class)) continue;
            if (!Modifier.isPublic(field.getModifiers())) {
                this.metadataErrors.addError("@ThriftField field '%s' is not public", field.toGenericString());
            }
            if (!Modifier.isStatic(field.getModifiers())) continue;
            this.metadataErrors.addError("@ThriftField field '%s' is static", field.toGenericString());
        }
    }

    protected final void addField(Field fieldField, boolean allowReaders, boolean allowWriters) {
        Preconditions.checkArgument((boolean)fieldField.isAnnotationPresent(ThriftField.class));
        ThriftField annotation = fieldField.getAnnotation(ThriftField.class);
        if (allowReaders) {
            FieldExtractor fieldExtractor = new FieldExtractor(this.structType, fieldField, annotation, FieldKind.THRIFT_FIELD);
            this.fields.add(fieldExtractor);
            this.extractors.add(fieldExtractor);
        }
        if (allowWriters) {
            FieldInjection fieldInjection = new FieldInjection(this.structType, fieldField, annotation, FieldKind.THRIFT_FIELD);
            this.fields.add(fieldInjection);
            this.fieldInjections.add(fieldInjection);
        }
    }

    protected final void extractFromMethods() {
        if (this.builderType != null) {
            this.addMethods(this.builderType, false, true);
            this.addMethods(this.structType, true, false);
        } else {
            this.addMethods(this.structType, true, true);
        }
    }

    protected final void addMethods(Type type, boolean allowReaders, boolean allowWriters) {
        Class clazz = TypeToken.of((Type)type).getRawType();
        for (Method fieldMethod : ReflectionHelper.findAnnotatedMethods(clazz, ThriftField.class)) {
            this.addMethod(type, fieldMethod, allowReaders, allowWriters);
        }
        for (Method method : ReflectionHelper.getAllDeclaredMethods(clazz)) {
            if (!method.isAnnotationPresent(ThriftField.class) && !this.hasThriftFieldAnnotation(method)) continue;
            if (!Modifier.isPublic(method.getModifiers())) {
                this.metadataErrors.addError("@ThriftField method '%s' is not public", method.toGenericString());
            }
            if (!Modifier.isStatic(method.getModifiers())) continue;
            this.metadataErrors.addError("@ThriftField method '%s' is static", method.toGenericString());
        }
    }

    protected final void addMethod(Type type, Method method, boolean allowReaders, boolean allowWriters) {
        Preconditions.checkArgument((boolean)method.isAnnotationPresent(ThriftField.class));
        ThriftField annotation = method.getAnnotation(ThriftField.class);
        Class clazz = TypeToken.of((Type)type).getRawType();
        if (this.isValidateGetter(method)) {
            if (allowReaders) {
                MethodExtractor methodExtractor = new MethodExtractor(type, method, annotation, FieldKind.THRIFT_FIELD);
                this.fields.add(methodExtractor);
                this.extractors.add(methodExtractor);
            } else {
                this.metadataErrors.addError("Reader method %s.%s is not allowed on a builder class", clazz.getName(), method.getName());
            }
        } else if (this.isValidateSetter(method)) {
            if (allowWriters) {
                ImmutableList parameters;
                if (method.getParameterCount() > 1 || this.hasThriftFieldAnnotation(method)) {
                    parameters = this.getParameterInjections(type, method.getParameterAnnotations(), ReflectionHelper.resolveFieldTypes(type, method.getGenericParameterTypes()), ReflectionHelper.extractParameterNames(method));
                    if (annotation.value() != Short.MIN_VALUE) {
                        this.metadataErrors.addError("A method with annotated parameters can not have a field id specified: %s.%s ", clazz.getName(), method.getName());
                    }
                    if (!annotation.name().isEmpty()) {
                        this.metadataErrors.addError("A method with annotated parameters can not have a field name specified: %s.%s ", clazz.getName(), method.getName());
                    }
                    if (annotation.requiredness() == ThriftField.Requiredness.REQUIRED) {
                        this.metadataErrors.addError("A method with annotated parameters can not be marked as required: %s.%s ", clazz.getName(), method.getName());
                    }
                } else {
                    Type parameterType = ReflectionHelper.resolveFieldTypes(type, method.getGenericParameterTypes())[0];
                    parameters = ImmutableList.of((Object)new ParameterInjection(type, 0, annotation, ReflectionHelper.extractFieldName(method), parameterType));
                }
                this.fields.addAll((Collection<FieldMetadata>)parameters);
                this.methodInjections.add(new MethodInjection(method, (List<ParameterInjection>)parameters));
            } else {
                this.metadataErrors.addError("Inject method %s.%s is not allowed on struct class, since struct has a builder", clazz.getName(), method.getName());
            }
        } else {
            this.metadataErrors.addError("Method %s.%s is not a supported getter or setter", clazz.getName(), method.getName());
        }
    }

    protected final boolean hasThriftFieldAnnotation(Method method) {
        Annotation[][] annotationArray = method.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] parameterAnnotations;
            for (Annotation parameterAnnotation : parameterAnnotations = annotationArray[i]) {
                if (!(parameterAnnotation instanceof ThriftField)) continue;
                return true;
            }
        }
        return false;
    }

    protected final boolean isValidateGetter(Method method) {
        return method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE;
    }

    protected final List<ParameterInjection> getParameterInjections(Type type, Annotation[][] parameterAnnotations, Type[] parameterTypes, List<String> parameterNames) {
        ArrayList<ParameterInjection> parameters = new ArrayList<ParameterInjection>(parameterAnnotations.length);
        for (int parameterIndex = 0; parameterIndex < parameterAnnotations.length; ++parameterIndex) {
            Annotation[] annotations = parameterAnnotations[parameterIndex];
            Type parameterType = parameterTypes[parameterIndex];
            ThriftField thriftField = null;
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof ThriftField)) continue;
                thriftField = (ThriftField)annotation;
            }
            ParameterInjection parameterInjection = new ParameterInjection(type, parameterIndex, thriftField, parameterNames.get(parameterIndex), parameterType);
            parameters.add(parameterInjection);
        }
        return parameters;
    }

    protected final void normalizeThriftFields(ThriftCatalog catalog) {
        Set<String> fieldsWithConflictingIds = this.inferThriftFieldIds();
        Map<Optional, List<FieldMetadata>> fieldsById = this.fields.stream().collect(Collectors.groupingBy(field -> Optional.ofNullable(field.getId())));
        for (Map.Entry<Optional, List<FieldMetadata>> entry : fieldsById.entrySet()) {
            Object field22;
            Object fieldName2;
            Collection fields = entry.getValue();
            if (!entry.getKey().isPresent()) {
                Set sortedFields = fields.stream().map(FieldMetadata::getOrExtractThriftFieldName).collect(Collectors.toCollection(TreeSet::new));
                for (Object fieldName2 : sortedFields) {
                    if (fieldsWithConflictingIds.contains(fieldName2)) continue;
                    this.metadataErrors.addError("Thrift class '%s' fields %s do not have an id", this.structName, sortedFields);
                }
                continue;
            }
            short fieldId = (Short)entry.getKey().get();
            String fieldName3 = this.extractFieldName(fieldId, fields);
            fieldName2 = fields.iterator();
            while (fieldName2.hasNext()) {
                FieldMetadata field3 = (FieldMetadata)fieldName2.next();
                field3.setName(fieldName3);
            }
            ThriftField.Requiredness requiredness = this.extractFieldRequiredness(fieldId, fieldName3, fields);
            for (Object field22 : fields) {
                ((FieldMetadata)field22).setRequiredness(requiredness);
            }
            boolean isLegacyId = this.extractFieldIsLegacyId(fieldId, fieldName3, fields);
            field22 = fields.iterator();
            while (field22.hasNext()) {
                FieldMetadata field4 = (FieldMetadata)field22.next();
                field4.setIsLegacyId(isLegacyId);
            }
            Map<String, String> idlAnnotations = this.extractFieldIdlAnnotations(fieldId, fields);
            for (FieldMetadata field5 : fields) {
                field5.setIdlAnnotations(idlAnnotations);
            }
            boolean isRecursiveReference = this.extractFieldIsRecursiveReference(fieldId, fields);
            for (FieldMetadata field6 : fields) {
                field6.setIsRecursiveReference(isRecursiveReference);
            }
            this.verifyFieldType(fieldId, fieldName3, fields, catalog);
        }
    }

    protected final Set<String> inferThriftFieldIds() {
        HashSet<String> fieldsWithConflictingIds = new HashSet<String>();
        ImmutableListMultimap fieldsByExplicitOrExtractedName = Multimaps.index(this.fields, FieldMetadata::getOrExtractThriftFieldName);
        this.inferThriftFieldIds((Multimap<String, FieldMetadata>)fieldsByExplicitOrExtractedName, fieldsWithConflictingIds);
        ImmutableListMultimap fieldsByExtractedName = Multimaps.index(this.fields, FieldMetadata::extractName);
        this.inferThriftFieldIds((Multimap<String, FieldMetadata>)fieldsByExtractedName, fieldsWithConflictingIds);
        return fieldsWithConflictingIds;
    }

    protected final void inferThriftFieldIds(Multimap<String, FieldMetadata> fieldsByName, Set<String> fieldsWithConflictingIds) {
        for (Map.Entry entry : fieldsByName.asMap().entrySet()) {
            Collection fields = (Collection)entry.getValue();
            String fieldName = (String)entry.getKey();
            if (fields.size() <= 1) continue;
            Set ids = fields.stream().map(FieldMetadata::getId).filter(Objects::nonNull).collect(Collectors.toSet());
            if (ids.size() > 1) {
                if (fieldsWithConflictingIds.contains(fieldName)) continue;
                this.metadataErrors.addError("Thrift class '%s' field '%s' has multiple ids: %s", this.structName, fieldName, ids.toString());
                fieldsWithConflictingIds.add(fieldName);
                continue;
            }
            if (ids.size() != 1) continue;
            short id = (Short)Iterables.getOnlyElement(ids);
            boolean isLegacyId = this.extractFieldIsLegacyId(id, fieldName, fields);
            for (FieldMetadata field : fields) {
                field.setId(id);
                field.setIsLegacyId(isLegacyId);
            }
        }
    }

    protected final Map<String, String> extractFieldIdlAnnotations(short fieldId, Collection<FieldMetadata> fields) {
        Set idlAnnotationMaps = fields.stream().map(field -> field == null ? null : field.getIdlAnnotations()).filter(annotationMap -> annotationMap != null && !annotationMap.isEmpty()).collect(Collectors.toSet());
        if (idlAnnotationMaps.isEmpty()) {
            return ImmutableMap.of();
        }
        if (idlAnnotationMaps.size() > 1) {
            this.metadataErrors.addError("Thrift class '%s' field '%s' has conflicting IDL annotation maps", this.structName, fieldId);
        }
        return (Map)idlAnnotationMaps.iterator().next();
    }

    protected final boolean extractFieldIsRecursiveReference(short fieldId, Collection<FieldMetadata> fields) {
        Set isRecursiveReferences = fields.stream().map(FieldMetadata::isRecursiveReference).filter(Objects::nonNull).collect(Collectors.toSet());
        if (isRecursiveReferences.isEmpty()) {
            return false;
        }
        if (isRecursiveReferences.size() > 1) {
            this.metadataErrors.addError("Thrift class '%s' field '%s' has both isRecursiveReference=TRUE and isRecursiveReference=FALSE", this.structName, fieldId);
        }
        return (Boolean)isRecursiveReferences.iterator().next();
    }

    protected final boolean extractFieldIsLegacyId(short id, String fieldName, Collection<FieldMetadata> fields) {
        Set isLegacyIds = fields.stream().map(FieldMetadata::getThriftFieldIsLegacyId).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        if (isLegacyIds.size() > 1) {
            this.metadataErrors.addError("Thrift class '%s' field '%s' has both isLegacyId=true and isLegacyId=false", this.structName, fieldName);
        }
        if (id < 0) {
            if (!isLegacyIds.contains(true)) {
                this.metadataErrors.addError("Thrift class '%s' field '%s' has a negative field id but not isLegacyId=true", this.structName, fieldName);
            }
        } else if (isLegacyIds.contains(true)) {
            this.metadataErrors.addError("Thrift class '%s' field '%s' has isLegacyId=true but not a negative field id", this.structName, fieldName);
        }
        return id < 0;
    }

    protected final String extractFieldName(short id, Collection<FieldMetadata> fields) {
        Set names = fields.stream().map(FieldMetadata::getName).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!names.isEmpty()) {
            if (names.size() > 1) {
                this.metadataErrors.addWarning("Thrift class %s field %s has multiple names %s", this.structName, id, names);
            }
            return (String)names.iterator().next();
        }
        return fields.stream().map(FieldMetadata::extractName).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalArgumentException("Field name not found for ID: " + id));
    }

    protected final ThriftField.Requiredness extractFieldRequiredness(short fieldId, String fieldName, Collection<FieldMetadata> fields) {
        Set requirednessValues = fields.stream().map(FieldMetadata::getRequiredness).filter(Objects::nonNull).filter(field -> field != ThriftField.Requiredness.UNSPECIFIED).collect(Collectors.toSet());
        if (requirednessValues.size() > 1) {
            this.metadataErrors.addError("Thrift class '%s' field '%s(%d)' has multiple requiredness values: %s", this.structName, fieldName, fieldId, requirednessValues.toString());
        }
        ThriftField.Requiredness resolvedRequiredness = requirednessValues.isEmpty() ? ThriftField.Requiredness.NONE : (ThriftField.Requiredness)requirednessValues.iterator().next();
        return resolvedRequiredness;
    }

    protected final void verifyFieldType(short id, String name, Collection<FieldMetadata> fields, ThriftCatalog catalog) {
        boolean isSupportedType = true;
        for (FieldMetadata field : fields) {
            if (catalog.isSupportedStructFieldType(field.getJavaType())) continue;
            this.metadataErrors.addError("Thrift class '%s' field '%s(%s)' type '%s' is not a supported Java type", this.structName, name, id, TypeToken.of((Type)field.getJavaType()));
            isSupportedType = false;
            break;
        }
        if (isSupportedType) {
            HashSet<ThriftTypeReference> types = new HashSet<ThriftTypeReference>();
            for (FieldMetadata field : fields) {
                types.add(catalog.getFieldThriftTypeReference(field));
            }
            if (types.size() > 1) {
                this.metadataErrors.addError("Thrift class '%s' field '%s(%s)' has multiple types: %s", this.structName, name, id, types);
            }
        }
    }

    protected final ThriftMethodInjection buildBuilderConstructorInjections() {
        ThriftMethodInjection builderMethodInjection = null;
        if (this.builderType != null) {
            MethodInjection builderMethod = this.builderMethodInjections.get(0);
            builderMethodInjection = new ThriftMethodInjection(builderMethod.getMethod(), AbstractThriftMetadataBuilder.buildParameterInjections(builderMethod.getParameters()));
        }
        return builderMethodInjection;
    }

    protected final Iterable<ThriftFieldMetadata> buildFieldInjections() {
        Map<Short, List<FieldMetadata>> fieldsById = this.fields.stream().collect(Collectors.groupingBy(FieldMetadata::getId));
        return fieldsById.values().stream().map(this::buildField).collect(Collectors.toList());
    }

    protected final List<ThriftMethodInjection> buildMethodInjections() {
        return this.methodInjections.stream().map(injection -> new ThriftMethodInjection(injection.getMethod(), AbstractThriftMetadataBuilder.buildParameterInjections(injection.getParameters()))).collect(Collectors.toList());
    }

    protected static List<ThriftParameterInjection> buildParameterInjections(List<ParameterInjection> parameters) {
        return parameters.stream().map(injection -> new ThriftParameterInjection(injection.getId(), injection.getName(), injection.getParameterIndex(), injection.getJavaType())).collect(Collectors.toList());
    }
}

