/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.metadata;

import com.google.common.base.Joiner;
import com.google.errorprone.annotations.Immutable;
import io.airlift.drift.codec.metadata.ThriftParameterInjection;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@Immutable
public class ThriftMethodInjection {
    private final Method method;
    private final List<ThriftParameterInjection> parameters;

    public ThriftMethodInjection(Method method, ThriftParameterInjection ... parameters) {
        this(method, Arrays.asList(parameters));
    }

    public ThriftMethodInjection(Method method, List<ThriftParameterInjection> parameters) {
        this.method = Objects.requireNonNull(method, "method is null");
        this.parameters = Objects.requireNonNull(parameters, "parameters is null");
    }

    public Method getMethod() {
        return this.method;
    }

    public List<ThriftParameterInjection> getParameters() {
        return this.parameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.method.getName());
        sb.append('(');
        Joiner.on((String)", ").appendTo(sb, this.parameters);
        sb.append(')');
        return sb.toString();
    }
}

