/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import io.trino.cost.BaseStatsCalculatorTest;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.SampleNode;
import org.junit.jupiter.api.Test;

public class TestSampleStatsRule
extends BaseStatsCalculatorTest {
    @Test
    public void testStatsForSampleNode() {
        this.tester().assertStatsFor(pb -> {
            Symbol a = pb.symbol("a", (Type)BigintType.BIGINT);
            Symbol b = pb.symbol("b", (Type)DoubleType.DOUBLE);
            return pb.sample(0.33, SampleNode.Type.BERNOULLI, (PlanNode)pb.values(a, b));
        }).withSourceStats(PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics(new Symbol("a"), SymbolStatsEstimate.builder().setDistinctValuesCount(20.0).setNullsFraction(0.3).setLowValue(1.0).setHighValue(30.0).build()).addSymbolStatistics(new Symbol("b"), SymbolStatsEstimate.builder().setDistinctValuesCount(40.0).setNullsFraction(0.6).setLowValue(13.5).setHighValue(Double.POSITIVE_INFINITY).build()).build()).check(check -> check.outputRowsCount(33.0).symbolStats("a", assertion -> assertion.dataSizeUnknown().distinctValuesCount(20.0).nullsFraction(0.3).lowValue(1.0).highValue(30.0)).symbolStats("b", assertion -> assertion.dataSizeUnknown().distinctValuesCount(23.1).nullsFraction(0.3).lowValue(13.5).highValueUnknown()));
    }
}

