/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.execution.CreateMaterializedViewTask;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Plugin;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableSchema;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TestingColumnHandle;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.Type;
import io.trino.sql.QueryUtil;
import io.trino.sql.tree.AllColumns;
import io.trino.sql.tree.CreateMaterializedView;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.SelectItem;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.StringLiteral;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
class TestCreateMaterializedViewTask {
    private static final String DEFAULT_MATERIALIZED_VIEW_FOO_PROPERTY_VALUE = null;
    private static final Integer DEFAULT_MATERIALIZED_VIEW_BAR_PROPERTY_VALUE = 123;
    private static final ConnectorTableMetadata MOCK_TABLE = new ConnectorTableMetadata(new SchemaTableName("schema", "mock_table"), List.of(new ColumnMetadata("a", (Type)SmallintType.SMALLINT), new ColumnMetadata("b", (Type)BigintType.BIGINT)), (Map)ImmutableMap.of((Object)"baz", (Object)"property_value"));
    private QueryRunner queryRunner;
    private MockMetadata metadata;
    private CreateMaterializedViewTask task;

    TestCreateMaterializedViewTask() {
    }

    @BeforeEach
    void setUp() {
        StandaloneQueryRunner queryRunner = new StandaloneQueryRunner(TestingSession.testSessionBuilder().setCatalog("test_catalog").build());
        this.metadata = new MockMetadata();
        queryRunner.installPlugin((Plugin)new MockConnectorPlugin(MockConnectorFactory.builder().withMetadataWrapper(ignored -> this.metadata).withGetMaterializedViewProperties(() -> ImmutableList.builder().add((Object)PropertyMetadata.stringProperty((String)"foo", (String)"test materialized view property", (String)DEFAULT_MATERIALIZED_VIEW_FOO_PROPERTY_VALUE, (boolean)false)).add((Object)PropertyMetadata.integerProperty((String)"bar", (String)"test materialized view property", (Integer)DEFAULT_MATERIALIZED_VIEW_BAR_PROPERTY_VALUE, (boolean)false)).build()).build()));
        queryRunner.createCatalog("test_catalog", "mock", (Map)ImmutableMap.of());
        Map tasks = (Map)queryRunner.getCoordinator().getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<Class<? extends Statement>, DataDefinitionTask<?>>>(this){}));
        this.task = (CreateMaterializedViewTask)tasks.get(CreateMaterializedView.class);
        this.queryRunner = queryRunner;
    }

    @AfterEach
    void tearDown() {
        if (this.queryRunner != null) {
            this.queryRunner.close();
        }
    }

    @Test
    void testCreateMaterializedViewIfNotExists() {
        CreateMaterializedView statement = new CreateMaterializedView(Optional.empty(), QualifiedName.of((String)"test_mv_if_not_exists"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"test_catalog", (String[])new String[]{"schema", "mock_table"}))), false, true, Optional.empty(), (List)ImmutableList.of(), Optional.empty());
        this.queryRunner.inTransaction(transactionSession -> {
            this.createMaterializedView((Session)transactionSession, statement);
            Assertions.assertThat((int)this.metadata.getCreateMaterializedViewCallCount()).isEqualTo(1);
            return null;
        });
    }

    @Test
    void testCreateMaterializedViewWithExistingView() {
        CreateMaterializedView statement = new CreateMaterializedView(Optional.empty(), QualifiedName.of((String)"test_mv_with_existing_view"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"test_catalog", (String[])new String[]{"schema", "mock_table"}))), false, false, Optional.empty(), (List)ImmutableList.of(), Optional.empty());
        this.queryRunner.inTransaction(transactionSession -> {
            TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.createMaterializedView((Session)transactionSession, statement)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.ALREADY_EXISTS}).hasMessage("Materialized view already exists");
            Assertions.assertThat((int)this.metadata.getCreateMaterializedViewCallCount()).isEqualTo(1);
            return null;
        });
    }

    @Test
    void testCreateMaterializedViewWithInvalidProperty() {
        CreateMaterializedView statement = new CreateMaterializedView(Optional.empty(), QualifiedName.of((String)"test_mv_with_invalid_property"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"test_catalog", (String[])new String[]{"schema", "mock_table"}))), false, true, Optional.empty(), (List)ImmutableList.of((Object)new Property(new Identifier("baz"), (Expression)new StringLiteral("abc"))), Optional.empty());
        this.queryRunner.inTransaction(transactionSession -> {
            TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.createMaterializedView((Session)transactionSession, statement)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_MATERIALIZED_VIEW_PROPERTY}).hasMessage("Catalog 'test_catalog' materialized view property 'baz' does not exist");
            Assertions.assertThat((int)this.metadata.getCreateMaterializedViewCallCount()).isEqualTo(0);
            return null;
        });
    }

    @Test
    void testCreateMaterializedViewWithDefaultProperties() {
        CreateMaterializedView statement = new CreateMaterializedView(Optional.empty(), QualifiedName.of((String)"test_catalog", (String[])new String[]{"schema", "mv_default_properties"}), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"test_catalog", (String[])new String[]{"schema", "mock_table"}))), false, true, Optional.empty(), (List)ImmutableList.of((Object)new Property(new Identifier("foo")), (Object)new Property(new Identifier("bar"))), Optional.empty());
        this.queryRunner.inTransaction(transactionSession -> {
            this.createMaterializedView((Session)transactionSession, statement);
            SchemaTableName viewName = SchemaTableName.schemaTableName((String)"schema", (String)"mv_default_properties");
            Optional<ConnectorMaterializedViewDefinition> definitionOptional = this.metadata.getMaterializedView(transactionSession.toConnectorSession(), viewName);
            Assertions.assertThat(definitionOptional).isPresent();
            Map<String, Object> properties = this.metadata.getMaterializedViewProperties(transactionSession.toConnectorSession(), viewName, definitionOptional.get());
            Assertions.assertThat((Object)properties.get("foo")).isEqualTo((Object)DEFAULT_MATERIALIZED_VIEW_FOO_PROPERTY_VALUE);
            Assertions.assertThat((Object)properties.get("bar")).isEqualTo((Object)DEFAULT_MATERIALIZED_VIEW_BAR_PROPERTY_VALUE);
            return null;
        });
    }

    @Test
    public void testCreateDenyPermission() {
        CreateMaterializedView statement = new CreateMaterializedView(Optional.empty(), QualifiedName.of((String)"test_mv_deny"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"test_catalog", (String[])new String[]{"schema", "mock_table"}))), false, true, Optional.empty(), (List)ImmutableList.of(), Optional.empty());
        this.queryRunner.getAccessControl().deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"test_mv_deny", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_MATERIALIZED_VIEW)});
        this.queryRunner.inTransaction(transactionSession -> {
            TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.createMaterializedView((Session)transactionSession, statement)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.PERMISSION_DENIED}).hasMessageContaining("Cannot create materialized view test_catalog.schema.test_mv");
            return null;
        });
    }

    private void createMaterializedView(Session transactionSession, CreateMaterializedView statement) {
        this.task.executeInternal(statement, transactionSession, (List)ImmutableList.of(), WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector());
    }

    private static class MockMetadata
    implements ConnectorMetadata {
        private final Map<SchemaTableName, ConnectorMaterializedViewDefinition> materializedViews = new ConcurrentHashMap<SchemaTableName, ConnectorMaterializedViewDefinition>();
        private final Map<SchemaTableName, Map<String, Object>> materializedViewProperties = new ConcurrentHashMap<SchemaTableName, Map<String, Object>>();

        private MockMetadata() {
        }

        public void createMaterializedView(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, Map<String, Object> properties, boolean replace, boolean ignoreExisting) {
            this.materializedViews.put(viewName, definition);
            this.materializedViewProperties.put(viewName, properties);
            if (!ignoreExisting) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Materialized view already exists");
            }
        }

        public ConnectorTableSchema getTableSchema(ConnectorSession session, ConnectorTableHandle table) {
            return MOCK_TABLE.getTableSchema();
        }

        public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
            if (tableName.equals((Object)MOCK_TABLE.getTable())) {
                return new TestingMetadata.TestingTableHandle(tableName);
            }
            return null;
        }

        public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
            return (Map)MOCK_TABLE.getColumns().stream().collect(ImmutableMap.toImmutableMap(ColumnMetadata::getName, column -> new TestingColumnHandle(column.getName())));
        }

        public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession session, SchemaTableName viewName) {
            return Optional.ofNullable(this.materializedViews.get(viewName));
        }

        public Map<String, Object> getMaterializedViewProperties(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition materializedViewDefinition) {
            return this.materializedViewProperties.get(viewName);
        }

        public int getCreateMaterializedViewCallCount() {
            return this.materializedViews.size();
        }
    }
}

