/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Plugin;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.io.Closeable;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestCreateTableColumnTypeCoercion {
    private static final String catalogName = "mock";
    private QueryRunner queryRunner;

    private QueryRunner createQueryRunner() {
        Session session = TestingSession.testSessionBuilder().setCatalog(catalogName).setSchema("default").build();
        StandaloneQueryRunner queryRunner = new StandaloneQueryRunner(session);
        queryRunner.installPlugin((Plugin)new MockConnectorPlugin(this.prepareConnectorFactory(catalogName)));
        queryRunner.createCatalog(catalogName, catalogName, (Map)ImmutableMap.of());
        return queryRunner;
    }

    private MockConnectorFactory prepareConnectorFactory(String catalogName) {
        return MockConnectorFactory.builder().withName(catalogName).withGetTableHandle((session, schemaTableName) -> null).withGetSupportedType((session, type) -> {
            if (type instanceof TimestampType) {
                return Optional.of(VarcharType.VARCHAR);
            }
            return Optional.empty();
        }).build();
    }

    @Test
    public void testIncompatibleTypeForCreateTableAsSelect() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.queryRunner.execute("CREATE TABLE test_incompatible_type AS SELECT TIMESTAMP '2020-09-27 12:34:56.999' a")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Type 'timestamp(3)' is not compatible with the supplied type 'varchar' in getSupportedType");
    }

    @Test
    public void testIncompatibleTypeForCreateTableAsSelectWithNoData() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.queryRunner.execute("CREATE TABLE test_incompatible_type AS SELECT TIMESTAMP '2020-09-27 12:34:56.999' a WITH NO DATA")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Type 'timestamp(3)' is not compatible with the supplied type 'varchar' in getSupportedType");
    }

    @BeforeAll
    public final void initQueryRunner() {
        this.queryRunner = this.createQueryRunner();
    }

    @AfterAll
    public final void destroyQueryRunner() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.queryRunner});
        this.queryRunner = null;
    }
}

