/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provider;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.tracing.SpanSerialization;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.trino.SessionTestUtils;
import io.trino.client.NodeVersion;
import io.trino.execution.Column;
import io.trino.execution.Input;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryState;
import io.trino.execution.TestQueryStats;
import io.trino.operator.RetryPolicy;
import io.trino.spi.QueryId;
import io.trino.spi.TrinoWarning;
import io.trino.spi.WarningCode;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.resourcegroups.QueryType;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.SelectedRole;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.transaction.TransactionId;
import io.trino.type.TypeSignatureDeserializer;
import io.trino.type.TypeSignatureKeyDeserializer;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestQueryInfo {
    @Test
    public void testQueryInfoRoundTrip() {
        JsonCodec codec = new JsonCodecFactory((Provider)new ObjectMapperProvider().withJsonSerializers(Map.of(Span.class, new SpanSerialization.SpanSerializer(OpenTelemetry.noop()))).withJsonDeserializers(Map.of(Span.class, new SpanSerialization.SpanDeserializer(OpenTelemetry.noop()), TypeSignature.class, new TypeSignatureDeserializer())).withKeyDeserializers(Map.of(TypeSignature.class, new TypeSignatureKeyDeserializer()))).jsonCodec(QueryInfo.class);
        QueryInfo expected = TestQueryInfo.createQueryInfo();
        QueryInfo actual = (QueryInfo)codec.fromJson(codec.toJsonBytes((Object)expected));
        Assertions.assertThat((Object)actual.getQueryId()).isEqualTo((Object)expected.getQueryId());
        Assertions.assertThat((Comparable)actual.getState()).isEqualTo((Object)expected.getState());
        Assertions.assertThat((boolean)actual.isScheduled()).isEqualTo(expected.isScheduled());
        Assertions.assertThat((OptionalDouble)actual.getProgressPercentage()).isEqualTo((Object)expected.getProgressPercentage());
        Assertions.assertThat((OptionalDouble)actual.getRunningPercentage()).isEqualTo((Object)expected.getRunningPercentage());
        Assertions.assertThat((URI)actual.getSelf()).isEqualTo((Object)expected.getSelf());
        Assertions.assertThat((List)actual.getFieldNames()).isEqualTo((Object)expected.getFieldNames());
        Assertions.assertThat((String)actual.getQuery()).isEqualTo(expected.getQuery());
        Assertions.assertThat((Optional)actual.getPreparedQuery()).isEqualTo((Object)expected.getPreparedQuery());
        TestQueryStats.assertExpectedQueryStats(actual.getQueryStats());
        Assertions.assertThat((Optional)actual.getSetCatalog()).isEqualTo((Object)expected.getSetCatalog());
        Assertions.assertThat((Optional)actual.getSetSchema()).isEqualTo((Object)expected.getSetSchema());
        Assertions.assertThat((Optional)actual.getSetPath()).isEqualTo((Object)expected.getSetPath());
        Assertions.assertThat((Map)actual.getSetSessionProperties()).isEqualTo((Object)expected.getSetSessionProperties());
        Assertions.assertThat((Collection)actual.getResetSessionProperties()).isEqualTo((Object)expected.getResetSessionProperties());
        Assertions.assertThat((Map)actual.getSetRoles()).isEqualTo((Object)expected.getSetRoles());
        Assertions.assertThat((Map)actual.getAddedPreparedStatements()).isEqualTo((Object)expected.getAddedPreparedStatements());
        Assertions.assertThat((Collection)actual.getDeallocatedPreparedStatements()).isEqualTo((Object)expected.getDeallocatedPreparedStatements());
        Assertions.assertThat((Optional)actual.getStartedTransactionId()).isEqualTo((Object)expected.getStartedTransactionId());
        Assertions.assertThat((boolean)actual.isClearTransactionId()).isEqualTo(expected.isClearTransactionId());
        Assertions.assertThat((String)actual.getUpdateType()).isEqualTo(expected.getUpdateType());
        Assertions.assertThat((Optional)actual.getOutputStage()).isEqualTo((Object)expected.getOutputStage());
        Assertions.assertThat((Object)actual.getFailureInfo()).isEqualTo((Object)expected.getFailureInfo());
        Assertions.assertThat((Object)actual.getErrorCode()).isEqualTo((Object)expected.getErrorCode());
        Assertions.assertThat((List)actual.getWarnings()).isEqualTo((Object)expected.getWarnings());
        Assertions.assertThat((Collection)actual.getInputs()).isEqualTo((Object)expected.getInputs());
        Assertions.assertThat((Optional)actual.getOutput()).isEqualTo((Object)expected.getOutput());
        Assertions.assertThat((List)actual.getReferencedTables()).isEqualTo((Object)expected.getReferencedTables());
        Assertions.assertThat((List)actual.getRoutines()).isEqualTo((Object)expected.getRoutines());
        Assertions.assertThat((boolean)actual.isFinalQueryInfo()).isEqualTo(expected.isFinalQueryInfo());
        Assertions.assertThat((Optional)actual.getResourceGroupId()).isEqualTo((Object)expected.getResourceGroupId());
        Assertions.assertThat((Optional)actual.getQueryType()).isEqualTo((Object)expected.getQueryType());
        Assertions.assertThat((Comparable)actual.getRetryPolicy()).isEqualTo((Object)expected.getRetryPolicy());
    }

    private static QueryInfo createQueryInfo() {
        return new QueryInfo(new QueryId("0"), SessionTestUtils.TEST_SESSION.toSessionRepresentation(), QueryState.FINISHED, URI.create("1"), (List)ImmutableList.of((Object)"number"), "SELECT 1 as number", Optional.of("prepared_query"), TestQueryStats.EXPECTED, Optional.of("set_catalog"), Optional.of("set_schema"), Optional.of("set_path"), Optional.of("set_authorization_user"), false, (Map)ImmutableMap.of((Object)"set_property", (Object)"set_value"), (Set)ImmutableSet.of((Object)"reset_property"), (Map)ImmutableMap.of((Object)"set_roles", (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("role"))), (Map)ImmutableMap.of((Object)"added_prepared_statement", (Object)"statement"), (Set)ImmutableSet.of((Object)"deallocated_prepared_statement", (Object)"statement"), Optional.of(TransactionId.create()), true, "42", Optional.empty(), null, null, (List)ImmutableList.of((Object)new TrinoWarning(new WarningCode(1, "name"), "message")), (Set)ImmutableSet.of((Object)new Input("catalog", new CatalogHandle.CatalogVersion("default"), "schema", "talble", Optional.empty(), (List)ImmutableList.of((Object)new Column("name", "type")), new PlanFragmentId("id"), new PlanNodeId("1"))), Optional.empty(), (List)ImmutableList.of(), (List)ImmutableList.of(), true, Optional.of(new ResourceGroupId("groupId")), Optional.of(QueryType.SELECT), RetryPolicy.TASK, false, new NodeVersion("test"));
    }
}

