/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import io.trino.execution.scheduler.faulttolerant.ArbitraryDistributionSplitAssigner;
import io.trino.execution.scheduler.faulttolerant.SplitAssignerTester;
import io.trino.execution.scheduler.faulttolerant.TaskDescriptor;
import io.trino.execution.scheduler.faulttolerant.TestingConnectorSplit;
import io.trino.metadata.Split;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestArbitraryDistributionSplitAssigner {
    private static final int FUZZ_TESTING_INVOCATION_COUNT = 100;
    private static final long STANDARD_SPLIT_SIZE_IN_BYTES = 1L;
    private static final PlanNodeId PARTITIONED_1 = new PlanNodeId("partitioned-1");
    private static final PlanNodeId PARTITIONED_2 = new PlanNodeId("partitioned-2");
    private static final PlanNodeId REPLICATED_1 = new PlanNodeId("replicated-1");
    private static final PlanNodeId REPLICATED_2 = new PlanNodeId("replicated-2");
    private static final HostAddress HOST_1 = HostAddress.fromParts((String)"localhost", (int)8081);
    private static final HostAddress HOST_2 = HostAddress.fromParts((String)"localhost", (int)8082);
    private static final HostAddress HOST_3 = HostAddress.fromParts((String)"localhost", (int)8083);

    @Test
    public void testEmpty() {
        ArbitraryDistributionSplitAssigner splitAssigner = TestArbitraryDistributionSplitAssigner.createSplitAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1), (Set<PlanNodeId>)ImmutableSet.of(), 100, false);
        SplitAssignerTester tester = new SplitAssignerTester();
        tester.update(splitAssigner.assign(PARTITIONED_1, (ListMultimap)ImmutableListMultimap.of(), true));
        Assertions.assertThat((boolean)tester.isNoMoreSplits(0, PARTITIONED_1)).isTrue();
        tester.update(splitAssigner.finish());
        List<TaskDescriptor> taskDescriptors = tester.getTaskDescriptors().orElseThrow();
        Assertions.assertThat(taskDescriptors).hasSize(1);
        TestArbitraryDistributionSplitAssigner.assertTaskDescriptor(taskDescriptors.get(0), 0, (ListMultimap<PlanNodeId, Split>)ImmutableListMultimap.of());
        splitAssigner = TestArbitraryDistributionSplitAssigner.createSplitAssigner((Set<PlanNodeId>)ImmutableSet.of(), (Set<PlanNodeId>)ImmutableSet.of((Object)REPLICATED_1), 100, false);
        tester = new SplitAssignerTester();
        tester.update(splitAssigner.assign(REPLICATED_1, (ListMultimap)ImmutableListMultimap.of(), true));
        Assertions.assertThat((boolean)tester.isNoMoreSplits(0, REPLICATED_1)).isTrue();
        tester.update(splitAssigner.finish());
        taskDescriptors = tester.getTaskDescriptors().orElseThrow();
        Assertions.assertThat(taskDescriptors).hasSize(1);
        TestArbitraryDistributionSplitAssigner.assertTaskDescriptor(taskDescriptors.get(0), 0, (ListMultimap<PlanNodeId, Split>)ImmutableListMultimap.of());
        splitAssigner = TestArbitraryDistributionSplitAssigner.createSplitAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1), (Set<PlanNodeId>)ImmutableSet.of((Object)REPLICATED_1), 100, true);
        tester = new SplitAssignerTester();
        tester.update(splitAssigner.assign(REPLICATED_1, (ListMultimap)ImmutableListMultimap.of(), true));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)tester.isNoMoreSplits(0, PARTITIONED_1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)tester.isNoMoreSplits(0, REPLICATED_1));
        tester.update(splitAssigner.assign(PARTITIONED_1, (ListMultimap)ImmutableListMultimap.of(), true));
        Assertions.assertThat((boolean)tester.isNoMoreSplits(0, PARTITIONED_1)).isTrue();
        Assertions.assertThat((boolean)tester.isNoMoreSplits(0, REPLICATED_1)).isTrue();
        tester.update(splitAssigner.finish());
        taskDescriptors = tester.getTaskDescriptors().orElseThrow();
        Assertions.assertThat(taskDescriptors).hasSize(1);
        TestArbitraryDistributionSplitAssigner.assertTaskDescriptor(taskDescriptors.get(0), 0, (ListMultimap<PlanNodeId, Split>)ImmutableListMultimap.of());
        splitAssigner = TestArbitraryDistributionSplitAssigner.createSplitAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1), (Set<PlanNodeId>)ImmutableSet.of((Object)REPLICATED_1), 100, true);
        tester = new SplitAssignerTester();
        tester.update(splitAssigner.assign(PARTITIONED_1, (ListMultimap)ImmutableListMultimap.of(), true));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)tester.isNoMoreSplits(0, PARTITIONED_1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)tester.isNoMoreSplits(0, REPLICATED_1));
        tester.update(splitAssigner.assign(REPLICATED_1, (ListMultimap)ImmutableListMultimap.of(), true));
        Assertions.assertThat((boolean)tester.isNoMoreSplits(0, PARTITIONED_1)).isTrue();
        Assertions.assertThat((boolean)tester.isNoMoreSplits(0, REPLICATED_1)).isTrue();
        tester.update(splitAssigner.finish());
        taskDescriptors = tester.getTaskDescriptors().orElseThrow();
        Assertions.assertThat(taskDescriptors).hasSize(1);
        TestArbitraryDistributionSplitAssigner.assertTaskDescriptor(taskDescriptors.get(0), 0, (ListMultimap<PlanNodeId, Split>)ImmutableListMultimap.of());
        splitAssigner = TestArbitraryDistributionSplitAssigner.createSplitAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1, (Object)PARTITIONED_2), (Set<PlanNodeId>)ImmutableSet.of((Object)REPLICATED_1, (Object)REPLICATED_2), 100, true);
        tester = new SplitAssignerTester();
        tester.update(splitAssigner.assign(REPLICATED_1, (ListMultimap)ImmutableListMultimap.of(), true));
        tester.update(splitAssigner.assign(PARTITIONED_1, (ListMultimap)ImmutableListMultimap.of(), true));
        tester.update(splitAssigner.assign(PARTITIONED_2, (ListMultimap)ImmutableListMultimap.of(), true));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)tester.isNoMoreSplits(0, PARTITIONED_1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)tester.isNoMoreSplits(0, REPLICATED_1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)tester.isNoMoreSplits(0, PARTITIONED_2));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)tester.isNoMoreSplits(0, REPLICATED_2));
        tester.update(splitAssigner.assign(REPLICATED_2, (ListMultimap)ImmutableListMultimap.of(), true));
        Assertions.assertThat((boolean)tester.isNoMoreSplits(0, PARTITIONED_1)).isTrue();
        Assertions.assertThat((boolean)tester.isNoMoreSplits(0, REPLICATED_1)).isTrue();
        Assertions.assertThat((boolean)tester.isNoMoreSplits(0, PARTITIONED_2)).isTrue();
        Assertions.assertThat((boolean)tester.isNoMoreSplits(0, REPLICATED_2)).isTrue();
        tester.update(splitAssigner.finish());
        taskDescriptors = tester.getTaskDescriptors().orElseThrow();
        Assertions.assertThat(taskDescriptors).hasSize(1);
        TestArbitraryDistributionSplitAssigner.assertTaskDescriptor(taskDescriptors.get(0), 0, (ListMultimap<PlanNodeId, Split>)ImmutableListMultimap.of());
    }

    @Test
    public void testNoHostRequirement() {
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1), (Set<PlanNodeId>)ImmutableSet.of(), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of(), true)), 1, false);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1), (Set<PlanNodeId>)ImmutableSet.of(), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1)), true)), 1, true);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1), (Set<PlanNodeId>)ImmutableSet.of(), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1), (Object)TestArbitraryDistributionSplitAssigner.createSplit(2)), true)), 1, false);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1), (Set<PlanNodeId>)ImmutableSet.of(), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1), (Object)TestArbitraryDistributionSplitAssigner.createSplit(2)), false), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(3), (Object)TestArbitraryDistributionSplitAssigner.createSplit(4)), false), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(5)), true)), 2, true);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1, (Object)PARTITIONED_2), (Set<PlanNodeId>)ImmutableSet.of(), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1)), true), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(2)), true)), 1, false);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1, (Object)PARTITIONED_2), (Set<PlanNodeId>)ImmutableSet.of(), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1)), false), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(2), (Object)TestArbitraryDistributionSplitAssigner.createSplit(3)), false), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(4)), false), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(5)), true), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(6)), true)), 1, true);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1, (Object)PARTITIONED_2), (Set<PlanNodeId>)ImmutableSet.of(), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1)), true), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(2), (Object)TestArbitraryDistributionSplitAssigner.createSplit(3)), false), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(4)), false), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(5)), false), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(6)), true)), 2, false);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1, (Object)PARTITIONED_2), (Set<PlanNodeId>)ImmutableSet.of((Object)REPLICATED_1), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1)), true), (Object)new SplitBatch(REPLICATED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(2)), true), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(3)), true)), 1, true);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1, (Object)PARTITIONED_2), (Set<PlanNodeId>)ImmutableSet.of((Object)REPLICATED_1), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(REPLICATED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1)), false), (Object)new SplitBatch(REPLICATED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(2)), false), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(3)), true), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(4)), true), (Object)new SplitBatch(REPLICATED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(5)), true)), 1, false);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1, (Object)PARTITIONED_2), (Set<PlanNodeId>)ImmutableSet.of((Object)REPLICATED_1), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1)), true), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(2)), true), (Object)new SplitBatch(REPLICATED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(3)), true)), 2, false);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1, (Object)PARTITIONED_2), (Set<PlanNodeId>)ImmutableSet.of((Object)REPLICATED_1, (Object)REPLICATED_2), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1)), true), (Object)new SplitBatch(REPLICATED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(2)), true), (Object)new SplitBatch(REPLICATED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(3)), true), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(4)), true)), 1, true);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1, (Object)PARTITIONED_2), (Set<PlanNodeId>)ImmutableSet.of((Object)REPLICATED_1, (Object)REPLICATED_2), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1)), true), (Object)new SplitBatch(REPLICATED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(2)), true), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(3)), true), (Object)new SplitBatch(REPLICATED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(4)), true)), 1, true);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1, (Object)PARTITIONED_2), (Set<PlanNodeId>)ImmutableSet.of((Object)REPLICATED_1, (Object)REPLICATED_2), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1)), false), (Object)new SplitBatch(REPLICATED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(2), (Object)TestArbitraryDistributionSplitAssigner.createSplit(3), (Object)TestArbitraryDistributionSplitAssigner.createSplit(4), (Object)TestArbitraryDistributionSplitAssigner.createSplit(5)), false), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(6), (Object)TestArbitraryDistributionSplitAssigner.createSplit(7)), false), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(8), (Object)TestArbitraryDistributionSplitAssigner.createSplit(9)), false), (Object)new SplitBatch(REPLICATED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(10), (Object)TestArbitraryDistributionSplitAssigner.createSplit(11), (Object)TestArbitraryDistributionSplitAssigner.createSplit(12), (Object)TestArbitraryDistributionSplitAssigner.createSplit(13)), false), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(14), (Object)TestArbitraryDistributionSplitAssigner.createSplit(15)), false), (Object)new SplitBatch(REPLICATED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(16), (Object)TestArbitraryDistributionSplitAssigner.createSplit(17), (Object)TestArbitraryDistributionSplitAssigner.createSplit(18), (Object)TestArbitraryDistributionSplitAssigner.createSplit(19)), true), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(20)), false), (Object)new SplitBatch(REPLICATED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(21), (Object)TestArbitraryDistributionSplitAssigner.createSplit(22)), false), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(23)), true), (Object)new SplitBatch(REPLICATED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(24), (Object)TestArbitraryDistributionSplitAssigner.createSplit(25)), true), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(26), (Object)TestArbitraryDistributionSplitAssigner.createSplit(27)), true), (Object[])new SplitBatch[0]), 3, true);
    }

    @Test
    public void testWithHostRequirement() {
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1), (Set<PlanNodeId>)ImmutableSet.of(), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1, (List<HostAddress>)ImmutableList.of((Object)HOST_1))), true)), 1, true);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1), (Set<PlanNodeId>)ImmutableSet.of(), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1, (List<HostAddress>)ImmutableList.of((Object)HOST_1, (Object)HOST_2))), true)), 1, false);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1), (Set<PlanNodeId>)ImmutableSet.of(), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1, (List<HostAddress>)ImmutableList.of((Object)HOST_1, (Object)HOST_2)), (Object)TestArbitraryDistributionSplitAssigner.createSplit(2, (List<HostAddress>)ImmutableList.of((Object)HOST_2))), true)), 1, true);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1), (Set<PlanNodeId>)ImmutableSet.of(), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1, (List<HostAddress>)ImmutableList.of((Object)HOST_1, (Object)HOST_2))), false), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(2, (List<HostAddress>)ImmutableList.of((Object)HOST_1))), true)), 2, false);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1), (Set<PlanNodeId>)ImmutableSet.of(), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1, (List<HostAddress>)ImmutableList.of((Object)HOST_1, (Object)HOST_2)), (Object)TestArbitraryDistributionSplitAssigner.createSplit(2, (List<HostAddress>)ImmutableList.of((Object)HOST_1, (Object)HOST_2))), false), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(3, (List<HostAddress>)ImmutableList.of((Object)HOST_3)), (Object)TestArbitraryDistributionSplitAssigner.createSplit(4, (List<HostAddress>)ImmutableList.of((Object)HOST_1))), false), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(5)), true)), 2, true);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1, (Object)PARTITIONED_2), (Set<PlanNodeId>)ImmutableSet.of(), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1, (List<HostAddress>)ImmutableList.of((Object)HOST_3))), true), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(2, (List<HostAddress>)ImmutableList.of((Object)HOST_3))), true)), 1, false);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1, (Object)PARTITIONED_2), (Set<PlanNodeId>)ImmutableSet.of(), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1, (List<HostAddress>)ImmutableList.of((Object)HOST_3))), false), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(2, (List<HostAddress>)ImmutableList.of((Object)HOST_3)), (Object)TestArbitraryDistributionSplitAssigner.createSplit(3, (List<HostAddress>)ImmutableList.of((Object)HOST_2))), false), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(4, (List<HostAddress>)ImmutableList.of((Object)HOST_1))), false), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(5)), true), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(6, (List<HostAddress>)ImmutableList.of((Object)HOST_3))), true)), 1, true);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1, (Object)PARTITIONED_2), (Set<PlanNodeId>)ImmutableSet.of(), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1, (List<HostAddress>)ImmutableList.of((Object)HOST_1, (Object)HOST_2))), true), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(2), (Object)TestArbitraryDistributionSplitAssigner.createSplit(3, (List<HostAddress>)ImmutableList.of((Object)HOST_3))), false), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(4, (List<HostAddress>)ImmutableList.of((Object)HOST_1, (Object)HOST_2))), false), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(5, (List<HostAddress>)ImmutableList.of((Object)HOST_3))), false), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(6, (List<HostAddress>)ImmutableList.of((Object)HOST_1, (Object)HOST_2))), true)), 2, false);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1, (Object)PARTITIONED_2), (Set<PlanNodeId>)ImmutableSet.of((Object)REPLICATED_1), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1, (List<HostAddress>)ImmutableList.of((Object)HOST_3))), true), (Object)new SplitBatch(REPLICATED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(2)), true), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(3, (List<HostAddress>)ImmutableList.of((Object)HOST_2))), true)), 1, true);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1, (Object)PARTITIONED_2), (Set<PlanNodeId>)ImmutableSet.of((Object)REPLICATED_1), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(REPLICATED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1)), false), (Object)new SplitBatch(REPLICATED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(2)), false), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(3, (List<HostAddress>)ImmutableList.of((Object)HOST_3))), true), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(4, (List<HostAddress>)ImmutableList.of((Object)HOST_3))), true), (Object)new SplitBatch(REPLICATED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(5)), true)), 1, false);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1, (Object)PARTITIONED_2), (Set<PlanNodeId>)ImmutableSet.of((Object)REPLICATED_1), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1, (List<HostAddress>)ImmutableList.of((Object)HOST_1))), true), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(2, (List<HostAddress>)ImmutableList.of((Object)HOST_2))), true), (Object)new SplitBatch(REPLICATED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(3)), true)), 2, true);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1, (Object)PARTITIONED_2), (Set<PlanNodeId>)ImmutableSet.of((Object)REPLICATED_1, (Object)REPLICATED_2), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1, (List<HostAddress>)ImmutableList.of((Object)HOST_1))), true), (Object)new SplitBatch(REPLICATED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(2)), true), (Object)new SplitBatch(REPLICATED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(3)), true), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(4, (List<HostAddress>)ImmutableList.of((Object)HOST_1))), true)), 1, false);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1, (Object)PARTITIONED_2), (Set<PlanNodeId>)ImmutableSet.of((Object)REPLICATED_1, (Object)REPLICATED_2), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1, (List<HostAddress>)ImmutableList.of((Object)HOST_2))), true), (Object)new SplitBatch(REPLICATED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(2)), true), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(3, (List<HostAddress>)ImmutableList.of((Object)HOST_2))), true), (Object)new SplitBatch(REPLICATED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(4)), true)), 1, true);
        TestArbitraryDistributionSplitAssigner.testAssigner((Set<PlanNodeId>)ImmutableSet.of((Object)PARTITIONED_1, (Object)PARTITIONED_2), (Set<PlanNodeId>)ImmutableSet.of((Object)REPLICATED_1, (Object)REPLICATED_2), (List<SplitBatch>)ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1, (List<HostAddress>)ImmutableList.of((Object)HOST_2))), false), (Object)new SplitBatch(REPLICATED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(2), (Object)TestArbitraryDistributionSplitAssigner.createSplit(3), (Object)TestArbitraryDistributionSplitAssigner.createSplit(4), (Object)TestArbitraryDistributionSplitAssigner.createSplit(5)), false), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(6, (List<HostAddress>)ImmutableList.of((Object)HOST_2, (Object)HOST_3)), (Object)TestArbitraryDistributionSplitAssigner.createSplit(7)), false), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(8), (Object)TestArbitraryDistributionSplitAssigner.createSplit(9, (List<HostAddress>)ImmutableList.of((Object)HOST_2, (Object)HOST_3))), false), (Object)new SplitBatch(REPLICATED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(10), (Object)TestArbitraryDistributionSplitAssigner.createSplit(11), (Object)TestArbitraryDistributionSplitAssigner.createSplit(12), (Object)TestArbitraryDistributionSplitAssigner.createSplit(13)), false), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(14), (Object)TestArbitraryDistributionSplitAssigner.createSplit(15, (List<HostAddress>)ImmutableList.of((Object)HOST_1, (Object)HOST_3))), false), (Object)new SplitBatch(REPLICATED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(16), (Object)TestArbitraryDistributionSplitAssigner.createSplit(17), (Object)TestArbitraryDistributionSplitAssigner.createSplit(18), (Object)TestArbitraryDistributionSplitAssigner.createSplit(19)), true), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(20, (List<HostAddress>)ImmutableList.of((Object)HOST_1, (Object)HOST_3))), false), (Object)new SplitBatch(REPLICATED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(21), (Object)TestArbitraryDistributionSplitAssigner.createSplit(22)), false), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(23, (List<HostAddress>)ImmutableList.of((Object)HOST_2, (Object)HOST_3))), true), (Object)new SplitBatch(REPLICATED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(24), (Object)TestArbitraryDistributionSplitAssigner.createSplit(25)), true), (Object)new SplitBatch(PARTITIONED_2, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(26), (Object)TestArbitraryDistributionSplitAssigner.createSplit(27, (List<HostAddress>)ImmutableList.of((Object)HOST_1, (Object)HOST_3))), true), (Object[])new SplitBatch[0]), 3, false);
    }

    @Test
    public void fuzzTestingNoHostRequirement() {
        for (int i = 0; i < 100; ++i) {
            this.fuzzTesting(false);
        }
    }

    @Test
    public void fuzzTestingWithHostRequirement() {
        for (int i = 0; i < 100; ++i) {
            this.fuzzTesting(true);
        }
    }

    @Test
    public void testAdaptiveTaskSizing() {
        ImmutableSet partitionedSources = ImmutableSet.of((Object)PARTITIONED_1);
        ImmutableList batches = ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1), (Object)TestArbitraryDistributionSplitAssigner.createSplit(2), (Object)TestArbitraryDistributionSplitAssigner.createSplit(3)), false), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(4), (Object)TestArbitraryDistributionSplitAssigner.createSplit(5), (Object)TestArbitraryDistributionSplitAssigner.createSplit(6)), false), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(7), (Object)TestArbitraryDistributionSplitAssigner.createSplit(8), (Object)TestArbitraryDistributionSplitAssigner.createSplit(9)), true));
        ArbitraryDistributionSplitAssigner splitAssigner = new ArbitraryDistributionSplitAssigner(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), (Set)partitionedSources, (Set)ImmutableSet.of(), 1, 1.2, 1L, 4L, 1L, 5);
        SplitAssignerTester tester = new SplitAssignerTester();
        for (SplitBatch batch : batches) {
            PlanNodeId planNodeId = batch.getPlanNodeId();
            List<Split> splits = batch.getSplits();
            boolean noMoreSplits = batch.isNoMoreSplits();
            tester.update(splitAssigner.assign(planNodeId, TestArbitraryDistributionSplitAssigner.createSplitsMultimap(splits), noMoreSplits));
            tester.checkContainsSplits(planNodeId, splits, false);
        }
        tester.update(splitAssigner.finish());
        List<TaskDescriptor> taskDescriptors = tester.getTaskDescriptors().orElseThrow();
        Assertions.assertThat(taskDescriptors).hasSize(4);
        TaskDescriptor taskDescriptor0 = taskDescriptors.get(0);
        TestArbitraryDistributionSplitAssigner.assertTaskDescriptor(taskDescriptor0, taskDescriptor0.getPartitionId(), (ListMultimap<PlanNodeId, Split>)ImmutableListMultimap.builder().put((Object)PARTITIONED_1, (Object)TestArbitraryDistributionSplitAssigner.createSplit(1)).build());
        TaskDescriptor taskDescriptor1 = taskDescriptors.get(1);
        TestArbitraryDistributionSplitAssigner.assertTaskDescriptor(taskDescriptor1, taskDescriptor1.getPartitionId(), (ListMultimap<PlanNodeId, Split>)ImmutableListMultimap.builder().put((Object)PARTITIONED_1, (Object)TestArbitraryDistributionSplitAssigner.createSplit(2)).put((Object)PARTITIONED_1, (Object)TestArbitraryDistributionSplitAssigner.createSplit(3)).build());
        TaskDescriptor taskDescriptor2 = taskDescriptors.get(2);
        TestArbitraryDistributionSplitAssigner.assertTaskDescriptor(taskDescriptor2, taskDescriptor2.getPartitionId(), (ListMultimap<PlanNodeId, Split>)ImmutableListMultimap.builder().put((Object)PARTITIONED_1, (Object)TestArbitraryDistributionSplitAssigner.createSplit(4)).put((Object)PARTITIONED_1, (Object)TestArbitraryDistributionSplitAssigner.createSplit(5)).put((Object)PARTITIONED_1, (Object)TestArbitraryDistributionSplitAssigner.createSplit(6)).build());
        TaskDescriptor taskDescriptor3 = taskDescriptors.get(3);
        TestArbitraryDistributionSplitAssigner.assertTaskDescriptor(taskDescriptor3, taskDescriptor3.getPartitionId(), (ListMultimap<PlanNodeId, Split>)ImmutableListMultimap.builder().put((Object)PARTITIONED_1, (Object)TestArbitraryDistributionSplitAssigner.createSplit(7)).put((Object)PARTITIONED_1, (Object)TestArbitraryDistributionSplitAssigner.createSplit(8)).put((Object)PARTITIONED_1, (Object)TestArbitraryDistributionSplitAssigner.createSplit(9)).build());
    }

    @Test
    public void testAdaptiveTaskSizingRounding() {
        ImmutableSet partitionedSources = ImmutableSet.of((Object)PARTITIONED_1);
        ImmutableList batches = ImmutableList.of((Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(1), (Object)TestArbitraryDistributionSplitAssigner.createSplit(2), (Object)TestArbitraryDistributionSplitAssigner.createSplit(3)), false), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(4), (Object)TestArbitraryDistributionSplitAssigner.createSplit(5), (Object)TestArbitraryDistributionSplitAssigner.createSplit(6)), false), (Object)new SplitBatch(PARTITIONED_1, (List<Split>)ImmutableList.of((Object)TestArbitraryDistributionSplitAssigner.createSplit(7), (Object)TestArbitraryDistributionSplitAssigner.createSplit(8), (Object)TestArbitraryDistributionSplitAssigner.createSplit(9)), true));
        ArbitraryDistributionSplitAssigner splitAssigner = new ArbitraryDistributionSplitAssigner(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), (Set)partitionedSources, (Set)ImmutableSet.of(), 1, 1.3, 100L, 400L, 100L, 5);
        SplitAssignerTester tester = new SplitAssignerTester();
        for (SplitBatch batch : batches) {
            PlanNodeId planNodeId = batch.getPlanNodeId();
            List<Split> splits = batch.getSplits();
            boolean noMoreSplits = batch.isNoMoreSplits();
            tester.update(splitAssigner.assign(planNodeId, TestArbitraryDistributionSplitAssigner.createSplitsMultimap(splits), noMoreSplits));
            tester.checkContainsSplits(planNodeId, splits, false);
        }
        tester.update(splitAssigner.finish());
        List<TaskDescriptor> taskDescriptors = tester.getTaskDescriptors().orElseThrow();
        Assertions.assertThat(taskDescriptors).hasSize(5);
        TaskDescriptor taskDescriptor0 = taskDescriptors.get(0);
        TestArbitraryDistributionSplitAssigner.assertTaskDescriptor(taskDescriptor0, taskDescriptor0.getPartitionId(), (ListMultimap<PlanNodeId, Split>)ImmutableListMultimap.builder().put((Object)PARTITIONED_1, (Object)TestArbitraryDistributionSplitAssigner.createSplit(1)).build());
        TaskDescriptor taskDescriptor1 = taskDescriptors.get(1);
        TestArbitraryDistributionSplitAssigner.assertTaskDescriptor(taskDescriptor1, taskDescriptor1.getPartitionId(), (ListMultimap<PlanNodeId, Split>)ImmutableListMultimap.builder().put((Object)PARTITIONED_1, (Object)TestArbitraryDistributionSplitAssigner.createSplit(2)).build());
        TaskDescriptor taskDescriptor2 = taskDescriptors.get(2);
        TestArbitraryDistributionSplitAssigner.assertTaskDescriptor(taskDescriptor2, taskDescriptor2.getPartitionId(), (ListMultimap<PlanNodeId, Split>)ImmutableListMultimap.builder().put((Object)PARTITIONED_1, (Object)TestArbitraryDistributionSplitAssigner.createSplit(3)).put((Object)PARTITIONED_1, (Object)TestArbitraryDistributionSplitAssigner.createSplit(4)).build());
        TaskDescriptor taskDescriptor3 = taskDescriptors.get(3);
        TestArbitraryDistributionSplitAssigner.assertTaskDescriptor(taskDescriptor3, taskDescriptor3.getPartitionId(), (ListMultimap<PlanNodeId, Split>)ImmutableListMultimap.builder().put((Object)PARTITIONED_1, (Object)TestArbitraryDistributionSplitAssigner.createSplit(5)).put((Object)PARTITIONED_1, (Object)TestArbitraryDistributionSplitAssigner.createSplit(6)).build());
        TaskDescriptor taskDescriptor4 = taskDescriptors.get(4);
        TestArbitraryDistributionSplitAssigner.assertTaskDescriptor(taskDescriptor4, taskDescriptor4.getPartitionId(), (ListMultimap<PlanNodeId, Split>)ImmutableListMultimap.builder().put((Object)PARTITIONED_1, (Object)TestArbitraryDistributionSplitAssigner.createSplit(7)).put((Object)PARTITIONED_1, (Object)TestArbitraryDistributionSplitAssigner.createSplit(8)).put((Object)PARTITIONED_1, (Object)TestArbitraryDistributionSplitAssigner.createSplit(9)).build());
    }

    private void fuzzTesting(boolean withHostRequirements) {
        HashSet<PlanNodeId> partitionedSources = new HashSet<PlanNodeId>();
        HashSet<PlanNodeId> replicatedSources = new HashSet<PlanNodeId>();
        partitionedSources.add(PARTITIONED_1);
        if (ThreadLocalRandom.current().nextBoolean()) {
            partitionedSources.add(PARTITIONED_2);
        }
        if (ThreadLocalRandom.current().nextDouble() > 0.2) {
            replicatedSources.add(REPLICATED_1);
        }
        if (ThreadLocalRandom.current().nextDouble() > 0.5) {
            replicatedSources.add(REPLICATED_2);
        }
        ImmutableSet allSources = ImmutableSet.builder().addAll(partitionedSources).addAll(replicatedSources).build();
        ArrayList<SplitBatch> batches = new ArrayList<SplitBatch>();
        Map splitCount = allSources.stream().collect(Collectors.toMap(Function.identity(), planNodeId -> ThreadLocalRandom.current().nextInt(100)));
        AtomicInteger nextSplitId = new AtomicInteger();
        while (!splitCount.isEmpty()) {
            int batchSize;
            ImmutableList remainingSources = ImmutableList.copyOf(splitCount.keySet());
            PlanNodeId source = (PlanNodeId)remainingSources.get(ThreadLocalRandom.current().nextInt(remainingSources.size()));
            int remaining = splitCount.compute(source, (arg_0, arg_1) -> TestArbitraryDistributionSplitAssigner.lambda$fuzzTesting$1(batchSize = ThreadLocalRandom.current().nextInt(5), arg_0, arg_1));
            if (remaining <= 0) {
                splitCount.remove(source);
            }
            List splits = (List)IntStream.range(0, batchSize).mapToObj(value -> this.generateSplit(nextSplitId, replicatedSources.contains(source), withHostRequirements)).collect(ImmutableList.toImmutableList());
            batches.add(new SplitBatch(source, splits, remaining <= 0));
        }
        int splitsPerPartition = ThreadLocalRandom.current().nextInt(3);
        TestArbitraryDistributionSplitAssigner.testAssigner(partitionedSources, replicatedSources, batches, splitsPerPartition, ThreadLocalRandom.current().nextBoolean());
    }

    private Split generateSplit(AtomicInteger nextSplitId, boolean replicated, boolean withHostRequirements) {
        if (replicated || !withHostRequirements || ThreadLocalRandom.current().nextDouble() > 0.5) {
            return TestArbitraryDistributionSplitAssigner.createSplit(nextSplitId.getAndIncrement());
        }
        ArrayList<HostAddress> allHosts = new ArrayList<HostAddress>();
        allHosts.add(HOST_1);
        allHosts.add(HOST_2);
        allHosts.add(HOST_3);
        Collections.shuffle(allHosts);
        ImmutableList addresses = ImmutableList.copyOf(allHosts.subList(0, ThreadLocalRandom.current().nextInt(1, allHosts.size())));
        return TestArbitraryDistributionSplitAssigner.createSplit(nextSplitId.getAndIncrement(), (List<HostAddress>)addresses);
    }

    private static void testAssigner(Set<PlanNodeId> partitionedSources, Set<PlanNodeId> replicatedSources, List<SplitBatch> batches, int partitionedSplitsPerPartition, boolean verifyMaxTaskSplitCount) {
        ArbitraryDistributionSplitAssigner splitAssigner = TestArbitraryDistributionSplitAssigner.createSplitAssigner(partitionedSources, replicatedSources, partitionedSplitsPerPartition, verifyMaxTaskSplitCount);
        SplitAssignerTester tester = new SplitAssignerTester();
        ArrayListMultimap expectedReplicatedSplits = ArrayListMultimap.create();
        HashMap<Integer, Object> expectedPartitionedSplits = new HashMap<Integer, Object>();
        HashSet<PlanNodeId> finishedReplicatedSources = new HashSet<PlanNodeId>();
        HashMap<Optional, PartitionAssignment> currentSplitAssignments = new HashMap<Optional, PartitionAssignment>();
        AtomicInteger nextPartitionId = new AtomicInteger();
        for (SplitBatch batch : batches) {
            PlanNodeId planNodeId = batch.getPlanNodeId();
            List<Split> splits = batch.getSplits();
            boolean noMoreSplits = batch.isNoMoreSplits();
            boolean replicated = replicatedSources.contains(planNodeId);
            if (replicated) {
                expectedReplicatedSplits.putAll((Object)planNodeId, splits);
                if (noMoreSplits) {
                    finishedReplicatedSources.add(planNodeId);
                }
            } else {
                for (Split split : splits) {
                    PartitionAssignment currentAssignment;
                    Optional<Object> hostRequirement = Optional.empty();
                    if (!split.isRemotelyAccessible()) {
                        int splitCount = Integer.MAX_VALUE;
                        for (HostAddress hostAddress : split.getConnectorSplit().getAddresses()) {
                            PartitionAssignment currentAssignment2 = (PartitionAssignment)currentSplitAssignments.get(Optional.of(hostAddress));
                            if (currentAssignment2 == null) {
                                hostRequirement = Optional.of(hostAddress);
                                break;
                            }
                            if (currentAssignment2.getSplits().size() >= splitCount) continue;
                            splitCount = currentAssignment2.getSplits().size();
                            hostRequirement = Optional.of(hostAddress);
                        }
                    }
                    if ((currentAssignment = (PartitionAssignment)currentSplitAssignments.get(hostRequirement)) != null && currentAssignment.getSplits().size() + 1 > partitionedSplitsPerPartition) {
                        expectedPartitionedSplits.computeIfAbsent(currentAssignment.getPartitionId(), key -> ArrayListMultimap.create()).putAll(currentAssignment.getSplits());
                        currentSplitAssignments.remove(hostRequirement);
                    }
                    currentSplitAssignments.computeIfAbsent(hostRequirement, key -> new PartitionAssignment(nextPartitionId.getAndIncrement())).getSplits().put((Object)planNodeId, (Object)split);
                }
            }
            tester.update(splitAssigner.assign(planNodeId, TestArbitraryDistributionSplitAssigner.createSplitsMultimap(splits), noMoreSplits));
            tester.checkContainsSplits(planNodeId, splits, replicated);
            if (!finishedReplicatedSources.containsAll(replicatedSources)) continue;
            Set openAssignments = (Set)currentSplitAssignments.values().stream().map(PartitionAssignment::getPartitionId).collect(ImmutableSet.toImmutableSet());
            for (int partitionId = 0; partitionId < nextPartitionId.get(); ++partitionId) {
                if (openAssignments.contains(partitionId)) continue;
                Assertions.assertThat((boolean)tester.isSealed(partitionId)).isTrue();
            }
        }
        tester.update(splitAssigner.finish());
        for (PartitionAssignment assignment : currentSplitAssignments.values()) {
            expectedPartitionedSplits.computeIfAbsent(assignment.getPartitionId(), key -> ArrayListMultimap.create()).putAll(assignment.getSplits());
        }
        List<TaskDescriptor> taskDescriptors = tester.getTaskDescriptors().orElseThrow();
        int expectedPartitionCount = nextPartitionId.get();
        if (expectedPartitionCount == 0) {
            Assertions.assertThat(taskDescriptors).hasSize(1);
            TaskDescriptor taskDescriptor = taskDescriptors.get(0);
            TestArbitraryDistributionSplitAssigner.assertTaskDescriptor(taskDescriptor, taskDescriptor.getPartitionId(), (ListMultimap<PlanNodeId, Split>)ImmutableListMultimap.copyOf((Multimap)expectedReplicatedSplits));
        } else {
            Assertions.assertThat(taskDescriptors).hasSize(expectedPartitionCount);
            for (TaskDescriptor taskDescriptor : taskDescriptors) {
                TestArbitraryDistributionSplitAssigner.assertTaskDescriptor(taskDescriptor, taskDescriptor.getPartitionId(), (ListMultimap<PlanNodeId, Split>)ImmutableListMultimap.builder().putAll((Multimap)expectedReplicatedSplits).putAll((Multimap)expectedPartitionedSplits.getOrDefault(taskDescriptor.getPartitionId(), ImmutableListMultimap.of())).build());
            }
        }
    }

    private static Split createSplit(int id) {
        return new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestingConnectorSplit(id, OptionalInt.empty(), Optional.empty()));
    }

    private static Split createSplit(int id, List<HostAddress> addresses) {
        return new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestingConnectorSplit(id, OptionalInt.empty(), Optional.of(addresses)));
    }

    private static ListMultimap<Integer, Split> createSplitsMultimap(List<Split> splits) {
        int nextPartitionId = 0;
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        for (Split split : splits) {
            result.put((Object)nextPartitionId++, (Object)split);
        }
        return result.build();
    }

    private static void assertTaskDescriptor(TaskDescriptor taskDescriptor, int expectedPartitionId, ListMultimap<PlanNodeId, Split> expectedSplits) {
        Assertions.assertThat((int)taskDescriptor.getPartitionId()).isEqualTo(expectedPartitionId);
        taskDescriptor.getSplits().getPlanNodeIds().forEach(planNodeId -> Assertions.assertThat((Collection)taskDescriptor.getSplits().getSplits(planNodeId).keySet()).isEqualTo((Object)ImmutableSet.of((Object)0)));
        TestArbitraryDistributionSplitAssigner.assertSplitsEqual((ListMultimap<PlanNodeId, Split>)taskDescriptor.getSplits().getSplitsFlat(), expectedSplits);
        ImmutableSet hostRequirement = null;
        for (Split split : taskDescriptor.getSplits().getSplitsFlat().values()) {
            if (split.isRemotelyAccessible()) continue;
            if (hostRequirement == null) {
                hostRequirement = ImmutableSet.copyOf((Collection)split.getAddresses());
                continue;
            }
            hostRequirement = Sets.intersection((Set)hostRequirement, (Set)ImmutableSet.copyOf((Collection)split.getAddresses()));
        }
        Assertions.assertThat((Optional)taskDescriptor.getNodeRequirements().getCatalogHandle()).isEqualTo(Optional.of(TestingHandles.TEST_CATALOG_HANDLE));
        Assertions.assertThat((Collection)taskDescriptor.getNodeRequirements().getAddresses()).containsAnyElementsOf((Iterable)(hostRequirement == null ? ImmutableSet.of() : hostRequirement));
    }

    private static void assertSplitsEqual(ListMultimap<PlanNodeId, Split> actual, ListMultimap<PlanNodeId, Split> expected) {
        ImmutableSetMultimap actualSplitIds = ImmutableSetMultimap.copyOf((Multimap)Multimaps.transformValues(actual, TestingConnectorSplit::getSplitId));
        ImmutableSetMultimap expectedSplitIds = ImmutableSetMultimap.copyOf((Multimap)Multimaps.transformValues(expected, TestingConnectorSplit::getSplitId));
        Assertions.assertThat((Object)actualSplitIds).isEqualTo((Object)expectedSplitIds);
    }

    private static ArbitraryDistributionSplitAssigner createSplitAssigner(Set<PlanNodeId> partitionedSources, Set<PlanNodeId> replicatedSources, int partitionedSplitsPerPartition, boolean verifyMaxTaskSplitCount) {
        long targetPartitionSizeInBytes = Long.MAX_VALUE;
        int maxTaskSplitCount = Integer.MAX_VALUE;
        if (verifyMaxTaskSplitCount) {
            maxTaskSplitCount = partitionedSplitsPerPartition;
        } else {
            targetPartitionSizeInBytes = 1L * (long)partitionedSplitsPerPartition;
        }
        return new ArbitraryDistributionSplitAssigner(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), partitionedSources, replicatedSources, Integer.MAX_VALUE, 1.0, targetPartitionSizeInBytes, targetPartitionSizeInBytes, 1L, maxTaskSplitCount);
    }

    private static /* synthetic */ Integer lambda$fuzzTesting$1(int batchSize, PlanNodeId key, Integer value) {
        return value - batchSize;
    }

    private static class SplitBatch {
        private final PlanNodeId planNodeId;
        private final List<Split> splits;
        private final boolean noMoreSplits;

        public SplitBatch(PlanNodeId planNodeId, List<Split> splits, boolean noMoreSplits) {
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.splits = ImmutableList.copyOf((Collection)Objects.requireNonNull(splits, "splits is null"));
            this.noMoreSplits = noMoreSplits;
        }

        public PlanNodeId getPlanNodeId() {
            return this.planNodeId;
        }

        public List<Split> getSplits() {
            return this.splits;
        }

        public boolean isNoMoreSplits() {
            return this.noMoreSplits;
        }
    }

    private static class PartitionAssignment {
        private final int partitionId;
        private final ListMultimap<PlanNodeId, Split> splits = ArrayListMultimap.create();

        private PartitionAssignment(int partitionId) {
            this.partitionId = partitionId;
        }

        public int getPartitionId() {
            return this.partitionId;
        }

        public ListMultimap<PlanNodeId, Split> getSplits() {
            return this.splits;
        }
    }
}

