/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.concurrent.MoreFutures;
import io.airlift.testing.TestingTicker;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.client.NodeVersion;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.execution.scheduler.faulttolerant.BinPackingNodeAllocatorService;
import io.trino.execution.scheduler.faulttolerant.NodeAllocator;
import io.trino.execution.scheduler.faulttolerant.NodeRequirements;
import io.trino.execution.scheduler.faulttolerant.TaskExecutionClass;
import io.trino.memory.MemoryInfo;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.memory.MemoryPoolInfo;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.Assert;
import java.net.URI;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
public class TestBinPackingNodeAllocator {
    private static final Session SESSION = TestingSession.testSessionBuilder().build();
    private static final HostAddress NODE_1_ADDRESS = HostAddress.fromParts((String)"127.0.0.1", (int)8080);
    private static final HostAddress NODE_2_ADDRESS = HostAddress.fromParts((String)"127.0.0.1", (int)8081);
    private static final HostAddress NODE_3_ADDRESS = HostAddress.fromParts((String)"127.0.0.1", (int)8082);
    private static final HostAddress NODE_4_ADDRESS = HostAddress.fromParts((String)"127.0.0.1", (int)8083);
    private static final InternalNode NODE_1 = new InternalNode("node-1", URI.create("local://" + String.valueOf(NODE_1_ADDRESS)), NodeVersion.UNKNOWN, false);
    private static final InternalNode NODE_2 = new InternalNode("node-2", URI.create("local://" + String.valueOf(NODE_2_ADDRESS)), NodeVersion.UNKNOWN, false);
    private static final InternalNode NODE_3 = new InternalNode("node-3", URI.create("local://" + String.valueOf(NODE_3_ADDRESS)), NodeVersion.UNKNOWN, false);
    private static final InternalNode NODE_4 = new InternalNode("node-4", URI.create("local://" + String.valueOf(NODE_4_ADDRESS)), NodeVersion.UNKNOWN, false);
    private static final CatalogHandle CATALOG_1 = TestingHandles.createTestCatalogHandle((String)"catalog1");
    private static final NodeRequirements REQ_NONE = new NodeRequirements(Optional.empty(), Set.of());
    private static final NodeRequirements REQ_NODE_1 = new NodeRequirements(Optional.empty(), Set.of(NODE_1_ADDRESS));
    private static final NodeRequirements REQ_NODE_2 = new NodeRequirements(Optional.empty(), Set.of(NODE_2_ADDRESS));
    private static final NodeRequirements REQ_CATALOG_1 = new NodeRequirements(Optional.of(CATALOG_1), Set.of());
    private static final long TEST_TIMEOUT = 2500L;
    private BinPackingNodeAllocatorService nodeAllocatorService;
    private ConcurrentHashMap<String, Optional<MemoryInfo>> workerMemoryInfos;
    private final TestingTicker ticker = new TestingTicker();

    private void setupNodeAllocatorService(InMemoryNodeManager nodeManager) {
        this.setupNodeAllocatorService(nodeManager, DataSize.ofBytes((long)0L));
    }

    private void setupNodeAllocatorService(InMemoryNodeManager nodeManager, DataSize taskRuntimeMemoryEstimationOverhead) {
        this.shutdownNodeAllocatorService();
        this.workerMemoryInfos = new ConcurrentHashMap();
        MemoryInfo memoryInfo = this.buildWorkerMemoryInfo(DataSize.ofBytes((long)0L), (Map<TaskId, DataSize>)ImmutableMap.of());
        this.workerMemoryInfos.put(NODE_1.getNodeIdentifier(), Optional.of(memoryInfo));
        this.workerMemoryInfos.put(NODE_2.getNodeIdentifier(), Optional.of(memoryInfo));
        this.workerMemoryInfos.put(NODE_3.getNodeIdentifier(), Optional.of(memoryInfo));
        this.workerMemoryInfos.put(NODE_4.getNodeIdentifier(), Optional.of(memoryInfo));
        this.nodeAllocatorService = new BinPackingNodeAllocatorService((InternalNodeManager)nodeManager, () -> this.workerMemoryInfos, false, java.time.Duration.of(1L, ChronoUnit.MINUTES), taskRuntimeMemoryEstimationOverhead, DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.GIGABYTE), (Ticker)this.ticker);
        this.nodeAllocatorService.start();
    }

    private void updateWorkerUsedMemory(InternalNode node, DataSize usedMemory, Map<TaskId, DataSize> taskMemoryUsage) {
        this.workerMemoryInfos.put(node.getNodeIdentifier(), Optional.of(this.buildWorkerMemoryInfo(usedMemory, taskMemoryUsage)));
    }

    private MemoryInfo buildWorkerMemoryInfo(DataSize usedMemory, Map<TaskId, DataSize> taskMemoryUsage) {
        return new MemoryInfo(4, new MemoryPoolInfo(DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.GIGABYTE).toBytes(), usedMemory.toBytes(), 0L, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)taskMemoryUsage.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((TaskId)entry.getKey()).toString(), entry -> ((DataSize)entry.getValue()).toBytes())), (Map)ImmutableMap.of()));
    }

    @AfterEach
    public void shutdownNodeAllocatorService() {
        if (this.nodeAllocatorService != null) {
            this.nodeAllocatorService.stop();
        }
        this.nodeAllocatorService = null;
    }

    @Test
    @Timeout(value=2500L, unit=TimeUnit.MILLISECONDS)
    public void testAllocateSimple() throws Exception {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[]{NODE_1, NODE_2});
        this.setupNodeAllocatorService(nodeManager);
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION);){
            NodeAllocator.NodeLease acquire1 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire1, NODE_1);
            NodeAllocator.NodeLease acquire2 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire2, NODE_2);
            NodeAllocator.NodeLease acquire3 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire3, NODE_1);
            NodeAllocator.NodeLease acquire4 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire4, NODE_2);
            NodeAllocator.NodeLease acquire5 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquire5);
            acquire2.release();
            TestBinPackingNodeAllocator.assertEventually(() -> {
                this.assertAcquired(acquire5);
                Assertions.assertThat((Object)((InternalNode)acquire5.getNode().get())).isEqualTo((Object)NODE_2);
            });
            NodeAllocator.NodeLease acquire6 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquire6);
            nodeManager.addNodes(new InternalNode[]{NODE_3});
            this.nodeAllocatorService.processPendingAcquires();
            TestBinPackingNodeAllocator.assertEventually(() -> {
                this.assertAcquired(acquire6);
                Assertions.assertThat((Object)((InternalNode)acquire6.getNode().get())).isEqualTo((Object)NODE_3);
            });
        }
    }

    @Test
    @Timeout(value=2500L, unit=TimeUnit.MILLISECONDS)
    public void testAllocateDifferentSizes() throws Exception {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[]{NODE_1, NODE_2});
        this.setupNodeAllocatorService(nodeManager);
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION);){
            NodeAllocator.NodeLease acquire1 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire1, NODE_1);
            NodeAllocator.NodeLease acquire2 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire2, NODE_2);
            NodeAllocator.NodeLease acquire3 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire3, NODE_1);
            NodeAllocator.NodeLease acquire4 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire4, NODE_2);
            NodeAllocator.NodeLease acquire5 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire5, NODE_1);
            NodeAllocator.NodeLease acquire6 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire6, NODE_2);
            NodeAllocator.NodeLease acquire7 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquire7);
            NodeAllocator.NodeLease acquire8 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquire8);
            acquire3.release();
            this.assertNotAcquired(acquire7);
            this.assertNotAcquired(acquire8);
            acquire4.release();
            this.assertAcquired(acquire8);
            acquire5.release();
            this.assertAcquired(acquire7);
        }
    }

    @Test
    @Timeout(value=2500L, unit=TimeUnit.MILLISECONDS)
    public void testAllocateDifferentSizesOpportunisticAcquisition() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[]{NODE_1, NODE_2});
        this.setupNodeAllocatorService(nodeManager);
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION);){
            NodeAllocator.NodeLease acquire1 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire1, NODE_1);
            NodeAllocator.NodeLease acquire2 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire2, NODE_2);
            NodeAllocator.NodeLease acquire3 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire3, NODE_1);
            NodeAllocator.NodeLease acquire4 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire4, NODE_2);
            NodeAllocator.NodeLease acquire5 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire5, NODE_1);
            NodeAllocator.NodeLease acquire6 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire6, NODE_2);
            NodeAllocator.NodeLease acquire7 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquire7);
            NodeAllocator.NodeLease acquire8 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquire8);
            acquire2.release();
            this.assertAcquired(acquire7);
            acquire1.release();
            this.assertAcquired(acquire8);
        }
    }

    @Test
    @Timeout(value=2500L, unit=TimeUnit.MILLISECONDS)
    public void testAllocateReleaseBeforeAcquired() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[]{NODE_1});
        this.setupNodeAllocatorService(nodeManager);
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION);){
            NodeAllocator.NodeLease acquire1 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire1, NODE_1);
            NodeAllocator.NodeLease acquire2 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire2, NODE_1);
            NodeAllocator.NodeLease acquire3 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquire3);
            NodeAllocator.NodeLease acquire4 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquire4);
            acquire3.release();
            this.assertNotAcquired(acquire4);
            acquire2.release();
            TestBinPackingNodeAllocator.assertEventually(() -> this.assertAcquired(acquire4, NODE_1));
        }
    }

    @Test
    @Timeout(value=2500L, unit=TimeUnit.MILLISECONDS)
    public void testNoMatchingNodeAvailable() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[0]);
        this.setupNodeAllocatorService(nodeManager);
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION);){
            NodeAllocator.NodeLease acquireNoMatching = nodeAllocator.acquire(REQ_CATALOG_1, DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquireNoMatching);
            this.ticker.increment(59L, TimeUnit.SECONDS);
            this.nodeAllocatorService.processPendingAcquires();
            this.assertNotAcquired(acquireNoMatching);
            this.ticker.increment(2L, TimeUnit.SECONDS);
            this.nodeAllocatorService.processPendingAcquires();
            Assertions.assertThatThrownBy(() -> Futures.getUnchecked((Future)acquireNoMatching.getNode())).hasMessageContaining("No nodes available to run query");
            nodeManager.addNodes(new InternalNode[]{NODE_2});
            NodeAllocator.NodeLease acquire1 = nodeAllocator.acquire(REQ_CATALOG_1, DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire1, NODE_2);
            NodeAllocator.NodeLease acquire2 = nodeAllocator.acquire(REQ_CATALOG_1, DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquire2);
            nodeManager.removeNode(NODE_2);
            this.nodeAllocatorService.processPendingAcquires();
            this.ticker.increment(61L, TimeUnit.SECONDS);
            this.nodeAllocatorService.processPendingAcquires();
            TestBinPackingNodeAllocator.assertEventually(() -> {
                Assertions.assertThat((boolean)acquire2.getNode().isCancelled()).isFalse();
                Assertions.assertThat((boolean)acquire2.getNode().isDone()).isTrue();
                Assertions.assertThatThrownBy(() -> MoreFutures.getFutureValue((Future)acquire2.getNode())).hasMessage("No nodes available to run query");
            });
        }
    }

    @Test
    @Timeout(value=2500L, unit=TimeUnit.MILLISECONDS)
    public void testNoMatchingNodeAvailableTimeoutReset() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[0]);
        this.setupNodeAllocatorService(nodeManager);
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION);){
            NodeAllocator.NodeLease acquireNoMatching1 = nodeAllocator.acquire(REQ_CATALOG_1, DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            NodeAllocator.NodeLease acquireNoMatching2 = nodeAllocator.acquire(REQ_CATALOG_1, DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquireNoMatching1);
            this.assertNotAcquired(acquireNoMatching2);
            this.ticker.increment(30L, TimeUnit.SECONDS);
            nodeManager.addNodes(new InternalNode[]{NODE_2});
            this.nodeAllocatorService.processPendingAcquires();
            ((AbstractBooleanAssert)Assertions.assertThat((acquireNoMatching1.getNode().isDone() != acquireNoMatching2.getNode().isDone() ? 1 : 0) != 0).describedAs("exactly one of pending acquires should be completed", new Object[0])).isTrue();
            NodeAllocator.NodeLease theAcquireLease = acquireNoMatching1.getNode().isDone() ? acquireNoMatching1 : acquireNoMatching2;
            NodeAllocator.NodeLease theNotAcquireLease = acquireNoMatching1.getNode().isDone() ? acquireNoMatching2 : acquireNoMatching1;
            nodeManager.removeNode(NODE_2);
            Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
            theAcquireLease.release();
            this.nodeAllocatorService.processPendingAcquires();
            this.assertNotAcquired(theNotAcquireLease);
            this.ticker.increment(59L, TimeUnit.SECONDS);
            this.nodeAllocatorService.processPendingAcquires();
            this.assertNotAcquired(theNotAcquireLease);
            this.ticker.increment(2L, TimeUnit.SECONDS);
            this.nodeAllocatorService.processPendingAcquires();
            Assertions.assertThatThrownBy(() -> Futures.getUnchecked((Future)theNotAcquireLease.getNode())).hasMessageContaining("No nodes available to run query");
        }
    }

    @Test
    @Timeout(value=2500L, unit=TimeUnit.MILLISECONDS)
    public void testRemoveAcquiredNode() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[]{NODE_1});
        this.setupNodeAllocatorService(nodeManager);
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION);){
            NodeAllocator.NodeLease acquire1 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire1, NODE_1);
            nodeManager.removeNode(NODE_1);
            acquire1.release();
        }
    }

    @Test
    @Timeout(value=2500L, unit=TimeUnit.MILLISECONDS)
    public void testAllocateNodeWithAddressRequirements() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[]{NODE_1, NODE_2});
        this.setupNodeAllocatorService(nodeManager);
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION);){
            NodeAllocator.NodeLease acquire1 = nodeAllocator.acquire(REQ_NODE_2, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire1, NODE_2);
            NodeAllocator.NodeLease acquire2 = nodeAllocator.acquire(REQ_NODE_2, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire2, NODE_2);
            NodeAllocator.NodeLease acquire3 = nodeAllocator.acquire(REQ_NODE_2, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquire3);
            NodeAllocator.NodeLease acquire4 = nodeAllocator.acquire(REQ_NODE_1, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire4, NODE_1);
            acquire1.release();
            TestBinPackingNodeAllocator.assertEventually(() -> this.assertAcquired(acquire3));
        }
    }

    @Test
    @Timeout(value=2500L, unit=TimeUnit.MILLISECONDS)
    public void testAllocateNotEnoughRuntimeMemory() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[]{NODE_1, NODE_2});
        this.setupNodeAllocatorService(nodeManager);
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION);){
            NodeAllocator.NodeLease acquire1 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire1, NODE_1);
            acquire1.attachTaskId(this.taskId(1));
            this.updateWorkerUsedMemory(NODE_1, DataSize.of((long)33L, (DataSize.Unit)DataSize.Unit.GIGABYTE), (Map<TaskId, DataSize>)ImmutableMap.of((Object)this.taskId(1), (Object)DataSize.of((long)33L, (DataSize.Unit)DataSize.Unit.GIGABYTE)));
            this.nodeAllocatorService.refreshNodePoolMemoryInfos();
            NodeAllocator.NodeLease acquire2 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire2, NODE_2);
            acquire2.attachTaskId(this.taskId(2));
            NodeAllocator.NodeLease acquire3 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire3, NODE_2);
            acquire3.attachTaskId(this.taskId(3));
            NodeAllocator.NodeLease acquire4 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire4, NODE_1);
            acquire4.attachTaskId(this.taskId(4));
            NodeAllocator.NodeLease acquire5 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquire5);
            NodeAllocator.NodeLease acquire6 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquire6);
            this.updateWorkerUsedMemory(NODE_1, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), (Map<TaskId, DataSize>)ImmutableMap.of((Object)this.taskId(1), (Object)DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE)));
            this.nodeAllocatorService.refreshNodePoolMemoryInfos();
            this.nodeAllocatorService.processPendingAcquires();
            this.assertAcquired(acquire5, NODE_1);
            acquire5.attachTaskId(this.taskId(5));
            this.assertNotAcquired(acquire6);
        }
    }

    @Test
    @Timeout(value=2500L, unit=TimeUnit.MILLISECONDS)
    public void testAllocateRuntimeMemoryDiscrepancies() {
        NodeAllocator.NodeLease acquire2;
        NodeAllocator.NodeLease acquire1;
        InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[]{NODE_1});
        this.setupNodeAllocatorService(nodeManager);
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION);){
            acquire1 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire1, NODE_1);
            acquire1.attachTaskId(this.taskId(1));
            this.updateWorkerUsedMemory(NODE_1, DataSize.of((long)33L, (DataSize.Unit)DataSize.Unit.GIGABYTE), (Map<TaskId, DataSize>)ImmutableMap.of((Object)this.taskId(1), (Object)DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE)));
            this.nodeAllocatorService.refreshNodePoolMemoryInfos();
            acquire2 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquire2);
        }
        this.setupNodeAllocatorService(nodeManager);
        nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION);
        try {
            acquire1 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire1, NODE_1);
            acquire1.attachTaskId(this.taskId(1));
            this.updateWorkerUsedMemory(NODE_1, DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE), (Map<TaskId, DataSize>)ImmutableMap.of((Object)this.taskId(1), (Object)DataSize.of((long)33L, (DataSize.Unit)DataSize.Unit.GIGABYTE)));
            this.nodeAllocatorService.refreshNodePoolMemoryInfos();
            acquire2 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquire2);
        }
        finally {
            if (nodeAllocator != null) {
                nodeAllocator.close();
            }
        }
        this.setupNodeAllocatorService(nodeManager);
        nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION);
        try {
            acquire1 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire1, NODE_1);
            acquire1.attachTaskId(this.taskId(1));
            this.updateWorkerUsedMemory(NODE_1, DataSize.of((long)33L, (DataSize.Unit)DataSize.Unit.GIGABYTE), (Map<TaskId, DataSize>)ImmutableMap.of());
            this.nodeAllocatorService.refreshNodePoolMemoryInfos();
            acquire2 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquire2);
        }
        finally {
            if (nodeAllocator != null) {
                nodeAllocator.close();
            }
        }
    }

    @Test
    @Timeout(value=2500L, unit=TimeUnit.MILLISECONDS)
    public void testSpaceReservedOnPrimaryNodeIfNoNodeWithEnoughRuntimeMemoryAvailable() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[]{NODE_1, NODE_2});
        this.setupNodeAllocatorService(nodeManager);
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION);){
            NodeAllocator.NodeLease acquire1 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire1, NODE_1);
            acquire1.attachTaskId(this.taskId(1));
            NodeAllocator.NodeLease acquire2 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire2, NODE_2);
            acquire2.attachTaskId(this.taskId(2));
            this.updateWorkerUsedMemory(NODE_1, DataSize.of((long)40L, (DataSize.Unit)DataSize.Unit.GIGABYTE), (Map<TaskId, DataSize>)ImmutableMap.of((Object)this.taskId(1), (Object)DataSize.of((long)40L, (DataSize.Unit)DataSize.Unit.GIGABYTE)));
            this.updateWorkerUsedMemory(NODE_2, DataSize.of((long)41L, (DataSize.Unit)DataSize.Unit.GIGABYTE), (Map<TaskId, DataSize>)ImmutableMap.of((Object)this.taskId(2), (Object)DataSize.of((long)41L, (DataSize.Unit)DataSize.Unit.GIGABYTE)));
            this.nodeAllocatorService.refreshNodePoolMemoryInfos();
            NodeAllocator.NodeLease acquire3 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquire3);
            NodeAllocator.NodeLease acquire4 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire4, NODE_1);
            acquire4.attachTaskId(this.taskId(2));
        }
    }

    @Test
    @Timeout(value=2500L, unit=TimeUnit.MILLISECONDS)
    public void testAllocateWithRuntimeMemoryEstimateOverhead() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[]{NODE_1});
        this.setupNodeAllocatorService(nodeManager, DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION);){
            NodeAllocator.NodeLease acquire1 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire1, NODE_1);
            acquire1.attachTaskId(this.taskId(1));
            this.updateWorkerUsedMemory(NODE_1, DataSize.of((long)30L, (DataSize.Unit)DataSize.Unit.GIGABYTE), (Map<TaskId, DataSize>)ImmutableMap.of((Object)this.taskId(1), (Object)DataSize.of((long)30L, (DataSize.Unit)DataSize.Unit.GIGABYTE)));
            this.nodeAllocatorService.refreshNodePoolMemoryInfos();
            NodeAllocator.NodeLease acquire2 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquire2);
            this.updateWorkerUsedMemory(NODE_1, DataSize.of((long)28L, (DataSize.Unit)DataSize.Unit.GIGABYTE), (Map<TaskId, DataSize>)ImmutableMap.of((Object)this.taskId(1), (Object)DataSize.of((long)28L, (DataSize.Unit)DataSize.Unit.GIGABYTE)));
            this.nodeAllocatorService.refreshNodePoolMemoryInfos();
            this.nodeAllocatorService.processPendingAcquires();
            this.assertAcquired(acquire2, NODE_1);
        }
    }

    @Test
    public void testStressAcquireRelease() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[]{NODE_1});
        this.setupNodeAllocatorService(nodeManager, DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION);){
            for (int i = 0; i < 10000000; ++i) {
                NodeAllocator.NodeLease lease = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
                lease.release();
            }
        }
    }

    @Test
    @Timeout(value=2500L, unit=TimeUnit.MILLISECONDS)
    public void testAllocateSpeculative() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[]{NODE_1, NODE_2});
        this.setupNodeAllocatorService(nodeManager);
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION);){
            NodeAllocator.NodeLease acquireSpeculative1 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.SPECULATIVE);
            this.assertAcquired(acquireSpeculative1, NODE_1);
            NodeAllocator.NodeLease acquireSpeculative2 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.SPECULATIVE);
            this.assertAcquired(acquireSpeculative2, NODE_2);
            NodeAllocator.NodeLease acquireStandard1 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquireStandard1, NODE_2);
            NodeAllocator.NodeLease acquireStandard2 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquireStandard2, NODE_1);
            NodeAllocator.NodeLease acquireSpeculative3 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.SPECULATIVE);
            this.assertNotAcquired(acquireSpeculative3);
            acquireSpeculative3.setExecutionClass(TaskExecutionClass.STANDARD);
            this.assertAcquired(acquireSpeculative3, NODE_1);
            acquireSpeculative1.release();
            acquireSpeculative2.release();
            acquireSpeculative3.release();
            NodeAllocator.NodeLease acquireStandard4 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquireStandard4, NODE_1);
            NodeAllocator.NodeLease acquireSpeculative4 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.SPECULATIVE);
            this.assertNotAcquired(acquireSpeculative4);
            NodeAllocator.NodeLease acquireStandard5 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquireStandard5);
            acquireStandard4.release();
            this.assertAcquired(acquireStandard5);
            this.assertNotAcquired(acquireSpeculative4);
            acquireStandard5.release();
            this.assertAcquired(acquireSpeculative4);
        }
    }

    @Test
    @Timeout(value=2500L, unit=TimeUnit.MILLISECONDS)
    public void testSwitchAcquiredSpeculativeToStandard() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[]{NODE_1});
        this.setupNodeAllocatorService(nodeManager);
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION);){
            NodeAllocator.NodeLease acquireSpeculative = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.SPECULATIVE);
            this.assertAcquired(acquireSpeculative, NODE_1);
            NodeAllocator.NodeLease acquireStandard1 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquireStandard1, NODE_1);
            acquireStandard1.release();
            acquireSpeculative.setExecutionClass(TaskExecutionClass.STANDARD);
            NodeAllocator.NodeLease acquireStandard2 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquireStandard2);
        }
    }

    @Test
    @Timeout(value=2500L, unit=TimeUnit.MILLISECONDS)
    public void testAllocateEagerSpeculative() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[]{NODE_1, NODE_2});
        this.setupNodeAllocatorService(nodeManager);
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION);){
            NodeAllocator.NodeLease acquireStandard1 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquireStandard1, NODE_1);
            NodeAllocator.NodeLease acquireStandard2 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquireStandard2, NODE_2);
            NodeAllocator.NodeLease acquireStandard3 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquireStandard3);
            NodeAllocator.NodeLease acquireSpeculative3 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.SPECULATIVE);
            this.assertNotAcquired(acquireSpeculative3);
            NodeAllocator.NodeLease acquireEagerSpeculative1 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.EAGER_SPECULATIVE);
            this.assertAcquired(acquireEagerSpeculative1, NODE_2);
            acquireStandard3.release();
            this.nodeAllocatorService.processPendingAcquires();
            this.assertNotAcquired(acquireSpeculative3);
            NodeAllocator.NodeLease acquireEagerSpeculative2 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.EAGER_SPECULATIVE);
            this.assertAcquired(acquireEagerSpeculative2, NODE_1);
            NodeAllocator.NodeLease acquireEagerSpeculative3 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.EAGER_SPECULATIVE);
            this.assertAcquired(acquireEagerSpeculative3, NODE_2);
            NodeAllocator.NodeLease acquireEagerSpeculative4 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.EAGER_SPECULATIVE);
            this.assertNotAcquired(acquireEagerSpeculative4);
            NodeAllocator.NodeLease acquireStandard4 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquireStandard4, NODE_2);
        }
    }

    @Test
    @Timeout(value=2500L, unit=TimeUnit.MILLISECONDS)
    public void testChangeMemoryRequirement() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[]{NODE_1, NODE_2});
        this.setupNodeAllocatorService(nodeManager);
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION);){
            NodeAllocator.NodeLease acquire1 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire1, NODE_1);
            NodeAllocator.NodeLease acquire2 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertAcquired(acquire2, NODE_2);
            NodeAllocator.NodeLease acquire3 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)40L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquire3);
            acquire3.setMemoryRequirement(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
            this.assertAcquired(acquire3, NODE_1);
            NodeAllocator.NodeLease acquire4 = nodeAllocator.acquire(REQ_NONE, DataSize.of((long)40L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
            this.assertNotAcquired(acquire4);
            acquire1.setMemoryRequirement(DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
            this.assertNotAcquired(acquire4);
            acquire3.setMemoryRequirement(DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
            this.assertAcquired(acquire4, NODE_1);
        }
    }

    private TaskId taskId(int partition) {
        return new TaskId(new StageId("test_query", 0), partition, 0);
    }

    private void assertAcquired(NodeAllocator.NodeLease lease, InternalNode node) {
        this.assertAcquired(lease, Optional.of(node));
    }

    private void assertAcquired(NodeAllocator.NodeLease lease) {
        this.assertAcquired(lease, Optional.empty());
    }

    private void assertAcquired(NodeAllocator.NodeLease lease, Optional<InternalNode> expectedNode) {
        TestBinPackingNodeAllocator.assertEventually(() -> {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)lease.getNode().isCancelled()).describedAs("node lease cancelled", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)lease.getNode().isDone()).describedAs("node lease not acquired", new Object[0])).isTrue();
            if (expectedNode.isPresent()) {
                Assertions.assertThat((Object)((InternalNode)lease.getNode().get())).isEqualTo(expectedNode.get());
            }
        });
    }

    private void assertNotAcquired(NodeAllocator.NodeLease lease) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)lease.getNode().isCancelled()).describedAs("node lease cancelled", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)lease.getNode().isDone()).describedAs("node lease acquired", new Object[0])).isFalse();
        this.nodeAllocatorService.processPendingAcquires();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)lease.getNode().isCancelled()).describedAs("node lease cancelled", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)lease.getNode().isDone()).describedAs("node lease acquired", new Object[0])).isFalse();
    }

    private static void assertEventually(ThrowingRunnable assertion) {
        Assert.assertEventually((Duration)new Duration(2500.0, TimeUnit.MILLISECONDS), (Duration)new Duration(10.0, TimeUnit.MILLISECONDS), () -> {
            try {
                assertion.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    static interface ThrowingRunnable {
        public void run() throws Exception;
    }
}

