/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.primitives.ImmutableLongArray;
import io.trino.client.NodeVersion;
import io.trino.execution.scheduler.OutputDataSizeEstimate;
import io.trino.execution.scheduler.faulttolerant.FaultTolerantPartitioningScheme;
import io.trino.execution.scheduler.faulttolerant.HashDistributionSplitAssigner;
import io.trino.execution.scheduler.faulttolerant.NodeRequirements;
import io.trino.execution.scheduler.faulttolerant.SplitAssignerTester;
import io.trino.execution.scheduler.faulttolerant.TaskDescriptor;
import io.trino.execution.scheduler.faulttolerant.TestingConnectorSplit;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingHandles;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.jupiter.api.Test;

public class TestHashDistributionSplitAssigner {
    private static final PlanNodeId PARTITIONED_1 = new PlanNodeId("partitioned-1");
    private static final PlanNodeId PARTITIONED_2 = new PlanNodeId("partitioned-2");
    private static final PlanNodeId REPLICATED_1 = new PlanNodeId("replicated-1");
    private static final PlanNodeId REPLICATED_2 = new PlanNodeId("replicated-2");
    private static final InternalNode NODE_1 = new InternalNode("node1", URI.create("http://localhost:8081"), NodeVersion.UNKNOWN, false);
    private static final InternalNode NODE_2 = new InternalNode("node2", URI.create("http://localhost:8082"), NodeVersion.UNKNOWN, false);
    private static final InternalNode NODE_3 = new InternalNode("node3", URI.create("http://localhost:8083"), NodeVersion.UNKNOWN, false);

    @Test
    public void testEmpty() {
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1).withSplits(new SplitBatch(PARTITIONED_1, (ListMultimap<Integer, Split>)ImmutableListMultimap.of(), true)).withSplitPartitionCount(10).withTargetPartitionSizeInBytes(1024L).withMergeAllowed(true).withExpectedTaskCount(10).run();
        TestHashDistributionSplitAssigner.testAssigner().withReplicatedSources(REPLICATED_1).withSplits(new SplitBatch(REPLICATED_1, (ListMultimap<Integer, Split>)ImmutableListMultimap.of(), true)).withSplitPartitionCount(1).withTargetPartitionSizeInBytes(1024L).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)REPLICATED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.builder().add(0L).build()))).withMergeAllowed(true).withExpectedTaskCount(1).run();
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1).withReplicatedSources(REPLICATED_1).withSplits(new SplitBatch(PARTITIONED_1, (ListMultimap<Integer, Split>)ImmutableListMultimap.of(), true), new SplitBatch(REPLICATED_1, (ListMultimap<Integer, Split>)ImmutableListMultimap.of(), true)).withSplitPartitionCount(10).withTargetPartitionSizeInBytes(1024L).withMergeAllowed(true).withExpectedTaskCount(10).run();
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1, PARTITIONED_2).withReplicatedSources(REPLICATED_1, REPLICATED_2).withSplits(new SplitBatch(PARTITIONED_1, (ListMultimap<Integer, Split>)ImmutableListMultimap.of(), true), new SplitBatch(REPLICATED_1, (ListMultimap<Integer, Split>)ImmutableListMultimap.of(), true), new SplitBatch(PARTITIONED_2, (ListMultimap<Integer, Split>)ImmutableListMultimap.of(), true), new SplitBatch(REPLICATED_2, (ListMultimap<Integer, Split>)ImmutableListMultimap.of(), true)).withSplitPartitionCount(10).withTargetPartitionSizeInBytes(1024L).withMergeAllowed(true).withExpectedTaskCount(10).run();
    }

    @Test
    public void testExplicitPartitionToNodeMap() {
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1).withSplits(new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(0, 0), TestHashDistributionSplitAssigner.createSplit(1, 0)), false), new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(2, 1), TestHashDistributionSplitAssigner.createSplit(3, 2)), true)).withSplitPartitionCount(3).withPartitionToNodeMap(Optional.of(ImmutableList.of((Object)NODE_1, (Object)NODE_2, (Object)NODE_3))).withTargetPartitionSizeInBytes(1000L).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)1L, (long)1L, (long)1L)))).withMergeAllowed(true).withExpectedTaskCount(3).run();
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1).withSplits(new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(0, 0), TestHashDistributionSplitAssigner.createSplit(1, 0)), true)).withSplitPartitionCount(3).withPartitionToNodeMap(Optional.of(ImmutableList.of((Object)NODE_1, (Object)NODE_2, (Object)NODE_3))).withTargetPartitionSizeInBytes(1000L).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)1L, (long)1L, (long)1L)))).withMergeAllowed(true).withExpectedTaskCount(3).run();
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1).withSplits(new SplitBatch(PARTITIONED_1, (ListMultimap<Integer, Split>)ImmutableListMultimap.of(), true)).withSplitPartitionCount(3).withPartitionToNodeMap(Optional.of(ImmutableList.of((Object)NODE_1, (Object)NODE_2, (Object)NODE_3))).withTargetPartitionSizeInBytes(1000L).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)1L, (long)1L, (long)1L)))).withMergeAllowed(true).withExpectedTaskCount(3).run();
    }

    @Test
    public void testMergeNotAllowed() {
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1).withSplits(new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(0, 0), TestHashDistributionSplitAssigner.createSplit(1, 0)), false), new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(2, 1), TestHashDistributionSplitAssigner.createSplit(3, 2)), true)).withSplitPartitionCount(3).withTargetPartitionSizeInBytes(1000L).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)1L, (long)1L, (long)1L)))).withMergeAllowed(false).withExpectedTaskCount(3).run();
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1).withSplits(new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(0, 0), TestHashDistributionSplitAssigner.createSplit(1, 0)), true)).withSplitPartitionCount(3).withTargetPartitionSizeInBytes(1000L).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)1L, (long)1L, (long)1L)))).withMergeAllowed(false).withExpectedTaskCount(3).run();
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1).withSplits(new SplitBatch(PARTITIONED_1, (ListMultimap<Integer, Split>)ImmutableListMultimap.of(), true)).withSplitPartitionCount(3).withTargetPartitionSizeInBytes(1000L).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)1L, (long)1L, (long)1L)))).withMergeAllowed(false).withExpectedTaskCount(3).run();
    }

    @Test
    public void testMissingEstimates() {
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1).withSplits(new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(0, 0), TestHashDistributionSplitAssigner.createSplit(1, 0)), false), new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(2, 1), TestHashDistributionSplitAssigner.createSplit(3, 2)), true)).withSplitPartitionCount(3).withPartitionToNodeMap(Optional.of(ImmutableList.of((Object)NODE_1, (Object)NODE_2, (Object)NODE_3))).withTargetPartitionSizeInBytes(1000L).withMergeAllowed(true).withExpectedTaskCount(3).run();
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1).withSplits(new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(0, 0), TestHashDistributionSplitAssigner.createSplit(1, 0)), true)).withSplitPartitionCount(3).withPartitionToNodeMap(Optional.of(ImmutableList.of((Object)NODE_1, (Object)NODE_2, (Object)NODE_3))).withTargetPartitionSizeInBytes(1000L).withMergeAllowed(true).withExpectedTaskCount(3).run();
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1).withSplits(new SplitBatch(PARTITIONED_1, (ListMultimap<Integer, Split>)ImmutableListMultimap.of(), true)).withSplitPartitionCount(3).withPartitionToNodeMap(Optional.of(ImmutableList.of((Object)NODE_1, (Object)NODE_2, (Object)NODE_3))).withTargetPartitionSizeInBytes(1000L).withMergeAllowed(true).withExpectedTaskCount(3).run();
    }

    @Test
    public void testHappyPath() {
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1).withSplits(new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(0, 0), TestHashDistributionSplitAssigner.createSplit(1, 0)), false), new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(2, 1), TestHashDistributionSplitAssigner.createSplit(3, 2)), true)).withSplitPartitionCount(3).withTargetPartitionSizeInBytes(3L).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)1L, (long)1L, (long)1L)))).withMergeAllowed(true).withExpectedTaskCount(1).run();
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1).withReplicatedSources(REPLICATED_1).withSplits(new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(0, 0), TestHashDistributionSplitAssigner.createSplit(1, 0)), false), new SplitBatch(REPLICATED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(2, 0), TestHashDistributionSplitAssigner.createSplit(3, 2)), false), new SplitBatch(REPLICATED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(4, 1), TestHashDistributionSplitAssigner.createSplit(5, 100)), true), new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(6, 1), TestHashDistributionSplitAssigner.createSplit(7, 2)), true)).withSplitPartitionCount(3).withTargetPartitionSizeInBytes(3L).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)1L, (long)1L, (long)1L)))).withMergeAllowed(true).withExpectedTaskCount(1).run();
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1).withReplicatedSources(REPLICATED_1).withSplits(new SplitBatch(REPLICATED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(2, 0), TestHashDistributionSplitAssigner.createSplit(3, 2)), false), new SplitBatch(REPLICATED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(4, 1), TestHashDistributionSplitAssigner.createSplit(5, 100)), true), new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(0, 0), TestHashDistributionSplitAssigner.createSplit(1, 0)), false), new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(6, 1), TestHashDistributionSplitAssigner.createSplit(7, 2)), true)).withSplitPartitionCount(3).withTargetPartitionSizeInBytes(1L).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)1L, (long)1L, (long)1L)))).withMergeAllowed(true).withExpectedTaskCount(3).run();
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1).withReplicatedSources(REPLICATED_1).withSplits(new SplitBatch(REPLICATED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(2, 0), TestHashDistributionSplitAssigner.createSplit(3, 2)), false), new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(0, 0), TestHashDistributionSplitAssigner.createSplit(1, 0)), false), new SplitBatch(REPLICATED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(4, 1), TestHashDistributionSplitAssigner.createSplit(5, 100)), true), new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(6, 1), TestHashDistributionSplitAssigner.createSplit(7, 2)), true)).withSplitPartitionCount(3).withTargetPartitionSizeInBytes(1L).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)1L, (long)1L, (long)1L)))).withMergeAllowed(true).withExpectedTaskCount(3).run();
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1).withReplicatedSources(REPLICATED_1, REPLICATED_2).withSplits(new SplitBatch(REPLICATED_2, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(11, 1), TestHashDistributionSplitAssigner.createSplit(12, 100)), true), new SplitBatch(REPLICATED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(2, 0), TestHashDistributionSplitAssigner.createSplit(3, 2)), false), new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(0, 0), TestHashDistributionSplitAssigner.createSplit(1, 0)), false), new SplitBatch(REPLICATED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(4, 1), TestHashDistributionSplitAssigner.createSplit(5, 100)), true), new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(6, 1), TestHashDistributionSplitAssigner.createSplit(7, 2)), true)).withSplitPartitionCount(3).withTargetPartitionSizeInBytes(1L).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)1L, (long)1L, (long)1L)))).withMergeAllowed(true).withExpectedTaskCount(3).run();
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1, PARTITIONED_2).withReplicatedSources(REPLICATED_1, REPLICATED_2).withSplits(new SplitBatch(REPLICATED_2, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(11, 1), TestHashDistributionSplitAssigner.createSplit(12, 100)), true), new SplitBatch(REPLICATED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(2, 0), TestHashDistributionSplitAssigner.createSplit(3, 2)), false), new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(0, 0), TestHashDistributionSplitAssigner.createSplit(1, 0)), false), new SplitBatch(PARTITIONED_2, TestHashDistributionSplitAssigner.createSplitMap(new Split[0]), true), new SplitBatch(REPLICATED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(4, 1), TestHashDistributionSplitAssigner.createSplit(5, 100)), true), new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(6, 1), TestHashDistributionSplitAssigner.createSplit(7, 2)), true)).withSplitPartitionCount(3).withTargetPartitionSizeInBytes(1L).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)1L, (long)1L, (long)1L)), (Object)PARTITIONED_2, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)1L, (long)1L, (long)1L)))).withMergeAllowed(true).withExpectedTaskCount(3).run();
    }

    @Test
    public void testPartitionSplitting() {
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1).withSplits(new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(0, 0), TestHashDistributionSplitAssigner.createSplit(1, 0)), false), new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(2, 0), TestHashDistributionSplitAssigner.createSplit(3, 0)), true)).withSplitPartitionCount(3).withTargetPartitionSizeInBytes(3L).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)5L, (long)1L, (long)1L)))).withSplittableSources(PARTITIONED_1).withMergeAllowed(true).withExpectedTaskCount(3).run();
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1).withSplits(new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(0, 0), TestHashDistributionSplitAssigner.createSplit(1, 0)), false), new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(2, 0), TestHashDistributionSplitAssigner.createSplit(3, 0)), true)).withSplitPartitionCount(3).withTargetPartitionSizeInBytes(3L).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)5L, (long)1L, (long)1L)))).withMergeAllowed(true).withExpectedTaskCount(2).run();
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1, PARTITIONED_2).withSplits(new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(0, 0), TestHashDistributionSplitAssigner.createSplit(1, 0)), false), new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(2, 0), TestHashDistributionSplitAssigner.createSplit(3, 0)), true), new SplitBatch(PARTITIONED_2, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(4, 0), TestHashDistributionSplitAssigner.createSplit(5, 1)), true)).withSplitPartitionCount(3).withTargetPartitionSizeInBytes(30L).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)50L, (long)1L, (long)1L)), (Object)PARTITIONED_2, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)2L, (long)1L, (long)1L)))).withSplittableSources(PARTITIONED_1).withMergeAllowed(true).withExpectedTaskCount(3).run();
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1, PARTITIONED_2).withSplits(new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(0, 0), TestHashDistributionSplitAssigner.createSplit(1, 0)), false), new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(2, 0), TestHashDistributionSplitAssigner.createSplit(3, 0)), true), new SplitBatch(PARTITIONED_2, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(4, 0), TestHashDistributionSplitAssigner.createSplit(5, 1)), true)).withSplitPartitionCount(3).withTargetPartitionSizeInBytes(30L).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)50L, (long)1L, (long)1L)), (Object)PARTITIONED_2, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)2L, (long)1L, (long)1L)))).withSplittableSources(PARTITIONED_1, PARTITIONED_2).withMergeAllowed(true).withExpectedTaskCount(3).run();
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1, PARTITIONED_2).withSplits(new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(0, 0), TestHashDistributionSplitAssigner.createSplit(1, 0)), false), new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(2, 0), TestHashDistributionSplitAssigner.createSplit(3, 0)), true), new SplitBatch(PARTITIONED_2, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(4, 0), TestHashDistributionSplitAssigner.createSplit(5, 0)), true)).withSplitPartitionCount(3).withTargetPartitionSizeInBytes(30L).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)50L, (long)1L, (long)1L)), (Object)PARTITIONED_2, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)2L, (long)1L, (long)1L)))).withSplittableSources(PARTITIONED_2).withMergeAllowed(true).withExpectedTaskCount(2).run();
        TestHashDistributionSplitAssigner.testAssigner().withPartitionedSources(PARTITIONED_1, PARTITIONED_2).withSplits(new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(0, 0), TestHashDistributionSplitAssigner.createSplit(1, 0)), false), new SplitBatch(PARTITIONED_1, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(2, 0), TestHashDistributionSplitAssigner.createSplit(3, 0)), true), new SplitBatch(PARTITIONED_2, TestHashDistributionSplitAssigner.createSplitMap(TestHashDistributionSplitAssigner.createSplit(4, 0), TestHashDistributionSplitAssigner.createSplit(5, 1)), true)).withSplitPartitionCount(3).withTargetPartitionSizeInBytes(30L).withTaskTargetMaxCount(10).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)1000L, (long)1L, (long)1L)), (Object)PARTITIONED_2, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)2L, (long)1L, (long)1L)))).withSplittableSources(PARTITIONED_1, PARTITIONED_2).withMergeAllowed(true).withExpectedTaskCount(12).run();
    }

    @Test
    public void testCreateOutputPartitionToTaskPartition() {
        TestHashDistributionSplitAssigner.testPartitionMapping().withSplitPartitionCount(3).withPartitionedSources(PARTITIONED_1).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)50L, (long)1L, (long)1L)))).withTargetPartitionSizeInBytes(25L).withSplittableSources(PARTITIONED_1).withMergeAllowed(true).withExpectedMappings(new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)0), 3), new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)1, (Object)2), 1)).run();
        TestHashDistributionSplitAssigner.testPartitionMapping().withSplitPartitionCount(3).withPartitionedSources(PARTITIONED_1).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)50L, (long)1L, (long)1L)))).withTargetPartitionSizeInBytes(25L).withMergeAllowed(true).withExpectedMappings(new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)0), 1), new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)1, (Object)2), 1)).run();
        TestHashDistributionSplitAssigner.testPartitionMapping().withSplitPartitionCount(3).withPartitionedSources(PARTITIONED_1).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)50L, (long)1L, (long)1L)))).withTargetPartitionSizeInBytes(25L).withMergeAllowed(false).withExpectedMappings(new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)0), 1), new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)1), 1), new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)2), 1)).run();
        TestHashDistributionSplitAssigner.testPartitionMapping().withSplitPartitionCount(3).withPartitionedSources(PARTITIONED_1).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)50L, (long)1L, (long)1L)))).withTargetPartitionSizeInBytes(25L).withMergeAllowed(false).withSplittableSources(PARTITIONED_1).withExpectedMappings(new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)0), 3), new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)1), 1), new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)2), 1)).run();
        TestHashDistributionSplitAssigner.testPartitionMapping().withSplitPartitionCount(4).withPartitionedSources(PARTITIONED_1).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)0L, (long)0L, (long)0L, (long)60L)))).withTargetPartitionSizeInBytes(25L).withMergeAllowed(false).withSplittableSources(PARTITIONED_1).withExpectedMappings(new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)0), 1), new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)1), 1), new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)2), 1), new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)3), 3)).run();
    }

    @Test
    public void testCreateOutputPartitionToTaskPartitionWithMinTaskCount() {
        TestHashDistributionSplitAssigner.testPartitionMapping().withSplitPartitionCount(8).withPartitionedSources(PARTITIONED_1).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)10L, (long[])new long[]{10L, 10L, 10L, 10L, 10L, 10L, 10L})))).withTargetPartitionSizeInBytes(50L).withMergeAllowed(true).withExpectedMappings(new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4), 1), new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)5, (Object)6, (Object)7), 1)).run();
        TestHashDistributionSplitAssigner.testPartitionMapping().withSplitPartitionCount(8).withPartitionedSources(PARTITIONED_1).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)10L, (long[])new long[]{10L, 10L, 10L, 10L, 10L, 10L, 10L})))).withTargetPartitionSizeInBytes(50L).withMergeAllowed(true).withTargetMinTaskCount(4).withExpectedMappings(new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)0, (Object)1), 1), new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)2, (Object)3), 1), new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)4, (Object)5), 1), new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)6, (Object)7), 1)).run();
        TestHashDistributionSplitAssigner.testPartitionMapping().withSplitPartitionCount(8).withPartitionedSources(PARTITIONED_1).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)1L, (long[])new long[]{1L, 10L, 1L, 1L, 1L, 1L, 1L})))).withTargetPartitionSizeInBytes(50L).withMergeAllowed(true).withExpectedMappings(new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object[])new Integer[]{6, 7}), 1)).run();
        TestHashDistributionSplitAssigner.testPartitionMapping().withSplitPartitionCount(8).withPartitionedSources(PARTITIONED_1).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)1L, (long[])new long[]{1L, 10L, 1L, 1L, 1L, 1L, 1L})))).withTargetPartitionSizeInBytes(50L).withMergeAllowed(true).withTargetMinTaskCount(4).withExpectedMappings(new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)0, (Object)1, (Object)3, (Object)4), 1), new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)2), 1), new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)5, (Object)6, (Object)7), 1)).run();
        TestHashDistributionSplitAssigner.testPartitionMapping().withSplitPartitionCount(2).withPartitionedSources(PARTITIONED_1).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)10L, (long)10L)))).withTargetPartitionSizeInBytes(50L).withMergeAllowed(true).withExpectedMappings(new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)0, (Object)1), 1)).run();
        TestHashDistributionSplitAssigner.testPartitionMapping().withSplitPartitionCount(2).withPartitionedSources(PARTITIONED_1).withSourceDataSizeEstimates((Map<PlanNodeId, OutputDataSizeEstimate>)ImmutableMap.of((Object)PARTITIONED_1, (Object)new OutputDataSizeEstimate(ImmutableLongArray.of((long)10L, (long)10L)))).withTargetPartitionSizeInBytes(50L).withMergeAllowed(true).withTargetMinTaskCount(4).withExpectedMappings(new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)0), 1), new PartitionMapping((Set<Integer>)ImmutableSet.of((Object)1), 1)).run();
    }

    private static ListMultimap<Integer, Split> createSplitMap(Split ... splits) {
        return (ListMultimap)Arrays.stream(splits).collect(ImmutableListMultimap.toImmutableListMultimap(split -> ((TestingConnectorSplit)split.getConnectorSplit()).getBucket().orElseThrow(), Function.identity()));
    }

    private static FaultTolerantPartitioningScheme createPartitioningScheme(int partitionCount, Optional<List<InternalNode>> partitionToNodeMap) {
        return new FaultTolerantPartitioningScheme(partitionCount, Optional.of(IntStream.range(0, partitionCount).toArray()), Optional.of(split -> ((TestingConnectorSplit)split.getConnectorSplit()).getBucket().orElseThrow()), partitionToNodeMap);
    }

    private static Split createSplit(int id, int partition) {
        return new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestingConnectorSplit(id, OptionalInt.of(partition), Optional.empty()));
    }

    public static AssignerTester testAssigner() {
        return new AssignerTester();
    }

    private static PartitionMappingTester testPartitionMapping() {
        return new PartitionMappingTester();
    }

    private static class AssignerTester {
        private Set<PlanNodeId> partitionedSources = ImmutableSet.of();
        private Set<PlanNodeId> replicatedSources = ImmutableSet.of();
        private List<SplitBatch> splits = ImmutableList.of();
        private int splitPartitionCount;
        private Optional<List<InternalNode>> partitionToNodeMap = Optional.empty();
        private long targetPartitionSizeInBytes;
        private int taskTargetMinCount;
        private int taskTargetMaxCount = Integer.MAX_VALUE;
        private Map<PlanNodeId, OutputDataSizeEstimate> sourceDataSizeEstimates = ImmutableMap.of();
        private Set<PlanNodeId> splittableSources = ImmutableSet.of();
        private boolean mergeAllowed;
        private int expectedTaskCount;

        private AssignerTester() {
        }

        public AssignerTester withPartitionedSources(PlanNodeId ... sources) {
            this.partitionedSources = ImmutableSet.copyOf((Object[])sources);
            return this;
        }

        public AssignerTester withReplicatedSources(PlanNodeId ... sources) {
            this.replicatedSources = ImmutableSet.copyOf((Object[])sources);
            return this;
        }

        public AssignerTester withSplits(SplitBatch ... splits) {
            this.splits = ImmutableList.copyOf((Object[])splits);
            return this;
        }

        public AssignerTester withSplitPartitionCount(int splitPartitionCount) {
            this.splitPartitionCount = splitPartitionCount;
            return this;
        }

        public AssignerTester withPartitionToNodeMap(Optional<List<InternalNode>> partitionToNodeMap) {
            this.partitionToNodeMap = partitionToNodeMap;
            return this;
        }

        public AssignerTester withTargetPartitionSizeInBytes(long targetPartitionSizeInBytes) {
            this.targetPartitionSizeInBytes = targetPartitionSizeInBytes;
            return this;
        }

        public AssignerTester withTaskTargetMaxCount(int taskTargetMaxCount) {
            this.taskTargetMaxCount = taskTargetMaxCount;
            return this;
        }

        public AssignerTester withSourceDataSizeEstimates(Map<PlanNodeId, OutputDataSizeEstimate> sourceDataSizeEstimates) {
            this.sourceDataSizeEstimates = sourceDataSizeEstimates;
            return this;
        }

        public AssignerTester withSplittableSources(PlanNodeId ... sources) {
            this.splittableSources = ImmutableSet.copyOf((Object[])sources);
            return this;
        }

        public AssignerTester withMergeAllowed(boolean mergeAllowed) {
            this.mergeAllowed = mergeAllowed;
            return this;
        }

        public AssignerTester withExpectedTaskCount(int expectedTaskCount) {
            this.expectedTaskCount = expectedTaskCount;
            return this;
        }

        public void run() {
            FaultTolerantPartitioningScheme partitioningScheme = TestHashDistributionSplitAssigner.createPartitioningScheme(this.splitPartitionCount, this.partitionToNodeMap);
            Map sourcePartitionToTaskPartition = HashDistributionSplitAssigner.createSourcePartitionToTaskPartition((FaultTolerantPartitioningScheme)partitioningScheme, this.partitionedSources, this.sourceDataSizeEstimates, (long)this.targetPartitionSizeInBytes, (int)this.taskTargetMinCount, (int)this.taskTargetMaxCount, this.splittableSources::contains, (boolean)this.mergeAllowed);
            HashDistributionSplitAssigner assigner = new HashDistributionSplitAssigner(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), this.partitionedSources, this.replicatedSources, partitioningScheme, sourcePartitionToTaskPartition);
            SplitAssignerTester tester = new SplitAssignerTester();
            HashMap<Integer, ListMultimap> partitionedSplitIds = new HashMap<Integer, ListMultimap>();
            HashMultimap replicatedSplitIds = HashMultimap.create();
            for (SplitBatch batch : this.splits) {
                tester.update(assigner.assign(batch.getPlanNodeId(), batch.getSplits(), batch.isNoMoreSplits()));
                boolean replicated = this.replicatedSources.contains(batch.getPlanNodeId());
                tester.checkContainsSplits(batch.getPlanNodeId(), batch.getSplits(), replicated);
                for (Map.Entry entry : batch.getSplits().entries()) {
                    int splitId = TestingConnectorSplit.getSplitId((Split)entry.getValue());
                    if (replicated) {
                        Assertions.assertThat((boolean)replicatedSplitIds.containsValue((Object)splitId)).isFalse();
                        replicatedSplitIds.put((Object)batch.getPlanNodeId(), (Object)splitId);
                        continue;
                    }
                    partitionedSplitIds.computeIfAbsent((Integer)entry.getKey(), key -> ArrayListMultimap.create()).put((Object)batch.getPlanNodeId(), (Object)splitId);
                }
            }
            tester.update(assigner.finish());
            Map taskDescriptors = (Map)tester.getTaskDescriptors().orElseThrow().stream().collect(ImmutableMap.toImmutableMap(TaskDescriptor::getPartitionId, Function.identity()));
            Assertions.assertThat((Map)taskDescriptors).hasSize(this.expectedTaskCount);
            for (TaskDescriptor taskDescriptor : taskDescriptors.values()) {
                int partitionId2 = taskDescriptor.getPartitionId();
                NodeRequirements nodeRequirements = taskDescriptor.getNodeRequirements();
                Assertions.assertThat((Optional)nodeRequirements.getCatalogHandle()).isEqualTo(Optional.of(TestingHandles.TEST_CATALOG_HANDLE));
                this.partitionToNodeMap.ifPresent(partitionToNode -> {
                    if (!taskDescriptor.getSplits().getSplitsFlat().isEmpty()) {
                        InternalNode node = (InternalNode)partitionToNode.get(partitionId2);
                        Assertions.assertThat((Collection)nodeRequirements.getAddresses()).containsExactly((Object[])new HostAddress[]{node.getHostAndPort()});
                    }
                });
                HashSet taskDescriptorSplitIds = new HashSet();
                replicatedSplitIds.keySet().forEach(planNodeId -> taskDescriptor.getSplits().getSplits(planNodeId).get((Object)0).stream().map(TestingConnectorSplit::getSplitId).forEach(taskDescriptorSplitIds::add));
                Assertions.assertThat(taskDescriptorSplitIds).containsAll((Iterable)replicatedSplitIds.values());
            }
            partitionedSplitIds.forEach((partitionId, sourceSplits) -> sourceSplits.forEach((source, splitId) -> {
                List descriptors = (List)((HashDistributionSplitAssigner.TaskPartition)sourcePartitionToTaskPartition.get(partitionId)).getSubPartitions().stream().filter(HashDistributionSplitAssigner.SubPartition::isIdAssigned).map(HashDistributionSplitAssigner.SubPartition::getId).map(taskDescriptors::get).collect(ImmutableList.toImmutableList());
                for (TaskDescriptor descriptor : descriptors) {
                    Multimap taskDescriptorSplitIds = (Multimap)descriptor.getSplits().getSplits(source).entries().stream().collect(ImmutableListMultimap.toImmutableListMultimap(Map.Entry::getKey, entry -> TestingConnectorSplit.getSplitId((Split)entry.getValue())));
                    if (taskDescriptorSplitIds.get(partitionId).contains(splitId) && this.splittableSources.contains(source)) {
                        return;
                    }
                    if (taskDescriptorSplitIds.get(partitionId).contains(splitId) || this.splittableSources.contains(source)) continue;
                    Fail.fail((String)("expected split not found: ." + splitId));
                }
                if (this.splittableSources.contains(source)) {
                    Fail.fail((String)("expected split not found: ." + splitId));
                }
            }));
        }
    }

    private static class SplitBatch {
        private final PlanNodeId planNodeId;
        private final ListMultimap<Integer, Split> splits;
        private final boolean noMoreSplits;

        public SplitBatch(PlanNodeId planNodeId, ListMultimap<Integer, Split> splits, boolean noMoreSplits) {
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.splits = ImmutableListMultimap.copyOf((Multimap)((Multimap)Objects.requireNonNull(splits, "splits is null")));
            this.noMoreSplits = noMoreSplits;
        }

        public PlanNodeId getPlanNodeId() {
            return this.planNodeId;
        }

        public ListMultimap<Integer, Split> getSplits() {
            return this.splits;
        }

        public boolean isNoMoreSplits() {
            return this.noMoreSplits;
        }
    }

    private static class PartitionMappingTester {
        private Set<PlanNodeId> partitionedSources = ImmutableSet.of();
        private int splitPartitionCount;
        private Optional<List<InternalNode>> partitionToNodeMap = Optional.empty();
        private long targetPartitionSizeInBytes;
        private int targetMinTaskCount;
        private Map<PlanNodeId, OutputDataSizeEstimate> sourceDataSizeEstimates = ImmutableMap.of();
        private Set<PlanNodeId> splittableSources = ImmutableSet.of();
        private boolean mergeAllowed;
        private Set<PartitionMapping> expectedMappings = ImmutableSet.of();

        private PartitionMappingTester() {
        }

        public PartitionMappingTester withPartitionedSources(PlanNodeId ... sources) {
            this.partitionedSources = ImmutableSet.copyOf((Object[])sources);
            return this;
        }

        public PartitionMappingTester withSplitPartitionCount(int splitPartitionCount) {
            this.splitPartitionCount = splitPartitionCount;
            return this;
        }

        public PartitionMappingTester withPartitionToNodeMap(Optional<List<InternalNode>> partitionToNodeMap) {
            this.partitionToNodeMap = partitionToNodeMap;
            return this;
        }

        public PartitionMappingTester withTargetPartitionSizeInBytes(long targetPartitionSizeInBytes) {
            this.targetPartitionSizeInBytes = targetPartitionSizeInBytes;
            return this;
        }

        public PartitionMappingTester withTargetMinTaskCount(int targetMinTaskCount) {
            this.targetMinTaskCount = targetMinTaskCount;
            return this;
        }

        public PartitionMappingTester withSourceDataSizeEstimates(Map<PlanNodeId, OutputDataSizeEstimate> sourceDataSizeEstimates) {
            this.sourceDataSizeEstimates = sourceDataSizeEstimates;
            return this;
        }

        public PartitionMappingTester withSplittableSources(PlanNodeId ... sources) {
            this.splittableSources = ImmutableSet.copyOf((Object[])sources);
            return this;
        }

        public PartitionMappingTester withMergeAllowed(boolean mergeAllowed) {
            this.mergeAllowed = mergeAllowed;
            return this;
        }

        public PartitionMappingTester withExpectedMappings(PartitionMapping ... mappings) {
            this.expectedMappings = ImmutableSet.copyOf((Object[])mappings);
            return this;
        }

        public void run() {
            FaultTolerantPartitioningScheme partitioningScheme = TestHashDistributionSplitAssigner.createPartitioningScheme(this.splitPartitionCount, this.partitionToNodeMap);
            Map actual = HashDistributionSplitAssigner.createSourcePartitionToTaskPartition((FaultTolerantPartitioningScheme)partitioningScheme, this.partitionedSources, this.sourceDataSizeEstimates, (long)this.targetPartitionSizeInBytes, (int)this.targetMinTaskCount, (int)Integer.MAX_VALUE, this.splittableSources::contains, (boolean)this.mergeAllowed);
            Set<PartitionMapping> actualGroups = PartitionMappingTester.extractMappings(actual);
            Assertions.assertThat(actualGroups).isEqualTo(this.expectedMappings);
        }

        private static Set<PartitionMapping> extractMappings(Map<Integer, HashDistributionSplitAssigner.TaskPartition> sourcePartitionToTaskPartition) {
            SetMultimap grouped = (SetMultimap)sourcePartitionToTaskPartition.entrySet().stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(Map.Entry::getValue, Map.Entry::getKey));
            return (Set)Multimaps.asMap((SetMultimap)grouped).entrySet().stream().map(entry -> new PartitionMapping((Set)entry.getValue(), ((HashDistributionSplitAssigner.TaskPartition)entry.getKey()).getSubPartitions().size())).collect(ImmutableSet.toImmutableSet());
        }
    }

    private record PartitionMapping(Set<Integer> sourcePartitions, int taskPartitionCount) {
        private PartitionMapping(Set<Integer> sourcePartitions, int taskPartitionCount) {
            this.sourcePartitions = sourcePartitions = ImmutableSet.copyOf((Collection)Objects.requireNonNull(sourcePartitions, "sourcePartitions is null"));
            this.taskPartitionCount = taskPartitionCount;
        }
    }
}

