/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.metadata.Split;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

class TestingConnectorSplit
implements ConnectorSplit {
    private static final long INSTANCE_SIZE = SizeOf.instanceSize(TestingConnectorSplit.class);
    private final int id;
    private final OptionalInt bucket;
    private final Optional<List<HostAddress>> addresses;

    public TestingConnectorSplit(int id, OptionalInt bucket, Optional<List<HostAddress>> addresses) {
        this.id = id;
        this.bucket = Objects.requireNonNull(bucket, "bucket is null");
        this.addresses = addresses.map(ImmutableList::copyOf);
    }

    public int getId() {
        return this.id;
    }

    public OptionalInt getBucket() {
        return this.bucket;
    }

    public boolean isRemotelyAccessible() {
        return this.addresses.isEmpty();
    }

    public List<HostAddress> getAddresses() {
        return this.addresses.orElse((List<HostAddress>)ImmutableList.of());
    }

    public Object getInfo() {
        return null;
    }

    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE + SizeOf.sizeOf((OptionalInt)this.bucket) + SizeOf.sizeOf(this.addresses, value -> SizeOf.estimatedSizeOf((List)value, HostAddress::getRetainedSizeInBytes));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestingConnectorSplit that = (TestingConnectorSplit)o;
        return this.id == that.id && Objects.equals(this.bucket, that.bucket) && Objects.equals(this.addresses, that.addresses);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.bucket, this.addresses);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("bucket", (Object)this.bucket).add("addresses", this.addresses).toString();
    }

    public static int getSplitId(Split split) {
        return ((TestingConnectorSplit)split.getConnectorSplit()).getId();
    }
}

