/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import io.airlift.json.JsonCodec;
import io.trino.metadata.QualifiedObjectName;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestQualifiedObjectName {
    private final JsonCodec<QualifiedObjectName> codec = JsonCodec.jsonCodec(QualifiedObjectName.class);

    @Test
    public void testJsonSerializationRoundTrip() {
        this.testRoundTrip(new QualifiedObjectName("catalog", "schema", "table_name"));
        this.testRoundTrip(new QualifiedObjectName("catalog.tw\u00f3j", "schema.\u015bciema", "tabel.tabelk\u00f3wna"));
        this.testRoundTrip(new QualifiedObjectName("cata\"l.o.g\"", "s\"ch.e.ma\"", "\"t.a.b.e.l\""));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new QualifiedObjectName("CataLOG", "SchemA", "TabEl")).isInstanceOf(IllegalArgumentException.class)).hasMessage("catalogName is not lowercase: CataLOG");
        this.testRoundTrip(new QualifiedObjectName("", "", ""));
    }

    private void testRoundTrip(QualifiedObjectName value) {
        String json = this.codec.toJson((Object)value);
        QualifiedObjectName parsed = (QualifiedObjectName)this.codec.fromJson(json);
        Assertions.assertThat((Object)parsed).isEqualTo((Object)value);
    }
}

