/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.airlift.stats.Distribution;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.operator.DriverStats;
import io.trino.operator.OperatorStats;
import io.trino.operator.PipelineStats;
import io.trino.operator.TestDriverStats;
import io.trino.operator.TestOperatorStats;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.jupiter.api.Test;

public class TestPipelineStats {
    public static final PipelineStats EXPECTED = new PipelineStats(0, new DateTime(100L), new DateTime(101L), new DateTime(102L), true, false, 1, 2, 1, 21L, 3, 2, 22L, 19, 4, DataSize.ofBytes((long)5L), DataSize.ofBytes((long)6L), TestPipelineStats.getTestDistribution(8), TestPipelineStats.getTestDistribution(9), new Duration(10.0, TimeUnit.NANOSECONDS), new Duration(11.0, TimeUnit.NANOSECONDS), new Duration(13.0, TimeUnit.NANOSECONDS), false, (Set)ImmutableSet.of(), DataSize.ofBytes((long)141L), 151L, new Duration(14.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)142L), 152L, DataSize.ofBytes((long)14L), 15L, DataSize.ofBytes((long)16L), 17L, new Duration(101.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)18L), 19L, new Duration(102.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)20L), (List)ImmutableList.of((Object)TestOperatorStats.EXPECTED), (List)ImmutableList.of((Object)TestDriverStats.EXPECTED));

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(PipelineStats.class);
        String json = codec.toJson((Object)EXPECTED);
        PipelineStats actual = (PipelineStats)codec.fromJson(json);
        TestPipelineStats.assertExpectedPipelineStats(actual);
    }

    public static void assertExpectedPipelineStats(PipelineStats actual) {
        Assertions.assertThat((Comparable)actual.getFirstStartTime()).isEqualTo((Object)new DateTime(100L, DateTimeZone.UTC));
        Assertions.assertThat((Comparable)actual.getLastStartTime()).isEqualTo((Object)new DateTime(101L, DateTimeZone.UTC));
        Assertions.assertThat((Comparable)actual.getLastEndTime()).isEqualTo((Object)new DateTime(102L, DateTimeZone.UTC));
        Assertions.assertThat((boolean)actual.isInputPipeline()).isEqualTo(true);
        Assertions.assertThat((boolean)actual.isOutputPipeline()).isEqualTo(false);
        Assertions.assertThat((int)actual.getTotalDrivers()).isEqualTo(1);
        Assertions.assertThat((int)actual.getQueuedDrivers()).isEqualTo(2);
        Assertions.assertThat((int)actual.getQueuedPartitionedDrivers()).isEqualTo(1);
        Assertions.assertThat((long)actual.getQueuedPartitionedSplitsWeight()).isEqualTo(21L);
        Assertions.assertThat((int)actual.getRunningDrivers()).isEqualTo(3);
        Assertions.assertThat((int)actual.getRunningPartitionedDrivers()).isEqualTo(2);
        Assertions.assertThat((long)actual.getRunningPartitionedSplitsWeight()).isEqualTo(22L);
        Assertions.assertThat((int)actual.getBlockedDrivers()).isEqualTo(19);
        Assertions.assertThat((int)actual.getCompletedDrivers()).isEqualTo(4);
        Assertions.assertThat((Comparable)actual.getUserMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)5L));
        Assertions.assertThat((Comparable)actual.getRevocableMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)6L));
        Assertions.assertThat((double)actual.getQueuedTime().getCount()).isEqualTo(8.0);
        Assertions.assertThat((double)actual.getElapsedTime().getCount()).isEqualTo(9.0);
        Assertions.assertThat((Comparable)actual.getTotalScheduledTime()).isEqualTo((Object)new Duration(10.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getTotalCpuTime()).isEqualTo((Object)new Duration(11.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getTotalBlockedTime()).isEqualTo((Object)new Duration(13.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getPhysicalInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)141L));
        Assertions.assertThat((long)actual.getPhysicalInputPositions()).isEqualTo(151L);
        Assertions.assertThat((Comparable)actual.getPhysicalInputReadTime()).isEqualTo((Object)new Duration(14.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getInternalNetworkInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)142L));
        Assertions.assertThat((long)actual.getInternalNetworkInputPositions()).isEqualTo(152L);
        Assertions.assertThat((Comparable)actual.getRawInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)14L));
        Assertions.assertThat((long)actual.getRawInputPositions()).isEqualTo(15L);
        Assertions.assertThat((Comparable)actual.getProcessedInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)16L));
        Assertions.assertThat((long)actual.getProcessedInputPositions()).isEqualTo(17L);
        Assertions.assertThat((Comparable)actual.getInputBlockedTime()).isEqualTo((Object)new Duration(101.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getOutputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)18L));
        Assertions.assertThat((long)actual.getOutputPositions()).isEqualTo(19L);
        Assertions.assertThat((Comparable)actual.getOutputBlockedTime()).isEqualTo((Object)new Duration(102.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getPhysicalWrittenDataSize()).isEqualTo((Object)DataSize.ofBytes((long)20L));
        Assertions.assertThat((int)actual.getOperatorSummaries().size()).isEqualTo(1);
        TestOperatorStats.assertExpectedOperatorStats((OperatorStats)actual.getOperatorSummaries().get(0));
        Assertions.assertThat((int)actual.getDrivers().size()).isEqualTo(1);
        TestDriverStats.assertExpectedDriverStats((DriverStats)actual.getDrivers().get(0));
    }

    private static Distribution.DistributionSnapshot getTestDistribution(int count) {
        Distribution distribution = new Distribution();
        for (int i = 0; i < count; ++i) {
            distribution.add((long)i);
        }
        return distribution.snapshot();
    }
}

