/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.util.concurrent.MoreExecutors;
import io.trino.Session;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.MemoryTrackingContext;
import io.trino.operator.DriverContext;
import io.trino.operator.OperatorContext;
import io.trino.operator.PipelineContext;
import io.trino.operator.TaskContext;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingSession;
import io.trino.testing.TestingTaskContext;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public final class TestingOperatorContext {
    public static OperatorContext create(ScheduledExecutorService scheduledExecutor) {
        Executor executor = MoreExecutors.directExecutor();
        TaskContext taskContext = TestingTaskContext.createTaskContext((Executor)executor, (ScheduledExecutorService)scheduledExecutor, (Session)TestingSession.testSessionBuilder().build());
        MemoryTrackingContext pipelineMemoryContext = new MemoryTrackingContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext());
        PipelineContext pipelineContext = new PipelineContext(1, taskContext, executor, scheduledExecutor, scheduledExecutor, pipelineMemoryContext, false, false, false);
        DriverContext driverContext = new DriverContext(pipelineContext, executor, scheduledExecutor, scheduledExecutor, pipelineMemoryContext, 0L);
        OperatorContext operatorContext = driverContext.addOperatorContext(1, new PlanNodeId("test"), "operator type");
        return operatorContext;
    }

    private TestingOperatorContext() {
    }
}

