/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join.unspilled;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.trino.SequencePageBuilder;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.operator.DriverContext;
import io.trino.operator.HashArraySizeSupplier;
import io.trino.operator.OperatorContext;
import io.trino.operator.PagesIndex;
import io.trino.operator.TaskContext;
import io.trino.operator.join.unspilled.HashBuilderOperator;
import io.trino.operator.join.unspilled.PartitionedLookupSourceFactory;
import io.trino.spi.Page;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingTaskContext;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestHashBuilderOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;

    @BeforeAll
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
    }

    @AfterAll
    public void tearDown() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdownNow();
            this.scheduledExecutor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() {
        long memoryPoolSizeInBytes = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes();
        TaskContext taskContext = TestingTaskContext.builder((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).setMemoryPoolSize(DataSize.ofBytes((long)memoryPoolSizeInBytes)).build();
        DriverContext driverContext = taskContext.addPipelineContext(0, false, false, false).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, new PlanNodeId("0"), HashBuilderOperator.class.getName());
        OperatorContext anotherOperatorContext = driverContext.addOperatorContext(1, new PlanNodeId("1"), "another operator");
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        PartitionedLookupSourceFactory lookupSourceFactory = new PartitionedLookupSourceFactory((List)types, (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)BigintType.BIGINT), 1, false, new TypeOperators());
        try (HashBuilderOperator operator = new HashBuilderOperator(operatorContext, lookupSourceFactory, 0, (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)1), OptionalInt.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), 10000, (PagesIndex.Factory)new PagesIndex.TestingFactory(false), HashArraySizeSupplier.defaultHashArraySizeSupplier());){
            Assertions.assertThat((Comparable)operator.getState()).isEqualTo((Object)HashBuilderOperator.State.CONSUMING_INPUT);
            ListenableFuture whenBuildFinishes = lookupSourceFactory.whenBuildFinishes();
            Assertions.assertThat((Future)whenBuildFinishes).isNotDone();
            for (int i = 0; i < 100; ++i) {
                Assertions.assertThat((Future)operator.isBlocked()).isDone();
                Assertions.assertThat((boolean)operator.needsInput()).isTrue();
                operator.addInput(TestHashBuilderOperator.somePage((List<Type>)types));
            }
            Assertions.assertThat((boolean)operator.isFinished()).isFalse();
            Assertions.assertThat((Comparable)operator.getState()).isEqualTo((Object)HashBuilderOperator.State.CONSUMING_INPUT);
            anotherOperatorContext.getOperatorMemoryContext().localUserMemoryContext().setBytes(memoryPoolSizeInBytes);
            operator.finish();
            Assertions.assertThat((Comparable)operator.getState()).isEqualTo((Object)HashBuilderOperator.State.CONSUMING_INPUT);
            Assertions.assertThat((boolean)operator.isFinished()).isFalse();
            Assertions.assertThat((Future)whenBuildFinishes).isNotDone();
            Assertions.assertThat((Future)operatorContext.isWaitingForMemory()).isNotDone();
            anotherOperatorContext.getOperatorMemoryContext().localUserMemoryContext().setBytes(0L);
            operator.finish();
            Assertions.assertThat((Comparable)operator.getState()).isEqualTo((Object)HashBuilderOperator.State.LOOKUP_SOURCE_BUILT);
            Assertions.assertThat((boolean)operator.isFinished()).isFalse();
            Assertions.assertThat((Future)whenBuildFinishes).isDone();
            Assertions.assertThat((Future)operator.isBlocked()).isNotDone();
            lookupSourceFactory.destroy();
            Assertions.assertThat((Future)operator.isBlocked()).isDone();
            Assertions.assertThat((Comparable)operator.getState()).isEqualTo((Object)HashBuilderOperator.State.LOOKUP_SOURCE_BUILT);
            operator.finish();
            Assertions.assertThat((Comparable)operator.getState()).isEqualTo((Object)HashBuilderOperator.State.CLOSED);
            Assertions.assertThat((boolean)operator.isFinished()).isTrue();
        }
        finally {
            operatorContext.destroy();
        }
    }

    private static Page somePage(List<Type> types) {
        int[] initialValues = new int[types.size()];
        Arrays.setAll(initialValues, i -> 100 * i);
        return SequencePageBuilder.createSequencePage(types, 7, initialValues);
    }
}

