/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import io.airlift.slice.Slices;
import io.trino.block.BlockAssertions;
import io.trino.operator.output.PositionsAppenderFactory;
import io.trino.operator.output.PositionsAppenderPageBuilder;
import io.trino.operator.output.PositionsAppenderSizeAccumulator;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPositionsAppenderPageBuilder {
    @Test
    public void testFullOnPositionCountLimit() {
        int maxPageBytes = 0x100000;
        int maxDirectSize = maxPageBytes * 10;
        PositionsAppenderPageBuilder pageBuilder = PositionsAppenderPageBuilder.withMaxPageSize((int)maxPageBytes, (int)maxDirectSize, List.of(VarcharType.VARCHAR), (PositionsAppenderFactory)new PositionsAppenderFactory(new BlockTypeOperators()));
        Block rleBlock = RunLengthEncodedBlock.create((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test"), (int)10);
        Page inputPage = new Page(new Block[]{rleBlock});
        IntArrayList positions = IntArrayList.wrap((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
        Assertions.assertEquals((int)32768, (int)32768, (String)"expected MAX_POSITION_COUNT to be 32768");
        for (int i = 0; i < 3276; ++i) {
            pageBuilder.appendToOutputPartition(inputPage, positions);
        }
        Assertions.assertFalse((boolean)pageBuilder.isFull(), (String)"pageBuilder should still not be full");
        pageBuilder.appendToOutputPartition(inputPage, positions);
        Assertions.assertTrue((boolean)pageBuilder.isFull(), (String)"pageBuilder should be full");
        PositionsAppenderSizeAccumulator sizeAccumulator = pageBuilder.computeAppenderSizes();
        Assertions.assertEquals((long)rleBlock.getSizeInBytes(), (long)sizeAccumulator.getSizeInBytes());
        Assertions.assertTrue((sizeAccumulator.getDirectSizeInBytes() < (long)maxDirectSize ? 1 : 0) != 0, (String)"direct size should still be below threshold");
        Assertions.assertEquals((long)sizeAccumulator.getSizeInBytes(), (long)pageBuilder.getSizeInBytes(), (String)"pageBuilder sizeInBytes must match sizeAccumulator value");
    }

    @Test
    public void testFullOnDirectSizeInBytes() {
        int maxPageBytes = 100;
        int maxDirectSize = 1000;
        PositionsAppenderPageBuilder pageBuilder = PositionsAppenderPageBuilder.withMaxPageSize((int)maxPageBytes, (int)maxDirectSize, List.of(VarcharType.VARCHAR), (PositionsAppenderFactory)new PositionsAppenderFactory(new BlockTypeOperators()));
        PositionsAppenderSizeAccumulator sizeAccumulator = pageBuilder.computeAppenderSizes();
        Assertions.assertEquals((long)0L, (long)sizeAccumulator.getSizeInBytes());
        Assertions.assertEquals((long)0L, (long)sizeAccumulator.getDirectSizeInBytes());
        Assertions.assertFalse((boolean)pageBuilder.isFull());
        Block rleBlock = RunLengthEncodedBlock.create((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test"), (int)10);
        Page inputPage = new Page(new Block[]{rleBlock});
        IntArrayList positions = IntArrayList.wrap((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
        pageBuilder.appendToOutputPartition(inputPage, positions);
        sizeAccumulator = pageBuilder.computeAppenderSizes();
        Assertions.assertEquals((long)rleBlock.getSizeInBytes(), (long)sizeAccumulator.getSizeInBytes());
        Assertions.assertEquals((long)sizeAccumulator.getSizeInBytes(), (long)pageBuilder.getSizeInBytes(), (String)"pageBuilder sizeInBytes must match sizeAccumulator value");
        Assertions.assertEquals((long)(rleBlock.getSizeInBytes() * 10L), (long)sizeAccumulator.getDirectSizeInBytes());
        Assertions.assertFalse((boolean)pageBuilder.isFull());
        while (pageBuilder.computeAppenderSizes().getDirectSizeInBytes() < (long)maxDirectSize) {
            pageBuilder.appendToOutputPartition(inputPage, positions);
        }
        sizeAccumulator = pageBuilder.computeAppenderSizes();
        Assertions.assertEquals((long)rleBlock.getSizeInBytes(), (long)sizeAccumulator.getSizeInBytes(), (String)"sizeInBytes must still report the RLE block size only");
        Assertions.assertEquals((long)sizeAccumulator.getSizeInBytes(), (long)pageBuilder.getSizeInBytes(), (String)"pageBuilder sizeInBytes must match sizeAccumulator value");
        Assertions.assertTrue((boolean)pageBuilder.isFull());
        Page result = pageBuilder.build();
        Assertions.assertEquals((int)120, (int)result.getPositionCount(), (String)"result positions should be below the 8192 maximum");
        Assertions.assertTrue((boolean)(result.getBlock(0) instanceof RunLengthEncodedBlock), (String)"result block is RLE encoded");
    }

    @Test
    public void testFlushUsefulDictionariesOnRelease() {
        int maxPageBytes = 100;
        int maxDirectSize = 1000;
        PositionsAppenderPageBuilder pageBuilder = PositionsAppenderPageBuilder.withMaxPageSize((int)maxPageBytes, (int)maxDirectSize, List.of(VarcharType.VARCHAR), (PositionsAppenderFactory)new PositionsAppenderFactory(new BlockTypeOperators()));
        Block valueBlock = Utils.nativeValueToBlock((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test"));
        Block dictionaryBlock = DictionaryBlock.create((int)10, (Block)valueBlock, (int[])new int[10]);
        Page inputPage = new Page(new Block[]{dictionaryBlock});
        pageBuilder.appendToOutputPartition(inputPage, IntArrayList.wrap((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        Assertions.assertEquals((long)40L, (long)pageBuilder.getSizeInBytes());
        Assertions.assertFalse((boolean)pageBuilder.isFull());
        Optional flushedPage = pageBuilder.flushOrFlattenBeforeRelease();
        Assertions.assertTrue((boolean)flushedPage.isPresent(), (String)"pageBuilder should force flush the dictionary");
        Assertions.assertTrue((boolean)(((Page)flushedPage.get()).getBlock(0) instanceof DictionaryBlock), (String)"result should be dictionary encoded");
    }

    @Test
    public void testFlattenUnhelpfulDictionariesOnRelease() {
        ValueBlock valueBlock = BlockAssertions.createRandomBlockForType((Type)VarcharType.VARCHAR, 10, 0.25f);
        Block dictionaryBlock = DictionaryBlock.create((int)10, (Block)valueBlock, (int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
        Page inputPage = new Page(new Block[]{dictionaryBlock});
        int maxPageBytes = Math.toIntExact(valueBlock.getSizeInBytes() * 10L);
        int maxDirectSize = maxPageBytes * 10;
        PositionsAppenderPageBuilder pageBuilder = PositionsAppenderPageBuilder.withMaxPageSize((int)maxPageBytes, (int)maxDirectSize, List.of(VarcharType.VARCHAR), (PositionsAppenderFactory)new PositionsAppenderFactory(new BlockTypeOperators()));
        pageBuilder.appendToOutputPartition(inputPage, IntArrayList.wrap((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        Assertions.assertEquals((long)40L, (long)pageBuilder.getSizeInBytes());
        Assertions.assertFalse((boolean)pageBuilder.isFull());
        Assertions.assertEquals(Optional.empty(), (Object)pageBuilder.flushOrFlattenBeforeRelease(), (String)"pageBuilder should not force a flush");
        Assertions.assertFalse((boolean)pageBuilder.isFull());
        Assertions.assertEquals((long)valueBlock.getSizeInBytes(), (long)pageBuilder.getSizeInBytes(), (String)"pageBuilder should have transitioned to direct mode");
        Page result = pageBuilder.build();
        Assertions.assertTrue((boolean)(result.getBlock(0) instanceof ValueBlock), (String)"result should not be a dictionary block");
    }
}

