/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestArrayMatchFunctions {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testAllMatch() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("all_match(a, x -> x % 2 = 1)").binding("a", "ARRAY[5, 7, 9]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("all_match(a, x -> x)").binding("a", "ARRAY[true, false, true]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("all_match(a, x -> substr(x, 1, 1) = 'a')").binding("a", "ARRAY['abc', 'ade', 'afg']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("all_match(a, x -> true)").binding("a", "ARRAY[]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("all_match(a, x -> x)").binding("a", "ARRAY[true, true, NULL]")))).matches("CAST(NULL AS boolean)");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("all_match(a, x -> x)").binding("a", "ARRAY[true, false, NULL]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("all_match(a, x -> x > 1)").binding("a", "ARRAY[NULL, NULL, NULL]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("all_match(a, x -> x IS NULL)").binding("a", "ARRAY[NULL, NULL, NULL]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("all_match(a, x -> cardinality(x) > 1)").binding("a", "ARRAY[MAP(ARRAY[1,2], ARRAY[3,4]), MAP(ARRAY[1,2,3], ARRAY[3,4,5])]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("all_match(a, t -> month(t) = 5)").binding("a", "ARRAY[TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '1111-05-10 12:34:56.123456789']")))).isEqualTo(true);
    }

    @Test
    public void testAnyMatch() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("any_match(a, x -> x % 2 = 1)").binding("a", "ARRAY[5, 8, 10]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("any_match(a, x -> x)").binding("a", "ARRAY[false, false, false]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("any_match(a, x -> substr(x, 1, 1) = 'a')").binding("a", "ARRAY['abc', 'def', 'ghi']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("any_match(a, x -> true)").binding("a", "ARRAY[]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("any_match(a, x -> x)").binding("a", "ARRAY[false, false, NULL]")))).matches("CAST(NULL AS boolean)");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("any_match(a, x -> x)").binding("a", "ARRAY[true, false, NULL]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("any_match(a, x -> x > 1)").binding("a", "ARRAY[NULL, NULL, NULL]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("any_match(a, x -> x IS NULL)").binding("a", "ARRAY[true, false, NULL]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("any_match(a, x -> cardinality(x) > 4)").binding("a", "ARRAY[MAP(ARRAY[1,2], ARRAY[3,4]), MAP(ARRAY[1,2,3], ARRAY[3,4,5])]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("any_match(a, t -> year(t) = 2020)").binding("a", "ARRAY[TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '1111-05-10 12:34:56.123456789']")))).isEqualTo(true);
    }

    @Test
    public void testNoneMatch() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("none_match(a, x -> x % 2 = 1)").binding("a", "ARRAY[5, 8, 10]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("none_match(a, x -> x)").binding("a", "ARRAY[false, false, false]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("none_match(a, x -> substr(x, 1, 1) = 'a')").binding("a", "ARRAY['abc', 'def', 'ghi']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("none_match(a, x -> true)").binding("a", "ARRAY[]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("none_match(a, x -> x)").binding("a", "ARRAY[false, false, NULL]")))).matches("CAST(NULL AS boolean)");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("none_match(a, x -> x)").binding("a", "ARRAY[true, false, NULL]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("none_match(a, x -> x > 1)").binding("a", "ARRAY[NULL, NULL, NULL]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("none_match(a, x -> x IS NULL)").binding("a", "ARRAY[true, false, NULL]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("none_match(a, x -> cardinality(x) > 4)").binding("a", "ARRAY[MAP(ARRAY[1,2], ARRAY[3,4]), MAP(ARRAY[1,2,3], ARRAY[3,4,5])]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("none_match(a, t -> month(t) = 10)").binding("a", "ARRAY[TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '1111-05-10 12:34:56.123456789']")))).isEqualTo(true);
    }
}

