/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.metadata.InternalFunctionBundle;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestOperatorValidation {
    @Test
    public void testInvalidArgumentCount() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestOperatorValidation.extractScalars(InvalidArgumentCount.class)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("ADD operator must have exactly 2 argument.*");
    }

    private static void extractScalars(Class<?> clazz) {
        InternalFunctionBundle.builder().scalars(clazz);
    }

    public static final class InvalidArgumentCount {
        @ScalarOperator(value=OperatorType.ADD)
        @SqlType(value="bigint")
        public static long add(@SqlType(value="bigint") long value) {
            return 0L;
        }
    }
}

