/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.type.JsonType;
import io.trino.type.UnknownType;
import java.util.Arrays;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestTryFunction {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
        this.assertions.addFunctions((FunctionBundle)InternalFunctionBundle.builder().scalars(TestTryFunction.class).build());
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @ScalarFunction
    @SqlType(value="bigint")
    public static long throwError() {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "internal error, should not be suppressed by $internal$try");
    }

    @Test
    public void testBasic() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try(42)")))).isEqualTo(42);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try(DOUBLE '4.5')")))).isEqualTo(4.5);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try(DECIMAL '4.5')")))).matches("4.5");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try(TRUE)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try('hello')")))).hasType((Type)VarcharType.createVarcharType((int)5)).isEqualTo("hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try(JSON '[true, false, 12, 12.7, \"12\", null]')")))).matches("JSON '[true,false,12,12.7,\"12\",null]'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try(ARRAY [1, 2])")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Arrays.asList(1, 2));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("TIMESTAMP '2020-05-10 12:34:56.123456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try(NULL)")))).isNull((Type)UnknownType.UNKNOWN);
    }

    @Test
    public void testExceptions() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try(1/a)").binding("a", "0")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try(json_parse(a))").binding("a", "'INVALID'")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try(CAST(a AS INTEGER))").binding("a", "NULL")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try(CAST(a AS TIMESTAMP))").binding("a", "'0000-00-01'")))).isNull((Type)TimestampType.TIMESTAMP_MILLIS);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try(CAST(a AS TIMESTAMP WITH TIME ZONE))").binding("a", "'0000-01-01 ABC'")))).isNull((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try(abs(a))").binding("a", "-9223372036854775807 - 1")))).isNull((Type)BigintType.BIGINT);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("try(throw_error())")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.GENERIC_INTERNAL_ERROR});
    }
}

