/*
 * Decompiled with CFR 0.152.
 */
package io.trino.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.client.NodeVersion;
import io.trino.connector.CatalogServiceProvider;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.eventlistener.EventListenerManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.QualifiedObjectName;
import io.trino.plugin.base.security.AllowAllAccessControl;
import io.trino.plugin.base.security.AllowAllSystemAccessControl;
import io.trino.plugin.base.security.ReadOnlySystemAccessControl;
import io.trino.security.AccessControl;
import io.trino.security.AccessControlConfig;
import io.trino.security.AccessControlManager;
import io.trino.security.SecurityContext;
import io.trino.spi.Plugin;
import io.trino.spi.QueryId;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaRoutineName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.BasicPrincipal;
import io.trino.spi.security.Identity;
import io.trino.spi.security.SystemAccessControl;
import io.trino.spi.security.SystemAccessControlFactory;
import io.trino.spi.security.SystemSecurityContext;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingEventListenerManager;
import io.trino.testing.TransactionBuilder;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAccessControlManager {
    private static final Principal PRINCIPAL = new BasicPrincipal("principal");
    private static final String USER_NAME = "user_name";
    private static final QueryId queryId = new QueryId("query_id");
    private static final Instant queryStart = Instant.now();

    @Test
    public void testInitializing() {
        AccessControlManager accessControlManager = TestAccessControlManager.createAccessControlManager(InMemoryTransactionManager.createTestTransactionManager());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanImpersonateUser(Identity.forUser((String)"test").build(), "foo")).isInstanceOf(TrinoException.class)).hasMessage("Trino server is still initializing");
    }

    @Test
    public void testNoneSystemAccessControl() {
        AccessControlManager accessControlManager = TestAccessControlManager.createAccessControlManager(InMemoryTransactionManager.createTestTransactionManager());
        accessControlManager.loadSystemAccessControl("allow-all", (Map)ImmutableMap.of());
        accessControlManager.checkCanImpersonateUser(Identity.forUser((String)"test").build(), "foo");
    }

    @Test
    public void testReadOnlySystemAccessControl() {
        Identity identity = Identity.forUser((String)USER_NAME).withPrincipal(PRINCIPAL).build();
        QualifiedObjectName tableName = new QualifiedObjectName("test_catalog", "schema", "table");
        TestAccessControlManager.assertAccessControl((SystemAccessControl)new ReadOnlySystemAccessControl(), (ConnectorAccessControl)new AllowAllAccessControl(), (accessControlManager, securityContext) -> {
            accessControlManager.checkCanSetUser(Optional.of(PRINCIPAL), USER_NAME);
            accessControlManager.checkCanSetSystemSessionProperty(identity, "property");
            accessControlManager.checkCanSetCatalogSessionProperty(securityContext, "test_catalog", "property");
            accessControlManager.checkCanShowSchemas(securityContext, "test_catalog");
            accessControlManager.checkCanShowTables(securityContext, new CatalogSchemaName("test_catalog", "schema"));
            accessControlManager.checkCanSelectFromColumns(securityContext, tableName, (Set)ImmutableSet.of((Object)"column"));
            accessControlManager.checkCanCreateViewWithSelectFromColumns(securityContext, tableName, (Set)ImmutableSet.of((Object)"column"));
            ImmutableSet catalogs = ImmutableSet.of((Object)"test_catalog");
            Assertions.assertThat((Collection)accessControlManager.filterCatalogs(securityContext, (Set)catalogs)).isEqualTo((Object)catalogs);
            ImmutableSet schemas = ImmutableSet.of((Object)"schema");
            Assertions.assertThat((Collection)accessControlManager.filterSchemas(securityContext, "test_catalog", (Set)schemas)).isEqualTo((Object)schemas);
            ImmutableSet tableNames = ImmutableSet.of((Object)new SchemaTableName("schema", "table"));
            Assertions.assertThat((Collection)accessControlManager.filterTables(securityContext, "test_catalog", (Set)tableNames)).isEqualTo((Object)tableNames);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanInsertIntoTable(securityContext, tableName)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot insert into table test_catalog.schema.table");
        });
    }

    @Test
    public void testNoCatalogAccessControl() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
        AccessControlManager accessControlManager = TestAccessControlManager.createAccessControlManager(transactionManager);
        accessControlManager.setSystemAccessControls((List)ImmutableList.of((Object)new TestSystemAccessControl()));
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanSelectFromColumns(TestAccessControlManager.context(transactionId), new QualifiedObjectName("test_catalog", "schema", "table"), (Set)ImmutableSet.of((Object)"column")));
    }

    @Test
    public void testDenyCatalogAccessControl() {
        TestAccessControlManager.assertAccessControl((SystemAccessControl)new AllowAllSystemAccessControl(), new DenyConnectorAccessControl(), (accessControlManager, securityContext) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSelectFromColumns(securityContext, new QualifiedObjectName("test_catalog", "schema", "table"), (Set)ImmutableSet.of((Object)"column"))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot select from columns [column] in table or view schema.table"));
    }

    @Test
    public void testDenySystemAccessControl() {
        TestAccessControlManager.assertAccessControl(new TestSystemAccessControl(), (ConnectorAccessControl)new AllowAllAccessControl(), (accessControlManager, securityContext) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSelectFromColumns(securityContext, new QualifiedObjectName("secured_catalog", "schema", "table"), (Set)ImmutableSet.of((Object)"column"))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot select from table secured_catalog.schema.table"));
    }

    @Test
    public void testDenyExecuteProcedureBySystem() {
        TestAccessControlManager.assertAccessControl(new TestSystemAccessControl(), (ConnectorAccessControl)new AllowAllAccessControl(), (accessControlManager, securityContext) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanExecuteProcedure(securityContext, new QualifiedObjectName("test_catalog", "schema", "procedure"))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot execute procedure test_catalog.schema.procedure"));
    }

    @Test
    public void testDenyExecuteProcedureByConnector() {
        TestAccessControlManager.assertAccessControl((SystemAccessControl)new AllowAllSystemAccessControl(), new DenyConnectorAccessControl(), (accessControlManager, securityContext) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanExecuteProcedure(securityContext, new QualifiedObjectName("test_catalog", "schema", "procedure"))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot execute procedure schema.procedure"));
    }

    @Test
    public void testAllowExecuteProcedure() {
        TestAccessControlManager.assertAccessControl((SystemAccessControl)new AllowAllSystemAccessControl(), (ConnectorAccessControl)new AllowAllAccessControl(), (accessControlManager, securityContext) -> accessControlManager.checkCanExecuteProcedure(securityContext, new QualifiedObjectName("test_catalog", "schema", "procedure")));
    }

    @Test
    public void testRegisterSingleEventListenerForDefaultAccessControl() {
        EventListener expectedListener = new EventListener(this){};
        String defaultAccessControlName = "event-listening-default-access-control";
        TestingEventListenerManager eventListenerManager = TestingEventListenerManager.emptyEventListenerManager();
        AccessControlManager accessControlManager = TestAccessControlManager.createAccessControlManager((EventListenerManager)eventListenerManager, defaultAccessControlName);
        accessControlManager.addSystemAccessControlFactory(TestAccessControlManager.eventListeningSystemAccessControlFactory(defaultAccessControlName, expectedListener));
        accessControlManager.loadSystemAccessControl();
        Assertions.assertThat((Collection)eventListenerManager.getConfiguredEventListeners()).contains((Object[])new EventListener[]{expectedListener});
    }

    @Test
    public void testRegisterMultipleEventListenerForDefaultAccessControl() {
        EventListener firstListener = new EventListener(this){};
        EventListener secondListener = new EventListener(this){};
        String defaultAccessControlName = "event-listening-default-access-control";
        TestingEventListenerManager eventListenerManager = TestingEventListenerManager.emptyEventListenerManager();
        AccessControlManager accessControlManager = TestAccessControlManager.createAccessControlManager((EventListenerManager)eventListenerManager, defaultAccessControlName);
        accessControlManager.addSystemAccessControlFactory(TestAccessControlManager.eventListeningSystemAccessControlFactory(defaultAccessControlName, firstListener, secondListener));
        accessControlManager.loadSystemAccessControl();
        Assertions.assertThat((Collection)eventListenerManager.getConfiguredEventListeners()).contains((Object[])new EventListener[]{firstListener, secondListener});
    }

    @Test
    public void testRegisterSingleEventListener() throws IOException {
        EventListener expectedListener = new EventListener(this){};
        String systemAccessControlName = "event-listening-sac";
        TestingEventListenerManager eventListenerManager = TestingEventListenerManager.emptyEventListenerManager();
        AccessControlManager accessControlManager = TestAccessControlManager.createAccessControlManager(eventListenerManager, (List<String>)ImmutableList.of((Object)("access-control.name=" + systemAccessControlName)));
        accessControlManager.addSystemAccessControlFactory(TestAccessControlManager.eventListeningSystemAccessControlFactory(systemAccessControlName, expectedListener));
        accessControlManager.loadSystemAccessControl();
        Assertions.assertThat((Collection)eventListenerManager.getConfiguredEventListeners()).contains((Object[])new EventListener[]{expectedListener});
    }

    @Test
    public void testRegisterMultipleEventListeners() throws IOException {
        EventListener firstListener = new EventListener(this){};
        EventListener secondListener = new EventListener(this){};
        String systemAccessControlName = "event-listening-sac";
        TestingEventListenerManager eventListenerManager = TestingEventListenerManager.emptyEventListenerManager();
        AccessControlManager accessControlManager = TestAccessControlManager.createAccessControlManager(eventListenerManager, (List<String>)ImmutableList.of((Object)("access-control.name=" + systemAccessControlName)));
        accessControlManager.addSystemAccessControlFactory(TestAccessControlManager.eventListeningSystemAccessControlFactory(systemAccessControlName, firstListener, secondListener));
        accessControlManager.loadSystemAccessControl();
        Assertions.assertThat((Collection)eventListenerManager.getConfiguredEventListeners()).contains((Object[])new EventListener[]{firstListener, secondListener});
    }

    @Test
    public void testDenyExecuteFunctionBySystemAccessControl() {
        QualifiedObjectName functionName = new QualifiedObjectName("test_catalog", "schema", "executed_function");
        TestAccessControlManager.assertAccessControl(new TestSystemAccessControl(), (ConnectorAccessControl)new AllowAllAccessControl(), (accessControlManager, securityContext) -> {
            Assertions.assertThat((boolean)accessControlManager.canExecuteFunction(securityContext, functionName)).isFalse();
            Assertions.assertThat((boolean)accessControlManager.canCreateViewWithExecuteFunction(securityContext, functionName)).isFalse();
        });
    }

    @Test
    public void testAllowExecuteFunction() {
        QualifiedObjectName functionName = new QualifiedObjectName("test_catalog", "schema", "executed_function");
        TestAccessControlManager.assertAccessControl((SystemAccessControl)new AllowAllSystemAccessControl(), (ConnectorAccessControl)new AllowAllAccessControl(), (accessControlManager, securityContext) -> {
            Assertions.assertThat((boolean)accessControlManager.canExecuteFunction(securityContext, functionName)).isTrue();
            Assertions.assertThat((boolean)accessControlManager.canCreateViewWithExecuteFunction(securityContext, functionName)).isTrue();
        });
    }

    @Test
    public void testAllowExecuteTableFunction() {
        QualifiedObjectName functionName = new QualifiedObjectName("test_catalog", "schema", "executed_function");
        TestAccessControlManager.assertAccessControl((SystemAccessControl)new AllowAllSystemAccessControl(), (ConnectorAccessControl)new AllowAllAccessControl(), (accessControlManager, securityContext) -> {
            Assertions.assertThat((boolean)accessControlManager.canExecuteFunction(securityContext, functionName)).isTrue();
            Assertions.assertThat((boolean)accessControlManager.canCreateViewWithExecuteFunction(securityContext, functionName)).isTrue();
        });
    }

    @Test
    public void testRemovedMethodsCannotBeDeclared() {
        try (StandaloneQueryRunner queryRunner = new StandaloneQueryRunner(SessionTestUtils.TEST_SESSION);){
            TransactionManager transactionManager = queryRunner.getTransactionManager();
            AccessControlManager accessControlManager = TestAccessControlManager.createAccessControlManager(transactionManager);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.setSystemAccessControls((List)ImmutableList.of((Object)new AllowAllSystemAccessControl(this){

                public void checkCanAccessCatalog(SystemSecurityContext context, String catalogName) {
                }
            }))).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Access control .* must not implement removed method checkCanAccessCatalog\\(.*\\)");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.setSystemAccessControls((List)ImmutableList.of((Object)new AllowAllSystemAccessControl(this){

                public void checkCanGrantExecuteFunctionPrivilege(SystemSecurityContext context, String functionName, TrinoPrincipal grantee, boolean grantOption) {
                }
            }))).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Access control .* must not implement removed method checkCanGrantExecuteFunctionPrivilege\\(.*\\)");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.setSystemAccessControls((List)ImmutableList.of((Object)new AllowAllSystemAccessControl(this){

                public void checkCanExecuteFunction(SystemSecurityContext systemSecurityContext, String functionName) {
                }
            }))).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Access control .* must not implement removed method checkCanExecuteFunction\\(.*\\)");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.setSystemAccessControls((List)ImmutableList.of((Object)new AllowAllSystemAccessControl(this){

                public void checkCanExecuteFunction(SystemSecurityContext systemSecurityContext, FunctionKind functionKind, CatalogSchemaRoutineName functionName) {
                }
            }))).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Access control .* must not implement removed method checkCanExecuteFunction\\(.*\\)");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.setSystemAccessControls((List)ImmutableList.of((Object)new AllowAllSystemAccessControl(this){

                public void checkCanGrantExecuteFunctionPrivilege(SystemSecurityContext context, FunctionKind functionKind, CatalogSchemaRoutineName functionName, TrinoPrincipal grantee, boolean grantOption) {
                }
            }))).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Access control .* must not implement removed method checkCanGrantExecuteFunctionPrivilege\\(.*\\)");
            accessControlManager.setSystemAccessControls((List)ImmutableList.of((Object)new AllowAllSystemAccessControl()));
        }
    }

    private static void assertAccessControl(SystemAccessControl systemAccessControl, ConnectorAccessControl accessControl, BiConsumer<AccessControlManager, SecurityContext> test) {
        try (StandaloneQueryRunner queryRunner = new StandaloneQueryRunner(SessionTestUtils.TEST_SESSION);){
            TransactionManager transactionManager = queryRunner.getTransactionManager();
            AccessControlManager accessControlManager = TestAccessControlManager.createAccessControlManager(transactionManager);
            accessControlManager.setSystemAccessControls((List)ImmutableList.of((Object)systemAccessControl));
            queryRunner.installPlugin((Plugin)new MockConnectorPlugin(MockConnectorFactory.create()));
            queryRunner.createCatalog("test_catalog", "mock", (Map)ImmutableMap.of());
            queryRunner.inTransaction(arg_0 -> TestAccessControlManager.lambda$assertAccessControl$21((QueryRunner)queryRunner, accessControlManager, accessControl, test, arg_0));
        }
    }

    private static SecurityContext context(TransactionId transactionId) {
        Identity identity = Identity.forUser((String)USER_NAME).withPrincipal(PRINCIPAL).build();
        return new SecurityContext(transactionId, identity, queryId, queryStart);
    }

    private static AccessControlManager createAccessControlManager(TestingEventListenerManager eventListenerManager, List<String> systemAccessControlProperties) throws IOException {
        Path systemAccessControlConfig = Files.createTempFile("access-control-config-file", ".properties", new FileAttribute[0]);
        Files.write(systemAccessControlConfig, systemAccessControlProperties, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        String accessControlConfigPath = systemAccessControlConfig.toFile().getAbsolutePath();
        return TestAccessControlManager.createAccessControlManager((EventListenerManager)eventListenerManager, new AccessControlConfig().setAccessControlFiles(accessControlConfigPath));
    }

    private static AccessControlManager createAccessControlManager(TransactionManager testTransactionManager) {
        return new AccessControlManager(NodeVersion.UNKNOWN, testTransactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager(), new AccessControlConfig(), OpenTelemetry.noop(), "default");
    }

    private static AccessControlManager createAccessControlManager(EventListenerManager eventListenerManager, AccessControlConfig config) {
        return new AccessControlManager(NodeVersion.UNKNOWN, InMemoryTransactionManager.createTestTransactionManager(), eventListenerManager, config, OpenTelemetry.noop(), "default");
    }

    private static AccessControlManager createAccessControlManager(EventListenerManager eventListenerManager, String defaultAccessControlName) {
        return new AccessControlManager(NodeVersion.UNKNOWN, InMemoryTransactionManager.createTestTransactionManager(), eventListenerManager, new AccessControlConfig(), OpenTelemetry.noop(), defaultAccessControlName);
    }

    private static SystemAccessControlFactory eventListeningSystemAccessControlFactory(final String name, final EventListener ... eventListeners) {
        return new SystemAccessControlFactory(){

            public String getName() {
                return name;
            }

            public SystemAccessControl create(Map<String, String> config) {
                return new SystemAccessControl(){

                    public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
                    }

                    public Iterable<EventListener> getEventListeners() {
                        return ImmutableSet.copyOf((Object[])eventListeners);
                    }
                };
            }
        };
    }

    private static /* synthetic */ Object lambda$assertAccessControl$21(QueryRunner queryRunner, AccessControlManager accessControlManager, ConnectorAccessControl accessControl, BiConsumer test, Session transactionSession) {
        CatalogHandle catalogHandle = (CatalogHandle)queryRunner.getPlannerContext().getMetadata().getCatalogHandle(transactionSession, "test_catalog").orElseThrow();
        accessControlManager.setConnectorAccessControlProvider(CatalogServiceProvider.singleton((CatalogHandle)catalogHandle, Optional.of(accessControl)));
        test.accept(accessControlManager, TestAccessControlManager.context(transactionSession.getRequiredTransactionId()));
        return null;
    }

    private static class TestSystemAccessControl
    implements SystemAccessControl {
        private TestSystemAccessControl() {
        }

        public boolean canAccessCatalog(SystemSecurityContext context, String catalogName) {
            return true;
        }

        public void checkCanSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
            if (table.getCatalogName().equals("secured_catalog")) {
                AccessDeniedException.denySelectTable((String)table.toString());
            }
        }

        public Set<String> filterCatalogs(SystemSecurityContext context, Set<String> catalogs) {
            return catalogs;
        }
    }

    private static class DenyConnectorAccessControl
    implements ConnectorAccessControl {
        private DenyConnectorAccessControl() {
        }
    }
}

