/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.cost.StatsAndCosts;
import io.trino.execution.DynamicFilterConfig;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.TableHandle;
import io.trino.operator.RetryPolicy;
import io.trino.server.DynamicFilterService;
import io.trino.spi.QueryId;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.TestingColumnHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.DynamicFilters;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.RemoteSourceNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.SymbolReference;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSession;
import io.trino.util.DynamicFiltersTestUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDynamicFilterService {
    private static final Session session = TestingSession.testSessionBuilder().build();

    @Test
    public void testDynamicFilterSummaryCompletion() {
        DynamicFilterService dynamicFilterService = TestDynamicFilterService.createDynamicFilterService();
        DynamicFilterId filterId = new DynamicFilterId("df");
        QueryId queryId = new QueryId("query");
        StageId stageId = new StageId(queryId, 0);
        dynamicFilterService.registerQuery(queryId, session, (Set)ImmutableSet.of((Object)filterId), (Set)ImmutableSet.of((Object)filterId), (Set)ImmutableSet.of());
        dynamicFilterService.stageCannotScheduleMoreTasks(stageId, 0, 3);
        Assertions.assertThat((boolean)dynamicFilterService.getSummary(queryId, filterId).isPresent()).isFalse();
        DynamicFilterService.DynamicFiltersStats stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assertions.assertThat((int)stats.getTotalDynamicFilters()).isEqualTo(1);
        Assertions.assertThat((int)stats.getDynamicFiltersCompleted()).isEqualTo(0);
        Assertions.assertThat((int)stats.getLazyDynamicFilters()).isEqualTo(1);
        Assertions.assertThat((int)stats.getReplicatedDynamicFilters()).isEqualTo(0);
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 0, 0), (Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)));
        Assertions.assertThat((boolean)dynamicFilterService.getSummary(queryId, filterId).isPresent()).isFalse();
        stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assertions.assertThat((int)stats.getDynamicFiltersCompleted()).isEqualTo(0);
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 1, 0), (Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L)));
        Assertions.assertThat((boolean)dynamicFilterService.getSummary(queryId, filterId).isPresent()).isFalse();
        stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assertions.assertThat((int)stats.getDynamicFiltersCompleted()).isEqualTo(0);
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 2, 0), (Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)3L)));
        Optional summary = dynamicFilterService.getSummary(queryId, filterId);
        Assertions.assertThat((boolean)summary.isPresent()).isTrue();
        Assertions.assertThat((Object)((Domain)summary.get())).isEqualTo((Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)));
        stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assertions.assertThat((int)stats.getDynamicFiltersCompleted()).isEqualTo(1);
        Assertions.assertThat((int)stats.getLazyDynamicFilters()).isEqualTo(1);
        Assertions.assertThat((int)stats.getReplicatedDynamicFilters()).isEqualTo(0);
        Assertions.assertThat((List)stats.getDynamicFilterDomainStats()).isEqualTo((Object)ImmutableList.of((Object)new DynamicFilterService.DynamicFilterDomainStats(filterId, DynamicFiltersTestUtil.getSimplifiedDomainString(1L, 3L, 3, (Type)IntegerType.INTEGER))));
    }

    @Test
    public void testDynamicFilter() {
        DynamicFilterService dynamicFilterService = TestDynamicFilterService.createDynamicFilterService();
        DynamicFilterId filterId1 = new DynamicFilterId("df1");
        DynamicFilterId filterId2 = new DynamicFilterId("df2");
        DynamicFilterId filterId3 = new DynamicFilterId("df3");
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol1 = symbolAllocator.newSymbol("DF_SYMBOL1", (Type)IntegerType.INTEGER);
        Symbol symbol2 = symbolAllocator.newSymbol("DF_SYMBOL2", (Type)IntegerType.INTEGER);
        Symbol symbol3 = symbolAllocator.newSymbol("DF_SYMBOL3", (Type)IntegerType.INTEGER);
        SymbolReference df1 = symbol1.toSymbolReference();
        SymbolReference df2 = symbol2.toSymbolReference();
        SymbolReference df3 = symbol3.toSymbolReference();
        QueryId queryId = new QueryId("query");
        StageId stageId1 = new StageId(queryId, 1);
        StageId stageId2 = new StageId(queryId, 2);
        StageId stageId3 = new StageId(queryId, 3);
        dynamicFilterService.registerQuery(queryId, session, (Set)ImmutableSet.of((Object)filterId1, (Object)filterId2, (Object)filterId3), (Set)ImmutableSet.of((Object)filterId1, (Object)filterId2, (Object)filterId3), (Set)ImmutableSet.of());
        dynamicFilterService.stageCannotScheduleMoreTasks(stageId1, 0, 2);
        dynamicFilterService.stageCannotScheduleMoreTasks(stageId2, 0, 2);
        dynamicFilterService.stageCannotScheduleMoreTasks(stageId3, 0, 2);
        DynamicFilter dynamicFilter = dynamicFilterService.createDynamicFilter(queryId, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId1, (Expression)df1), (Object)new DynamicFilters.Descriptor(filterId2, (Expression)df2), (Object)new DynamicFilters.Descriptor(filterId3, (Expression)df3)), (Map)ImmutableMap.of((Object)symbol1, (Object)new TestingColumnHandle("probeColumnA"), (Object)symbol2, (Object)new TestingColumnHandle("probeColumnA"), (Object)symbol3, (Object)new TestingColumnHandle("probeColumnB")), symbolAllocator.getTypes());
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)dynamicFilter.getColumnsCovered()).describedAs("columns covered", new Object[0])).isEqualTo(Set.of(new TestingColumnHandle("probeColumnA"), new TestingColumnHandle("probeColumnB")));
        Assertions.assertThat((boolean)dynamicFilter.getCurrentPredicate().isAll()).isTrue();
        Assertions.assertThat((boolean)dynamicFilter.isComplete()).isFalse();
        Assertions.assertThat((boolean)dynamicFilter.isAwaitable()).isTrue();
        DynamicFilterService.DynamicFiltersStats stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assertions.assertThat((int)stats.getTotalDynamicFilters()).isEqualTo(3);
        Assertions.assertThat((int)stats.getDynamicFiltersCompleted()).isEqualTo(0);
        Assertions.assertThat((int)stats.getLazyDynamicFilters()).isEqualTo(3);
        Assertions.assertThat((int)stats.getReplicatedDynamicFilters()).isEqualTo(0);
        CompletableFuture blockedFuture = dynamicFilter.isBlocked();
        Assertions.assertThat((boolean)blockedFuture.isDone()).isFalse();
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId1, 0, 0), (Map)ImmutableMap.of((Object)filterId1, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)));
        Assertions.assertThat((boolean)dynamicFilter.getCurrentPredicate().isAll()).isTrue();
        Assertions.assertThat((boolean)dynamicFilter.isComplete()).isFalse();
        Assertions.assertThat((boolean)dynamicFilter.isAwaitable()).isTrue();
        Assertions.assertThat((boolean)blockedFuture.isDone()).isFalse();
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId1, 1, 0), (Map)ImmutableMap.of((Object)filterId1, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L)));
        Assertions.assertThat((Object)dynamicFilter.getCurrentPredicate()).isEqualTo((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("probeColumnA"), (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)1L, (Object)2L)))));
        Assertions.assertThat((boolean)blockedFuture.isDone()).isTrue();
        Assertions.assertThat((boolean)blockedFuture.isCompletedExceptionally()).isFalse();
        stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assertions.assertThat((int)stats.getDynamicFiltersCompleted()).isEqualTo(1);
        Assertions.assertThat((boolean)dynamicFilter.isComplete()).isFalse();
        Assertions.assertThat((boolean)dynamicFilter.isAwaitable()).isTrue();
        blockedFuture = dynamicFilter.isBlocked();
        Assertions.assertThat((boolean)blockedFuture.isDone()).isFalse();
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId2, 0, 0), (Map)ImmutableMap.of((Object)filterId2, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L)));
        Assertions.assertThat((Object)dynamicFilter.getCurrentPredicate()).isEqualTo((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("probeColumnA"), (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)1L, (Object)2L)))));
        Assertions.assertThat((boolean)dynamicFilter.isComplete()).isFalse();
        Assertions.assertThat((boolean)dynamicFilter.isAwaitable()).isTrue();
        Assertions.assertThat((boolean)blockedFuture.isDone()).isFalse();
        stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assertions.assertThat((int)stats.getDynamicFiltersCompleted()).isEqualTo(1);
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId2, 1, 0), (Map)ImmutableMap.of((Object)filterId2, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)3L)));
        Assertions.assertThat((Object)dynamicFilter.getCurrentPredicate()).isEqualTo((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("probeColumnA"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L))));
        Assertions.assertThat((boolean)blockedFuture.isDone()).isTrue();
        Assertions.assertThat((boolean)blockedFuture.isCompletedExceptionally()).isFalse();
        stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assertions.assertThat((int)stats.getDynamicFiltersCompleted()).isEqualTo(2);
        Assertions.assertThat((boolean)dynamicFilter.isComplete()).isFalse();
        Assertions.assertThat((boolean)dynamicFilter.isAwaitable()).isTrue();
        blockedFuture = dynamicFilter.isBlocked();
        Assertions.assertThat((boolean)blockedFuture.isDone()).isFalse();
        DynamicFilter dynamicFilterColumnA = dynamicFilterService.createDynamicFilter(queryId, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId1, (Expression)df1), (Object)new DynamicFilters.Descriptor(filterId2, (Expression)df2)), (Map)ImmutableMap.of((Object)symbol1, (Object)new TestingColumnHandle("probeColumnA"), (Object)symbol2, (Object)new TestingColumnHandle("probeColumnA")), symbolAllocator.getTypes());
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)dynamicFilterColumnA.getColumnsCovered()).describedAs("columns covered", new Object[0])).isEqualTo(Set.of(new TestingColumnHandle("probeColumnA")));
        Assertions.assertThat((boolean)dynamicFilterColumnA.isComplete()).isTrue();
        Assertions.assertThat((boolean)dynamicFilterColumnA.isAwaitable()).isFalse();
        Assertions.assertThat((boolean)dynamicFilterColumnA.isBlocked().isDone()).isTrue();
        Assertions.assertThat((Object)dynamicFilterColumnA.getCurrentPredicate()).isEqualTo((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("probeColumnA"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L))));
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId3, 0, 0), (Map)ImmutableMap.of((Object)filterId3, (Object)Domain.none((Type)IntegerType.INTEGER)));
        Assertions.assertThat((Object)dynamicFilter.getCurrentPredicate()).isEqualTo((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("probeColumnA"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L))));
        Assertions.assertThat((boolean)dynamicFilter.isComplete()).isFalse();
        Assertions.assertThat((boolean)dynamicFilter.isAwaitable()).isTrue();
        Assertions.assertThat((boolean)blockedFuture.isDone()).isFalse();
        stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assertions.assertThat((int)stats.getDynamicFiltersCompleted()).isEqualTo(2);
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId3, 1, 0), (Map)ImmutableMap.of((Object)filterId3, (Object)Domain.none((Type)IntegerType.INTEGER)));
        Assertions.assertThat((Object)dynamicFilter.getCurrentPredicate()).isEqualTo((Object)TupleDomain.none());
        Assertions.assertThat((boolean)blockedFuture.isDone()).isTrue();
        Assertions.assertThat((boolean)blockedFuture.isCompletedExceptionally()).isFalse();
        stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assertions.assertThat((int)stats.getDynamicFiltersCompleted()).isEqualTo(3);
        Assertions.assertThat((int)stats.getLazyDynamicFilters()).isEqualTo(3);
        Assertions.assertThat((int)stats.getReplicatedDynamicFilters()).isEqualTo(0);
        Assertions.assertThat((Collection)ImmutableSet.copyOf((Collection)stats.getDynamicFilterDomainStats())).isEqualTo((Object)ImmutableSet.of((Object)new DynamicFilterService.DynamicFilterDomainStats(filterId1, DynamicFiltersTestUtil.getSimplifiedDomainString(1L, 2L, 2, (Type)IntegerType.INTEGER)), (Object)new DynamicFilterService.DynamicFilterDomainStats(filterId2, DynamicFiltersTestUtil.getSimplifiedDomainString(2L, 3L, 2, (Type)IntegerType.INTEGER)), (Object)new DynamicFilterService.DynamicFilterDomainStats(filterId3, Domain.none((Type)IntegerType.INTEGER).toString(session.toConnectorSession()))));
        Assertions.assertThat((boolean)dynamicFilter.isComplete()).isTrue();
        Assertions.assertThat((boolean)dynamicFilter.isAwaitable()).isFalse();
        Assertions.assertThat((boolean)dynamicFilter.isBlocked().isDone()).isTrue();
    }

    @Test
    public void testShortCircuitOnAllTupleDomain() {
        DynamicFilterService dynamicFilterService = TestDynamicFilterService.createDynamicFilterService();
        DynamicFilterId filterId1 = new DynamicFilterId("df1");
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol1 = symbolAllocator.newSymbol("DF_SYMBOL1", (Type)IntegerType.INTEGER);
        SymbolReference df1 = symbol1.toSymbolReference();
        QueryId queryId = new QueryId("query");
        StageId stageId1 = new StageId(queryId, 1);
        dynamicFilterService.registerQuery(queryId, session, (Set)ImmutableSet.of((Object)filterId1), (Set)ImmutableSet.of((Object)filterId1), (Set)ImmutableSet.of());
        dynamicFilterService.stageCannotScheduleMoreTasks(stageId1, 0, 2);
        DynamicFilter dynamicFilter = dynamicFilterService.createDynamicFilter(queryId, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId1, (Expression)df1)), (Map)ImmutableMap.of((Object)symbol1, (Object)new TestingColumnHandle("probeColumnA")), symbolAllocator.getTypes());
        Assertions.assertThat((boolean)dynamicFilter.getCurrentPredicate().isAll()).isTrue();
        Assertions.assertThat((boolean)dynamicFilter.isComplete()).isFalse();
        Assertions.assertThat((boolean)dynamicFilter.isBlocked().isDone()).isFalse();
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId1, 1, 0), (Map)ImmutableMap.of((Object)filterId1, (Object)Domain.all((Type)IntegerType.INTEGER)));
        Assertions.assertThat((boolean)dynamicFilter.getCurrentPredicate().isAll()).isTrue();
        Assertions.assertThat((boolean)dynamicFilter.isComplete()).isTrue();
        Assertions.assertThat((boolean)dynamicFilter.isBlocked().isDone()).isTrue();
    }

    @Test
    public void testDynamicFilterCoercion() {
        DynamicFilterService dynamicFilterService = TestDynamicFilterService.createDynamicFilterService();
        DynamicFilterId filterId1 = new DynamicFilterId("df1");
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol1 = symbolAllocator.newSymbol("DF_SYMBOL1", (Type)IntegerType.INTEGER);
        Cast df1 = new Cast((Expression)symbol1.toSymbolReference(), TypeSignatureTranslator.toSqlType((Type)BigintType.BIGINT));
        QueryId queryId = new QueryId("query");
        StageId stageId1 = new StageId(queryId, 1);
        dynamicFilterService.registerQuery(queryId, session, (Set)ImmutableSet.of((Object)filterId1), (Set)ImmutableSet.of((Object)filterId1), (Set)ImmutableSet.of());
        dynamicFilterService.stageCannotScheduleMoreTasks(stageId1, 0, 1);
        DynamicFilter dynamicFilter = dynamicFilterService.createDynamicFilter(queryId, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId1, (Expression)df1)), (Map)ImmutableMap.of((Object)symbol1, (Object)new TestingColumnHandle("probeColumnA")), symbolAllocator.getTypes());
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)dynamicFilter.getColumnsCovered()).describedAs("columns covered", new Object[0])).isEqualTo(Set.of(new TestingColumnHandle("probeColumnA")));
        Assertions.assertThat((boolean)dynamicFilter.isComplete()).isFalse();
        Assertions.assertThat((boolean)dynamicFilter.getCurrentPredicate().isAll()).isTrue();
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId1, 0, 0), (Map)ImmutableMap.of((Object)filterId1, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L))));
        Assertions.assertThat((boolean)dynamicFilter.isComplete()).isTrue();
        Assertions.assertThat((Object)dynamicFilter.getCurrentPredicate()).isEqualTo((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("probeColumnA"), (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)))));
    }

    @Test
    public void testReplicatedDynamicFilter() {
        DynamicFilterService dynamicFilterService = TestDynamicFilterService.createDynamicFilterService();
        DynamicFilterId filterId1 = new DynamicFilterId("df1");
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol1 = symbolAllocator.newSymbol("DF_SYMBOL1", (Type)IntegerType.INTEGER);
        SymbolReference df1 = symbol1.toSymbolReference();
        QueryId queryId = new QueryId("query");
        StageId stageId1 = new StageId(queryId, 1);
        dynamicFilterService.registerQuery(queryId, session, (Set)ImmutableSet.of((Object)filterId1), (Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)filterId1));
        DynamicFilter dynamicFilter = dynamicFilterService.createDynamicFilter(queryId, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId1, (Expression)df1)), (Map)ImmutableMap.of((Object)symbol1, (Object)new TestingColumnHandle("probeColumnA")), symbolAllocator.getTypes());
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)dynamicFilter.getColumnsCovered()).describedAs("columns covered", new Object[0])).isEqualTo(Set.of(new TestingColumnHandle("probeColumnA")));
        Assertions.assertThat((boolean)dynamicFilter.getCurrentPredicate().isAll()).isTrue();
        DynamicFilterService.DynamicFiltersStats stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assertions.assertThat((int)stats.getTotalDynamicFilters()).isEqualTo(1);
        Assertions.assertThat((int)stats.getDynamicFiltersCompleted()).isEqualTo(0);
        Assertions.assertThat((int)stats.getReplicatedDynamicFilters()).isEqualTo(1);
        Assertions.assertThat((int)stats.getLazyDynamicFilters()).isEqualTo(0);
        Assertions.assertThat((boolean)dynamicFilter.isComplete()).isFalse();
        Assertions.assertThat((boolean)dynamicFilter.isAwaitable()).isFalse();
        Assertions.assertThat((boolean)dynamicFilter.isBlocked().isDone()).isTrue();
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId1, 0, 0), (Map)ImmutableMap.of((Object)filterId1, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)));
        Assertions.assertThat((Object)dynamicFilter.getCurrentPredicate()).isEqualTo((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("probeColumnA"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L))));
        Assertions.assertThat((boolean)dynamicFilter.isComplete()).isTrue();
        Assertions.assertThat((boolean)dynamicFilter.isAwaitable()).isFalse();
        stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assertions.assertThat((int)stats.getTotalDynamicFilters()).isEqualTo(1);
        Assertions.assertThat((int)stats.getDynamicFiltersCompleted()).isEqualTo(1);
        Assertions.assertThat((int)stats.getReplicatedDynamicFilters()).isEqualTo(1);
        Assertions.assertThat((int)stats.getLazyDynamicFilters()).isEqualTo(0);
        Assertions.assertThat((List)stats.getDynamicFilterDomainStats()).isEqualTo((Object)ImmutableList.of((Object)new DynamicFilterService.DynamicFilterDomainStats(filterId1, Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L).toString(session.toConnectorSession()))));
    }

    @Test
    public void testStageCannotScheduleMoreTasks() {
        DynamicFilterService dynamicFilterService = TestDynamicFilterService.createDynamicFilterService();
        DynamicFilterId filterId1 = new DynamicFilterId("df1");
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol1 = symbolAllocator.newSymbol("DF_SYMBOL1", (Type)IntegerType.INTEGER);
        SymbolReference df1 = symbol1.toSymbolReference();
        QueryId queryId = new QueryId("query");
        StageId stageId1 = new StageId(queryId, 1);
        dynamicFilterService.registerQuery(queryId, session, (Set)ImmutableSet.of((Object)filterId1), (Set)ImmutableSet.of((Object)filterId1), (Set)ImmutableSet.of());
        DynamicFilter dynamicFilter = dynamicFilterService.createDynamicFilter(queryId, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId1, (Expression)df1)), (Map)ImmutableMap.of((Object)symbol1, (Object)new TestingColumnHandle("probeColumnA")), symbolAllocator.getTypes());
        Assertions.assertThat((boolean)dynamicFilter.getCurrentPredicate().isAll()).isTrue();
        Assertions.assertThat((boolean)dynamicFilter.isComplete()).isFalse();
        CompletableFuture blockedFuture = dynamicFilter.isBlocked();
        Assertions.assertThat((boolean)blockedFuture.isDone()).isFalse();
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId1, 0, 0), (Map)ImmutableMap.of((Object)filterId1, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)));
        Assertions.assertThat((boolean)dynamicFilter.getCurrentPredicate().isAll()).isTrue();
        Assertions.assertThat((boolean)dynamicFilter.isComplete()).isFalse();
        Assertions.assertThat((boolean)blockedFuture.isDone()).isFalse();
        dynamicFilterService.stageCannotScheduleMoreTasks(stageId1, 0, 1);
        Assertions.assertThat((Object)dynamicFilter.getCurrentPredicate()).isEqualTo((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("probeColumnA"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L))));
        Assertions.assertThat((boolean)dynamicFilter.isComplete()).isTrue();
        Assertions.assertThat((boolean)blockedFuture.isDone()).isTrue();
        Assertions.assertThat((boolean)blockedFuture.isCompletedExceptionally()).isFalse();
    }

    @Test
    public void testDynamicFilterCancellation() {
        DynamicFilterService dynamicFilterService = TestDynamicFilterService.createDynamicFilterService();
        DynamicFilterId filterId = new DynamicFilterId("df");
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol1 = symbolAllocator.newSymbol("DF_SYMBOL1", (Type)IntegerType.INTEGER);
        SymbolReference df1 = symbol1.toSymbolReference();
        QueryId queryId = new QueryId("query");
        StageId stageId = new StageId(queryId, 0);
        dynamicFilterService.registerQuery(queryId, session, (Set)ImmutableSet.of((Object)filterId), (Set)ImmutableSet.of((Object)filterId), (Set)ImmutableSet.of());
        dynamicFilterService.stageCannotScheduleMoreTasks(stageId, 0, 2);
        TestingColumnHandle column = new TestingColumnHandle("probeColumnA");
        DynamicFilter dynamicFilter = dynamicFilterService.createDynamicFilter(queryId, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId, (Expression)df1)), (Map)ImmutableMap.of((Object)symbol1, (Object)column), symbolAllocator.getTypes());
        Assertions.assertThat((boolean)dynamicFilter.isBlocked().isDone()).isFalse();
        Assertions.assertThat((boolean)dynamicFilter.isComplete()).isFalse();
        Assertions.assertThat((Object)dynamicFilter.getCurrentPredicate()).isEqualTo((Object)TupleDomain.all());
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 0, 0), (Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)));
        Assertions.assertThat((Object)dynamicFilter.getCurrentPredicate()).isEqualTo((Object)TupleDomain.all());
        CompletableFuture isBlocked = dynamicFilter.isBlocked();
        Assertions.assertThat((boolean)isBlocked.isDone()).isFalse();
        Assertions.assertThat((boolean)isBlocked.cancel(false)).isFalse();
        Assertions.assertThat((boolean)dynamicFilter.isBlocked().isDone()).isFalse();
        Assertions.assertThat((boolean)dynamicFilter.isComplete()).isFalse();
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 1, 0), (Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L)));
        Assertions.assertThat((boolean)isBlocked.isDone()).isTrue();
        Assertions.assertThat((boolean)dynamicFilter.isComplete()).isTrue();
        Assertions.assertThat((Object)dynamicFilter.getCurrentPredicate()).isEqualTo((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)1L, (Object)2L)))));
    }

    @Test
    public void testIsAwaitable() {
        DynamicFilterService dynamicFilterService = TestDynamicFilterService.createDynamicFilterService();
        DynamicFilterId filterId1 = new DynamicFilterId("df1");
        DynamicFilterId filterId2 = new DynamicFilterId("df2");
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol = symbolAllocator.newSymbol("symbol", (Type)IntegerType.INTEGER);
        TestingColumnHandle handle = new TestingColumnHandle("probeColumnA");
        QueryId queryId = new QueryId("query");
        dynamicFilterService.registerQuery(queryId, session, (Set)ImmutableSet.of((Object)filterId1, (Object)filterId2), (Set)ImmutableSet.of((Object)filterId1), (Set)ImmutableSet.of());
        DynamicFilter dynamicFilter1 = dynamicFilterService.createDynamicFilter(queryId, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId1, (Expression)symbol.toSymbolReference())), (Map)ImmutableMap.of((Object)symbol, (Object)handle), symbolAllocator.getTypes());
        DynamicFilter dynamicFilter2 = dynamicFilterService.createDynamicFilter(queryId, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId2, (Expression)symbol.toSymbolReference())), (Map)ImmutableMap.of((Object)symbol, (Object)handle), symbolAllocator.getTypes());
        Assertions.assertThat((boolean)dynamicFilter1.isAwaitable()).isTrue();
        Assertions.assertThat((boolean)dynamicFilter2.isAwaitable()).isFalse();
    }

    @Test
    public void testMultipleColumnMapping() {
        DynamicFilterService dynamicFilterService = TestDynamicFilterService.createDynamicFilterService();
        DynamicFilterId filterId1 = new DynamicFilterId("df1");
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol1 = symbolAllocator.newSymbol("DF_SYMBOL1", (Type)IntegerType.INTEGER);
        Symbol symbol2 = symbolAllocator.newSymbol("DF_SYMBOL2", (Type)IntegerType.INTEGER);
        SymbolReference df1 = symbol1.toSymbolReference();
        SymbolReference df2 = symbol2.toSymbolReference();
        QueryId queryId = new QueryId("query");
        StageId stageId1 = new StageId(queryId, 1);
        dynamicFilterService.registerQuery(queryId, session, (Set)ImmutableSet.of((Object)filterId1), (Set)ImmutableSet.of((Object)filterId1), (Set)ImmutableSet.of());
        dynamicFilterService.stageCannotScheduleMoreTasks(stageId1, 0, 1);
        TestingColumnHandle column1 = new TestingColumnHandle("probeColumnA");
        TestingColumnHandle column2 = new TestingColumnHandle("probeColumnB");
        DynamicFilter dynamicFilter = dynamicFilterService.createDynamicFilter(queryId, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId1, (Expression)df1), (Object)new DynamicFilters.Descriptor(filterId1, (Expression)df2)), (Map)ImmutableMap.of((Object)symbol1, (Object)column1, (Object)symbol2, (Object)column2), symbolAllocator.getTypes());
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)dynamicFilter.getColumnsCovered()).describedAs("columns covered", new Object[0])).isEqualTo(Set.of(column1, column2));
        Domain domain = Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L);
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId1, 0, 0), (Map)ImmutableMap.of((Object)filterId1, (Object)domain));
        Assertions.assertThat((Object)dynamicFilter.getCurrentPredicate()).isEqualTo((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column1, (Object)domain, (Object)column2, (Object)domain)));
    }

    @Test
    public void testDynamicFilterConsumer() {
        DynamicFilterService dynamicFilterService = TestDynamicFilterService.createDynamicFilterService();
        DynamicFilterId filterId1 = new DynamicFilterId("df1");
        DynamicFilterId filterId2 = new DynamicFilterId("df2");
        ImmutableSet dynamicFilters = ImmutableSet.of((Object)filterId1, (Object)filterId2);
        QueryId queryId = new QueryId("query");
        StageId stageId = new StageId(queryId, 0);
        dynamicFilterService.registerQuery(queryId, session, (Set)dynamicFilters, (Set)dynamicFilters, (Set)ImmutableSet.of());
        dynamicFilterService.stageCannotScheduleMoreTasks(stageId, 0, 2);
        HashMap consumerCollectedFilters = new HashMap();
        dynamicFilterService.registerDynamicFilterConsumer(queryId, 0, (Set)dynamicFilters, domains -> domains.forEach((filter, domain) -> Assertions.assertThat((Object)consumerCollectedFilters.put(filter, domain)).isNull()));
        Assertions.assertThat((boolean)consumerCollectedFilters.isEmpty()).isTrue();
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 0, 0), (Map)ImmutableMap.of((Object)filterId1, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)));
        Assertions.assertThat((boolean)consumerCollectedFilters.isEmpty()).isTrue();
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 1, 0), (Map)ImmutableMap.of((Object)filterId1, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)3L), (Object)filterId2, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L)));
        Assertions.assertThat(consumerCollectedFilters).isEqualTo((Object)ImmutableMap.of((Object)filterId1, (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)1L, (Object)3L))));
        HashMap secondConsumerCollectedFilters = new HashMap();
        dynamicFilterService.registerDynamicFilterConsumer(queryId, 0, (Set)ImmutableSet.of((Object)filterId1), domains -> domains.forEach((filter, domain) -> Assertions.assertThat((Object)secondConsumerCollectedFilters.put(filter, domain)).isNull()));
        Assertions.assertThat(secondConsumerCollectedFilters).isEqualTo((Object)ImmutableMap.of((Object)filterId1, (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)1L, (Object)3L))));
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 0, 0), (Map)ImmutableMap.of((Object)filterId2, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)4L)));
        Assertions.assertThat(consumerCollectedFilters).isEqualTo((Object)ImmutableMap.of((Object)filterId1, (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)1L, (Object)3L)), (Object)filterId2, (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)2L, (Object)4L))));
        Assertions.assertThat(secondConsumerCollectedFilters).isEqualTo((Object)ImmutableMap.of((Object)filterId1, (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)1L, (Object)3L))));
    }

    @Test
    public void testDynamicFilterConsumerCallbackCount() {
        DynamicFilterService dynamicFilterService = TestDynamicFilterService.createDynamicFilterService();
        DynamicFilterId filterId1 = new DynamicFilterId("df1");
        DynamicFilterId filterId2 = new DynamicFilterId("df2");
        ImmutableSet dynamicFilters = ImmutableSet.of((Object)filterId1, (Object)filterId2);
        QueryId queryId = new QueryId("query");
        StageId stageId = new StageId(queryId, 0);
        dynamicFilterService.registerQuery(queryId, session, (Set)dynamicFilters, (Set)dynamicFilters, (Set)ImmutableSet.of());
        dynamicFilterService.stageCannotScheduleMoreTasks(stageId, 0, 2);
        HashMap consumerCollectedFilters = new HashMap();
        AtomicInteger callbackCount = new AtomicInteger();
        dynamicFilterService.registerDynamicFilterConsumer(queryId, 0, (Set)dynamicFilters, domains -> {
            callbackCount.getAndIncrement();
            domains.forEach((filter, domain) -> Assertions.assertThat((Object)consumerCollectedFilters.put(filter, domain)).isNull());
        });
        Assertions.assertThat((boolean)consumerCollectedFilters.isEmpty()).isTrue();
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 0, 0), (Map)ImmutableMap.of((Object)filterId1, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L), (Object)filterId2, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L)));
        Assertions.assertThat((boolean)consumerCollectedFilters.isEmpty()).isTrue();
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 1, 0), (Map)ImmutableMap.of((Object)filterId1, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)3L), (Object)filterId2, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)4L)));
        Assertions.assertThat(consumerCollectedFilters).isEqualTo((Object)ImmutableMap.of((Object)filterId1, (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)1L, (Object)3L)), (Object)filterId2, (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)2L, (Object)4L))));
        Assertions.assertThat((int)callbackCount.get()).isEqualTo(2);
        HashMap secondConsumerCollectedFilters = new HashMap();
        AtomicInteger secondCallbackCount = new AtomicInteger();
        dynamicFilterService.registerDynamicFilterConsumer(queryId, 0, (Set)dynamicFilters, domains -> {
            secondCallbackCount.getAndIncrement();
            domains.forEach((filter, domain) -> Assertions.assertThat((Object)secondConsumerCollectedFilters.put(filter, domain)).isNull());
        });
        Assertions.assertThat(secondConsumerCollectedFilters).isEqualTo((Object)ImmutableMap.of((Object)filterId1, (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)1L, (Object)3L)), (Object)filterId2, (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)2L, (Object)4L))));
        Assertions.assertThat((int)secondCallbackCount.get()).isEqualTo(2);
        Assertions.assertThat((int)callbackCount.get()).isEqualTo(2);
    }

    @Test
    public void testSourceStageInnerLazyDynamicFilters() {
        DynamicFilterId dynamicFilterId = new DynamicFilterId("filterId");
        Assertions.assertThat((Collection)DynamicFilterService.getSourceStageInnerLazyDynamicFilters((PlanFragment)TestDynamicFilterService.createPlan(dynamicFilterId, SystemPartitioningHandle.SOURCE_DISTRIBUTION, ExchangeNode.Type.REPLICATE))).isEqualTo((Object)ImmutableSet.of((Object)dynamicFilterId));
        Assertions.assertThat((Collection)DynamicFilterService.getSourceStageInnerLazyDynamicFilters((PlanFragment)TestDynamicFilterService.createPlan(dynamicFilterId, SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, ExchangeNode.Type.REPLICATE))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)DynamicFilterService.getSourceStageInnerLazyDynamicFilters((PlanFragment)TestDynamicFilterService.createPlan(dynamicFilterId, SystemPartitioningHandle.SOURCE_DISTRIBUTION, ExchangeNode.Type.REPARTITION))).isEqualTo((Object)ImmutableSet.of());
    }

    @Test
    public void testOutboundDynamicFilters() {
        DynamicFilterId filterId1 = new DynamicFilterId("filterId1");
        DynamicFilterId filterId2 = new DynamicFilterId("filterId2");
        Assertions.assertThat((Collection)DynamicFilterService.getOutboundDynamicFilters((PlanFragment)TestDynamicFilterService.createPlan(filterId1, filterId1, SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, ExchangeNode.Type.REPLICATE))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)DynamicFilterService.getOutboundDynamicFilters((PlanFragment)TestDynamicFilterService.createPlan(filterId1, filterId1, SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, ExchangeNode.Type.REPARTITION))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)DynamicFilterService.getOutboundDynamicFilters((PlanFragment)TestDynamicFilterService.createPlan(filterId1, filterId2, SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, ExchangeNode.Type.REPLICATE))).isEqualTo((Object)ImmutableSet.of((Object)filterId1));
        Assertions.assertThat((Collection)DynamicFilterService.getOutboundDynamicFilters((PlanFragment)TestDynamicFilterService.createPlan(filterId1, filterId2, SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, ExchangeNode.Type.REPARTITION))).isEqualTo((Object)ImmutableSet.of((Object)filterId1));
    }

    @Test
    public void testMultipleQueryAttempts() {
        DynamicFilterService dynamicFilterService = TestDynamicFilterService.createDynamicFilterService();
        DynamicFilterId filterId = new DynamicFilterId("df");
        QueryId queryId = new QueryId("query");
        StageId stageId = new StageId(queryId, 0);
        dynamicFilterService.registerQuery(queryId, session, (Set)ImmutableSet.of((Object)filterId), (Set)ImmutableSet.of((Object)filterId), (Set)ImmutableSet.of());
        dynamicFilterService.stageCannotScheduleMoreTasks(stageId, 0, 3);
        Assertions.assertThat((boolean)dynamicFilterService.getSummary(queryId, filterId).isPresent()).isFalse();
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 0, 0), (Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)));
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 1, 0), (Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L)));
        Assertions.assertThat((boolean)dynamicFilterService.getSummary(queryId, filterId).isPresent()).isFalse();
        dynamicFilterService.registerQueryRetry(queryId, 1);
        dynamicFilterService.stageCannotScheduleMoreTasks(stageId, 1, 3);
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 2, 0), (Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)3L)));
        Assertions.assertThat((boolean)dynamicFilterService.getSummary(queryId, filterId).isPresent()).isFalse();
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 0, 1), (Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)4L)));
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 1, 1), (Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)5L)));
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 2, 1), (Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)6L)));
        Assertions.assertThat((Optional)dynamicFilterService.getSummary(queryId, filterId)).isEqualTo(Optional.of(Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)4L, (Object)5L, (Object)6L))));
        DynamicFilterService.DynamicFiltersStats stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assertions.assertThat((int)stats.getDynamicFiltersCompleted()).isEqualTo(1);
        Assertions.assertThat((int)stats.getLazyDynamicFilters()).isEqualTo(1);
        Assertions.assertThat((int)stats.getReplicatedDynamicFilters()).isEqualTo(0);
        Assertions.assertThat((List)stats.getDynamicFilterDomainStats()).isEqualTo((Object)ImmutableList.of((Object)new DynamicFilterService.DynamicFilterDomainStats(filterId, DynamicFiltersTestUtil.getSimplifiedDomainString(4L, 6L, 3, (Type)IntegerType.INTEGER))));
    }

    @Test
    public void testSizeLimit() {
        DataSize sizeLimit = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
        DynamicFilterConfig config = new DynamicFilterConfig();
        config.setSmallMaxSizePerFilter(sizeLimit);
        DynamicFilterService dynamicFilterService = new DynamicFilterService(TestingPlannerContext.PLANNER_CONTEXT.getMetadata(), TestingPlannerContext.PLANNER_CONTEXT.getFunctionManager(), TestingPlannerContext.PLANNER_CONTEXT.getTypeOperators(), config);
        QueryId queryId = new QueryId("query");
        StageId stage1 = new StageId(queryId, 0);
        StageId stage2 = new StageId(queryId, 1);
        StageId stage3 = new StageId(queryId, 3);
        StageId stage4 = new StageId(queryId, 3);
        DynamicFilterId compactFilter = new DynamicFilterId("compact");
        DynamicFilterId largeFilter = new DynamicFilterId("large");
        DynamicFilterId replicatedFilter1 = new DynamicFilterId("replicated1");
        DynamicFilterId replicatedFilter2 = new DynamicFilterId("replicated2");
        dynamicFilterService.registerQuery(queryId, session, (Set)ImmutableSet.of((Object)compactFilter, (Object)largeFilter, (Object)replicatedFilter1, (Object)replicatedFilter2), (Set)ImmutableSet.of((Object)compactFilter, (Object)largeFilter, (Object)replicatedFilter1, (Object)replicatedFilter2), (Set)ImmutableSet.of((Object)replicatedFilter1, (Object)replicatedFilter2));
        Domain domain1 = Domain.multipleValues((Type)VarcharType.VARCHAR, (List)((List)LongStream.range(0L, 5L).mapToObj(i -> Slices.utf8Slice((String)("value" + i))).collect(ImmutableList.toImmutableList())));
        Domain domain2 = Domain.multipleValues((Type)VarcharType.VARCHAR, (List)((List)LongStream.range(6L, 31L).mapToObj(i -> Slices.utf8Slice((String)("value" + i))).collect(ImmutableList.toImmutableList())));
        Domain domain3 = Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)IntStream.range(0, 800).mapToObj(i -> "x").collect(Collectors.joining())));
        Assertions.assertThat((long)domain1.getRetainedSizeInBytes()).isLessThan(sizeLimit.toBytes());
        Assertions.assertThat((long)domain1.union(domain2).getRetainedSizeInBytes()).isGreaterThanOrEqualTo(sizeLimit.toBytes());
        Assertions.assertThat((long)domain1.union(domain2).union(domain3).simplify(1).getRetainedSizeInBytes()).isGreaterThanOrEqualTo(sizeLimit.toBytes());
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stage1, 0, 0), (Map)ImmutableMap.of((Object)compactFilter, (Object)domain1));
        Assertions.assertThat((Optional)dynamicFilterService.getSummary(queryId, compactFilter)).isNotPresent();
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stage1, 1, 0), (Map)ImmutableMap.of((Object)compactFilter, (Object)domain2));
        Assertions.assertThat((Optional)dynamicFilterService.getSummary(queryId, compactFilter)).isNotPresent();
        dynamicFilterService.stageCannotScheduleMoreTasks(stage1, 0, 2);
        Assertions.assertThat((Optional)dynamicFilterService.getSummary(queryId, compactFilter)).isPresent();
        Domain compactFilterSummary = (Domain)dynamicFilterService.getSummary(queryId, compactFilter).get();
        Assertions.assertThat((Object)compactFilterSummary.getValues()).isEqualTo((Object)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value0"), (boolean)true, (Object)Slices.utf8Slice((String)"value9"), (boolean)true), (Range[])new Range[0]));
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stage2, 0, 0), (Map)ImmutableMap.of((Object)largeFilter, (Object)domain1));
        Assertions.assertThat((Optional)dynamicFilterService.getSummary(queryId, largeFilter)).isNotPresent();
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stage2, 1, 0), (Map)ImmutableMap.of((Object)largeFilter, (Object)domain2));
        Assertions.assertThat((Optional)dynamicFilterService.getSummary(queryId, largeFilter)).isNotPresent();
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stage2, 2, 0), (Map)ImmutableMap.of((Object)largeFilter, (Object)domain3));
        Assertions.assertThat((Optional)dynamicFilterService.getSummary(queryId, largeFilter)).isPresent();
        Assertions.assertThat((Object)((Domain)dynamicFilterService.getSummary(queryId, largeFilter).get())).isEqualTo((Object)Domain.all((Type)VarcharType.VARCHAR));
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stage3, 0, 0), (Map)ImmutableMap.of((Object)replicatedFilter1, (Object)domain1.union(domain2)));
        Assertions.assertThat((Optional)dynamicFilterService.getSummary(queryId, replicatedFilter1)).isPresent();
        Assertions.assertThat((Object)((Domain)dynamicFilterService.getSummary(queryId, replicatedFilter1).get()).getValues()).isEqualTo((Object)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value0"), (boolean)true, (Object)Slices.utf8Slice((String)"value9"), (boolean)true), (Range[])new Range[0]));
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stage4, 0, 0), (Map)ImmutableMap.of((Object)replicatedFilter2, (Object)domain1.union(domain2).union(domain3)));
        Assertions.assertThat((Optional)dynamicFilterService.getSummary(queryId, replicatedFilter2)).isPresent();
        Assertions.assertThat((Object)((Domain)dynamicFilterService.getSummary(queryId, replicatedFilter2).get())).isEqualTo((Object)Domain.all((Type)VarcharType.VARCHAR));
    }

    @Test
    public void testCollectMoreThanOnceForTheSameTask() {
        DynamicFilterService dynamicFilterService = TestDynamicFilterService.createDynamicFilterService();
        QueryId query = new QueryId("query");
        StageId stage = new StageId(query, 0);
        DynamicFilterId filter = new DynamicFilterId("filter");
        dynamicFilterService.registerQuery(query, session, (Set)ImmutableSet.of((Object)filter), (Set)ImmutableSet.of((Object)filter), (Set)ImmutableSet.of());
        dynamicFilterService.stageCannotScheduleMoreTasks(stage, 0, 2);
        Domain domain1 = Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value1"));
        Domain domain2 = Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value2"));
        Domain domain3 = Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value3"));
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stage, 0, 0), (Map)ImmutableMap.of((Object)filter, (Object)domain1));
        Assertions.assertThat((Optional)dynamicFilterService.getSummary(query, filter)).isNotPresent();
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stage, 0, 0), (Map)ImmutableMap.of((Object)filter, (Object)domain2));
        Assertions.assertThat((Optional)dynamicFilterService.getSummary(query, filter)).isNotPresent();
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stage, 1, 0), (Map)ImmutableMap.of((Object)filter, (Object)domain3));
        Assertions.assertThat((Optional)dynamicFilterService.getSummary(query, filter)).isPresent();
        Assertions.assertThat((Object)((Domain)dynamicFilterService.getSummary(query, filter).get())).isEqualTo((Object)domain1.union(domain3));
    }

    @Test
    public void testMultipleTaskAttempts() {
        DynamicFilterService dynamicFilterService = TestDynamicFilterService.createDynamicFilterService();
        DynamicFilterId filterId = new DynamicFilterId("df");
        QueryId queryId = new QueryId("query");
        StageId stageId = new StageId(queryId, 0);
        Session taskRetriesEnabled = Session.builder((Session)session).setSystemProperty("retry_policy", RetryPolicy.TASK.name()).build();
        dynamicFilterService.registerQuery(queryId, taskRetriesEnabled, (Set)ImmutableSet.of((Object)filterId), (Set)ImmutableSet.of((Object)filterId), (Set)ImmutableSet.of());
        dynamicFilterService.stageCannotScheduleMoreTasks(stageId, 0, 3);
        Assertions.assertThat((boolean)dynamicFilterService.getSummary(queryId, filterId).isPresent()).isFalse();
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 0, 0), (Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)));
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 1, 0), (Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L)));
        Assertions.assertThat((boolean)dynamicFilterService.getSummary(queryId, filterId).isPresent()).isFalse();
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 0, 1), (Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)0L)));
        Assertions.assertThat((boolean)dynamicFilterService.getSummary(queryId, filterId).isPresent()).isFalse();
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 2, 0), (Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)6L)));
        Assertions.assertThat((Optional)dynamicFilterService.getSummary(queryId, filterId)).isEqualTo(Optional.of(Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)6L))));
        DynamicFilterService.DynamicFiltersStats stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assertions.assertThat((int)stats.getDynamicFiltersCompleted()).isEqualTo(1);
        Assertions.assertThat((int)stats.getLazyDynamicFilters()).isEqualTo(1);
        Assertions.assertThat((int)stats.getReplicatedDynamicFilters()).isEqualTo(0);
        Assertions.assertThat((List)stats.getDynamicFilterDomainStats()).isEqualTo((Object)ImmutableList.of((Object)new DynamicFilterService.DynamicFilterDomainStats(filterId, DynamicFiltersTestUtil.getSimplifiedDomainString(1L, 6L, 3, (Type)IntegerType.INTEGER))));
    }

    private static DynamicFilterService createDynamicFilterService() {
        return new DynamicFilterService(TestingPlannerContext.PLANNER_CONTEXT.getMetadata(), TestingPlannerContext.PLANNER_CONTEXT.getFunctionManager(), TestingPlannerContext.PLANNER_CONTEXT.getTypeOperators(), new DynamicFilterConfig());
    }

    private static PlanFragment createPlan(DynamicFilterId dynamicFilterId, PartitioningHandle stagePartitioning, ExchangeNode.Type exchangeType) {
        return TestDynamicFilterService.createPlan(dynamicFilterId, dynamicFilterId, stagePartitioning, exchangeType);
    }

    private static PlanFragment createPlan(DynamicFilterId consumedDynamicFilterId, DynamicFilterId producedDynamicFilterId, PartitioningHandle stagePartitioning, ExchangeNode.Type exchangeType) {
        Symbol symbol = new Symbol("column");
        Symbol buildSymbol = new Symbol("buildColumn");
        PlanNodeId tableScanNodeId = new PlanNodeId("plan_id");
        TableScanNode tableScan = TableScanNode.newInstance((PlanNodeId)tableScanNodeId, (TableHandle)TestingHandles.TEST_TABLE_HANDLE, (List)ImmutableList.of((Object)symbol), (Map)ImmutableMap.of((Object)symbol, (Object)new TestingMetadata.TestingColumnHandle("column")), (boolean)false, Optional.empty());
        FilterNode filterNode = new FilterNode(new PlanNodeId("filter_node_id"), (PlanNode)tableScan, DynamicFilters.createDynamicFilterExpression((Metadata)MetadataManager.createTestMetadataManager(), (DynamicFilterId)consumedDynamicFilterId, (Type)VarcharType.VARCHAR, (Expression)symbol.toSymbolReference()));
        RemoteSourceNode remote = new RemoteSourceNode(new PlanNodeId("remote_id"), new PlanFragmentId("plan_fragment_id"), (List)ImmutableList.of((Object)buildSymbol), Optional.empty(), exchangeType, RetryPolicy.NONE);
        return new PlanFragment(new PlanFragmentId("plan_id"), (PlanNode)new JoinNode(new PlanNodeId("join_id"), JoinType.INNER, (PlanNode)filterNode, (PlanNode)remote, (List)ImmutableList.of(), tableScan.getOutputSymbols(), remote.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of((Object)producedDynamicFilterId, (Object)buildSymbol), Optional.empty()), (Map)ImmutableMap.of((Object)symbol, (Object)VarcharType.VARCHAR), stagePartitioning, Optional.empty(), (List)ImmutableList.of((Object)tableScanNodeId), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)symbol)), StatsAndCosts.empty(), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty());
    }
}

