/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import io.airlift.http.client.HttpClient;
import io.airlift.http.client.JsonResponseHandler;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.testing.Closeables;
import io.trino.client.ProtocolHeaders;
import io.trino.failuredetector.HeartbeatFailureDetector;
import io.trino.server.testing.TestingTrinoServer;
import java.io.Closeable;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestNodeResource {
    private TestingTrinoServer server;
    private HttpClient client;

    @BeforeAll
    public void setup() {
        this.server = TestingTrinoServer.create();
        this.client = new JettyHttpClient();
    }

    @AfterAll
    public void tearDown() throws Exception {
        Closeables.closeAll((Closeable[])new Closeable[]{this.server, this.client});
        this.server = null;
        this.client = null;
    }

    @Test
    public void testGetAllNodes() {
        List nodes = (List)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/node")).setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "unknown").build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(HeartbeatFailureDetector.Stats.class)));
        Assertions.assertThat((boolean)nodes.isEmpty()).isTrue();
    }

    @Test
    public void testGetFailedNodes() {
        List nodes = (List)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/node/failed")).setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "unknown").build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(HeartbeatFailureDetector.Stats.class)));
        Assertions.assertThat((boolean)nodes.isEmpty()).isTrue();
    }
}

