/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.JsonResponseHandler;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.UnexpectedResponseException;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import io.trino.client.ProtocolHeaders;
import io.trino.client.QueryResults;
import io.trino.execution.QueryState;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.server.BasicQueryInfo;
import io.trino.server.QueryStateInfo;
import io.trino.server.TestQueryResource;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.Plugin;
import io.trino.testing.TestingAccessControlManager;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestQueryStateInfoResource {
    private static final String LONG_LASTING_QUERY = "SELECT * FROM tpch.sf1.lineitem";
    private static final JsonCodec<QueryResults> QUERY_RESULTS_JSON_CODEC = JsonCodec.jsonCodec(QueryResults.class);
    private TestingTrinoServer server;
    private HttpClient client;
    private QueryResults queryResults;

    @BeforeAll
    public void setUp() {
        this.server = TestingTrinoServer.create();
        this.server.installPlugin((Plugin)new TpchPlugin());
        this.server.createCatalog("tpch", "tpch");
        this.client = new JettyHttpClient();
        Request request1 = Request.Builder.preparePost().setUri(HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath("/v1/statement").build()).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)LONG_LASTING_QUERY, (Charset)StandardCharsets.UTF_8)).setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "user1").build();
        this.queryResults = (QueryResults)this.client.execute(request1, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_JSON_CODEC));
        this.client.execute(Request.Builder.prepareGet().setUri(this.queryResults.getNextUri()).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_JSON_CODEC));
        Request request2 = Request.Builder.preparePost().setUri(HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath("/v1/statement").build()).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)LONG_LASTING_QUERY, (Charset)StandardCharsets.UTF_8)).setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "user2").build();
        QueryResults queryResults2 = (QueryResults)this.client.execute(request2, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(QueryResults.class)));
        this.client.execute(Request.Builder.prepareGet().setUri(queryResults2.getNextUri()).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_JSON_CODEC));
        long start = System.nanoTime();
        while (Duration.nanosSince((long)start).compareTo(new Duration(5.0, TimeUnit.MINUTES)) < 0) {
            List queryInfos = (List)this.client.execute(Request.Builder.prepareGet().setUri(HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath("/v1/query").build()).setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "unknown").build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(TestQueryResource.BASIC_QUERY_INFO_CODEC));
            if (queryInfos.size() != 2) continue;
            if (queryInfos.stream().allMatch(info -> info.getState() == QueryState.RUNNING)) break;
            List errorCodes = (List)queryInfos.stream().filter(info -> info.getState() == QueryState.FAILED).map(BasicQueryInfo::getErrorCode).collect(ImmutableList.toImmutableList());
            if (errorCodes.isEmpty()) continue;
            Fail.fail((String)("setup queries failed with: " + String.valueOf(errorCodes)));
        }
    }

    @AfterAll
    public void tearDown() throws IOException {
        Closer closer = Closer.create();
        closer.register((Closeable)this.server);
        closer.register((Closeable)this.client);
        closer.close();
        this.server = null;
        this.client = null;
    }

    @Test
    public void testGetAllQueryStateInfos() {
        List infos = (List)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/queryState")).setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "unknown").build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(QueryStateInfo.class)));
        Assertions.assertThat((int)infos.size()).isEqualTo(2);
    }

    @Test
    public void testGetQueryStateInfosForUser() {
        List infos = (List)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/queryState?user=user2")).setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "unknown").build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(QueryStateInfo.class)));
        Assertions.assertThat((int)infos.size()).isEqualTo(1);
    }

    @Test
    public void testGetQueryStateInfosForUserNoResult() {
        List infos = (List)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/queryState?user=user3")).setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "unknown").build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(QueryStateInfo.class)));
        Assertions.assertThat((boolean)infos.isEmpty()).isTrue();
    }

    @Test
    public void testGetQueryStateInfo() {
        QueryStateInfo info = (QueryStateInfo)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/queryState/" + this.queryResults.getId())).setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "unknown").build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(QueryStateInfo.class)));
        Assertions.assertThat((Object)info).isNotNull();
    }

    @Test
    public void testGetAllQueryStateInfosDenied() {
        List infos = (List)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/queryState")).setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "any-other-user").build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(QueryStateInfo.class)));
        Assertions.assertThat((int)infos.size()).isEqualTo(2);
        this.testGetAllQueryStateInfosDenied("user1", 1);
        this.testGetAllQueryStateInfosDenied("any-other-user", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGetAllQueryStateInfosDenied(String executionUser, int expectedCount) {
        this.server.getAccessControl().deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)executionUser, (String)"query", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.VIEW_QUERY)});
        try {
            List infos = (List)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/queryState")).setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), executionUser).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(QueryStateInfo.class)));
            Assertions.assertThat((int)infos.size()).isEqualTo(expectedCount);
        }
        finally {
            this.server.getAccessControl().reset();
        }
    }

    @Test
    public void testGetQueryStateInfoDenied() {
        this.server.getAccessControl().deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"query", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.VIEW_QUERY)});
        try {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/queryState/" + this.queryResults.getId())).setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "unknown").build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(QueryStateInfo.class)))).isInstanceOf(UnexpectedResponseException.class)).matches(throwable -> ((UnexpectedResponseException)throwable).getStatusCode() == 403);
        }
        finally {
            this.server.getAccessControl().reset();
        }
    }

    @Test
    public void testGetQueryStateInfoNo() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/queryState/123")).setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "unknown").build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(QueryStateInfo.class)))).isInstanceOf(UnexpectedResponseException.class)).hasMessageMatching("Expected response code .*, but was 404");
    }
}

