/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.remotetask;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import io.airlift.testing.TestingTicker;
import io.airlift.units.Duration;
import io.trino.server.remotetask.Backoff;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBackoff {
    @Test
    public void testFailureInterval() {
        TestingTicker ticker = new TestingTicker();
        ticker.increment(1L, TimeUnit.NANOSECONDS);
        Backoff backoff = new Backoff(1, new Duration(15.0, TimeUnit.SECONDS), (Ticker)ticker, (List)ImmutableList.of((Object)new Duration(10.0, TimeUnit.MILLISECONDS)));
        ticker.increment(10L, TimeUnit.MICROSECONDS);
        Assertions.assertThat((long)backoff.getFailureCount()).isEqualTo(0L);
        Assertions.assertThat((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS)).isEqualTo(0L);
        Assertions.assertThat((boolean)backoff.failure()).isFalse();
        Assertions.assertThat((long)backoff.getFailureCount()).isEqualTo(1L);
        Assertions.assertThat((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS)).isEqualTo(0L);
        ticker.increment(14L, TimeUnit.SECONDS);
        Assertions.assertThat((boolean)backoff.failure()).isFalse();
        Assertions.assertThat((long)backoff.getFailureCount()).isEqualTo(2L);
        Assertions.assertThat((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS)).isEqualTo(14L);
        ticker.increment(1L, TimeUnit.SECONDS);
        Assertions.assertThat((boolean)backoff.failure()).isTrue();
        Assertions.assertThat((long)backoff.getFailureCount()).isEqualTo(3L);
        Assertions.assertThat((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS)).isEqualTo(15L);
    }

    @Test
    public void testMinTries() {
        TestingTicker ticker = new TestingTicker();
        ticker.increment(1L, TimeUnit.NANOSECONDS);
        Backoff backoff = new Backoff(3, new Duration(1.0, TimeUnit.NANOSECONDS), (Ticker)ticker, (List)ImmutableList.of((Object)new Duration(10.0, TimeUnit.MILLISECONDS)));
        ticker.increment(10L, TimeUnit.MICROSECONDS);
        Assertions.assertThat((long)backoff.getFailureCount()).isEqualTo(0L);
        Assertions.assertThat((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS)).isEqualTo(0L);
        Assertions.assertThat((boolean)backoff.failure()).isFalse();
        Assertions.assertThat((long)backoff.getFailureCount()).isEqualTo(1L);
        Assertions.assertThat((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS)).isEqualTo(0L);
        ticker.increment(14L, TimeUnit.SECONDS);
        Assertions.assertThat((boolean)backoff.failure()).isFalse();
        Assertions.assertThat((long)backoff.getFailureCount()).isEqualTo(2L);
        Assertions.assertThat((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS)).isEqualTo(14L);
        ticker.increment(1L, TimeUnit.SECONDS);
        Assertions.assertThat((boolean)backoff.failure()).isTrue();
        Assertions.assertThat((long)backoff.getFailureCount()).isEqualTo(3L);
        Assertions.assertThat((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS)).isEqualTo(15L);
    }

    @Test
    public void testStartRequest() {
        TestingTicker ticker = new TestingTicker();
        ticker.increment(1L, TimeUnit.NANOSECONDS);
        Backoff backoff = new Backoff(1, new Duration(15.0, TimeUnit.SECONDS), (Ticker)ticker, (List)ImmutableList.of((Object)new Duration(10.0, TimeUnit.MILLISECONDS)));
        ticker.increment(10L, TimeUnit.MICROSECONDS);
        Assertions.assertThat((boolean)backoff.failure()).isFalse();
        Assertions.assertThat((long)backoff.getFailureCount()).isEqualTo(1L);
        Assertions.assertThat((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS)).isEqualTo(0L);
        Assertions.assertThat((long)backoff.getFailureRequestTimeTotal().roundTo(TimeUnit.SECONDS)).isEqualTo(0L);
        ticker.increment(7L, TimeUnit.SECONDS);
        backoff.startRequest();
        ticker.increment(7L, TimeUnit.SECONDS);
        Assertions.assertThat((boolean)backoff.failure()).isFalse();
        Assertions.assertThat((long)backoff.getFailureCount()).isEqualTo(2L);
        Assertions.assertThat((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS)).isEqualTo(14L);
        Assertions.assertThat((long)backoff.getFailureRequestTimeTotal().roundTo(TimeUnit.SECONDS)).isEqualTo(7L);
        ticker.increment(1L, TimeUnit.SECONDS);
        backoff.startRequest();
        ticker.increment(1L, TimeUnit.SECONDS);
        Assertions.assertThat((boolean)backoff.failure()).isTrue();
        Assertions.assertThat((long)backoff.getFailureCount()).isEqualTo(3L);
        Assertions.assertThat((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS)).isEqualTo(16L);
        Assertions.assertThat((long)backoff.getFailureRequestTimeTotal().roundTo(TimeUnit.SECONDS)).isEqualTo(8L);
    }

    @Test
    public void testDelay() {
        TestingTicker ticker = new TestingTicker();
        ticker.increment(1L, TimeUnit.NANOSECONDS);
        Backoff backoff = new Backoff(1, new Duration(15.0, TimeUnit.SECONDS), (Ticker)ticker, (List)ImmutableList.of((Object)new Duration(0.0, TimeUnit.SECONDS), (Object)new Duration(1.0, TimeUnit.SECONDS), (Object)new Duration(2.0, TimeUnit.SECONDS), (Object)new Duration(4.0, TimeUnit.SECONDS), (Object)new Duration(8.0, TimeUnit.SECONDS)));
        Assertions.assertThat((long)backoff.getFailureCount()).isEqualTo(0L);
        Assertions.assertThat((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS)).isEqualTo(0L);
        Assertions.assertThat((boolean)backoff.failure()).isFalse();
        Assertions.assertThat((long)backoff.getFailureCount()).isEqualTo(1L);
        Assertions.assertThat((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS)).isEqualTo(0L);
        long backoffDelay = backoff.getBackoffDelayNanos();
        Assertions.assertThat((long)TimeUnit.NANOSECONDS.toSeconds(backoffDelay)).isEqualTo(0L);
        ticker.increment(backoffDelay, TimeUnit.NANOSECONDS);
        Assertions.assertThat((boolean)backoff.failure()).isFalse();
        Assertions.assertThat((long)backoff.getFailureCount()).isEqualTo(2L);
        Assertions.assertThat((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS)).isEqualTo(0L);
        backoffDelay = backoff.getBackoffDelayNanos();
        Assertions.assertThat((long)TimeUnit.NANOSECONDS.toSeconds(backoffDelay)).isEqualTo(1L);
        ticker.increment(backoffDelay, TimeUnit.NANOSECONDS);
        Assertions.assertThat((boolean)backoff.failure()).isFalse();
        Assertions.assertThat((long)backoff.getFailureCount()).isEqualTo(3L);
        Assertions.assertThat((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS)).isEqualTo(1L);
        backoffDelay = backoff.getBackoffDelayNanos();
        Assertions.assertThat((long)TimeUnit.NANOSECONDS.toSeconds(backoffDelay)).isEqualTo(2L);
        ticker.increment(backoffDelay, TimeUnit.NANOSECONDS);
        Assertions.assertThat((boolean)backoff.failure()).isFalse();
        Assertions.assertThat((long)backoff.getFailureCount()).isEqualTo(4L);
        Assertions.assertThat((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS)).isEqualTo(3L);
        backoffDelay = backoff.getBackoffDelayNanos();
        Assertions.assertThat((long)TimeUnit.NANOSECONDS.toSeconds(backoffDelay)).isEqualTo(4L);
        ticker.increment(backoffDelay, TimeUnit.NANOSECONDS);
        Assertions.assertThat((boolean)backoff.failure()).isFalse();
        Assertions.assertThat((long)backoff.getFailureCount()).isEqualTo(5L);
        Assertions.assertThat((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS)).isEqualTo(7L);
        backoffDelay = backoff.getBackoffDelayNanos();
        Assertions.assertThat((long)TimeUnit.NANOSECONDS.toSeconds(backoffDelay)).isEqualTo(8L);
        ticker.increment(backoffDelay, TimeUnit.NANOSECONDS);
        Assertions.assertThat((boolean)backoff.failure()).isTrue();
        Assertions.assertThat((long)backoff.getFailureCount()).isEqualTo(6L);
        Assertions.assertThat((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS)).isEqualTo(15L);
        backoffDelay = backoff.getBackoffDelayNanos();
        Assertions.assertThat((long)TimeUnit.NANOSECONDS.toSeconds(backoffDelay)).isEqualTo(8L);
    }
}

