/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.collect.ImmutableList;
import io.trino.server.security.PasswordAuthenticatorConfig;
import io.trino.server.security.PasswordAuthenticatorManager;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.BasicPrincipal;
import io.trino.spi.security.PasswordAuthenticator;
import io.trino.spi.security.PasswordAuthenticatorFactory;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPasswordAuthenticatorManager {
    @Test
    public void testMultipleConfigFiles() throws Exception {
        Path config1 = Files.createTempFile("passwordConfig", "1", new FileAttribute[0]);
        Path config2 = Files.createTempFile("passwordConfig", "2", new FileAttribute[0]);
        Files.write(config1, (Iterable<? extends CharSequence>)ImmutableList.of((Object)"password-authenticator.name=type1"), new OpenOption[0]);
        Files.write(config2, (Iterable<? extends CharSequence>)ImmutableList.of((Object)"password-authenticator.name=type2"), new OpenOption[0]);
        PasswordAuthenticatorManager manager = new PasswordAuthenticatorManager(new PasswordAuthenticatorConfig().setPasswordAuthenticatorFiles(String.valueOf(config1.toAbsolutePath()) + "," + String.valueOf(config2.toAbsolutePath())));
        manager.setRequired();
        manager.addPasswordAuthenticatorFactory((PasswordAuthenticatorFactory)new TestingPasswordAuthenticatorFactory("type1", "password1"));
        manager.addPasswordAuthenticatorFactory((PasswordAuthenticatorFactory)new TestingPasswordAuthenticatorFactory("type2", "password2"));
        manager.loadPasswordAuthenticator();
        List authenticators = manager.getAuthenticators();
        Assertions.assertThat((boolean)this.login(authenticators, "password1")).isTrue();
        Assertions.assertThat((boolean)this.login(authenticators, "password2")).isTrue();
        Assertions.assertThat((boolean)this.login(authenticators, "wrong_password")).isFalse();
    }

    private boolean login(List<PasswordAuthenticator> authenticators, String password) {
        return authenticators.stream().anyMatch(authenticator -> {
            try {
                authenticator.createAuthenticatedPrincipal("ignore", password);
                return true;
            }
            catch (AccessDeniedException e) {
                return false;
            }
        });
    }

    private static class TestingPasswordAuthenticatorFactory
    implements PasswordAuthenticatorFactory {
        private final String name;
        private final String password;

        public TestingPasswordAuthenticatorFactory(String name, String password) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.password = Objects.requireNonNull(password, "password is null");
        }

        public String getName() {
            return this.name;
        }

        public PasswordAuthenticator create(Map<String, String> config) {
            return (user, password) -> {
                if (password.equals(this.password)) {
                    return new BasicPrincipal(user);
                }
                throw new AccessDeniedException("You shall not pass!");
            };
        }
    }
}

